/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.minidump;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.corereaders.memory.Addresses;
import com.ibm.j9ddr.corereaders.memory.IMemoryRange;
import com.ibm.j9ddr.corereaders.memory.IModule;
import com.ibm.j9ddr.corereaders.memory.IProcess;
import com.ibm.j9ddr.corereaders.memory.MemoryFault;
import com.ibm.j9ddr.corereaders.minidump.unwind.RuntimeFunction;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindInfo;
import com.ibm.j9ddr.corereaders.minidump.unwind.UnwindModule;
import com.ibm.j9ddr.corereaders.osthread.IOSStackFrame;
import com.ibm.j9ddr.corereaders.osthread.IOSThread;
import com.ibm.j9ddr.corereaders.osthread.IRegister;
import com.ibm.j9ddr.corereaders.osthread.OSStackFrame;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class BaseWindowsOSThread
implements IOSThread {
    private static final Logger logger = Logger.getLogger("j9ddr.core_readers");
    private List<IOSStackFrame> stackFrames;
    protected final IProcess process;

    protected BaseWindowsOSThread(IProcess process) {
        this.process = process;
    }

    public List<IOSStackFrame> getStackFrames() {
        if (null == this.stackFrames) {
            this.stackFrames = new LinkedList<IOSStackFrame>();
            try {
                if (this.process.bytesPerPointer() == 4) {
                    this.walkStack32();
                } else {
                    this.walkStack64();
                }
            }
            catch (CorruptDataException ex) {
                logger.logp(Level.FINE, "com.ibm.j9ddr.corereaders.minidump.BaseWindowsOSThread", "getStackFrames", "Problem walking native stack: " + ex.getMessage());
            }
        }
        return Collections.unmodifiableList(this.stackFrames);
    }

    protected abstract long getStackStart();

    protected abstract long getStackEnd();

    private void walkStack32() throws CorruptDataException {
        long ebp = this.getBasePointer();
        long eip = this.getInstructionPointer();
        long esp = this.getStackPointer();
        long stackStart = this.getStackStart();
        long stackEnd = this.getStackEnd();
        if (-1L == eip && stackStart <= esp && esp < stackEnd) {
            try {
                eip = this.process.getPointerAt(esp);
            }
            catch (MemoryFault memoryFault) {
                // empty catch block
            }
        }
        int bytesPerPointer = this.process.bytesPerPointer();
        if (Addresses.lessThanOrEqual(stackStart, ebp) && Addresses.lessThan(ebp, stackEnd)) {
            this.stackFrames.add(new OSStackFrame(ebp, eip));
        } else if (Addresses.lessThan(stackStart, esp) && Addresses.lessThan(esp, stackEnd)) {
            this.stackFrames.add(new OSStackFrame(esp, eip));
            ebp = esp + (long)bytesPerPointer;
        }
        while (stackStart <= ebp && ebp < stackEnd) {
            try {
                long newBP = this.process.getPointerAt(ebp);
                long retAddress = this.process.getPointerAt(ebp + (long)bytesPerPointer);
                this.stackFrames.add(new OSStackFrame(newBP, retAddress));
                ebp = newBP;
            }
            catch (MemoryFault e) {
                break;
            }
        }
    }

    private void walkStack64() throws CorruptDataException {
        long ip = this.getInstructionPointer();
        long rsp = this.getStackPointer();
        while (ip != 0L) {
            this.stackFrames.add(new OSStackFrame(rsp, ip));
            UnwindModule module = this.getModuleForInstructionAddress(ip);
            RuntimeFunction rf = null;
            if (module == null || (rf = module.getUnwindDataForAddress(ip - module.getLoadAddress())) == null) break;
            UnwindInfo info = new UnwindInfo(this.process.getAddressSpace(), module, rf.getUnwindInfoAddress());
            rsp = info.apply(rsp);
            ip = this.process.getPointerAt(rsp);
            rsp += 8L;
        }
    }

    public UnwindModule getModuleForInstructionAddress(long address) throws CorruptDataException {
        Collection<? extends IModule> modules = this.process.getModules();
        IModule matchingModule = null;
        block0: for (IModule iModule : modules) {
            for (IMemoryRange iMemoryRange : iModule.getMemoryRanges()) {
                if (!iMemoryRange.contains(address)) continue;
                matchingModule = iModule;
                break block0;
            }
        }
        if (matchingModule == null || !(matchingModule instanceof UnwindModule)) {
            return null;
        }
        return (UnwindModule)matchingModule;
    }

    protected long getValueOfNamedRegister(Collection<? extends IRegister> registers, String string) {
        for (IRegister iRegister : registers) {
            if (!iRegister.getName().equals(string)) continue;
            return iRegister.getValue().longValue();
        }
        return -1L;
    }
}

