/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders;

import java.io.File;
import javax.imageio.stream.ImageInputStream;

public class LibraryDataSource {
    private final Source type;
    private final File file;
    private final ImageInputStream stream;
    private final String name;

    public LibraryDataSource(String name) {
        this.type = Source.NOT_FOUND;
        this.stream = null;
        this.file = null;
        this.name = name;
    }

    public LibraryDataSource(File file) {
        this.type = Source.FILE;
        this.file = file;
        this.stream = null;
        this.name = file.getName();
    }

    public LibraryDataSource(String name, ImageInputStream in) {
        this.type = Source.STREAM;
        this.stream = in;
        this.file = null;
        this.name = name;
    }

    public Source getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        if (this.type == Source.FILE) {
            return this.file;
        }
        throw new UnsupportedOperationException("This operation is not supported for data sources of type " + this.type.name());
    }

    public ImageInputStream getStream() {
        if (this.type == Source.STREAM) {
            return this.stream;
        }
        throw new UnsupportedOperationException("This operation is not supported for data sources of type " + this.type.name());
    }

    public String toString() {
        StringBuilder data = new StringBuilder();
        data.append("Library Data Source : ");
        data.append(this.type.name());
        data.append("\n");
        switch (this.type) {
            case FILE: {
                data.append(this.file.getAbsolutePath());
                break;
            }
            case STREAM: {
                data.append(this.stream.getClass().getName());
            }
        }
        return data.toString();
    }

    public static enum Source {
        NOT_FOUND,
        FILE,
        STREAM;

    }
}

