/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.tools.ddrinteractive.commands;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.tools.ddrinteractive.Command;
import com.ibm.j9ddr.tools.ddrinteractive.CommandUtils;
import com.ibm.j9ddr.tools.ddrinteractive.Context;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractiveCommandException;
import com.ibm.j9ddr.vm29.j9.DataType;
import com.ibm.j9ddr.vm29.j9.HashTable;
import com.ibm.j9ddr.vm29.j9.ModuleHashTable;
import com.ibm.j9ddr.vm29.pointer.generated.J9HashTablePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9JavaVMPointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9ModulePointer;
import com.ibm.j9ddr.vm29.pointer.generated.J9PackagePointer;
import com.ibm.j9ddr.vm29.pointer.helper.J9ObjectHelper;
import com.ibm.j9ddr.vm29.pointer.helper.J9RASHelper;
import com.ibm.j9ddr.vm29.tools.ddrinteractive.JavaVersionHelper;
import java.io.PrintStream;
import java.util.Iterator;

public class DumpModuleDirectedExportsCommand
extends Command {
    public DumpModuleDirectedExportsCommand() {
        this.addCommand("dumpmoduledirectedexports", "<packageAddress>", "dump all modules that the package is exported to");
    }

    @Override
    public void run(String command, String[] args, Context context, PrintStream out) throws DDRInteractiveCommandException {
        if (args.length != 1) {
            CommandUtils.dbgPrint(out, "Usage: !dumpmoduledirectedexports <packageAddress>\n");
            return;
        }
        try {
            J9JavaVMPointer vm = J9RASHelper.getVM(DataType.getJ9RASPointer());
            int hitCount = 0;
            if (JavaVersionHelper.ensureJava9AndUp(vm, out)) {
                String targetPackageAddress = args[0];
                J9PackagePointer packagePtr = J9PackagePointer.cast(Long.decode(targetPackageAddress));
                J9HashTablePointer exportTable = packagePtr.exportsHashTable();
                HashTable<J9ModulePointer> moduleHashTable = ModuleHashTable.fromJ9HashTable(exportTable);
                Iterator slotIterator = moduleHashTable.iterator();
                while (slotIterator.hasNext()) {
                    J9ModulePointer exportModulePtr = (J9ModulePointer)slotIterator.next();
                    ++hitCount;
                    String moduleName = J9ObjectHelper.stringValue(exportModulePtr.moduleName());
                    String hexAddress = exportModulePtr.getHexAddress();
                    out.printf("%-30s !j9module %s%n", moduleName, hexAddress);
                }
                out.println(String.format("Found %d module(s) that the package is exported to\n", hitCount));
            }
        }
        catch (CorruptDataException e) {
            throw new DDRInteractiveCommandException(e);
        }
    }
}

