/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.vm29.pointer.generated;

import com.ibm.j9ddr.CorruptDataException;
import com.ibm.j9ddr.GeneratedFieldAccessor;
import com.ibm.j9ddr.GeneratedPointerClass;
import com.ibm.j9ddr.NullPointerDereference;
import com.ibm.j9ddr.vm29.pointer.AbstractPointer;
import com.ibm.j9ddr.vm29.pointer.DoublePointer;
import com.ibm.j9ddr.vm29.pointer.PointerPointer;
import com.ibm.j9ddr.vm29.pointer.StructurePointer;
import com.ibm.j9ddr.vm29.pointer.UDATAPointer;
import com.ibm.j9ddr.vm29.pointer.VoidPointer;
import com.ibm.j9ddr.vm29.structure.J9FormatValue;
import com.ibm.j9ddr.vm29.types.Scalar;
import com.ibm.j9ddr.vm29.types.U64;
import com.ibm.j9ddr.vm29.types.UDATA;

@GeneratedPointerClass(structureClass=J9FormatValue.class)
public class J9FormatValuePointer
extends StructurePointer {
    public static final J9FormatValuePointer NULL = new J9FormatValuePointer(0L);

    protected J9FormatValuePointer(long address) {
        super(address);
    }

    public static J9FormatValuePointer cast(AbstractPointer structure) {
        return J9FormatValuePointer.cast(structure.getAddress());
    }

    public static J9FormatValuePointer cast(UDATA udata) {
        return J9FormatValuePointer.cast(udata.longValue());
    }

    public static J9FormatValuePointer cast(long address) {
        if (address == 0L) {
            return NULL;
        }
        return new J9FormatValuePointer(address);
    }

    @Override
    public J9FormatValuePointer add(long count) {
        return J9FormatValuePointer.cast(this.address + J9FormatValue.SIZEOF * count);
    }

    @Override
    public J9FormatValuePointer add(Scalar count) {
        return this.add(count.longValue());
    }

    @Override
    public J9FormatValuePointer addOffset(long offset) {
        return J9FormatValuePointer.cast(this.address + offset);
    }

    @Override
    public J9FormatValuePointer addOffset(Scalar offset) {
        return this.addOffset(offset.longValue());
    }

    @Override
    public J9FormatValuePointer sub(long count) {
        return J9FormatValuePointer.cast(this.address - J9FormatValue.SIZEOF * count);
    }

    @Override
    public J9FormatValuePointer sub(Scalar count) {
        return this.sub(count.longValue());
    }

    @Override
    public J9FormatValuePointer subOffset(long offset) {
        return J9FormatValuePointer.cast(this.address - offset);
    }

    @Override
    public J9FormatValuePointer subOffset(Scalar offset) {
        return this.subOffset(offset.longValue());
    }

    @Override
    public J9FormatValuePointer untag(long mask) {
        return J9FormatValuePointer.cast(this.address & (mask ^ 0xFFFFFFFFFFFFFFFFL));
    }

    @Override
    public J9FormatValuePointer untag() {
        return this.untag(UDATA.SIZEOF - 1);
    }

    @Override
    protected long sizeOfBaseType() {
        return J9FormatValue.SIZEOF;
    }

    @GeneratedFieldAccessor(offsetFieldName="_dblOffset_", declaredType="double")
    public double dbl() throws CorruptDataException {
        return this.getDoubleAtOffset(J9FormatValue._dblOffset_);
    }

    public DoublePointer dblEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return DoublePointer.cast(this.address + (long)J9FormatValue._dblOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_ptrOffset_", declaredType="void*")
    public VoidPointer ptr() throws CorruptDataException {
        return VoidPointer.cast(this.getPointerAtOffset(J9FormatValue._ptrOffset_));
    }

    public PointerPointer ptrEA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return PointerPointer.cast(this.address + (long)J9FormatValue._ptrOffset_);
    }

    @GeneratedFieldAccessor(offsetFieldName="_u64Offset_", declaredType="U64")
    public UDATA u64() throws CorruptDataException {
        return new U64(this.getLongAtOffset(J9FormatValue._u64Offset_));
    }

    public UDATAPointer u64EA() throws CorruptDataException {
        if (this.address == 0L) {
            throw new NullPointerDereference();
        }
        return UDATAPointer.cast(this.address + (long)J9FormatValue._u64Offset_);
    }
}

