/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.libraries;

import java.io.File;
import java.io.IOException;
import javax.imageio.stream.FileImageInputStream;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.ImageInputStreamImpl;

public class SlidingImageInputStream
extends ImageInputStreamImpl {
    private final ImageInputStream stream;
    private long length;
    private long start;
    private static final int BUFFER_SIZE = 4096;
    private final byte[] buffer = new byte[4096];
    private int bytesAvailable = 0;
    private boolean EOF = false;
    private int bufferPos = 0;
    private long bytesRead = 0L;
    private boolean hasBufferRefreshed = false;
    private long markBytesRead = 0L;
    private long markFilePos = 0L;
    private long bufferStartPos = 0L;

    public SlidingImageInputStream(File raf, long start, long length) throws IOException {
        this.stream = new FileImageInputStream(raf);
        this.init(start, length);
    }

    public SlidingImageInputStream(ImageInputStream iis, long start, long length) throws IOException {
        this.stream = iis;
        this.init(start, length);
    }

    private void init(long start, long length) throws IOException {
        this.stream.seek(start);
        this.checkBuffer();
        this.length = length;
        this.start = start;
        this.markFilePos = this.stream.getStreamPosition();
    }

    @Override
    public int read() throws IOException {
        if (this.EOF) {
            return -1;
        }
        if (this.bytesRead == this.length) {
            this.EOF = true;
            return -1;
        }
        this.checkBuffer();
        ++this.bytesRead;
        return 0xFF & this.buffer[this.bufferPos++];
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int copiedBytes;
        int tocopy;
        if (this.EOF) {
            return -1;
        }
        if (this.bytesRead == this.length) {
            this.EOF = true;
            return -1;
        }
        if (len + off > b.length) {
            String msg = String.format("The array is too small to copy %d bytes starting at offset %d", len, off);
            throw new IndexOutOfBoundsException(msg);
        }
        if (len < this.bytesAvailable - this.bufferPos) {
            int tocopy2 = (int)Math.min((long)len, this.length - this.bytesRead);
            System.arraycopy(this.buffer, this.bufferPos, b, off, tocopy2);
            this.bufferPos += tocopy2;
            this.bytesRead += (long)tocopy2;
            return tocopy2;
        }
        for (copiedBytes = 0; !this.EOF && copiedBytes < len && this.bytesRead < this.length; copiedBytes += tocopy) {
            tocopy = (int)Math.min((long)(this.bytesAvailable - this.bufferPos), this.length - this.bytesRead);
            tocopy = Math.min(tocopy, len - copiedBytes);
            System.arraycopy(this.buffer, this.bufferPos, b, copiedBytes, tocopy);
            this.bufferPos += tocopy;
            this.bytesRead += (long)tocopy;
            this.checkBuffer();
        }
        return copiedBytes;
    }

    private void checkBuffer() throws IOException {
        if (this.bytesAvailable == this.bufferPos) {
            this.bufferStartPos = this.bytesRead;
            this.hasBufferRefreshed = true;
            this.bytesAvailable = this.stream.read(this.buffer);
            if (this.bytesAvailable == -1) {
                this.EOF = true;
            }
            this.bufferPos = 0;
        }
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public void mark() {
        this.hasBufferRefreshed = false;
        this.markBytesRead = this.bytesRead;
        super.mark();
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        long resetCount = this.bytesRead - this.markBytesRead;
        this.bytesRead -= resetCount;
        if (this.hasBufferRefreshed) {
            this.bufferPos = 0;
            this.bytesAvailable = 0;
            this.stream.seek(this.markFilePos - resetCount);
        } else {
            this.bufferPos = (int)((long)this.bufferPos - resetCount);
        }
    }

    @Override
    public void seek(long pos) throws IOException {
        if (pos < this.bufferStartPos || pos >= this.bufferStartPos + 4096L) {
            this.stream.seek(this.start + pos);
            this.bufferPos = 0;
            this.bytesAvailable = 0;
            this.bytesRead = pos;
            this.checkBuffer();
            super.seek(pos);
        } else {
            int diff = (int)(pos - this.bufferStartPos);
            this.bytesRead = this.bufferStartPos + (long)diff;
            this.bufferPos = diff;
        }
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.bytesRead;
    }
}

