/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.macho;

import com.ibm.j9ddr.corereaders.macho.LoadCommand;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.stream.ImageInputStream;

public class BuildVersionCommand
extends LoadCommand {
    int platform;
    int minOs;
    int sdk;
    int numTools;
    Version minOsVersion;
    Version sdkVersion;
    List<BuildToolVersion> tools;

    @Override
    public BuildVersionCommand readCommand(ImageInputStream stream, long streamSegmentOffset) throws IOException {
        super.readCommand(stream, streamSegmentOffset);
        this.minOs = stream.readInt();
        this.sdk = stream.readInt();
        this.minOsVersion = new Version(this.minOs);
        this.sdkVersion = new Version(this.sdk);
        this.numTools = stream.readInt();
        this.tools = new ArrayList<BuildToolVersion>(this.numTools);
        for (int i = 0; i < this.numTools; ++i) {
            BuildToolVersion tool = new BuildToolVersion();
            tool.toolType = stream.readInt();
            tool.version = stream.readInt();
            this.tools.add(tool);
        }
        return this;
    }

    public static class BuildToolVersion {
        public static final int TOOL_CLANG = 1;
        public static final int TOOL_SWIFT = 2;
        public static final int TOOL_LD = 3;
        int toolType;
        int version;
    }

    public static class Version {
        int major;
        int minor;
        int patch;

        public Version(int encoding) {
            int i;
            for (i = 8; i > 4; --i) {
                this.major = this.major * 10 + (encoding >>> i * 4 & 0xF);
            }
            for (i = 4; i > 2; --i) {
                this.minor = this.minor * 10 + (encoding >>> i * 4 & 0xF);
            }
            for (i = 2; i > 0; --i) {
                this.patch = this.patch * 10 + (encoding >>> i * 4 & 0xF);
            }
        }
    }
}

