/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.corereaders.debugger;

import java.util.Comparator;
import java.util.SortedMap;
import java.util.TreeMap;

abstract class JniRegisters {
    SortedMap<String, Number> _registers = new TreeMap<String, Number>(new RegisterComparator());

    JniRegisters() {
    }

    public static native long getNumberRegisters(long var0);

    public static native String getRegisterName(long var0);

    public static native Number getRegisterValue(long var0, long var2);

    private native boolean fetchRegisters(long var1);

    protected abstract long getStackPointer();

    protected abstract long getInstructionPointer();

    protected abstract long getLinkRegister();

    protected abstract long getBasePointer();

    public int size() {
        return this._registers.size();
    }

    public void setRegister(String name, long value) {
        this._registers.put(new String(name), new Long(value));
    }

    public SortedMap<String, Number> readRegisters(long tid) {
        this.fetchRegisters(tid);
        return this._registers;
    }

    public SortedMap<String, Number> getRegisters() {
        return this._registers;
    }

    public class RegisterComparator
    implements Comparator<String> {
        @Override
        public int compare(String s1, String s2) {
            int last = ((String)s1).length() - 1;
            if (last >= 1 && Character.isDigit(((String)s1).charAt(last)) && Character.isLetter(((String)s1).charAt(last - 1))) {
                s1 = ((String)s1).substring(0, last) + "0" + ((String)s1).substring(last);
            }
            if ((last = ((String)s2).length() - 1) >= 1 && Character.isDigit(((String)s2).charAt(last)) && Character.isLetter(((String)s2).charAt(last - 1))) {
                s2 = ((String)s2).substring(0, last) + "0" + ((String)s2).substring(last);
            }
            return ((String)s1).compareTo((String)s2);
        }
    }
}

