/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.j9ddr.command;

import com.ibm.j9ddr.command.CommandReader;
import com.ibm.j9ddr.command.ExitException;
import com.ibm.j9ddr.tools.ddrinteractive.DDRInteractive;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Semaphore;
import java.util.concurrent.SynchronousQueue;

public class JNICommandReader
extends CommandReader {
    private static final BlockingQueue<String> commandQueue = new SynchronousQueue<String>(true);
    public static String newline = System.getProperty("line.separator");
    private static final Semaphore lock = new Semaphore(0, true);

    public JNICommandReader(PrintStream out) {
        super(out);
    }

    public static void enqueueCommand(String command, String args) {
        try {
            commandQueue.put("!" + command + " " + args + newline);
            lock.acquire();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private String getCommand() {
        try {
            return commandQueue.take();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processInput(DDRInteractive engine) throws Exception {
        while (true) {
            String line;
            if ((line = this.getCommand()).length() == 0) {
                continue;
            }
            try {
                this.processLine(engine, line);
                continue;
            }
            catch (ExitException e) {
                return;
            }
            finally {
                lock.release();
                continue;
            }
            break;
        }
    }

    @Override
    public void setInputStream(InputStream in) {
    }
}

