MODULE tPythag;

IMPORT Out;

CONST eps = 1.0E-10;

PROCEDURE Pythag(x, y: LONGREAL): LONGREAL;
  VAR r: LONGREAL;
BEGIN
  LOOP
    Out.LongReal(x, 0); Out.Char(' '); Out.LongReal(y, 0); Out.Ln;
    r := y/x; r := r * r;
    IF r < eps THEN EXIT END;
    r := r/(4+r);
    x := x + 2*x*r;
    y := y*r
  END;
  RETURN x
END Pythag;

BEGIN
  Out.LongReal(Pythag(1, 1), 0); Out.Ln;
  Out.LongReal(Pythag(3, 4), 0); Out.Ln
END tPythag.

(*<<
1.00000000000 1.00000000000
1.40000000000 0.200000000000
1.41421319797 0.00101522842640
1.41421356237 1.30798116260E-10
1.41421356237
3.00000000000 4.00000000000
4.84615384615 1.23076923077
4.99996185317 0.0195311754945
5.00000000000 7.45058059692E-08
5.00000000000
>>*)

(*[[
!! (SYMFILE #tPythag STAMP #tPythag.%main 1 #tPythag.m)
!! (CHKSUM STAMP)
!! 
MODULE tPythag STAMP 0
IMPORT Out STAMP
ENDHDR

PROC tPythag.Pythag 8 6 0
! PROCEDURE Pythag(x, y: LONGREAL): LONGREAL;
LABEL L1
!     Out.LongReal(x, 0); Out.Char(' '); Out.LongReal(y, 0); Out.Ln;
CONST 0
LDLD 12
GLOBAL Out.LongReal
CALL 3
CONST 32
ALIGNC
GLOBAL Out.Char
CALL 1
CONST 0
LDLD 20
GLOBAL Out.LongReal
CALL 3
GLOBAL Out.Ln
CALL 0
!     r := y/x; r := r * r;
LDLD 20
LDLD 12
DZCHECK 12
DDIV
STLD -8
LDLD -8
LDLD -8
DTIMES
STLD -8
!     IF r < eps THEN EXIT END;
LDLD -8
DCONST 1.0e-10
DJLT L2
!     r := r/(4+r);
LDLD -8
LDLD -8
DCONST 4.0
DPLUS
DZCHECK 14
DDIV
STLD -8
!     x := x + 2*x*r;
LDLD 12
LDLD 12
DCONST 2.0
DTIMES
LDLD -8
DTIMES
DPLUS
STLD 12
!     y := y*r
LDLD 20
LDLD -8
DTIMES
STLD 20
JUMP L1
LABEL L2
!   RETURN x
LDLD 12
RETURN
END

PROC tPythag.%main 0 6 0
!   Out.LongReal(Pythag(1, 1), 0); Out.Ln;
CONST 0
DCONST 1.0
DCONST 1.0
GLOBAL tPythag.Pythag
CALLD 4
GLOBAL Out.LongReal
CALL 3
GLOBAL Out.Ln
CALL 0
!   Out.LongReal(Pythag(3, 4), 0); Out.Ln
CONST 0
DCONST 4.0
DCONST 3.0
GLOBAL tPythag.Pythag
CALLD 4
GLOBAL Out.LongReal
CALL 3
GLOBAL Out.Ln
CALL 0
RETURN
END

! End of file
]]*)
