const React = require('react');

const {
  Box,
  Color
} = require('ink');

const util = require('util');

const counts = require('./counts.js');

const chalk = require('chalk');

const yaml = require('tap-yaml');

const ms = require('ms');

const importJSX = require('import-jsx');

const AssertName = importJSX('./assert-name.js');
const StatusMark = importJSX('./status-mark.js');

const showYaml = test => test.results && !test.results.ok && !test.lists.fail.length && (test.options.exitCode || test.options.signal);

const lists = test => /*#__PURE__*/React.createElement(Box, {
  flexDirection: "column",
  marginBottom: showYaml(test) || test.lists.fail.length || test.lists.todo.length || test.lists.skip.length ? 1 : 0
}, test.lists.fail.length ? /*#__PURE__*/React.createElement(Box, {
  flexDirection: "column"
}, test.lists.fail.map((res, i) => /*#__PURE__*/React.createElement(AssertName, Object.assign({}, res, {
  key: '' + i
})))) : '', test.lists.todo.length ? /*#__PURE__*/React.createElement(Box, {
  flexDirection: "column"
}, test.lists.todo.map((res, i) => /*#__PURE__*/React.createElement(AssertName, Object.assign({}, res, {
  key: '' + i
})))) : '', test.lists.skip.length ? /*#__PURE__*/React.createElement(Box, {
  flexDirection: "column"
}, test.lists.skip.map((res, i) => /*#__PURE__*/React.createElement(AssertName, Object.assign({}, res, {
  key: '' + i
})))) : '', // cases where no tests fail, but the test fails
// eg, exiting with non-zero code, being killed, etc.
showYaml(test) ? /*#__PURE__*/React.createElement(Box, null, '  ' + yaml.stringify({
  command: test.options.command,
  args: test.options.args,
  exitCode: test.options.exitCode,
  signal: test.options.signal
}).replace(/\n/g, '\n  ').trimRight()) : '', printBail(test.results));

const skipOrTodoReason = test => test.options.skip && test.options.skip !== true ? ` > ${chalk.cyan(test.options.skip)}` : test.options.todo && test.options.todo !== true ? ` > ${chalk.magenta(test.options.todo)}` : '';

const printBail = results => !results || !results.bailout ? '' : /*#__PURE__*/React.createElement(Box, {
  marginTop: 1
}, chalk.bold.red('BAILOUT ') + results.bailout);

const printLists = test => test.results && (test.results.bailout || !test.results.ok || test.counts.pass !== test.counts.total);

const time = (time, start, end) => !start ? /*#__PURE__*/React.createElement(Color, {
  dim: true
}, ' ...') : /*#__PURE__*/React.createElement(Color, {
  hex: "#aaa",
  bold: true
}, ms(time || (end || Date.now()) - start));

module.exports = ({
  test
}) => /*#__PURE__*/React.createElement(Box, {
  flexDirection: "column"
}, /*#__PURE__*/React.createElement(Box, null, /*#__PURE__*/React.createElement(StatusMark, {
  test: test
}), ' ' + test.name + skipOrTodoReason(test), counts(test.counts), time(test.time, test.startTime, test.endTime)), printLists(test) ? lists(test) : '');
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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