const React = require('react');

const {
  Box,
  Color
} = require('ink');

const glyphColor = ({
  ok,
  skip,
  todo
}) => ({
  [skip ? 'cyan' : todo ? 'magenta' : !ok ? 'red' : 'green']: true
});

const glyphText = ({
  ok,
  skip,
  todo
}) => skip ? ' ~ ' : todo ? ' ☐ ' : !ok ? ' ✖ ' : ' ✓ ';

const Glyph = ({
  ok,
  skip,
  todo
}) => /*#__PURE__*/React.createElement(Box, {
  width: 3
}, /*#__PURE__*/React.createElement(Color, Object.assign({
  bold: true
}, glyphColor({
  ok,
  skip,
  todo
})), glyphText({
  ok,
  skip,
  todo
})));

const Reason = ({
  skip,
  todo
}) => skip && skip !== true ? /*#__PURE__*/React.createElement(Box, null, ' > ', /*#__PURE__*/React.createElement(Color, glyphColor({
  skip,
  todo
}), skip)) : todo && todo !== true ? /*#__PURE__*/React.createElement(Box, null, ' > ', /*#__PURE__*/React.createElement(Color, glyphColor({
  skip,
  todo
}), todo)) : '';

const AssertName = ({
  ok,
  name,
  skip,
  todo
}) => /*#__PURE__*/React.createElement(Box, null, /*#__PURE__*/React.createElement(Glyph, {
  ok,
  skip,
  todo
}), name || '(unnamed test)', /*#__PURE__*/React.createElement(Reason, {
  skip,
  todo
}));

module.exports = AssertName;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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