<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/collectors/ebpf.plugin/integrations/ebpf_shm.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/collectors/ebpf.plugin/metadata.yaml"
sidebar_label: "eBPF SHM"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/eBPF"
most_popular: False
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# eBPF SHM


<img src="https://netdata.cloud/img/ebpf.jpg" width="150"/>


Plugin: ebpf.plugin
Module: shm

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

Monitor syscall responsible to manipulate shared memory.

Attach tracing (kprobe, trampoline) to internal kernel functions according options used to compile kernel.

This collector is only supported on the following platforms:

- Linux

This collector supports collecting metrics from multiple instances of this integration, including remote instances.

The plugin needs setuid because it loads data inside kernel. Netada sets necessary permission during installation time.

### Default Behavior

#### Auto-Detection

The plugin checks kernel compilation flags (CONFIG_KPROBES, CONFIG_BPF, CONFIG_BPF_SYSCALL, CONFIG_BPF_JIT) and presence of BTF files to decide which eBPF program will be attached.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

This thread will add overhead every time that an internal kernel function monitored by this thread is called. The estimated additional period of time is between 90-200ms per call on kernels that do not have BTF technology.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per cgroup

These Metrics show grouped information per cgroup/service.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| cgroup.shmget | get | calls/s |
| cgroup.shmat | at | calls/s |
| cgroup.shmdt | dt | calls/s |
| cgroup.shmctl | ctl | calls/s |
| services.shmget | a dimension per systemd service | calls/s |
| services.shmat | a dimension per systemd service | calls/s |
| services.shmdt | a dimension per systemd service | calls/s |
| services.shmctl | a dimension per systemd service | calls/s |

### Per apps

These Metrics show grouped information per apps group.

Labels:

| Label      | Description     |
|:-----------|:----------------|
| app_group | The name of the group defined in the configuration. |

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| app.ebpf_shmget_call | calls | calls/s |
| app.ebpf_shmat_call | calls | calls/s |
| app.ebpf_shmdt_call | calls | calls/s |
| app.ebpf_shmctl_call | calls | calls/s |

### Per eBPF SHM instance

These Metrics show number of calls for specified syscall.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| system.shared_memory_calls | get, at, dt, ctl | calls/s |



## Alerts

There are no alerts configured by default for this integration.


## Setup


### Prerequisites

#### Compile kernel

Check if your kernel was compiled with necessary options (CONFIG_KPROBES, CONFIG_BPF, CONFIG_BPF_SYSCALL, CONFIG_BPF_JIT) in `/proc/config.gz` or inside /boot/config file. Some cited names can be different accoring preferences of Linux distributions.
When you do not have options set, it is necessary to get the kernel source code from https://kernel.org or a kernel package from your distribution, this last is preferred. The kernel compilation has a well definedd pattern, but distributions can deliver their configuration files
with different names.

Now follow steps:
1. Copy the configuration file to /usr/src/linux/.config.
2. Select the necessary options: make oldconfig
3. Compile your kernel image: make bzImage
4. Compile your modules: make modules
5. Copy your new kernel image for boot loader directory
6. Install the new modules: make modules_install
7. Generate an initial ramdisk image (`initrd`) if it is necessary.
8. Update your boot loader


#### Debug Filesystem

This thread needs to attach a tracepoint to monitor when a process schedule an exit event. To allow this specific feaure, it is necessary to mount `debugfs` (`mount -t debugfs none /sys/kernel/debug/`).`



### Configuration

#### Options

This configuration file have two different sections. The `[global]` overwrites all default options, while `[syscalls]` allow user to select the syscall to monitor.


<details open><summary>Config options</summary>



| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| update every | Data collection frequency. | 5 | no |
| ebpf load mode | Define whether plugin will monitor the call (`entry`) for the functions or it will also monitor the return (`return`). | entry | no |
| apps | Enable or disable integration with apps.plugin | no | no |
| cgroups | Enable or disable integration with cgroup.plugin | no | no |
| pid table size | Number of elements stored inside hash tables used to monitor calls per PID. | 32768 | no |
| ebpf type format | Define the file type to load an eBPF program. Three options are available: `legacy` (Attach only `kprobe`), `co-re` (Plugin tries to use `trampoline` when available), and `auto` (plugin check OS configuration before to load). | auto | no |
| ebpf co-re tracing | Select the attach method used by plugin when `co-re` is defined in previous option. Two options are available: `trampoline` (Option with lowest overhead), and `probe` (the same of legacy code). | trampoline | no |
| maps per core | Define how plugin will load their hash maps. When enabled (`yes`) plugin will load one hash table per core, instead to have centralized information. | yes | no |
| lifetime | Set default lifetime for thread when enabled by cloud. | 300 | no |
| shmget | Enable or disable monitoring for syscall `shmget` | yes | no |
| shmat | Enable or disable monitoring for syscall `shmat` | yes | no |
| shmdt | Enable or disable monitoring for syscall `shmdt` | yes | no |
| shmctl | Enable or disable monitoring for syscall `shmctl` | yes | no |


</details>



#### via File

The configuration file name for this integration is `ebpf.d/shm.conf`.

The file format is a modified INI syntax. The general structure is:

```ini
[section1]
    option1 = some value
    option2 = some other value

[section2]
    option3 = some third value
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config ebpf.d/shm.conf
```

##### Examples
There are no configuration examples.


