<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/health/notifications/pushover/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/health/notifications/pushover/metadata.yaml"
sidebar_label: "PushOver"
learn_status: "Published"
learn_rel_path: "Alerting/Notifications/Agent Dispatched Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# PushOver


<img src="https://netdata.cloud/img/pushover.png" width="150"/>


Send notification to Pushover using Netdata's Agent alert notification feature, which supports dozens of endpoints, user roles, and more.
- Netdata will send warning messages with priority 0 and critical messages with priority 1.
- Pushover allows you to select do-not-disturb hours. The way this is configured, critical notifications will ring and vibrate your phone, even during the do-not-disturb-hours.
- All other notifications will be delivered silently.



<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup

### Prerequisites

#### 

- An Application token. You can use the same on all your Netdata servers.
- A User token for each user you are going to send notifications to. This is the actual recipient of the notification.
- Access to the terminal where Netdata Agent is running



### Configuration

#### File

The configuration file name for this integration is `health_alarm_notify.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config health_alarm_notify.conf
```
#### Options

The following options can be defined for this notification

<details><summary>Config Options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| SEND_PUSHOVER | Set `SEND_PUSHOVER` to YES | YES | yes |
| PUSHOVER_WEBHOOK_URL | set `PUSHOVER_WEBHOOK_URL` to your Pushover Application token. |  | yes |
| DEFAULT_RECIPIENT_PUSHOVER | Set `DEFAULT_RECIPIENT_PUSHOVER` the Pushover User token you want the alert notifications to be sent to. You can define multiple User tokens like this: `USERTOKEN1` `USERTOKEN2`. |  | yes |

##### DEFAULT_RECIPIENT_PUSHOVER

All roles will default to this variable if left unconfigured.

The `DEFAULT_RECIPIENT_PUSHOVER` can be edited in the following entries at the bottom of the same file:
```conf
role_recipients_pushover[sysadmin]="USERTOKEN1"
role_recipients_pushover[domainadmin]="USERTOKEN2"
role_recipients_pushover[dba]="USERTOKEN3 USERTOKEN4"
role_recipients_pushover[webmaster]="USERTOKEN5"
role_recipients_pushover[proxyadmin]="USERTOKEN6"
role_recipients_pushover[sitemgr]="USERTOKEN7"
```


</details>

#### Examples

##### Basic Configuration



```yaml
#------------------------------------------------------------------------------
# pushover (pushover.net) global notification options

SEND_PUSHOVER="YES"
PUSHOVER_APP_TOKEN="XXXXXXXXX"
DEFAULT_RECIPIENT_PUSHOVER="USERTOKEN"

```


## Troubleshooting

### Test Notification

You can run the following command by hand, to test alerts configuration:

```bash
# become user netdata
sudo su -s /bin/bash netdata

# enable debugging info on the console
export NETDATA_ALARM_NOTIFY_DEBUG=1

# send test alarms to sysadmin
/usr/libexec/netdata/plugins.d/alarm-notify.sh test

# send test alarms to any role
/usr/libexec/netdata/plugins.d/alarm-notify.sh test "ROLE"
```

Note that this will test _all_ alert mechanisms for the selected role.


