#------------------------------------------------------------------------
# -*- mode: cmake -*-
#------------------------------------------------------------------------
include(ax_packaging_deb)
include(ax_packaging_macports)
include(ax_packaging_rpm)

function(ax_packaging)
  if("${CMAKE_GENERATOR}" MATCHES "Make")
    set(STAGING_DIR "${CMAKE_BINARY_DIR}/staging")
    set(TAR_DIR_NAME "${PROJECT_NAME}-${${PROJECT_NAME}_VERSION}")
    set(TAR_NAME "${TAR_DIR_NAME}.tar.gz")
    if(NOT PROJECT_SPEC_FILENAME)
      set(PROJECT_SPEC_FILENAME ${CMAKE_BINARY_DIR}/${PROJECT_NAME}.spec)
    endif(NOT PROJECT_SPEC_FILENAME)
    add_custom_target(dist
		      COMMAND cpack -G TGZ --config CPackSourceConfig.cmake
		      COMMAND ${CMAKE_COMMAND} -E make_directory ${STAGING_DIR}
		      COMMAND tar -x -z -C ${STAGING_DIR} -f ${CMAKE_BINARY_DIR}/${TAR_NAME}
		      COMMAND ${CMAKE_COMMAND} -E copy ${PROJECT_SPEC_FILENAME} ${STAGING_DIR}/${TAR_DIR_NAME}
		      COMMAND ${CMAKE_COMMAND} -E copy ${PROJECT_DEBIAN_RULES_OUTPUT_FILENAME} ${STAGING_DIR}/${TAR_DIR_NAME}/debian/.
		      COMMAND tar -c -z -C ${STAGING_DIR} -f ${TAR_NAME} ${TAR_DIR_NAME}
		      WORKING_DIRECTORY ${CMAKE_CURRENT_DIR})
  endif("${CMAKE_GENERATOR}" MATCHES "Make")

  ax_packaging_deb()
  ax_packaging_macports()
  ax_packaging_rpm()
endfunction(ax_packaging)