% -*- mode: octave -*-
%------------------------------------------------------------------------
%------------------------------------------------------------------------

unit_test = UnitTest( );

hostname = unit_test.hostname( );
port = unit_test.port( );
protocol = ndsm.Connection.PROTOCOL_TWO;
if ( strcmp( argv, '-proto-1' ) )
    protocol = ndsm.Connection.PROTOCOL_ONE;
elseif ( strcmp( argv, '-proto-2' ) )
	protocol = ndsm.Connection.PROTOCOL_TWO;
end


%------------------------------------------------------------------------
% Establish the connection
%------------------------------------------------------------------------
	   
conn = ndsm.Connection(hostname, port, protocol );

%------------------------------------------------------------------------
% Run the test
%------------------------------------------------------------------------
if(  conn.getprotocol() == ndsm.Connection.PROTOCOL_ONE )
  unit_test.check( conn.countchannels('*'), ...
		  4*11, ...
		  'PROTOCOL 1 Full count' );
  unit_test.check( conn.countchannels('*4*'), ...
		  11, ...
		  'PROTOCOL 1 Channels containing the number 4' );
  unit_test.check( conn.countchannels('*4*', ...
				      ndsm.Channel.getDEFAULT_CHANNEL_MASK( ), ...
				      ndsm.Channel.getDEFAULT_DATA_MASK( ), ...
				      0.9, ...
				      1.1), ...
		  5, ...
		  'PROTOCOL 1 Channels containing the number 4 - DEFAULT_CHANNEL_MASK and DEFAULT_DATA_MASK' );
  unit_test.check( conn.countchannels('*', ...
				      ndsm.Channel.CHANNEL_TYPE_ONLINE), ...
		  4, ...
		  'PROTOCOL 1 All online channels' );
  unit_test.check( conn.countchannels('*', ...
				      ndsm.Channel.CHANNEL_TYPE_ONLINE, ...
				      ndsm.Channel.getDEFAULT_DATA_MASK( ), ...
				      10.0, ...
				      300.0), ...
		  4, ...
		  'PROTOCOL 1 All online channels with DEFAULT_DATA_MASK' );
else
  unit_test.check( conn.countchannels('*'), ...
		  12, ...
		  'PROTOCOL 2 Full count' );
  unit_test.check( conn.countchannels('*4*'), ...
		  3, ...
		  'PROTOCOL 2 Channels containing the number 4' );
  unit_test.check( conn.countchannels('*4*', ...
				      ndsm.Channel.getDEFAULT_CHANNEL_MASK( ), ...
				      ndsm.Channel.getDEFAULT_DATA_MASK( ), ...
				      0.9, ...
				      1.1), ...
		  1, ...
		  'PROTOCOL 2 Channels containing the number 4 - DEFAULT_CHANNEL_MASK and DEFAULT_DATA_MASK' );
  unit_test.check( conn.countchannels('*', ...
				      ndsm.Channel.CHANNEL_TYPE_RAW), ...
		  4, ...
		  'PROTOCOL 2 All raw channel types' );
  unit_test.check( conn.countchannels('*', ...
				      ndsm.Channel.CHANNEL_TYPE_RAW, ...
				      ndsm.Channel.getDEFAULT_DATA_MASK( ), ...
				      10.0, ...
				      300.0), ...
		  4, ...
		  'PROTOCOL 2 all raw channesl with DEFAULT_DATA_MASK' );
end

%------------------------------------------------------------------------
% Finish
%------------------------------------------------------------------------
conn.close( );

unit_test.exit( );
