/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/main":function(){define("dojox/main",["dojo/_base/kernel"],function(_1){return _1.dojox;});},"dojox/grid/_Grid":function(){define(["dojo/_base/kernel","../main","dojo/_base/declare","./_Events","./_Scroller","./_Layout","./_View","./_ViewManager","./_RowManager","./_FocusManager","./_EditManager","./Selection","./_RowSelector","./util","dijit/_Widget","dijit/_TemplatedMixin","dijit/CheckedMenuItem","dojo/text!./resources/_Grid.html","dojo/string","dojo/_base/array","dojo/_base/lang","dojo/_base/sniff","dojox/html/metrics","dojo/_base/html","dojo/query","dojo/dnd/common","dojo/i18n!dijit/nls/loading"],function(_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d,_e,_f,_10,_11,_12,_13,_14,_15,_16,has,_17,_18,_19){if(!_2.isCopyKey){_2.isCopyKey=_2.dnd.getCopyKeyState;}var _1a=_4("dojox.grid._Grid",[_10,_11,_5],{templateString:_13,classTag:"dojoxGrid",rowCount:5,keepRows:75,rowsPerPage:25,autoWidth:false,initialWidth:"",autoHeight:"",rowHeight:0,autoRender:true,defaultHeight:"15em",height:"",structure:null,elasticView:-1,singleClickEdit:false,selectionMode:"extended",rowSelector:"",columnReordering:false,headerMenu:null,placeholderLabel:"GridColumns",selectable:false,_click:null,loadingMessage:"<span class='dojoxGridLoading'>${loadingState}</span>",errorMessage:"<span class='dojoxGridError'>${errorState}</span>",noDataMessage:"",escapeHTMLInData:true,formatterScope:null,editable:false,summary:"",_setSummaryAttr:"domNode",sortInfo:0,_placeholders:null,_layoutClass:_7,buildRendering:function(){this.inherited(arguments);if(!this.domNode.getAttribute("tabIndex")){this.domNode.tabIndex="0";}this.createScroller();this.createLayout();this.createViews();this.createManagers();this.createSelection();this.connect(this.selection,"onSelected","onSelected");this.connect(this.selection,"onDeselected","onDeselected");this.connect(this.selection,"onChanged","onSelectionChanged");_17.initOnFontResize();this.connect(_17,"onFontResize","textSizeChanged");_f.funnelEvents(this.domNode,this,"doKeyEvent",_f.keyEvents);if(this.selectionMode!="none"){this.domNode.setAttribute("aria-multiselectable",this.selectionMode=="single"?"false":"true");}_18.addClass(this.domNode,this.classTag);if(!this.isLeftToRight()){_18.addClass(this.domNode,this.classTag+"Rtl");}if(this.rowHeight>0){_18.addClass(this.viewsNode,this.classTag+"FixedRowHeight");}},postMixInProperties:function(){this.inherited(arguments);var _1b=_2.i18n.getLocalization("dijit","loading",this.lang);this.loadingMessage=_14.substitute(this.loadingMessage,_1b);this.errorMessage=_14.substitute(this.errorMessage,_1b);if(this.srcNodeRef&&this.srcNodeRef.style.height){this.height=this.srcNodeRef.style.height;}this._setAutoHeightAttr(this.autoHeight,true);this.lastScrollTop=this.scrollTop=0;},postCreate:function(){this._placeholders=[];this._setHeaderMenuAttr(this.headerMenu);this._setStructureAttr(this.structure);this._click=[];this.inherited(arguments);if(this.domNode&&this.autoWidth&&this.initialWidth){this.domNode.style.width=this.initialWidth;}if(this.domNode&&!this.editable){_18.attr(this.domNode,"aria-readonly","true");}},destroy:function(){this.domNode.onReveal=null;this.domNode.onSizeChange=null;delete this._click;if(this.scroller){this.scroller.destroy();delete this.scroller;}this.edit.destroy();delete this.edit;this.views.destroyViews();if(this.focus){this.focus.destroy();delete this.focus;}if(this.headerMenu&&this._placeholders.length){_15.forEach(this._placeholders,function(p){p.unReplace(true);});this.headerMenu.unBindDomNode(this.viewsHeaderNode);}this.inherited(arguments);},_setAutoHeightAttr:function(ah,_1c){if(typeof ah=="string"){if(!ah||ah=="false"){ah=false;}else{if(ah=="true"){ah=true;}else{ah=window.parseInt(ah,10);}}}if(typeof ah=="number"){if(isNaN(ah)){ah=false;}if(ah<0){ah=true;}else{if(ah===0){ah=false;}}}this.autoHeight=ah;if(typeof ah=="boolean"){this._autoHeight=ah;}else{if(typeof ah=="number"){this._autoHeight=(ah>=this.get("rowCount"));}else{this._autoHeight=false;}}if(this._started&&!_1c){this.render();}},_getRowCountAttr:function(){return this.updating&&this.invalidated&&this.invalidated.rowCount!=undefined?this.invalidated.rowCount:this.rowCount;},textSizeChanged:function(){this.render();},sizeChange:function(){this.update();},createManagers:function(){this.rows=new _a(this);this.focus=new _b(this);this.edit=new _c(this);},createSelection:function(){this.selection=new _d(this);},createScroller:function(){this.scroller=new _6();this.scroller.grid=this;this.scroller.renderRow=_16.hitch(this,"renderRow");this.scroller.removeRow=_16.hitch(this,"rowRemoved");},createLayout:function(){this.layout=new this._layoutClass(this);this.connect(this.layout,"moveColumn","onMoveColumn");},onMoveColumn:function(){this.update();},onResizeColumn:function(_1d){},createViews:function(){this.views=new _9(this);this.views.createView=_16.hitch(this,"createView");},createView:function(_1e,idx){var c=_16.getObject(_1e);var _1f=new c({grid:this,index:idx});this.viewsNode.appendChild(_1f.domNode);this.viewsHeaderNode.appendChild(_1f.headerNode);this.views.addView(_1f);_18.attr(this.domNode,"align",this.isLeftToRight()?"left":"right");return _1f;},buildViews:function(){for(var i=0,vs;(vs=this.layout.structure[i]);i++){this.createView(vs.type||_3._scopeName+".grid._View",i).setStructure(vs);}this.scroller.setContentNodes(this.views.getContentNodes());},_setStructureAttr:function(_20){var s=_20;if(s&&_16.isString(s)){_2.deprecated("dojox.grid._Grid.set('structure', 'objVar')","use dojox.grid._Grid.set('structure', objVar) instead","2.0");s=_16.getObject(s);}this.structure=s;if(!s){if(this.layout.structure){s=this.layout.structure;}else{return;}}this.views.destroyViews();this.focus.focusView=null;if(s!==this.layout.structure){this.layout.setStructure(s);}this._structureChanged();},setStructure:function(_21){_2.deprecated("dojox.grid._Grid.setStructure(obj)","use dojox.grid._Grid.set('structure', obj) instead.","2.0");this._setStructureAttr(_21);},getColumnTogglingItems:function(){var _22,_23=[];_22=_15.map(this.layout.cells,function(_24){if(!_24.menuItems){_24.menuItems=[];}var _25=this;var _26=new _12({label:_24.name,checked:!_24.hidden,_gridCell:_24,onChange:function(_27){if(_25.layout.setColumnVisibility(this._gridCell.index,_27)){var _28=this._gridCell.menuItems;if(_28.length>1){_15.forEach(_28,function(_29){if(_29!==this){_29.setAttribute("checked",_27);}},this);}_27=_15.filter(_25.layout.cells,function(c){if(c.menuItems.length>1){_15.forEach(c.menuItems,"item.set('disabled', false);");}else{c.menuItems[0].set("disabled",false);}return !c.hidden;});if(_27.length==1){_15.forEach(_27[0].menuItems,"item.set('disabled', true);");}}},destroy:function(){var _2a=_15.indexOf(this._gridCell.menuItems,this);this._gridCell.menuItems.splice(_2a,1);delete this._gridCell;_12.prototype.destroy.apply(this,arguments);}});_24.menuItems.push(_26);if(!_24.hidden){_23.push(_26);}return _26;},this);if(_23.length==1){_23[0].set("disabled",true);}return _22;},_setHeaderMenuAttr:function(_2b){if(this._placeholders&&this._placeholders.length){_15.forEach(this._placeholders,function(p){p.unReplace(true);});this._placeholders=[];}if(this.headerMenu){this.headerMenu.unBindDomNode(this.viewsHeaderNode);}this.headerMenu=_2b;if(!_2b){return;}this.headerMenu.bindDomNode(this.viewsHeaderNode);if(this.headerMenu.getPlaceholders){this._placeholders=this.headerMenu.getPlaceholders(this.placeholderLabel);}},setHeaderMenu:function(_2c){_2.deprecated("dojox.grid._Grid.setHeaderMenu(obj)","use dojox.grid._Grid.set('headerMenu', obj) instead.","2.0");this._setHeaderMenuAttr(_2c);},setupHeaderMenu:function(){if(this._placeholders&&this._placeholders.length){_15.forEach(this._placeholders,function(p){if(p._replaced){p.unReplace(true);}p.replace(this.getColumnTogglingItems());},this);}},_fetch:function(_2d){this.setScrollTop(0);},getItem:function(_2e){return null;},showMessage:function(_2f){if(_2f){this.messagesNode.innerHTML=_2f;this.messagesNode.style.display="";}else{this.messagesNode.innerHTML="";this.messagesNode.style.display="none";}},_structureChanged:function(){this.buildViews();if(this.autoRender&&this._started){this.render();}},hasLayout:function(){return this.layout.cells.length;},resize:function(_30,_31){this._pendingChangeSize=_30;this._pendingResultSize=_31;this.sizeChange();},_getPadBorder:function(){this._padBorder=this._padBorder||_18._getPadBorderExtents(this.domNode);return this._padBorder;},_getHeaderHeight:function(){var vns=this.viewsHeaderNode.style,t=vns.display=="none"?0:this.views.measureHeader();vns.height=t+"px";this.views.normalizeHeaderNodeHeight();return t;},_resize:function(_32,_33){_32=_32||this._pendingChangeSize;_33=_33||this._pendingResultSize;delete this._pendingChangeSize;delete this._pendingResultSize;if(!this.domNode){return;}var pn=this.domNode.parentNode;if(!pn||pn.nodeType!=1||!this.hasLayout()||pn.style.visibility=="hidden"||pn.style.display=="none"){return;}var _34=this._getPadBorder();var hh=undefined;var h;if(this._autoHeight){this.domNode.style.height="auto";}else{if(typeof this.autoHeight=="number"){h=hh=this._getHeaderHeight();h+=(this.scroller.averageRowHeight*this.autoHeight);this.domNode.style.height=h+"px";}else{if(this.domNode.clientHeight<=_34.h){if(pn==document.body){this.domNode.style.height=this.defaultHeight;}else{if(this.height){this.domNode.style.height=this.height;}else{this.fitTo="parent";}}}}}if(_33){_32=_33;}if(!this._autoHeight&&_32){_18.marginBox(this.domNode,_32);this.height=this.domNode.style.height;delete this.fitTo;}else{if(this.fitTo=="parent"){h=this._parentContentBoxHeight=(this._parentContentBoxHeight>0?this._parentContentBoxHeight:_18._getContentBox(pn).h);this.domNode.style.height=Math.max(0,h)+"px";}}var _35=_15.some(this.views.views,function(v){return v.flexCells;});if(!this._autoHeight&&(h||_18._getContentBox(this.domNode).h)===0){this.viewsHeaderNode.style.display="none";}else{this.viewsHeaderNode.style.display="block";if(!_35&&hh===undefined){hh=this._getHeaderHeight();}}if(_35){hh=undefined;}this.adaptWidth();this.adaptHeight(hh);this.postresize();},adaptWidth:function(){var _36=(!this.initialWidth&&this.autoWidth);var w=_36?0:this.domNode.clientWidth||(this.domNode.offsetWidth-this._getPadBorder().w),vw=this.views.arrange(1,w);this.views.onEach("adaptWidth");if(_36){this.domNode.style.width=vw+"px";}},adaptHeight:function(_37){var t=_37===undefined?this._getHeaderHeight():_37;var h=(this._autoHeight?-1:Math.max(this.domNode.clientHeight-t,0)||0);this.views.onEach("setSize",[0,h]);this.views.onEach("adaptHeight");if(!this._autoHeight){var _38=0,_39=0;var _3a=_15.filter(this.views.views,function(v){var has=v.hasHScrollbar();if(has){_38++;}else{_39++;}return (!has);});if(_38>0&&_39>0){_15.forEach(_3a,function(v){v.adaptHeight(true);});}}if(this.autoHeight===true||h!=-1||(typeof this.autoHeight=="number"&&this.autoHeight>=this.get("rowCount"))){this.scroller.windowHeight=h;}else{this.scroller.windowHeight=Math.max(this.domNode.clientHeight-t,0);}},startup:function(){if(this._started){return;}this.inherited(arguments);if(this.autoRender){this.render();}},render:function(){if(!this.domNode){return;}if(!this._started){return;}if(!this.hasLayout()){this.scroller.init(0,this.keepRows,this.rowsPerPage);return;}this.update=this.defaultUpdate;this._render();},_render:function(){this.scroller.init(this.get("rowCount"),this.keepRows,this.rowsPerPage);this.prerender();this.setScrollTop(0);this.postrender();},prerender:function(){this.keepRows=this._autoHeight?0:this.keepRows;this.scroller.setKeepInfo(this.keepRows);this.views.render();this._resize();},postrender:function(){this.postresize();this.focus.initFocusView();_18.setSelectable(this.domNode,this.selectable);},postresize:function(){if(this._autoHeight){var _3b=Math.max(this.views.measureContent())+"px";this.viewsNode.style.height=_3b;}},renderRow:function(_3c,_3d){this.views.renderRow(_3c,_3d,this._skipRowRenormalize);},rowRemoved:function(_3e){this.views.rowRemoved(_3e);},invalidated:null,updating:false,beginUpdate:function(){this.invalidated=[];this.updating=true;},endUpdate:function(){this.updating=false;var i=this.invalidated,r;if(i.all){this.update();}else{if(i.rowCount!=undefined){this.updateRowCount(i.rowCount);}else{for(r in i){this.updateRow(Number(r));}}}this.invalidated=[];},defaultUpdate:function(){if(!this.domNode){return;}if(this.updating){this.invalidated.all=true;return;}this.lastScrollTop=this.scrollTop;this.prerender();this.scroller.invalidateNodes();this.setScrollTop(this.lastScrollTop);this.postrender();},update:function(){this.render();},updateRow:function(_3f){_3f=Number(_3f);if(this.updating){this.invalidated[_3f]=true;}else{this.views.updateRow(_3f);this.scroller.rowHeightChanged(_3f);}},updateRows:function(_40,_41){_40=Number(_40);_41=Number(_41);var i;if(this.updating){for(i=0;i<_41;i++){this.invalidated[i+_40]=true;}}else{for(i=0;i<_41;i++){this.views.updateRow(i+_40,this._skipRowRenormalize);}this.scroller.rowHeightChanged(_40);}},updateRowCount:function(_42){if(this.updating){this.invalidated.rowCount=_42;}else{this.rowCount=_42;this._setAutoHeightAttr(this.autoHeight,true);if(this.layout.cells.length){this.scroller.updateRowCount(_42);}this._resize();if(this.layout.cells.length){this.setScrollTop(this.scrollTop);}}},updateRowStyles:function(_43){this.views.updateRowStyles(_43);},getRowNode:function(_44){if(this.focus.focusView&&!(this.focus.focusView instanceof _e)){return this.focus.focusView.rowNodes[_44];}else{for(var i=0,_45;(_45=this.views.views[i]);i++){if(!(_45 instanceof _e)){return _45.rowNodes[_44];}}}return null;},rowHeightChanged:function(_46){this.views.renormalizeRow(_46);this.scroller.rowHeightChanged(_46);},fastScroll:true,delayScroll:false,scrollRedrawThreshold:(has("ie")?100:50),scrollTo:function(_47){if(!this.fastScroll){this.setScrollTop(_47);return;}var _48=Math.abs(this.lastScrollTop-_47);this.lastScrollTop=_47;if(_48>this.scrollRedrawThreshold||this.delayScroll){this.delayScroll=true;this.scrollTop=_47;this.views.setScrollTop(_47);if(this._pendingScroll){window.clearTimeout(this._pendingScroll);}var _49=this;this._pendingScroll=window.setTimeout(function(){delete _49._pendingScroll;_49.finishScrollJob();},200);}else{this.setScrollTop(_47);}},finishScrollJob:function(){this.delayScroll=false;this.setScrollTop(this.scrollTop);},setScrollTop:function(_4a){this.scroller.scroll(this.views.setScrollTop(_4a));},scrollToRow:function(_4b){this.setScrollTop(this.scroller.findScrollTop(_4b)+1);},styleRowNode:function(_4c,_4d){if(_4d){this.rows.styleRowNode(_4c,_4d);}},_mouseOut:function(e){this.rows.setOverRow(-2);},getCell:function(_4e){return this.layout.cells[_4e];},setCellWidth:function(_4f,_50){this.getCell(_4f).unitWidth=_50;},getCellName:function(_51){return "Cell "+_51.index;},canSort:function(_52){},sort:function(){},getSortAsc:function(_53){_53=_53==undefined?this.sortInfo:_53;return Boolean(_53>0);},getSortIndex:function(_54){_54=_54==undefined?this.sortInfo:_54;return Math.abs(_54)-1;},setSortIndex:function(_55,_56){var si=_55+1;if(_56!=undefined){si*=(_56?1:-1);}else{if(this.getSortIndex()==_55){si=-this.sortInfo;}}this.setSortInfo(si);},setSortInfo:function(_57){if(this.canSort(_57)){this.sortInfo=_57;this.sort();this.update();}},doKeyEvent:function(e){e.dispatch="do"+e.type;this.onKeyEvent(e);},_dispatch:function(m,e){if(m in this){return this[m](e);}return false;},dispatchKeyEvent:function(e){this._dispatch(e.dispatch,e);},dispatchContentEvent:function(e){this.edit.dispatchEvent(e)||e.sourceView.dispatchContentEvent(e)||this._dispatch(e.dispatch,e);},dispatchHeaderEvent:function(e){e.sourceView.dispatchHeaderEvent(e)||this._dispatch("doheader"+e.type,e);},dokeydown:function(e){this.onKeyDown(e);},doclick:function(e){if(e.cellNode){this.onCellClick(e);}else{this.onRowClick(e);}},dodblclick:function(e){if(e.cellNode){this.onCellDblClick(e);}else{this.onRowDblClick(e);}},docontextmenu:function(e){if(e.cellNode){this.onCellContextMenu(e);}else{this.onRowContextMenu(e);}},doheaderclick:function(e){if(e.cellNode){this.onHeaderCellClick(e);}else{this.onHeaderClick(e);}},doheaderdblclick:function(e){if(e.cellNode){this.onHeaderCellDblClick(e);}else{this.onHeaderDblClick(e);}},doheadercontextmenu:function(e){if(e.cellNode){this.onHeaderCellContextMenu(e);}else{this.onHeaderContextMenu(e);}},doStartEdit:function(_58,_59){this.onStartEdit(_58,_59);},doApplyCellEdit:function(_5a,_5b,_5c){this.onApplyCellEdit(_5a,_5b,_5c);},doCancelEdit:function(_5d){this.onCancelEdit(_5d);},doApplyEdit:function(_5e){this.onApplyEdit(_5e);},addRow:function(){this.updateRowCount(this.get("rowCount")+1);},removeSelectedRows:function(){if(this.allItemsSelected){this.updateRowCount(0);}else{this.updateRowCount(Math.max(0,this.get("rowCount")-this.selection.getSelected().length));}this.selection.clear();}});_1a.markupFactory=function(_5f,_60,_61,_62){var _63=function(n){var w=_18.attr(n,"width")||"auto";if((w!="auto")&&(w.slice(-2)!="em")&&(w.slice(-1)!="%")){w=parseInt(w,10)+"px";}return w;};if(!_5f.structure&&_60.nodeName.toLowerCase()=="table"){_5f.structure=_19("> colgroup",_60).map(function(cg){var sv=_18.attr(cg,"span");var v={noscroll:(_18.attr(cg,"noscroll")=="true")?true:false,__span:(!!sv?parseInt(sv,10):1),cells:[]};if(_18.hasAttr(cg,"width")){v.width=_63(cg);}return v;});if(!_5f.structure.length){_5f.structure.push({__span:Infinity,cells:[]});}_19("thead > tr",_60).forEach(function(tr,_64){var _65=0;var _66=0;var _67;var _68=null;_19("> th",tr).map(function(th){if(!_68){_67=0;_68=_5f.structure[0];}else{if(_65>=(_67+_68.__span)){_66++;_67+=_68.__span;var _69=_68;_68=_5f.structure[_66];}}var _6a={name:_16.trim(_18.attr(th,"name")||th.innerHTML),colSpan:parseInt(_18.attr(th,"colspan")||1,10),type:_16.trim(_18.attr(th,"cellType")||""),id:_16.trim(_18.attr(th,"id")||"")};_65+=_6a.colSpan;var _6b=_18.attr(th,"rowspan");if(_6b){_6a.rowSpan=_6b;}if(_18.hasAttr(th,"width")){_6a.width=_63(th);}if(_18.hasAttr(th,"relWidth")){_6a.relWidth=window.parseInt(_18.attr(th,"relWidth"),10);}if(_18.hasAttr(th,"hidden")){_6a.hidden=(_18.attr(th,"hidden")=="true"||_18.attr(th,"hidden")===true);}if(_62){_62(th,_6a);}_6a.type=_6a.type?_16.getObject(_6a.type):_3.grid.cells.Cell;if(_6a.type&&_6a.type.markupFactory){_6a.type.markupFactory(th,_6a);}if(!_68.cells[_64]){_68.cells[_64]=[];}_68.cells[_64].push(_6a);});});}return new _61(_5f,_60);};return _1a;});},"dojox/grid/_Events":function(){define(["dojo/keys","dojo/dom-class","dojo/_base/declare","dojo/_base/event","dojo/_base/sniff"],function(_6c,_6d,_6e,_6f,has){return _6e("dojox.grid._Events",null,{cellOverClass:"dojoxGridCellOver",onKeyEvent:function(e){this.dispatchKeyEvent(e);},onContentEvent:function(e){this.dispatchContentEvent(e);},onHeaderEvent:function(e){this.dispatchHeaderEvent(e);},onStyleRow:function(_70){var i=_70;i.customClasses+=(i.odd?" dojoxGridRowOdd":"")+(i.selected?" dojoxGridRowSelected":"")+(i.over?" dojoxGridRowOver":"");this.focus.styleRow(_70);this.edit.styleRow(_70);},onKeyDown:function(e){if(e.altKey||e.metaKey){return;}var _71;switch(e.keyCode){case _6c.ESCAPE:this.edit.cancel();break;case _6c.ENTER:if(!this.edit.isEditing()){_71=this.focus.getHeaderIndex();if(_71>=0){this.setSortIndex(_71);break;}else{this.selection.clickSelect(this.focus.rowIndex,dojo.isCopyKey(e),e.shiftKey);}_6f.stop(e);}if(!e.shiftKey){var _72=this.edit.isEditing();this.edit.apply();if(!_72){this.edit.setEditCell(this.focus.cell,this.focus.rowIndex);}}if(!this.edit.isEditing()){var _73=this.focus.focusView||this.views.views[0];_73.content.decorateEvent(e);this.onRowClick(e);_6f.stop(e);}break;case _6c.SPACE:if(!this.edit.isEditing()){_71=this.focus.getHeaderIndex();if(_71>=0){this.setSortIndex(_71);break;}else{this.selection.clickSelect(this.focus.rowIndex,dojo.isCopyKey(e),e.shiftKey);this.focus._focusifyCellNode(true);this.focus.setFocusCell(this.focus.cell,this.focus.rowIndex);}_6f.stop(e);}break;case _6c.TAB:this.focus[e.shiftKey?"previousKey":"nextKey"](e);break;case _6c.LEFT_ARROW:case _6c.RIGHT_ARROW:if(!this.edit.isEditing()){var _74=e.keyCode;_6f.stop(e);_71=this.focus.getHeaderIndex();if(_71>=0&&(e.shiftKey&&e.ctrlKey)){this.focus.colSizeAdjust(e,_71,(_74==_6c.LEFT_ARROW?-1:1)*5);}else{var _75=(_74==_6c.LEFT_ARROW)?1:-1;if(this.isLeftToRight()){_75*=-1;}this.focus.move(0,_75);}}break;case _6c.UP_ARROW:if(!this.edit.isEditing()&&this.focus.rowIndex!==0){_6f.stop(e);this.focus.move(-1,0);}break;case _6c.DOWN_ARROW:if(!this.edit.isEditing()&&this.focus.rowIndex+1!=this.rowCount){_6f.stop(e);this.focus.move(1,0);}break;case _6c.PAGE_UP:if(!this.edit.isEditing()&&this.focus.rowIndex!==0){_6f.stop(e);if(this.focus.rowIndex!=this.scroller.firstVisibleRow+1){this.focus.move(this.scroller.firstVisibleRow-this.focus.rowIndex,0);}else{this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex-1));this.focus.move(this.scroller.firstVisibleRow-this.scroller.lastVisibleRow+1,0);}}break;case _6c.PAGE_DOWN:if(!this.edit.isEditing()&&this.focus.rowIndex+1!=this.rowCount){_6f.stop(e);if(this.focus.rowIndex!=this.scroller.lastVisibleRow-1){this.focus.move(this.scroller.lastVisibleRow-this.focus.rowIndex-1,0);}else{this.setScrollTop(this.scroller.findScrollTop(this.focus.rowIndex+1));this.focus.move(this.scroller.lastVisibleRow-this.scroller.firstVisibleRow-1,0);}}break;default:break;}},onMouseOver:function(e){e.rowIndex==-1?this.onHeaderCellMouseOver(e):this.onCellMouseOver(e);},onMouseOut:function(e){e.rowIndex==-1?this.onHeaderCellMouseOut(e):this.onCellMouseOut(e);},onMouseDown:function(e){e.rowIndex==-1?this.onHeaderCellMouseDown(e):this.onCellMouseDown(e);},onMouseOverRow:function(e){if(!this.rows.isOver(e.rowIndex)){this.rows.setOverRow(e.rowIndex);e.rowIndex==-1?this.onHeaderMouseOver(e):this.onRowMouseOver(e);}},onMouseOutRow:function(e){if(this.rows.isOver(-1)){this.onHeaderMouseOut(e);}else{if(!this.rows.isOver(-2)){this.rows.setOverRow(-2);this.onRowMouseOut(e);}}},onMouseDownRow:function(e){if(e.rowIndex!=-1){this.onRowMouseDown(e);}},onCellMouseOver:function(e){if(e.cellNode){_6d.add(e.cellNode,this.cellOverClass);}},onCellMouseOut:function(e){if(e.cellNode){_6d.remove(e.cellNode,this.cellOverClass);}},onCellMouseDown:function(e){},onCellClick:function(e){this._click[0]=this._click[1];this._click[1]=e;if(!this.edit.isEditCell(e.rowIndex,e.cellIndex)){this.focus.setFocusCell(e.cell,e.rowIndex);}if(this._click.length>1&&this._click[0]==null){this._click.shift();}this.onRowClick(e);},onCellDblClick:function(e){var _76;if(this._click.length>1&&has("ie")){_76=this._click[1];}else{if(this._click.length>1&&this._click[0].rowIndex!=this._click[1].rowIndex){_76=this._click[0];}else{_76=e;}}this.focus.setFocusCell(_76.cell,_76.rowIndex);this.edit.setEditCell(_76.cell,_76.rowIndex);this.onRowDblClick(e);},onCellContextMenu:function(e){this.onRowContextMenu(e);},onCellFocus:function(_77,_78){this.edit.cellFocus(_77,_78);},onRowClick:function(e){this.edit.rowClick(e);this.selection.clickSelectEvent(e);},onRowDblClick:function(e){},onRowMouseOver:function(e){},onRowMouseOut:function(e){},onRowMouseDown:function(e){},onRowContextMenu:function(e){_6f.stop(e);},onHeaderMouseOver:function(e){},onHeaderMouseOut:function(e){},onHeaderCellMouseOver:function(e){if(e.cellNode){_6d.add(e.cellNode,this.cellOverClass);}},onHeaderCellMouseOut:function(e){if(e.cellNode){_6d.remove(e.cellNode,this.cellOverClass);}},onHeaderCellMouseDown:function(e){},onHeaderClick:function(e){},onHeaderCellClick:function(e){this.setSortIndex(e.cell.index);this.onHeaderClick(e);},onHeaderDblClick:function(e){},onHeaderCellDblClick:function(e){this.onHeaderDblClick(e);},onHeaderCellContextMenu:function(e){this.onHeaderContextMenu(e);},onHeaderContextMenu:function(e){if(!this.headerMenu){_6f.stop(e);}},onStartEdit:function(_79,_7a){},onApplyCellEdit:function(_7b,_7c,_7d){},onCancelEdit:function(_7e){},onApplyEdit:function(_7f){},onCanSelect:function(_80){return true;},onCanDeselect:function(_81){return true;},onSelected:function(_82){this.updateRowStyles(_82);},onDeselected:function(_83){this.updateRowStyles(_83);},onSelectionChanged:function(){}});});},"dojox/grid/_Scroller":function(){define(["dijit/registry","dojo/_base/declare","dojo/_base/lang","./util","dojo/_base/html"],function(_84,_85,_86,_87,_88){var _89=function(_8a){var i=0,n,p=_8a.parentNode;while((n=p.childNodes[i++])){if(n==_8a){return i-1;}}return -1;};var _8b=function(_8c){if(!_8c){return;}dojo.forEach(_84.toArray(),function(w){if(w.domNode&&_88.isDescendant(w.domNode,_8c,true)){w.destroy();}});};var _8d=function(_8e){var _8f=_88.byId(_8e);return (_8f&&_8f.tagName?_8f.tagName.toLowerCase():"");};var _90=function(_91,_92){var _93=[];var i=0,n;while((n=_91.childNodes[i])){i++;if(_8d(n)==_92){_93.push(n);}}return _93;};var _94=function(_95){return _90(_95,"div");};return _85("dojox.grid._Scroller",null,{constructor:function(_96){this.setContentNodes(_96);this.pageHeights=[];this.pageNodes=[];this.stack=[];},rowCount:0,defaultRowHeight:32,keepRows:100,contentNode:null,scrollboxNode:null,defaultPageHeight:0,keepPages:10,pageCount:0,windowHeight:0,firstVisibleRow:0,lastVisibleRow:0,averageRowHeight:0,page:0,pageTop:0,init:function(_97,_98,_99){switch(arguments.length){case 3:this.rowsPerPage=_99;case 2:this.keepRows=_98;case 1:this.rowCount=_97;default:break;}this.defaultPageHeight=(this.grid.rowHeight>0?this.grid.rowHeight:this.defaultRowHeight)*this.rowsPerPage;this.pageCount=this._getPageCount(this.rowCount,this.rowsPerPage);this.setKeepInfo(this.keepRows);this.invalidate();if(this.scrollboxNode){this.scrollboxNode.scrollTop=0;this.scroll(0);this.scrollboxNode.onscroll=_86.hitch(this,"onscroll");}},_getPageCount:function(_9a,_9b){return _9a?(Math.ceil(_9a/_9b)||1):0;},destroy:function(){this.invalidateNodes();delete this.contentNodes;delete this.contentNode;delete this.scrollboxNode;},setKeepInfo:function(_9c){this.keepRows=_9c;this.keepPages=!this.keepRows?this.keepPages:Math.max(Math.ceil(this.keepRows/this.rowsPerPage),2);},setContentNodes:function(_9d){this.contentNodes=_9d;this.colCount=(this.contentNodes?this.contentNodes.length:0);this.pageNodes=[];for(var i=0;i<this.colCount;i++){this.pageNodes[i]=[];}},getDefaultNodes:function(){return this.pageNodes[0]||[];},invalidate:function(){this._invalidating=true;this.invalidateNodes();this.pageHeights=[];this.height=(this.pageCount?(this.pageCount-1)*this.defaultPageHeight+this.calcLastPageHeight():0);this.resize();this._invalidating=false;},updateRowCount:function(_9e){this.invalidateNodes();this.rowCount=_9e;var _9f=this.pageCount;if(_9f===0){this.height=1;}this.pageCount=this._getPageCount(this.rowCount,this.rowsPerPage);if(this.pageCount<_9f){for(var i=_9f-1;i>=this.pageCount;i--){this.height-=this.getPageHeight(i);delete this.pageHeights[i];}}else{if(this.pageCount>_9f){this.height+=this.defaultPageHeight*(this.pageCount-_9f-1)+this.calcLastPageHeight();}}this.resize();},pageExists:function(_a0){return Boolean(this.getDefaultPageNode(_a0));},measurePage:function(_a1){if(this.grid.rowHeight){return ((_a1+1)*this.rowsPerPage>this.rowCount?this.rowCount-_a1*this.rowsPerPage:this.rowsPerPage)*this.grid.rowHeight;}var n=this.getDefaultPageNode(_a1);return (n&&n.innerHTML)?n.offsetHeight:undefined;},positionPage:function(_a2,_a3){for(var i=0;i<this.colCount;i++){this.pageNodes[i][_a2].style.top=_a3+"px";}},repositionPages:function(_a4){var _a5=this.getDefaultNodes();var _a6=0;for(var i=0;i<this.stack.length;i++){_a6=Math.max(this.stack[i],_a6);}var n=_a5[_a4];var y=(n?this.getPageNodePosition(n)+this.getPageHeight(_a4):0);for(var p=_a4+1;p<=_a6;p++){n=_a5[p];if(n){if(this.getPageNodePosition(n)==y){return;}this.positionPage(p,y);}y+=this.getPageHeight(p);}},installPage:function(_a7){for(var i=0;i<this.colCount;i++){this.contentNodes[i].appendChild(this.pageNodes[i][_a7]);}},preparePage:function(_a8,_a9){var p=(_a9?this.popPage():null);for(var i=0;i<this.colCount;i++){var _aa=this.pageNodes[i];var _ab=(p===null?this.createPageNode():this.invalidatePageNode(p,_aa));_ab.pageIndex=_a8;_aa[_a8]=_ab;}},renderPage:function(_ac){var _ad=[];var i,j;for(i=0;i<this.colCount;i++){_ad[i]=this.pageNodes[i][_ac];}for(i=0,j=_ac*this.rowsPerPage;(i<this.rowsPerPage)&&(j<this.rowCount);i++,j++){this.renderRow(j,_ad);}},removePage:function(_ae){for(var i=0,j=_ae*this.rowsPerPage;i<this.rowsPerPage;i++,j++){this.removeRow(j);}},destroyPage:function(_af){for(var i=0;i<this.colCount;i++){var n=this.invalidatePageNode(_af,this.pageNodes[i]);if(n){_88.destroy(n);}}},pacify:function(_b0){},pacifying:false,pacifyTicks:200,setPacifying:function(_b1){if(this.pacifying!=_b1){this.pacifying=_b1;this.pacify(this.pacifying);}},startPacify:function(){this.startPacifyTicks=new Date().getTime();},doPacify:function(){var _b2=(new Date().getTime()-this.startPacifyTicks)>this.pacifyTicks;this.setPacifying(true);this.startPacify();return _b2;},endPacify:function(){this.setPacifying(false);},resize:function(){if(this.scrollboxNode){this.windowHeight=this.scrollboxNode.clientHeight;}for(var i=0;i<this.colCount;i++){_87.setStyleHeightPx(this.contentNodes[i],Math.max(1,this.height));}var _b3=(!this._invalidating);if(!_b3){var ah=this.grid.get("autoHeight");if(typeof ah=="number"&&ah<=Math.min(this.rowsPerPage,this.rowCount)){_b3=true;}}if(_b3){this.needPage(this.page,this.pageTop);}var _b4=(this.page<this.pageCount-1)?this.rowsPerPage:((this.rowCount%this.rowsPerPage)||this.rowsPerPage);var _b5=this.getPageHeight(this.page);this.averageRowHeight=(_b5>0&&_b4>0)?(_b5/_b4):0;},calcLastPageHeight:function(){if(!this.pageCount){return 0;}var _b6=this.pageCount-1;var _b7=((this.rowCount%this.rowsPerPage)||(this.rowsPerPage))*this.defaultRowHeight;this.pageHeights[_b6]=_b7;return _b7;},updateContentHeight:function(_b8){this.height+=_b8;this.resize();},updatePageHeight:function(_b9,_ba,_bb){if(this.pageExists(_b9)){var oh=this.getPageHeight(_b9);var h=(this.measurePage(_b9));if(h===undefined){h=oh;}this.pageHeights[_b9]=h;if(oh!=h){this.updateContentHeight(h-oh);var ah=this.grid.get("autoHeight");if((typeof ah=="number"&&ah>this.rowCount)||(ah===true&&!_ba)){if(!_bb){this.grid.sizeChange();}else{var ns=this.grid.viewsNode.style;ns.height=parseInt(ns.height)+h-oh+"px";this.repositionPages(_b9);}}else{this.repositionPages(_b9);}}return h;}return 0;},rowHeightChanged:function(_bc,_bd){this.updatePageHeight(Math.floor(_bc/this.rowsPerPage),false,_bd);},invalidateNodes:function(){while(this.stack.length){this.destroyPage(this.popPage());}},createPageNode:function(){var p=document.createElement("div");_88.attr(p,"role","presentation");p.style.position="absolute";p.style[this.grid.isLeftToRight()?"left":"right"]="0";return p;},getPageHeight:function(_be){var ph=this.pageHeights[_be];return (ph!==undefined?ph:this.defaultPageHeight);},pushPage:function(_bf){return this.stack.push(_bf);},popPage:function(){return this.stack.shift();},findPage:function(_c0){var i=0,h=0;for(var ph=0;i<this.pageCount;i++,h+=ph){ph=this.getPageHeight(i);if(h+ph>=_c0){break;}}this.page=i;this.pageTop=h;},buildPage:function(_c1,_c2,_c3){this.preparePage(_c1,_c2);this.positionPage(_c1,_c3);this.installPage(_c1);this.renderPage(_c1);this.pushPage(_c1);},needPage:function(_c4,_c5){var h=this.getPageHeight(_c4),oh=h;if(!this.pageExists(_c4)){this.buildPage(_c4,(!this.grid._autoHeight&&this.keepPages&&(this.stack.length>=this.keepPages)),_c5);h=this.updatePageHeight(_c4,true);}else{this.positionPage(_c4,_c5);}return h;},onscroll:function(){this.scroll(this.scrollboxNode.scrollTop);},scroll:function(_c6){this.grid.scrollTop=_c6;if(this.colCount){this.startPacify();this.findPage(_c6);var h=this.height;var b=this.getScrollBottom(_c6);for(var p=this.page,y=this.pageTop;(p<this.pageCount)&&((b<0)||(y<b));p++){y+=this.needPage(p,y);}this.firstVisibleRow=this.getFirstVisibleRow(this.page,this.pageTop,_c6);this.lastVisibleRow=this.getLastVisibleRow(p-1,y,b);if(h!=this.height){this.repositionPages(p-1);}this.endPacify();}},getScrollBottom:function(_c7){return (this.windowHeight>=0?_c7+this.windowHeight:-1);},processNodeEvent:function(e,_c8){var t=e.target;while(t&&(t!=_c8)&&t.parentNode&&(t.parentNode.parentNode!=_c8)){t=t.parentNode;}if(!t||!t.parentNode||(t.parentNode.parentNode!=_c8)){return false;}var _c9=t.parentNode;e.topRowIndex=_c9.pageIndex*this.rowsPerPage;e.rowIndex=e.topRowIndex+_89(t);e.rowTarget=t;return true;},processEvent:function(e){return this.processNodeEvent(e,this.contentNode);},renderRow:function(_ca,_cb){},removeRow:function(_cc){},getDefaultPageNode:function(_cd){return this.getDefaultNodes()[_cd];},positionPageNode:function(_ce,_cf){},getPageNodePosition:function(_d0){return _d0.offsetTop;},invalidatePageNode:function(_d1,_d2){var p=_d2[_d1];if(p){delete _d2[_d1];this.removePage(_d1,p);_8b(p);p.innerHTML="";}return p;},getPageRow:function(_d3){return _d3*this.rowsPerPage;},getLastPageRow:function(_d4){return Math.min(this.rowCount,this.getPageRow(_d4+1))-1;},getFirstVisibleRow:function(_d5,_d6,_d7){if(!this.pageExists(_d5)){return 0;}var row=this.getPageRow(_d5);var _d8=this.getDefaultNodes();var _d9=_94(_d8[_d5]);for(var i=0,l=_d9.length;i<l&&_d6<_d7;i++,row++){_d6+=_d9[i].offsetHeight;}return (row?row-1:row);},getLastVisibleRow:function(_da,_db,_dc){if(!this.pageExists(_da)){return 0;}var _dd=this.getDefaultNodes();var row=this.getLastPageRow(_da);var _de=_94(_dd[_da]);for(var i=_de.length-1;i>=0&&_db>_dc;i--,row--){_db-=_de[i].offsetHeight;}return row+1;},findTopRow:function(_df){var _e0=this.getDefaultNodes();var _e1=_94(_e0[this.page]);for(var i=0,l=_e1.length,t=this.pageTop,h;i<l;i++){h=_e1[i].offsetHeight;t+=h;if(t>=_df){this.offset=h-(t-_df);return i+this.page*this.rowsPerPage;}}return -1;},findScrollTop:function(_e2){var _e3=Math.floor(_e2/this.rowsPerPage);var t=0;var i,l;for(i=0;i<_e3;i++){t+=this.getPageHeight(i);}this.pageTop=t;this.page=_e3;this.needPage(_e3,this.pageTop);var _e4=this.getDefaultNodes();var _e5=_94(_e4[_e3]);var r=_e2-this.rowsPerPage*_e3;for(i=0,l=_e5.length;i<l&&i<r;i++){t+=_e5[i].offsetHeight;}return t;},dummy:0});});},"dijit/registry":function(){define("dijit/registry",["dojo/_base/array","dojo/sniff","dojo/_base/unload","dojo/_base/window","./main"],function(_e6,has,_e7,win,_e8){var _e9={},_ea={};var _eb={length:0,add:function(_ec){if(_ea[_ec.id]){throw new Error("Tried to register widget with id=="+_ec.id+" but that id is already registered");}_ea[_ec.id]=_ec;this.length++;},remove:function(id){if(_ea[id]){delete _ea[id];this.length--;}},byId:function(id){return typeof id=="string"?_ea[id]:id;},byNode:function(_ed){return _ea[_ed.getAttribute("widgetId")];},toArray:function(){var ar=[];for(var id in _ea){ar.push(_ea[id]);}return ar;},getUniqueId:function(_ee){var id;do{id=_ee+"_"+(_ee in _e9?++_e9[_ee]:_e9[_ee]=0);}while(_ea[id]);return _e8._scopeName=="dijit"?id:_e8._scopeName+"_"+id;},findWidgets:function(_ef,_f0){var _f1=[];function _f2(_f3){for(var _f4=_f3.firstChild;_f4;_f4=_f4.nextSibling){if(_f4.nodeType==1){var _f5=_f4.getAttribute("widgetId");if(_f5){var _f6=_ea[_f5];if(_f6){_f1.push(_f6);}}else{if(_f4!==_f0){_f2(_f4);}}}}};_f2(_ef);return _f1;},_destroyAll:function(){_e8._curFocus=null;_e8._prevFocus=null;_e8._activeStack=[];_e6.forEach(_eb.findWidgets(win.body()),function(_f7){if(!_f7._destroyed){if(_f7.destroyRecursive){_f7.destroyRecursive();}else{if(_f7.destroy){_f7.destroy();}}}});},getEnclosingWidget:function(_f8){while(_f8){var id=_f8.nodeType==1&&_f8.getAttribute("widgetId");if(id){return _ea[id];}_f8=_f8.parentNode;}return null;},_hash:_ea};_e8.registry=_eb;return _eb;});},"dijit/main":function(){define("dijit/main",["dojo/_base/kernel"],function(_f9){return _f9.dijit;});},"dojox/grid/util":function(){define(["../main","dojo/_base/lang","dojo/dom"],function(_fa,_fb,dom){var dgu=_fb.getObject("grid.util",true,_fa);dgu.na="...";dgu.rowIndexTag="gridRowIndex";dgu.gridViewTag="gridView";dgu.fire=function(ob,ev,_fc){var fn=ob&&ev&&ob[ev];return fn&&(_fc?fn.apply(ob,_fc):ob[ev]());};dgu.setStyleHeightPx=function(_fd,_fe){if(_fe>=0){var s=_fd.style;var v=_fe+"px";if(_fd&&s["height"]!=v){s["height"]=v;}}};dgu.mouseEvents=["mouseover","mouseout","mousedown","mouseup","click","dblclick","contextmenu"];dgu.keyEvents=["keyup","keydown","keypress"];dgu.funnelEvents=function(_ff,_100,_101,_102){var evts=(_102?_102:dgu.mouseEvents.concat(dgu.keyEvents));for(var i=0,l=evts.length;i<l;i++){_100.connect(_ff,"on"+evts[i],_101);}};dgu.removeNode=function(_103){_103=dom.byId(_103);_103&&_103.parentNode&&_103.parentNode.removeChild(_103);return _103;};dgu.arrayCompare=function(inA,inB){for(var i=0,l=inA.length;i<l;i++){if(inA[i]!=inB[i]){return false;}}return (inA.length==inB.length);};dgu.arrayInsert=function(_104,_105,_106){if(_104.length<=_105){_104[_105]=_106;}else{_104.splice(_105,0,_106);}};dgu.arrayRemove=function(_107,_108){_107.splice(_108,1);};dgu.arraySwap=function(_109,inI,inJ){var _10a=_109[inI];_109[inI]=_109[inJ];_109[inJ]=_10a;};return dgu;});},"dojox/grid/_Layout":function(){define(["dojo/_base/kernel","../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-geometry","./cells","./_RowSelector"],function(dojo,_10b,_10c,_10d,lang,_10e){return _10c("dojox.grid._Layout",null,{constructor:function(_10f){this.grid=_10f;},cells:[],structure:null,defaultWidth:"6em",moveColumn:function(_110,_111,_112,_113,_114){var _115=this.structure[_110].cells[0];var _116=this.structure[_111].cells[0];var cell=null;var _117=0;var _118=0;for(var i=0,c;c=_115[i];i++){if(c.index==_112){_117=i;break;}}cell=_115.splice(_117,1)[0];cell.view=this.grid.views.views[_111];for(i=0,c=null;c=_116[i];i++){if(c.index==_113){_118=i;break;}}if(!_114){_118+=1;}_116.splice(_118,0,cell);var _119=this.grid.getCell(this.grid.getSortIndex());if(_119){_119._currentlySorted=this.grid.getSortAsc();}this.cells=[];_112=0;var v;for(i=0;v=this.structure[i];i++){for(var j=0,cs;cs=v.cells[j];j++){for(var k=0;c=cs[k];k++){c.index=_112;this.cells.push(c);if("_currentlySorted" in c){var si=_112+1;si*=c._currentlySorted?1:-1;this.grid.sortInfo=si;delete c._currentlySorted;}_112++;}}}_10d.forEach(this.cells,function(c){var _11a=c.markup[2].split(" ");var _11b=parseInt(_11a[1].substring(5));if(_11b!=c.index){_11a[1]="idx=\""+c.index+"\"";c.markup[2]=_11a.join(" ");}});this.grid.setupHeaderMenu();},setColumnVisibility:function(_11c,_11d){var cell=this.cells[_11c];if(cell.hidden==_11d){cell.hidden=!_11d;var v=cell.view,w=v.viewWidth;if(w&&w!="auto"){v._togglingColumn=_10e.getMarginBox(cell.getHeaderNode()).w||0;}v.update();return true;}else{return false;}},addCellDef:function(_11e,_11f,_120){var self=this;var _121=function(_122){var w=0;if(_122.colSpan>1){w=0;}else{w=_122.width||self._defaultCellProps.width||self.defaultWidth;if(!isNaN(w)){w=w+"em";}}return w;};var _123={grid:this.grid,subrow:_11e,layoutIndex:_11f,index:this.cells.length};if(_120&&_120 instanceof _10b.grid.cells._Base){var _124=lang.clone(_120);_123.unitWidth=_121(_124._props);_124=lang.mixin(_124,this._defaultCellProps,_120._props,_123);return _124;}var _125=_120.type||_120.cellType||this._defaultCellProps.type||this._defaultCellProps.cellType||_10b.grid.cells.Cell;if(lang.isString(_125)){_125=lang.getObject(_125);}_123.unitWidth=_121(_120);return new _125(lang.mixin({},this._defaultCellProps,_120,_123));},addRowDef:function(_126,_127){var _128=[];var _129=0,_12a=0,_12b=true;for(var i=0,def,cell;(def=_127[i]);i++){cell=this.addCellDef(_126,i,def);_128.push(cell);this.cells.push(cell);if(_12b&&cell.relWidth){_129+=cell.relWidth;}else{if(cell.width){var w=cell.width;if(typeof w=="string"&&w.slice(-1)=="%"){_12a+=window.parseInt(w,10);}else{if(w=="auto"){_12b=false;}}}}}if(_129&&_12b){_10d.forEach(_128,function(cell){if(cell.relWidth){cell.width=cell.unitWidth=((cell.relWidth/_129)*(100-_12a))+"%";}});}return _128;},addRowsDef:function(_12c){var _12d=[];if(lang.isArray(_12c)){if(lang.isArray(_12c[0])){for(var i=0,row;_12c&&(row=_12c[i]);i++){_12d.push(this.addRowDef(i,row));}}else{_12d.push(this.addRowDef(0,_12c));}}return _12d;},addViewDef:function(_12e){this._defaultCellProps=_12e.defaultCell||{};if(_12e.width&&_12e.width=="auto"){delete _12e.width;}return lang.mixin({},_12e,{cells:this.addRowsDef(_12e.rows||_12e.cells)});},setStructure:function(_12f){this.fieldIndex=0;this.cells=[];var s=this.structure=[];if(this.grid.rowSelector){var sel={type:_10b._scopeName+".grid._RowSelector"};if(lang.isString(this.grid.rowSelector)){var _130=this.grid.rowSelector;if(_130=="false"){sel=null;}else{if(_130!="true"){sel["width"]=_130;}}}else{if(!this.grid.rowSelector){sel=null;}}if(sel){s.push(this.addViewDef(sel));}}var _131=function(def){return ("name" in def||"field" in def||"get" in def);};var _132=function(def){if(lang.isArray(def)){if(lang.isArray(def[0])||_131(def[0])){return true;}}return false;};var _133=function(def){return (def!==null&&lang.isObject(def)&&("cells" in def||"rows" in def||("type" in def&&!_131(def))));};if(lang.isArray(_12f)){var _134=false;for(var i=0,st;(st=_12f[i]);i++){if(_133(st)){_134=true;break;}}if(!_134){s.push(this.addViewDef({cells:_12f}));}else{for(i=0;(st=_12f[i]);i++){if(_132(st)){s.push(this.addViewDef({cells:st}));}else{if(_133(st)){s.push(this.addViewDef(st));}}}}}else{if(_133(_12f)){s.push(this.addViewDef(_12f));}}this.cellCount=this.cells.length;this.grid.setupHeaderMenu();}});});},"dojox/grid/cells":function(){define(["../main","./cells/_base"],function(_135){return _135.grid.cells;});},"dojox/grid/cells/_base":function(){define(["dojo/_base/kernel","dojo/_base/declare","dojo/_base/lang","dojo/_base/event","dojo/_base/connect","dojo/_base/array","dojo/_base/sniff","dojo/dom","dojo/dom-attr","dojo/dom-construct","dijit/_Widget","../util"],function(dojo,_136,lang,_137,_138,_139,has,dom,_13a,_13b,_13c,util){var _13d=_136("dojox.grid._DeferredTextWidget",_13c,{deferred:null,_destroyOnRemove:true,postCreate:function(){if(this.deferred){this.deferred.addBoth(lang.hitch(this,function(text){if(this.domNode){this.domNode.innerHTML=text;}}));}}});var _13e=function(_13f){try{util.fire(_13f,"focus");util.fire(_13f,"select");}catch(e){}};var _140=function(){setTimeout(lang.hitch.apply(dojo,arguments),0);};var _141=_136("dojox.grid.cells._Base",null,{styles:"",classes:"",editable:false,alwaysEditing:false,formatter:null,defaultValue:"...",value:null,hidden:false,noresize:false,draggable:true,_valueProp:"value",_formatPending:false,constructor:function(_142){this._props=_142||{};lang.mixin(this,_142);if(this.draggable===undefined){this.draggable=true;}},_defaultFormat:function(_143,_144){var s=this.grid.formatterScope||this;var f=this.formatter;if(f&&s&&typeof f=="string"){f=this.formatter=s[f];}var v=(_143!=this.defaultValue&&f)?f.apply(s,_144):_143;if(typeof v=="undefined"){return this.defaultValue;}if(v&&v.addBoth){v=new _13d({deferred:v},_13b.create("span",{innerHTML:this.defaultValue}));}if(v&&v.declaredClass&&v.startup){return "<div class='dojoxGridStubNode' linkWidget='"+v.id+"' cellIdx='"+this.index+"'>"+this.defaultValue+"</div>";}return v;},format:function(_145,_146){var f,i=this.grid.edit.info,d=this.get?this.get(_145,_146):(this.value||this.defaultValue);d=(d&&d.replace&&this.grid.escapeHTMLInData)?d.replace(/&/g,"&amp;").replace(/</g,"&lt;"):d;if(this.editable&&(this.alwaysEditing||(i.rowIndex==_145&&i.cell==this))){return this.formatEditing(d,_145);}else{return this._defaultFormat(d,[d,_145,this]);}},formatEditing:function(_147,_148){},getNode:function(_149){return this.view.getCellNode(_149,this.index);},getHeaderNode:function(){return this.view.getHeaderCellNode(this.index);},getEditNode:function(_14a){return (this.getNode(_14a)||0).firstChild||0;},canResize:function(){var uw=this.unitWidth;return uw&&(uw!=="auto");},isFlex:function(){var uw=this.unitWidth;return uw&&lang.isString(uw)&&(uw=="auto"||uw.slice(-1)=="%");},applyEdit:function(_14b,_14c){if(this.getNode(_14c)){this.grid.edit.applyCellEdit(_14b,this,_14c);}},cancelEdit:function(_14d){this.grid.doCancelEdit(_14d);},_onEditBlur:function(_14e){if(this.grid.edit.isEditCell(_14e,this.index)){this.grid.edit.apply();}},registerOnBlur:function(_14f,_150){if(this.commitOnBlur){_138.connect(_14f,"onblur",function(e){setTimeout(lang.hitch(this,"_onEditBlur",_150),250);});}},needFormatNode:function(_151,_152){this._formatPending=true;_140(this,"_formatNode",_151,_152);},cancelFormatNode:function(){this._formatPending=false;},_formatNode:function(_153,_154){if(this._formatPending){this._formatPending=false;if(!has("ie")){dom.setSelectable(this.grid.domNode,true);}this.formatNode(this.getEditNode(_154),_153,_154);}},formatNode:function(_155,_156,_157){if(has("ie")){_140(this,"focus",_157,_155);}else{this.focus(_157,_155);}},dispatchEvent:function(m,e){if(m in this){return this[m](e);}},getValue:function(_158){return this.getEditNode(_158)[this._valueProp];},setValue:function(_159,_15a){var n=this.getEditNode(_159);if(n){n[this._valueProp]=_15a;}},focus:function(_15b,_15c){_13e(_15c||this.getEditNode(_15b));},save:function(_15d){this.value=this.value||this.getValue(_15d);},restore:function(_15e){this.setValue(_15e,this.value);},_finish:function(_15f){dom.setSelectable(this.grid.domNode,false);this.cancelFormatNode();},apply:function(_160){this.applyEdit(this.getValue(_160),_160);this._finish(_160);},cancel:function(_161){this.cancelEdit(_161);this._finish(_161);}});_141.markupFactory=function(node,_162){var _163=lang.trim(_13a.get(node,"formatter")||"");if(_163){_162.formatter=lang.getObject(_163)||_163;}var get=lang.trim(_13a.get(node,"get")||"");if(get){_162.get=lang.getObject(get);}var _164=function(attr,cell,_165){var _166=lang.trim(_13a.get(node,attr)||"");if(_166){cell[_165||attr]=!(_166.toLowerCase()=="false");}};_164("sortDesc",_162);_164("editable",_162);_164("alwaysEditing",_162);_164("noresize",_162);_164("draggable",_162);var _167=lang.trim(_13a.get(node,"loadingText")||_13a.get(node,"defaultValue")||"");if(_167){_162.defaultValue=_167;}var _168=function(attr,cell,_169){var _16a=lang.trim(_13a.get(node,attr)||"")||undefined;if(_16a){cell[_169||attr]=_16a;}};_168("styles",_162);_168("headerStyles",_162);_168("cellStyles",_162);_168("classes",_162);_168("headerClasses",_162);_168("cellClasses",_162);};var Cell=_136("dojox.grid.cells.Cell",_141,{constructor:function(){this.keyFilter=this.keyFilter;},keyFilter:null,formatEditing:function(_16b,_16c){this.needFormatNode(_16b,_16c);return "<input class=\"dojoxGridInput\" type=\"text\" value=\""+_16b+"\">";},formatNode:function(_16d,_16e,_16f){this.inherited(arguments);this.registerOnBlur(_16d,_16f);},doKey:function(e){if(this.keyFilter){var key=String.fromCharCode(e.charCode);if(key.search(this.keyFilter)==-1){_137.stop(e);}}},_finish:function(_170){this.inherited(arguments);var n=this.getEditNode(_170);try{util.fire(n,"blur");}catch(e){}}});Cell.markupFactory=function(node,_171){_141.markupFactory(node,_171);var _172=lang.trim(_13a.get(node,"keyFilter")||"");if(_172){_171.keyFilter=new RegExp(_172);}};var _173=_136("dojox.grid.cells.RowIndex",Cell,{name:"Row",postscript:function(){this.editable=false;},get:function(_174){return _174+1;}});_173.markupFactory=function(node,_175){Cell.markupFactory(node,_175);};var _176=_136("dojox.grid.cells.Select",Cell,{options:null,values:null,returnIndex:-1,constructor:function(_177){this.values=this.values||this.options;},formatEditing:function(_178,_179){this.needFormatNode(_178,_179);var h=["<select class=\"dojoxGridSelect\">"];for(var i=0,o,v;((o=this.options[i])!==undefined)&&((v=this.values[i])!==undefined);i++){v=v.replace?v.replace(/&/g,"&amp;").replace(/</g,"&lt;"):v;o=o.replace?o.replace(/&/g,"&amp;").replace(/</g,"&lt;"):o;h.push("<option",(_178==v?" selected":"")," value=\""+v+"\"",">",o,"</option>");}h.push("</select>");return h.join("");},_defaultFormat:function(_17a,_17b){var v=this.inherited(arguments);if(!this.formatter&&this.values&&this.options){var i=_139.indexOf(this.values,v);if(i>=0){v=this.options[i];}}return v;},getValue:function(_17c){var n=this.getEditNode(_17c);if(n){var i=n.selectedIndex,o=n.options[i];return this.returnIndex>-1?i:o.value||o.innerHTML;}}});_176.markupFactory=function(node,cell){Cell.markupFactory(node,cell);var _17d=lang.trim(_13a.get(node,"options")||"");if(_17d){var o=_17d.split(",");if(o[0]!=_17d){cell.options=o;}}var _17e=lang.trim(_13a.get(node,"values")||"");if(_17e){var v=_17e.split(",");if(v[0]!=_17e){cell.values=v;}}};var _17f=_136("dojox.grid.cells.AlwaysEdit",Cell,{alwaysEditing:true,_formatNode:function(_180,_181){this.formatNode(this.getEditNode(_181),_180,_181);},applyStaticValue:function(_182){var e=this.grid.edit;e.applyCellEdit(this.getValue(_182),this,_182);e.start(this,_182,true);}});_17f.markupFactory=function(node,cell){Cell.markupFactory(node,cell);};var Bool=_136("dojox.grid.cells.Bool",_17f,{_valueProp:"checked",formatEditing:function(_183,_184){return "<input class=\"dojoxGridInput\" type=\"checkbox\""+(_183?" checked=\"checked\"":"")+" style=\"width: auto\" />";},doclick:function(e){if(e.target.tagName=="INPUT"){this.applyStaticValue(e.rowIndex);}}});Bool.markupFactory=function(node,cell){_17f.markupFactory(node,cell);};return _141;});},"dijit/_Widget":function(){define("dijit/_Widget",["dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/query","dojo/ready","./registry","./_WidgetBase","./_OnDijitClickMixin","./_FocusMixin","dojo/uacss","./hccss"],function(_185,_186,_187,_188,has,_189,lang,_18a,_18b,_18c,_18d,_18e,_18f){function _190(){};function _191(_192){return function(obj,_193,_194,_195){if(obj&&typeof _193=="string"&&obj[_193]==_190){return obj.on(_193.substring(2).toLowerCase(),lang.hitch(_194,_195));}return _192.apply(_187,arguments);};};_185.around(_187,"connect",_191);if(_189.connect){_185.around(_189,"connect",_191);}var _196=_188("dijit._Widget",[_18d,_18e,_18f],{onClick:_190,onDblClick:_190,onKeyDown:_190,onKeyPress:_190,onKeyUp:_190,onMouseDown:_190,onMouseMove:_190,onMouseOut:_190,onMouseOver:_190,onMouseLeave:_190,onMouseEnter:_190,onMouseUp:_190,constructor:function(_197){this._toConnect={};for(var name in _197){if(this[name]===_190){this._toConnect[name.replace(/^on/,"").toLowerCase()]=_197[name];delete _197[name];}}},postCreate:function(){this.inherited(arguments);for(var name in this._toConnect){this.on(name,this._toConnect[name]);}delete this._toConnect;},on:function(type,func){if(this[this._onMap(type)]===_190){return _187.connect(this.domNode,type.toLowerCase(),this,func);}return this.inherited(arguments);},_setFocusedAttr:function(val){this._focused=val;this._set("focused",val);},setAttribute:function(attr,_198){_189.deprecated(this.declaredClass+"::setAttribute(attr, value) is deprecated. Use set() instead.","","2.0");this.set(attr,_198);},attr:function(name,_199){if(_186.isDebug){var _19a=arguments.callee._ach||(arguments.callee._ach={}),_19b=(arguments.callee.caller||"unknown caller").toString();if(!_19a[_19b]){_189.deprecated(this.declaredClass+"::attr() is deprecated. Use get() or set() instead, called from "+_19b,"","2.0");_19a[_19b]=true;}}var args=arguments.length;if(args>=2||typeof name==="object"){return this.set.apply(this,arguments);}else{return this.get(name);}},getDescendants:function(){_189.deprecated(this.declaredClass+"::getDescendants() is deprecated. Use getChildren() instead.","","2.0");return this.containerNode?_18a("[widgetId]",this.containerNode).map(_18c.byNode):[];},_onShow:function(){this.onShow();},onShow:function(){},onHide:function(){},onClose:function(){return true;}});if(has("dijit-legacy-requires")){_18b(0,function(){var _19c=["dijit/_base"];require(_19c);});}return _196;});},"dijit/_WidgetBase":function(){define("dijit/_WidgetBase",["require","dojo/_base/array","dojo/aspect","dojo/_base/config","dojo/_base/connect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/dom-construct","dojo/dom-geometry","dojo/dom-style","dojo/has","dojo/_base/kernel","dojo/_base/lang","dojo/on","dojo/ready","dojo/Stateful","dojo/topic","dojo/_base/window","./Destroyable","./registry"],function(_19d,_19e,_19f,_1a0,_1a1,_1a2,dom,_1a3,_1a4,_1a5,_1a6,_1a7,has,_1a8,lang,on,_1a9,_1aa,_1ab,win,_1ac,_1ad){has.add("dijit-legacy-requires",!_1a8.isAsync);if(has("dijit-legacy-requires")){_1a9(0,function(){var _1ae=["dijit/_base/manager"];_19d(_1ae);});}var _1af={};function _1b0(obj){var ret={};for(var attr in obj){ret[attr.toLowerCase()]=true;}return ret;};function _1b1(attr){return function(val){_1a3[val?"set":"remove"](this.domNode,attr,val);this._set(attr,val);};};function _1b2(a,b){return a===b||(a!==a&&b!==b);};return _1a2("dijit._WidgetBase",[_1aa,_1ac],{id:"",_setIdAttr:"domNode",lang:"",_setLangAttr:_1b1("lang"),dir:"",_setDirAttr:_1b1("dir"),textDir:"","class":"",_setClassAttr:{node:"domNode",type:"class"},style:"",title:"",tooltip:"",baseClass:"",srcNodeRef:null,domNode:null,containerNode:null,ownerDocument:null,_setOwnerDocumentAttr:function(val){this._set("ownerDocument",val);},attributeMap:{},_blankGif:_1a0.blankGif||_19d.toUrl("dojo/resources/blank.gif"),postscript:function(_1b3,_1b4){this.create(_1b3,_1b4);},create:function(_1b5,_1b6){this.srcNodeRef=dom.byId(_1b6);this._connects=[];this._supportingWidgets=[];if(this.srcNodeRef&&(typeof this.srcNodeRef.id=="string")){this.id=this.srcNodeRef.id;}if(_1b5){this.params=_1b5;lang.mixin(this,_1b5);}this.postMixInProperties();if(!this.id){this.id=_1ad.getUniqueId(this.declaredClass.replace(/\./g,"_"));if(this.params){delete this.params.id;}}this.ownerDocument=this.ownerDocument||(this.srcNodeRef?this.srcNodeRef.ownerDocument:win.doc);this.ownerDocumentBody=win.body(this.ownerDocument);_1ad.add(this);this.buildRendering();var _1b7;if(this.domNode){this._applyAttributes();var _1b8=this.srcNodeRef;if(_1b8&&_1b8.parentNode&&this.domNode!==_1b8){_1b8.parentNode.replaceChild(this.domNode,_1b8);_1b7=true;}this.domNode.setAttribute("widgetId",this.id);}this.postCreate();if(_1b7){delete this.srcNodeRef;}this._created=true;},_applyAttributes:function(){var ctor=this.constructor,list=ctor._setterAttrs;if(!list){list=(ctor._setterAttrs=[]);for(var attr in this.attributeMap){list.push(attr);}var _1b9=ctor.prototype;for(var _1ba in _1b9){if(_1ba in this.attributeMap){continue;}var _1bb="_set"+_1ba.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();})+"Attr";if(_1bb in _1b9){list.push(_1ba);}}}var _1bc={};for(var key in this.params||{}){_1bc[key]=this[key];}_19e.forEach(list,function(attr){if(attr in _1bc){}else{if(this[attr]){this.set(attr,this[attr]);}}},this);for(key in _1bc){this.set(key,_1bc[key]);}},postMixInProperties:function(){},buildRendering:function(){if(!this.domNode){this.domNode=this.srcNodeRef||this.ownerDocument.createElement("div");}if(this.baseClass){var _1bd=this.baseClass.split(" ");if(!this.isLeftToRight()){_1bd=_1bd.concat(_19e.map(_1bd,function(name){return name+"Rtl";}));}_1a4.add(this.domNode,_1bd);}},postCreate:function(){},startup:function(){if(this._started){return;}this._started=true;_19e.forEach(this.getChildren(),function(obj){if(!obj._started&&!obj._destroyed&&lang.isFunction(obj.startup)){obj.startup();obj._started=true;}});},destroyRecursive:function(_1be){this._beingDestroyed=true;this.destroyDescendants(_1be);this.destroy(_1be);},destroy:function(_1bf){this._beingDestroyed=true;this.uninitialize();function _1c0(w){if(w.destroyRecursive){w.destroyRecursive(_1bf);}else{if(w.destroy){w.destroy(_1bf);}}};_19e.forEach(this._connects,lang.hitch(this,"disconnect"));_19e.forEach(this._supportingWidgets,_1c0);if(this.domNode){_19e.forEach(_1ad.findWidgets(this.domNode,this.containerNode),_1c0);}this.destroyRendering(_1bf);_1ad.remove(this.id);this._destroyed=true;},destroyRendering:function(_1c1){if(this.bgIframe){this.bgIframe.destroy(_1c1);delete this.bgIframe;}if(this.domNode){if(_1c1){_1a3.remove(this.domNode,"widgetId");}else{_1a5.destroy(this.domNode);}delete this.domNode;}if(this.srcNodeRef){if(!_1c1){_1a5.destroy(this.srcNodeRef);}delete this.srcNodeRef;}},destroyDescendants:function(_1c2){_19e.forEach(this.getChildren(),function(_1c3){if(_1c3.destroyRecursive){_1c3.destroyRecursive(_1c2);}});},uninitialize:function(){return false;},_setStyleAttr:function(_1c4){var _1c5=this.domNode;if(lang.isObject(_1c4)){_1a7.set(_1c5,_1c4);}else{if(_1c5.style.cssText){_1c5.style.cssText+="; "+_1c4;}else{_1c5.style.cssText=_1c4;}}this._set("style",_1c4);},_attrToDom:function(attr,_1c6,_1c7){_1c7=arguments.length>=3?_1c7:this.attributeMap[attr];_19e.forEach(lang.isArray(_1c7)?_1c7:[_1c7],function(_1c8){var _1c9=this[_1c8.node||_1c8||"domNode"];var type=_1c8.type||"attribute";switch(type){case "attribute":if(lang.isFunction(_1c6)){_1c6=lang.hitch(this,_1c6);}var _1ca=_1c8.attribute?_1c8.attribute:(/^on[A-Z][a-zA-Z]*$/.test(attr)?attr.toLowerCase():attr);if(_1c9.tagName){_1a3.set(_1c9,_1ca,_1c6);}else{_1c9.set(_1ca,_1c6);}break;case "innerText":_1c9.innerHTML="";_1c9.appendChild(this.ownerDocument.createTextNode(_1c6));break;case "innerHTML":_1c9.innerHTML=_1c6;break;case "class":_1a4.replace(_1c9,_1c6,this[attr]);break;}},this);},get:function(name){var _1cb=this._getAttrNames(name);return this[_1cb.g]?this[_1cb.g]():this[name];},set:function(name,_1cc){if(typeof name==="object"){for(var x in name){this.set(x,name[x]);}return this;}var _1cd=this._getAttrNames(name),_1ce=this[_1cd.s];if(lang.isFunction(_1ce)){var _1cf=_1ce.apply(this,Array.prototype.slice.call(arguments,1));}else{var _1d0=this.focusNode&&!lang.isFunction(this.focusNode)?"focusNode":"domNode",tag=this[_1d0].tagName,_1d1=_1af[tag]||(_1af[tag]=_1b0(this[_1d0])),map=name in this.attributeMap?this.attributeMap[name]:_1cd.s in this?this[_1cd.s]:((_1cd.l in _1d1&&typeof _1cc!="function")||/^aria-|^data-|^role$/.test(name))?_1d0:null;if(map!=null){this._attrToDom(name,_1cc,map);}this._set(name,_1cc);}return _1cf||this;},_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}var uc=name.replace(/^[a-z]|-[a-zA-Z]/g,function(c){return c.charAt(c.length-1).toUpperCase();});return (apn[name]={n:name+"Node",s:"_set"+uc+"Attr",g:"_get"+uc+"Attr",l:uc.toLowerCase()});},_set:function(name,_1d2){var _1d3=this[name];this[name]=_1d2;if(this._created&&!_1b2(_1d2,_1d3)){if(this._watchCallbacks){this._watchCallbacks(name,_1d3,_1d2);}this.emit("attrmodified-"+name,{detail:{prevValue:_1d3,newValue:_1d2}});}},emit:function(type,_1d4,_1d5){_1d4=_1d4||{};if(_1d4.bubbles===undefined){_1d4.bubbles=true;}if(_1d4.cancelable===undefined){_1d4.cancelable=true;}if(!_1d4.detail){_1d4.detail={};}_1d4.detail.widget=this;var ret,_1d6=this["on"+type];if(_1d6){ret=_1d6.apply(this,_1d5?_1d5:[_1d4]);}if(this._started&&!this._beingDestroyed){on.emit(this.domNode,type.toLowerCase(),_1d4);}return ret;},on:function(type,func){var _1d7=this._onMap(type);if(_1d7){return _19f.after(this,_1d7,func,true);}return this.own(on(this.domNode,type,func))[0];},_onMap:function(type){var ctor=this.constructor,map=ctor._onMap;if(!map){map=(ctor._onMap={});for(var attr in ctor.prototype){if(/^on/.test(attr)){map[attr.replace(/^on/,"").toLowerCase()]=attr;}}}return map[typeof type=="string"&&type.toLowerCase()];},toString:function(){return "[Widget "+this.declaredClass+", "+(this.id||"NO ID")+"]";},getChildren:function(){return this.containerNode?_1ad.findWidgets(this.containerNode):[];},getParent:function(){return _1ad.getEnclosingWidget(this.domNode.parentNode);},connect:function(obj,_1d8,_1d9){return this.own(_1a1.connect(obj,_1d8,this,_1d9))[0];},disconnect:function(_1da){_1da.remove();},subscribe:function(t,_1db){return this.own(_1ab.subscribe(t,lang.hitch(this,_1db)))[0];},unsubscribe:function(_1dc){_1dc.remove();},isLeftToRight:function(){return this.dir?(this.dir=="ltr"):_1a6.isBodyLtr(this.ownerDocument);},isFocusable:function(){return this.focus&&(_1a7.get(this.domNode,"display")!="none");},placeAt:function(_1dd,_1de){var _1df=!_1dd.tagName&&_1ad.byId(_1dd);if(_1df&&_1df.addChild&&(!_1de||typeof _1de==="number")){_1df.addChild(this,_1de);}else{var ref=_1df?(_1df.containerNode&&!/after|before|replace/.test(_1de||"")?_1df.containerNode:_1df.domNode):dom.byId(_1dd,this.ownerDocument);_1a5.place(this.domNode,ref,_1de);if(!this._started&&(this.getParent()||{})._started){this.startup();}}return this;},getTextDir:function(text,_1e0){return _1e0;},applyTextDir:function(){},defer:function(fcn,_1e1){var _1e2=setTimeout(lang.hitch(this,function(){if(!_1e2){return;}_1e2=null;if(!this._destroyed){lang.hitch(this,fcn)();}}),_1e1||0);return {remove:function(){if(_1e2){clearTimeout(_1e2);_1e2=null;}return null;}};}});});},"dojo/Stateful":function(){define(["./_base/declare","./_base/lang","./_base/array","./when"],function(_1e3,lang,_1e4,when){return _1e3("dojo.Stateful",null,{_attrPairNames:{},_getAttrNames:function(name){var apn=this._attrPairNames;if(apn[name]){return apn[name];}return (apn[name]={s:"_"+name+"Setter",g:"_"+name+"Getter"});},postscript:function(_1e5){if(_1e5){this.set(_1e5);}},_get:function(name,_1e6){return typeof this[_1e6.g]==="function"?this[_1e6.g]():this[name];},get:function(name){return this._get(name,this._getAttrNames(name));},set:function(name,_1e7){if(typeof name==="object"){for(var x in name){if(name.hasOwnProperty(x)&&x!="_watchCallbacks"){this.set(x,name[x]);}}return this;}var _1e8=this._getAttrNames(name),_1e9=this._get(name,_1e8),_1ea=this[_1e8.s],_1eb;if(typeof _1ea==="function"){_1eb=_1ea.apply(this,Array.prototype.slice.call(arguments,1));}else{this[name]=_1e7;}if(this._watchCallbacks){var self=this;when(_1eb,function(){self._watchCallbacks(name,_1e9,_1e7);});}return this;},_changeAttrValue:function(name,_1ec){var _1ed=this.get(name);this[name]=_1ec;if(this._watchCallbacks){this._watchCallbacks(name,_1ed,_1ec);}return this;},watch:function(name,_1ee){var _1ef=this._watchCallbacks;if(!_1ef){var self=this;_1ef=this._watchCallbacks=function(name,_1f0,_1f1,_1f2){var _1f3=function(_1f4){if(_1f4){_1f4=_1f4.slice();for(var i=0,l=_1f4.length;i<l;i++){_1f4[i].call(self,name,_1f0,_1f1);}}};_1f3(_1ef["_"+name]);if(!_1f2){_1f3(_1ef["*"]);}};}if(!_1ee&&typeof name==="function"){_1ee=name;name="*";}else{name="_"+name;}var _1f5=_1ef[name];if(typeof _1f5!=="object"){_1f5=_1ef[name]=[];}_1f5.push(_1ee);var _1f6={};_1f6.unwatch=_1f6.remove=function(){var _1f7=_1e4.indexOf(_1f5,_1ee);if(_1f7>-1){_1f5.splice(_1f7,1);}};return _1f6;}});});},"dijit/Destroyable":function(){define("dijit/Destroyable",["dojo/_base/array","dojo/aspect","dojo/_base/declare"],function(_1f8,_1f9,_1fa){return _1fa("dijit.Destroyable",null,{destroy:function(_1fb){this._destroyed=true;},own:function(){_1f8.forEach(arguments,function(_1fc){var _1fd="destroyRecursive" in _1fc?"destroyRecursive":"destroy" in _1fc?"destroy":"remove";var odh=_1f9.before(this,"destroy",function(_1fe){_1fc[_1fd](_1fe);});var hdh=_1f9.after(_1fc,_1fd,function(){odh.remove();hdh.remove();},true);},this);return arguments;}});});},"dijit/_OnDijitClickMixin":function(){define("dijit/_OnDijitClickMixin",["dojo/on","dojo/_base/array","dojo/keys","dojo/_base/declare","dojo/has","dojo/_base/unload","dojo/_base/window","./a11yclick"],function(on,_1ff,keys,_200,has,_201,win,_202){var ret=_200("dijit._OnDijitClickMixin",null,{connect:function(obj,_203,_204){return this.inherited(arguments,[obj,_203=="ondijitclick"?_202:_203,_204]);}});ret.a11yclick=_202;return ret;});},"dijit/a11yclick":function(){define("dijit/a11yclick",["dojo/_base/array","dojo/_base/declare","dojo/has","dojo/keys","dojo/on"],function(_205,_206,has,keys,on){function _207(node){do{if(node.dojoClick){return true;}}while(node=node.parentNode);};function _208(e){return (e.keyCode===keys.ENTER||e.keyCode===keys.SPACE)&&!e.ctrlKey&&!e.shiftKey&&!e.altKey&&!e.metaKey&&!/input|button/i.test(e.target.nodeName)&&_207(e.target);};var _209;on(document,"keydown",function(e){if(_208(e)){_209=e.target;e.preventDefault();}});on(document,"keyup",function(e){if(_208(e)&&e.target==_209){_209=null;on.emit(e.target,"click",{cancelable:true,bubbles:true});}});if(has("touch")){var _20a;on(document,"touchend",function(e){var _20b=e.target;if(_207(_20b)){var _20c=on.once(_20b,"click",function(e){if(_20a){clearTimeout(_20a);_20a=null;}});if(_20a){clearTimeout(_20a);}_20a=setTimeout(function(){_20a=null;_20c.remove();on.emit(_20b,"click",{cancelable:true,bubbles:true});},600);}});}return function(node,_20d){node.dojoClick=true;return on(node,"click",_20d);};});},"dijit/_FocusMixin":function(){define("dijit/_FocusMixin",["./focus","./_WidgetBase","dojo/_base/declare","dojo/_base/lang"],function(_20e,_20f,_210,lang){lang.extend(_20f,{focused:false,onFocus:function(){},onBlur:function(){},_onFocus:function(){this.onFocus();},_onBlur:function(){this.onBlur();}});return _210("dijit._FocusMixin",null,{_focusManager:_20e});});},"dijit/focus":function(){define("dijit/focus",["dojo/aspect","dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-construct","dojo/Evented","dojo/_base/lang","dojo/on","dojo/ready","dojo/sniff","dojo/Stateful","dojo/_base/unload","dojo/_base/window","dojo/window","./a11y","./registry","./main"],function(_211,_212,dom,_213,_214,_215,lang,on,_216,has,_217,_218,win,_219,a11y,_21a,_21b){var _21c;var _21d=_212([_217,_215],{curNode:null,activeStack:[],constructor:function(){var _21e=lang.hitch(this,function(node){if(dom.isDescendant(this.curNode,node)){this.set("curNode",null);}if(dom.isDescendant(this.prevNode,node)){this.set("prevNode",null);}});_211.before(_214,"empty",_21e);_211.before(_214,"destroy",_21e);},registerIframe:function(_21f){return this.registerWin(_21f.contentWindow,_21f);},registerWin:function(_220,_221){var _222=this,body=_220.document&&_220.document.body;if(body){var mdh=on(body,"mousedown",function(evt){_222._justMouseDowned=true;setTimeout(function(){_222._justMouseDowned=false;},13);if(evt&&evt.target&&evt.target.parentNode==null){return;}_222._onTouchNode(_221||evt.target,"mouse");});var fih=on(body,"focusin",function(evt){_21c=(new Date()).getTime();if(!evt.target.tagName){return;}var tag=evt.target.tagName.toLowerCase();if(tag=="#document"||tag=="body"){return;}if(a11y.isFocusable(evt.target)){_222._onFocusNode(_221||evt.target);}else{_222._onTouchNode(_221||evt.target);}});var foh=on(body,"focusout",function(evt){if((new Date()).getTime()<_21c+100){return;}_222._onBlurNode(_221||evt.target);});return {remove:function(){mdh.remove();fih.remove();foh.remove();mdh=fih=foh=null;body=null;}};}},_onBlurNode:function(node){if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);}this._clearFocusTimer=setTimeout(lang.hitch(this,function(){this.set("prevNode",this.curNode);this.set("curNode",null);}),0);if(this._justMouseDowned){return;}if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);}this._clearActiveWidgetsTimer=setTimeout(lang.hitch(this,function(){delete this._clearActiveWidgetsTimer;this._setStack([]);}),0);},_onTouchNode:function(node,by){if(this._clearActiveWidgetsTimer){clearTimeout(this._clearActiveWidgetsTimer);delete this._clearActiveWidgetsTimer;}var _223=[];try{while(node){var _224=_213.get(node,"dijitPopupParent");if(_224){node=_21a.byId(_224).domNode;}else{if(node.tagName&&node.tagName.toLowerCase()=="body"){if(node===win.body()){break;}node=_219.get(node.ownerDocument).frameElement;}else{var id=node.getAttribute&&node.getAttribute("widgetId"),_225=id&&_21a.byId(id);if(_225&&!(by=="mouse"&&_225.get("disabled"))){_223.unshift(id);}node=node.parentNode;}}}}catch(e){}this._setStack(_223,by);},_onFocusNode:function(node){if(!node){return;}if(node.nodeType==9){return;}if(this._clearFocusTimer){clearTimeout(this._clearFocusTimer);delete this._clearFocusTimer;}this._onTouchNode(node);if(node==this.curNode){return;}this.set("prevNode",this.curNode);this.set("curNode",node);},_setStack:function(_226,by){var _227=this.activeStack;this.set("activeStack",_226);for(var _228=0;_228<Math.min(_227.length,_226.length);_228++){if(_227[_228]!=_226[_228]){break;}}var _229;for(var i=_227.length-1;i>=_228;i--){_229=_21a.byId(_227[i]);if(_229){_229._hasBeenBlurred=true;_229.set("focused",false);if(_229._focusManager==this){_229._onBlur(by);}this.emit("widget-blur",_229,by);}}for(i=_228;i<_226.length;i++){_229=_21a.byId(_226[i]);if(_229){_229.set("focused",true);if(_229._focusManager==this){_229._onFocus(by);}this.emit("widget-focus",_229,by);}}},focus:function(node){if(node){try{node.focus();}catch(e){}}}});var _22a=new _21d();_216(function(){var _22b=_22a.registerWin(_219.get(win.doc));if(has("ie")){_218.addOnWindowUnload(function(){if(_22b){_22b.remove();_22b=null;}});}});_21b.focus=function(node){_22a.focus(node);};for(var attr in _22a){if(!/^_/.test(attr)){_21b.focus[attr]=typeof _22a[attr]=="function"?lang.hitch(_22a,attr):_22a[attr];}}_22a.watch(function(attr,_22c,_22d){_21b.focus[attr]=_22d;});return _22a;});},"dojo/window":function(){define(["./_base/lang","./sniff","./_base/window","./dom","./dom-geometry","./dom-style","./dom-construct"],function(lang,has,_22e,dom,geom,_22f,_230){has.add("rtl-adjust-position-for-verticalScrollBar",function(win,doc){var body=_22e.body(doc),_231=_230.create("div",{style:{overflow:"scroll",overflowX:"visible",direction:"rtl",visibility:"hidden",position:"absolute",left:"0",top:"0",width:"64px",height:"64px"}},body,"last"),div=_230.create("div",{style:{overflow:"hidden",direction:"ltr"}},_231,"last"),ret=geom.position(div).x!=0;_231.removeChild(div);body.removeChild(_231);return ret;});has.add("position-fixed-support",function(win,doc){var body=_22e.body(doc),_232=_230.create("span",{style:{visibility:"hidden",position:"fixed",left:"1px",top:"1px"}},body,"last"),_233=_230.create("span",{style:{position:"fixed",left:"0",top:"0"}},_232,"last"),ret=geom.position(_233).x!=geom.position(_232).x;_232.removeChild(_233);body.removeChild(_232);return ret;});var _234={getBox:function(doc){doc=doc||_22e.doc;var _235=(doc.compatMode=="BackCompat")?_22e.body(doc):doc.documentElement,_236=geom.docScroll(doc),w,h;if(has("touch")){var _237=_234.get(doc);w=_237.innerWidth||_235.clientWidth;h=_237.innerHeight||_235.clientHeight;}else{w=_235.clientWidth;h=_235.clientHeight;}return {l:_236.x,t:_236.y,w:w,h:h};},get:function(doc){if(has("ie")&&_234!==document.parentWindow){doc.parentWindow.execScript("document._parentWindow = window;","Javascript");var win=doc._parentWindow;doc._parentWindow=null;return win;}return doc.parentWindow||doc.defaultView;},scrollIntoView:function(node,pos){try{node=dom.byId(node);var doc=node.ownerDocument||_22e.doc,body=_22e.body(doc),html=doc.documentElement||body.parentNode,isIE=has("ie"),isWK=has("webkit");if(node==body||node==html){return;}if(!(has("mozilla")||isIE||isWK||has("opera")||has("trident"))&&("scrollIntoView" in node)){node.scrollIntoView(false);return;}var _238=doc.compatMode=="BackCompat",_239=Math.min(body.clientWidth||html.clientWidth,html.clientWidth||body.clientWidth),_23a=Math.min(body.clientHeight||html.clientHeight,html.clientHeight||body.clientHeight),_23b=(isWK||_238)?body:html,_23c=pos||geom.position(node),el=node.parentNode,_23d=function(el){return (isIE<=6||(isIE==7&&_238))?false:(has("position-fixed-support")&&(_22f.get(el,"position").toLowerCase()=="fixed"));},self=this,_23e=function(el,x,y){if(el.tagName=="BODY"||el.tagName=="HTML"){self.get(el.ownerDocument).scrollBy(x,y);}else{x&&(el.scrollLeft+=x);y&&(el.scrollTop+=y);}};if(_23d(node)){return;}while(el){if(el==body){el=_23b;}var _23f=geom.position(el),_240=_23d(el),rtl=_22f.getComputedStyle(el).direction.toLowerCase()=="rtl";if(el==_23b){_23f.w=_239;_23f.h=_23a;if(_23b==html&&(isIE||has("trident"))&&rtl){_23f.x+=_23b.offsetWidth-_23f.w;}_23f.x=0;_23f.y=0;}else{var pb=geom.getPadBorderExtents(el);_23f.w-=pb.w;_23f.h-=pb.h;_23f.x+=pb.l;_23f.y+=pb.t;var _241=el.clientWidth,_242=_23f.w-_241;if(_241>0&&_242>0){if(rtl&&has("rtl-adjust-position-for-verticalScrollBar")){_23f.x+=_242;}_23f.w=_241;}_241=el.clientHeight;_242=_23f.h-_241;if(_241>0&&_242>0){_23f.h=_241;}}if(_240){if(_23f.y<0){_23f.h+=_23f.y;_23f.y=0;}if(_23f.x<0){_23f.w+=_23f.x;_23f.x=0;}if(_23f.y+_23f.h>_23a){_23f.h=_23a-_23f.y;}if(_23f.x+_23f.w>_239){_23f.w=_239-_23f.x;}}var l=_23c.x-_23f.x,t=_23c.y-_23f.y,r=l+_23c.w-_23f.w,bot=t+_23c.h-_23f.h;var s,old;if(r*l>0&&(!!el.scrollLeft||el==_23b||el.scrollWidth>el.offsetHeight)){s=Math[l<0?"max":"min"](l,r);if(rtl&&((isIE==8&&!_238)||has("trident")>=5)){s=-s;}old=el.scrollLeft;_23e(el,s,0);s=el.scrollLeft-old;_23c.x-=s;}if(bot*t>0&&(!!el.scrollTop||el==_23b||el.scrollHeight>el.offsetHeight)){s=Math.ceil(Math[t<0?"max":"min"](t,bot));old=el.scrollTop;_23e(el,0,s);s=el.scrollTop-old;_23c.y-=s;}el=(el!=_23b)&&!_240&&el.parentNode;}}catch(error){console.error("scrollIntoView: "+error);node.scrollIntoView(false);}}};1&&lang.setObject("dojo.window",_234);return _234;});},"dijit/a11y":function(){define("dijit/a11y",["dojo/_base/array","dojo/dom","dojo/dom-attr","dojo/dom-style","dojo/_base/lang","dojo/sniff","./main"],function(_243,dom,_244,_245,lang,has,_246){var _247;var a11y={_isElementShown:function(elem){var s=_245.get(elem);return (s.visibility!="hidden")&&(s.visibility!="collapsed")&&(s.display!="none")&&(_244.get(elem,"type")!="hidden");},hasDefaultTabStop:function(elem){switch(elem.nodeName.toLowerCase()){case "a":return _244.has(elem,"href");case "area":case "button":case "input":case "object":case "select":case "textarea":return true;case "iframe":var body;try{var _248=elem.contentDocument;if("designMode" in _248&&_248.designMode=="on"){return true;}body=_248.body;}catch(e1){try{body=elem.contentWindow.document.body;}catch(e2){return false;}}return body&&(body.contentEditable=="true"||(body.firstChild&&body.firstChild.contentEditable=="true"));default:return elem.contentEditable=="true";}},effectiveTabIndex:function(elem){if(_244.get(elem,"disabled")){return _247;}else{if(_244.has(elem,"tabIndex")){return +_244.get(elem,"tabIndex");}else{return a11y.hasDefaultTabStop(elem)?0:_247;}}},isTabNavigable:function(elem){return a11y.effectiveTabIndex(elem)>=0;},isFocusable:function(elem){return a11y.effectiveTabIndex(elem)>=-1;},_getTabNavigable:function(root){var _249,last,_24a,_24b,_24c,_24d,_24e={};function _24f(node){return node&&node.tagName.toLowerCase()=="input"&&node.type&&node.type.toLowerCase()=="radio"&&node.name&&node.name.toLowerCase();};var _250=a11y._isElementShown,_251=a11y.effectiveTabIndex;var _252=function(_253){for(var _254=_253.firstChild;_254;_254=_254.nextSibling){if(_254.nodeType!=1||(has("ie")<=9&&_254.scopeName!=="HTML")||!_250(_254)){continue;}var _255=_251(_254);if(_255>=0){if(_255==0){if(!_249){_249=_254;}last=_254;}else{if(_255>0){if(!_24a||_255<_24b){_24b=_255;_24a=_254;}if(!_24c||_255>=_24d){_24d=_255;_24c=_254;}}}var rn=_24f(_254);if(_244.get(_254,"checked")&&rn){_24e[rn]=_254;}}if(_254.nodeName.toUpperCase()!="SELECT"){_252(_254);}}};if(_250(root)){_252(root);}function rs(node){return _24e[_24f(node)]||node;};return {first:rs(_249),last:rs(last),lowest:rs(_24a),highest:rs(_24c)};},getFirstInTabbingOrder:function(root,doc){var _256=a11y._getTabNavigable(dom.byId(root,doc));return _256.lowest?_256.lowest:_256.first;},getLastInTabbingOrder:function(root,doc){var _257=a11y._getTabNavigable(dom.byId(root,doc));return _257.last?_257.last:_257.highest;}};1&&lang.mixin(_246,a11y);return a11y;});},"dojo/uacss":function(){define(["./dom-geometry","./_base/lang","./ready","./sniff","./_base/window"],function(_258,lang,_259,has,_25a){var html=_25a.doc.documentElement,ie=has("ie"),_25b=has("trident"),_25c=has("opera"),maj=Math.floor,ff=has("ff"),_25d=_258.boxModel.replace(/-/,""),_25e={"dj_quirks":has("quirks"),"dj_opera":_25c,"dj_khtml":has("khtml"),"dj_webkit":has("webkit"),"dj_safari":has("safari"),"dj_chrome":has("chrome"),"dj_gecko":has("mozilla")};if(ie){_25e["dj_ie"]=true;_25e["dj_ie"+maj(ie)]=true;_25e["dj_iequirks"]=has("quirks");}if(_25b){_25e["dj_trident"]=true;_25e["dj_trident"+maj(_25b)]=true;}if(ff){_25e["dj_ff"+maj(ff)]=true;}_25e["dj_"+_25d]=true;var _25f="";for(var clz in _25e){if(_25e[clz]){_25f+=clz+" ";}}html.className=lang.trim(html.className+" "+_25f);_259(90,function(){if(!_258.isBodyLtr()){var _260="dj_rtl dijitRtl "+_25f.replace(/ /g,"-rtl ");html.className=lang.trim(html.className+" "+_260+"dj_rtl dijitRtl "+_25f.replace(/ /g,"-rtl "));}});return has;});},"dijit/hccss":function(){define("dijit/hccss",["dojo/dom-class","dojo/hccss","dojo/ready","dojo/_base/window"],function(_261,has,_262,win){_262(90,function(){if(has("highcontrast")){_261.add(win.body(),"dijit_a11y");}});return has;});},"dojo/hccss":function(){define(["require","./_base/config","./dom-class","./dom-style","./has","./ready","./_base/window"],function(_263,_264,_265,_266,has,_267,win){has.add("highcontrast",function(){var div=win.doc.createElement("div");div.style.cssText="border: 1px solid; border-color:red green; position: absolute; height: 5px; top: -999px;"+"background-image: url("+(_264.blankGif||_263.toUrl("./resources/blank.gif"))+");";win.body().appendChild(div);var cs=_266.getComputedStyle(div),_268=cs.backgroundImage,hc=(cs.borderTopColor==cs.borderRightColor)||(_268&&(_268=="none"||_268=="url(invalid-url:)"));if(has("ie")<=8){div.outerHTML="";}else{win.body().removeChild(div);}return hc;});_267(90,function(){if(has("highcontrast")){_265.add(win.body(),"dj_a11y");}});return has;});},"dojox/grid/_RowSelector":function(){define(["dojo/_base/declare","./_View"],function(_269,_26a){return _269("dojox.grid._RowSelector",_26a,{defaultWidth:"2em",noscroll:true,padBorderWidth:2,buildRendering:function(){this.inherited("buildRendering",arguments);this.scrollboxNode.style.overflow="hidden";this.headerNode.style.visibility="hidden";},getWidth:function(){return this.viewWidth||this.defaultWidth;},buildRowContent:function(_26b,_26c){var w=this.contentWidth||0;_26c.innerHTML="<table class=\"dojoxGridRowbarTable\" style=\"width:"+w+"px;height:1px;\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"><tr><td class=\"dojoxGridRowbarInner\">&nbsp;</td></tr></table>";},renderHeader:function(){},updateRow:function(){},resize:function(){this.adaptHeight();},adaptWidth:function(){if(!("contentWidth" in this)&&this.contentNode&&this.contentNode.offsetWidth>0){this.contentWidth=this.contentNode.offsetWidth-this.padBorderWidth;}},doStyleRowNode:function(_26d,_26e){var n=["dojoxGridRowbar dojoxGridNonNormalizedCell"];if(this.grid.rows.isOver(_26d)){n.push("dojoxGridRowbarOver");}if(this.grid.selection.isSelected(_26d)){n.push("dojoxGridRowbarSelected");}_26e.className=n.join(" ");},domouseover:function(e){this.grid.onMouseOverRow(e);},domouseout:function(e){if(!this.isIntraRowEvent(e)){this.grid.onMouseOutRow(e);}}});});},"dojox/grid/_View":function(){define(["dojo","dijit/registry","../main","dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/_base/connect","dojo/_base/sniff","dojo/query","dojo/_base/window","dojo/text!./resources/View.html","dojo/dnd/Source","dijit/_Widget","dijit/_TemplatedMixin","dojox/html/metrics","./util","dojo/_base/html","./_Builder","dojo/dnd/Avatar","dojo/dnd/Manager"],function(dojo,_26f,_270,_271,_272,lang,_273,has,_274,win,_275,_276,_277,_278,_279,util,html,_27a,_27b,_27c){var _27d=function(_27e,_27f){return _27e.style.cssText==undefined?_27e.getAttribute("style"):_27e.style.cssText;};var _280=_271("dojox.grid._View",[_277,_278],{defaultWidth:"18em",viewWidth:"",templateString:_275,classTag:"dojoxGrid",marginBottom:0,rowPad:2,_togglingColumn:-1,_headerBuilderClass:_27a._HeaderBuilder,_contentBuilderClass:_27a._ContentBuilder,postMixInProperties:function(){this.rowNodes={};},postCreate:function(){this.connect(this.scrollboxNode,"onscroll","doscroll");util.funnelEvents(this.contentNode,this,"doContentEvent",["mouseover","mouseout","click","dblclick","contextmenu","mousedown"]);util.funnelEvents(this.headerNode,this,"doHeaderEvent",["dblclick","mouseover","mouseout","mousemove","mousedown","click","contextmenu"]);this.content=new this._contentBuilderClass(this);this.header=new this._headerBuilderClass(this);if(!this.grid.isLeftToRight()){this.headerNodeContainer.style.width="";}},destroy:function(){html.destroy(this.headerNode);delete this.headerNode;for(var i in this.rowNodes){this._cleanupRowWidgets(this.rowNodes[i]);html.destroy(this.rowNodes[i]);}this.rowNodes={};if(this.source){this.source.destroy();}this.inherited(arguments);},focus:function(){if(has("ie")||has("webkit")||has("opera")){this.hiddenFocusNode.focus();}else{this.scrollboxNode.focus();}},setStructure:function(_281){var vs=(this.structure=_281);if(vs.width&&!isNaN(vs.width)){this.viewWidth=vs.width+"em";}else{this.viewWidth=vs.width||(vs.noscroll?"auto":this.viewWidth);}this._onBeforeRow=vs.onBeforeRow||function(){};this._onAfterRow=vs.onAfterRow||function(){};this.noscroll=vs.noscroll;if(this.noscroll){this.scrollboxNode.style.overflow="hidden";}this.simpleStructure=Boolean(vs.cells.length==1);this.testFlexCells();this.updateStructure();},_cleanupRowWidgets:function(_282){if(_282){_272.forEach(_274("[widgetId]",_282).map(_26f.byNode),function(w){if(w._destroyOnRemove){w.destroy();delete w;}else{if(w.domNode&&w.domNode.parentNode){w.domNode.parentNode.removeChild(w.domNode);}}});}},onBeforeRow:function(_283,_284){this._onBeforeRow(_283,_284);if(_283>=0){this._cleanupRowWidgets(this.getRowNode(_283));}},onAfterRow:function(_285,_286,_287){this._onAfterRow(_285,_286,_287);var g=this.grid;_272.forEach(_274(".dojoxGridStubNode",_287),function(n){if(n&&n.parentNode){var lw=n.getAttribute("linkWidget");var _288=window.parseInt(html.attr(n,"cellIdx"),10);var _289=g.getCell(_288);var w=_26f.byId(lw);if(w){n.parentNode.replaceChild(w.domNode,n);if(!w._started){w.startup();}dojo.destroy(n);}else{n.innerHTML="";}}},this);},testFlexCells:function(){this.flexCells=false;for(var j=0,row;(row=this.structure.cells[j]);j++){for(var i=0,cell;(cell=row[i]);i++){cell.view=this;this.flexCells=this.flexCells||cell.isFlex();}}return this.flexCells;},updateStructure:function(){this.header.update();this.content.update();},getScrollbarWidth:function(){var _28a=this.hasVScrollbar();var _28b=html.style(this.scrollboxNode,"overflow");if(this.noscroll||!_28b||_28b=="hidden"){_28a=false;}else{if(_28b=="scroll"){_28a=true;}}return (_28a?_279.getScrollbar().w:0);},getColumnsWidth:function(){var h=this.headerContentNode;return h&&h.firstChild?(h.firstChild.offsetWidth||html.style(h.firstChild,"width")):0;},setColumnsWidth:function(_28c){this.headerContentNode.firstChild.style.width=_28c+"px";if(this.viewWidth){this.viewWidth=_28c+"px";}},getWidth:function(){return this.viewWidth||(this.getColumnsWidth()+this.getScrollbarWidth())+"px";},getContentWidth:function(){return Math.max(0,html._getContentBox(this.domNode).w-this.getScrollbarWidth())+"px";},render:function(){this.scrollboxNode.style.height="";this.renderHeader();if(this._togglingColumn>=0){this.setColumnsWidth(this.getColumnsWidth()-this._togglingColumn);this._togglingColumn=-1;}var _28d=this.grid.layout.cells;var _28e=lang.hitch(this,function(node,_28f){!this.grid.isLeftToRight()&&(_28f=!_28f);var inc=_28f?-1:1;var idx=this.header.getCellNodeIndex(node)+inc;var cell=_28d[idx];while(cell&&cell.getHeaderNode()&&cell.getHeaderNode().style.display=="none"){idx+=inc;cell=_28d[idx];}if(cell){return cell.getHeaderNode();}return null;});if(this.grid.columnReordering&&this.simpleStructure){if(this.source){this.source.destroy();}var _290="dojoxGrid_bottomMarker";var _291="dojoxGrid_topMarker";if(this.bottomMarker){html.destroy(this.bottomMarker);}this.bottomMarker=html.byId(_290);if(this.topMarker){html.destroy(this.topMarker);}this.topMarker=html.byId(_291);if(!this.bottomMarker){this.bottomMarker=html.create("div",{"id":_290,"class":"dojoxGridColPlaceBottom"},win.body());this._hide(this.bottomMarker);this.topMarker=html.create("div",{"id":_291,"class":"dojoxGridColPlaceTop"},win.body());this._hide(this.topMarker);}this.arrowDim=html.contentBox(this.bottomMarker);var _292=html.contentBox(this.headerContentNode.firstChild.rows[0]).h;this.source=new _276(this.headerContentNode.firstChild.rows[0],{horizontal:true,accept:["gridColumn_"+this.grid.id],viewIndex:this.index,generateText:false,onMouseDown:lang.hitch(this,function(e){this.header.decorateEvent(e);if((this.header.overRightResizeArea(e)||this.header.overLeftResizeArea(e))&&this.header.canResize(e)&&!this.header.moveable){this.header.beginColumnResize(e);}else{if(this.grid.headerMenu){this.grid.headerMenu.onCancel(true);}if(e.button===(has("ie")<9?1:0)){_276.prototype.onMouseDown.call(this.source,e);}}}),onMouseOver:lang.hitch(this,function(e){var src=this.source;if(src._getChildByEvent(e)){_276.prototype.onMouseOver.apply(src,arguments);}}),_markTargetAnchor:lang.hitch(this,function(_293){var src=this.source;if(src.current==src.targetAnchor&&src.before==_293){return;}if(src.targetAnchor&&_28e(src.targetAnchor,src.before)){src._removeItemClass(_28e(src.targetAnchor,src.before),src.before?"After":"Before");}_276.prototype._markTargetAnchor.call(src,_293);var _294=_293?src.targetAnchor:_28e(src.targetAnchor,src.before);var _295=0;if(!_294){_294=src.targetAnchor;_295=html.contentBox(_294).w+this.arrowDim.w/2+2;}var pos=html.position(_294,true);var left=Math.floor(pos.x-this.arrowDim.w/2+_295);html.style(this.bottomMarker,"visibility","visible");html.style(this.topMarker,"visibility","visible");html.style(this.bottomMarker,{"left":left+"px","top":(_292+pos.y)+"px"});html.style(this.topMarker,{"left":left+"px","top":(pos.y-this.arrowDim.h)+"px"});if(src.targetAnchor&&_28e(src.targetAnchor,src.before)){src._addItemClass(_28e(src.targetAnchor,src.before),src.before?"After":"Before");}}),_unmarkTargetAnchor:lang.hitch(this,function(){var src=this.source;if(!src.targetAnchor){return;}if(src.targetAnchor&&_28e(src.targetAnchor,src.before)){src._removeItemClass(_28e(src.targetAnchor,src.before),src.before?"After":"Before");}this._hide(this.bottomMarker);this._hide(this.topMarker);_276.prototype._unmarkTargetAnchor.call(src);}),destroy:lang.hitch(this,function(){_273.disconnect(this._source_conn);_273.unsubscribe(this._source_sub);_276.prototype.destroy.call(this.source);if(this.bottomMarker){html.destroy(this.bottomMarker);delete this.bottomMarker;}if(this.topMarker){html.destroy(this.topMarker);delete this.topMarker;}}),onDndCancel:lang.hitch(this,function(){_276.prototype.onDndCancel.call(this.source);this._hide(this.bottomMarker);this._hide(this.topMarker);})});this._source_conn=_273.connect(this.source,"onDndDrop",this,"_onDndDrop");this._source_sub=_273.subscribe("/dnd/drop/before",this,"_onDndDropBefore");this.source.startup();}},_hide:function(node){html.style(node,{top:"-10000px","visibility":"hidden"});},_onDndDropBefore:function(_296,_297,copy){if(_27c.manager().target!==this.source){return;}this.source._targetNode=this.source.targetAnchor;this.source._beforeTarget=this.source.before;var _298=this.grid.views.views;var _299=_298[_296.viewIndex];var _29a=_298[this.index];if(_29a!=_299){_299.convertColPctToFixed();_29a.convertColPctToFixed();}},_onDndDrop:function(_29b,_29c,copy){if(_27c.manager().target!==this.source){if(_27c.manager().source===this.source){this._removingColumn=true;}return;}this._hide(this.bottomMarker);this._hide(this.topMarker);var _29d=function(n){return n?html.attr(n,"idx"):null;};var w=html.marginBox(_29c[0]).w;if(_29b.viewIndex!==this.index){var _29e=this.grid.views.views;var _29f=_29e[_29b.viewIndex];var _2a0=_29e[this.index];if(_29f.viewWidth&&_29f.viewWidth!="auto"){_29f.setColumnsWidth(_29f.getColumnsWidth()-w);}if(_2a0.viewWidth&&_2a0.viewWidth!="auto"){_2a0.setColumnsWidth(_2a0.getColumnsWidth());}}var stn=this.source._targetNode;var stb=this.source._beforeTarget;!this.grid.isLeftToRight()&&(stb=!stb);var _2a1=this.grid.layout;var idx=this.index;delete this.source._targetNode;delete this.source._beforeTarget;_2a1.moveColumn(_29b.viewIndex,idx,_29d(_29c[0]),_29d(stn),stb);},renderHeader:function(){this.headerContentNode.innerHTML=this.header.generateHtml(this._getHeaderContent);if(this.flexCells){this.contentWidth=this.getContentWidth();this.headerContentNode.firstChild.style.width=this.contentWidth;}util.fire(this,"onAfterRow",[-1,this.structure.cells,this.headerContentNode]);},_getHeaderContent:function(_2a2){var n=_2a2.name||_2a2.grid.getCellName(_2a2);if(/^\s+$/.test(n)){n="&nbsp;";}var ret=["<div class=\"dojoxGridSortNode"];if(_2a2.index!=_2a2.grid.getSortIndex()){ret.push("\">");}else{ret=ret.concat([" ",_2a2.grid.sortInfo>0?"dojoxGridSortUp":"dojoxGridSortDown","\"><div class=\"dojoxGridArrowButtonChar\">",_2a2.grid.sortInfo>0?"&#9650;":"&#9660;","</div><div class=\"dojoxGridArrowButtonNode\" role=\"presentation\"></div>","<div class=\"dojoxGridColCaption\">"]);}ret=ret.concat([n,"</div></div>"]);return ret.join("");},resize:function(){this.adaptHeight();this.adaptWidth();},hasHScrollbar:function(_2a3){var _2a4=this._hasHScroll||false;if(this._hasHScroll==undefined||_2a3){if(this.noscroll){this._hasHScroll=false;}else{var _2a5=html.style(this.scrollboxNode,"overflow");if(_2a5=="hidden"){this._hasHScroll=false;}else{if(_2a5=="scroll"){this._hasHScroll=true;}else{this._hasHScroll=(this.scrollboxNode.offsetWidth-this.getScrollbarWidth()<this.contentNode.offsetWidth);}}}}if(_2a4!==this._hasHScroll){this.grid.update();}return this._hasHScroll;},hasVScrollbar:function(_2a6){var _2a7=this._hasVScroll||false;if(this._hasVScroll==undefined||_2a6){if(this.noscroll){this._hasVScroll=false;}else{var _2a8=html.style(this.scrollboxNode,"overflow");if(_2a8=="hidden"){this._hasVScroll=false;}else{if(_2a8=="scroll"){this._hasVScroll=true;}else{this._hasVScroll=(this.scrollboxNode.scrollHeight>this.scrollboxNode.clientHeight);}}}}if(_2a7!==this._hasVScroll){this.grid.update();}return this._hasVScroll;},convertColPctToFixed:function(){var _2a9=false;this.grid.initialWidth="";var _2aa=_274("th",this.headerContentNode);var _2ab=_272.map(_2aa,function(c,vIdx){var w=c.style.width;html.attr(c,"vIdx",vIdx);if(w&&w.slice(-1)=="%"){_2a9=true;}else{if(w&&w.slice(-2)=="px"){return window.parseInt(w,10);}}return html.contentBox(c).w;});if(_2a9){_272.forEach(this.grid.layout.cells,function(cell,idx){if(cell.view==this){var _2ac=cell.view.getHeaderCellNode(cell.index);if(_2ac&&html.hasAttr(_2ac,"vIdx")){var vIdx=window.parseInt(html.attr(_2ac,"vIdx"));this.setColWidth(idx,_2ab[vIdx]);html.removeAttr(_2ac,"vIdx");}}},this);return true;}return false;},adaptHeight:function(_2ad){if(!this.grid._autoHeight){var h=(this.domNode.style.height&&parseInt(this.domNode.style.height.replace(/px/,""),10))||this.domNode.clientHeight;var self=this;var _2ae=function(){var v;for(var i in self.grid.views.views){v=self.grid.views.views[i];if(v!==self&&v.hasHScrollbar()){return true;}}return false;};if(_2ad||(this.noscroll&&_2ae())){h-=_279.getScrollbar().h;}util.setStyleHeightPx(this.scrollboxNode,h);}this.hasVScrollbar(true);},adaptWidth:function(){if(this.flexCells){this.contentWidth=this.getContentWidth();this.headerContentNode.firstChild.style.width=this.contentWidth;}var w=this.scrollboxNode.offsetWidth-this.getScrollbarWidth();if(!this._removingColumn){w=Math.max(w,this.getColumnsWidth())+"px";}else{w=Math.min(w,this.getColumnsWidth())+"px";this._removingColumn=false;}var cn=this.contentNode;cn.style.width=w;this.hasHScrollbar(true);},setSize:function(w,h){var ds=this.domNode.style;var hs=this.headerNode.style;if(w){ds.width=w;hs.width=w;}ds.height=(h>=0?h+"px":"");},renderRow:function(_2af){var _2b0=this.createRowNode(_2af);this.buildRow(_2af,_2b0);return _2b0;},createRowNode:function(_2b1){var node=document.createElement("div");node.className=this.classTag+"Row";if(this instanceof _270.grid._RowSelector){html.attr(node,"role","presentation");}else{html.attr(node,"role","row");if(this.grid.selectionMode!="none"){node.setAttribute("aria-selected","false");}}node[util.gridViewTag]=this.id;node[util.rowIndexTag]=_2b1;this.rowNodes[_2b1]=node;return node;},buildRow:function(_2b2,_2b3){this.buildRowContent(_2b2,_2b3);this.styleRow(_2b2,_2b3);},buildRowContent:function(_2b4,_2b5){_2b5.innerHTML=this.content.generateHtml(_2b4,_2b4);if(this.flexCells&&this.contentWidth){_2b5.firstChild.style.width=this.contentWidth;}util.fire(this,"onAfterRow",[_2b4,this.structure.cells,_2b5]);},rowRemoved:function(_2b6){if(_2b6>=0){this._cleanupRowWidgets(this.getRowNode(_2b6));}this.grid.edit.save(this,_2b6);delete this.rowNodes[_2b6];},getRowNode:function(_2b7){return this.rowNodes[_2b7];},getCellNode:function(_2b8,_2b9){var row=this.getRowNode(_2b8);if(row){return this.content.getCellNode(row,_2b9);}},getHeaderCellNode:function(_2ba){if(this.headerContentNode){return this.header.getCellNode(this.headerContentNode,_2ba);}},styleRow:function(_2bb,_2bc){_2bc._style=_27d(_2bc);this.styleRowNode(_2bb,_2bc);},styleRowNode:function(_2bd,_2be){if(_2be){this.doStyleRowNode(_2bd,_2be);}},doStyleRowNode:function(_2bf,_2c0){this.grid.styleRowNode(_2bf,_2c0);},updateRow:function(_2c1){var _2c2=this.getRowNode(_2c1);if(_2c2){_2c2.style.height="";this.buildRow(_2c1,_2c2);}return _2c2;},updateRowStyles:function(_2c3){this.styleRowNode(_2c3,this.getRowNode(_2c3));},lastTop:0,firstScroll:0,_nativeScroll:false,doscroll:function(_2c4){if(has("ff")>=13||has("chrome")){this._nativeScroll=true;}var _2c5=this.grid.isLeftToRight();if(this.firstScroll<2){if((!_2c5&&this.firstScroll==1)||(_2c5&&this.firstScroll===0)){var s=html.marginBox(this.headerNodeContainer);if(has("ie")){this.headerNodeContainer.style.width=s.w+this.getScrollbarWidth()+"px";}else{if(has("mozilla")){this.headerNodeContainer.style.width=s.w-this.getScrollbarWidth()+"px";this.scrollboxNode.scrollLeft=_2c5?this.scrollboxNode.clientWidth-this.scrollboxNode.scrollWidth:this.scrollboxNode.scrollWidth-this.scrollboxNode.clientWidth;}}}this.firstScroll++;}this.headerNode.scrollLeft=this.scrollboxNode.scrollLeft;var top=this.scrollboxNode.scrollTop;if(top!==this.lastTop){this.grid.scrollTo(top);}this._nativeScroll=false;},setScrollTop:function(_2c6){this.lastTop=_2c6;if(!this._nativeScroll){this.scrollboxNode.scrollTop=_2c6;}return this.scrollboxNode.scrollTop;},doContentEvent:function(e){if(this.content.decorateEvent(e)){this.grid.onContentEvent(e);}},doHeaderEvent:function(e){if(this.header.decorateEvent(e)){this.grid.onHeaderEvent(e);}},dispatchContentEvent:function(e){return this.content.dispatchEvent(e);},dispatchHeaderEvent:function(e){return this.header.dispatchEvent(e);},setColWidth:function(_2c7,_2c8){this.grid.setCellWidth(_2c7,_2c8+"px");},update:function(){if(!this.domNode){return;}this.content.update();this.grid.update();var left=this.scrollboxNode.scrollLeft;this.scrollboxNode.scrollLeft=left;this.headerNode.scrollLeft=left;}});var _2c9=_271("dojox.grid._GridAvatar",_27b,{construct:function(){var dd=win.doc;var a=dd.createElement("table");a.cellPadding=a.cellSpacing="0";a.className="dojoxGridDndAvatar";a.style.position="absolute";a.style.zIndex=1999;a.style.margin="0px";var b=dd.createElement("tbody");var tr=dd.createElement("tr");var td=dd.createElement("td");var img=dd.createElement("td");tr.className="dojoxGridDndAvatarItem";img.className="dojoxGridDndAvatarItemImage";img.style.width="16px";var _2ca=this.manager.source,node;if(_2ca.creator){node=_2ca._normalizedCreator(_2ca.getItem(this.manager.nodes[0].id).data,"avatar").node;}else{node=this.manager.nodes[0].cloneNode(true);var _2cb,_2cc;if(node.tagName.toLowerCase()=="tr"){_2cb=dd.createElement("table");_2cc=dd.createElement("tbody");_2cc.appendChild(node);_2cb.appendChild(_2cc);node=_2cb;}else{if(node.tagName.toLowerCase()=="th"){_2cb=dd.createElement("table");_2cc=dd.createElement("tbody");var r=dd.createElement("tr");_2cb.cellPadding=_2cb.cellSpacing="0";r.appendChild(node);_2cc.appendChild(r);_2cb.appendChild(_2cc);node=_2cb;}}}node.id="";td.appendChild(node);tr.appendChild(img);tr.appendChild(td);html.style(tr,"opacity",0.9);b.appendChild(tr);a.appendChild(b);this.node=a;var m=_27c.manager();this.oldOffsetY=m.OFFSET_Y;m.OFFSET_Y=1;},destroy:function(){_27c.manager().OFFSET_Y=this.oldOffsetY;this.inherited(arguments);}});var _2cd=_27c.manager().makeAvatar;_27c.manager().makeAvatar=function(){var src=this.source;if(src.viewIndex!==undefined&&!html.hasClass(win.body(),"dijit_a11y")){return new _2c9(this);}return _2cd.call(_27c.manager());};return _280;});},"url:dojox/grid/resources/View.html":"<div class=\"dojoxGridView\" role=\"presentation\">\n\t<div class=\"dojoxGridHeader\" dojoAttachPoint=\"headerNode\" role=\"presentation\">\n\t\t<div dojoAttachPoint=\"headerNodeContainer\" style=\"width:9000em\" role=\"presentation\">\n\t\t\t<div dojoAttachPoint=\"headerContentNode\" role=\"row\"></div>\n\t\t</div>\n\t</div>\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" dojoAttachPoint=\"hiddenFocusNode\" role=\"presentation\" />\n\t<input type=\"checkbox\" class=\"dojoxGridHiddenFocus\" role=\"presentation\" />\n\t<div class=\"dojoxGridScrollbox\" dojoAttachPoint=\"scrollboxNode\" role=\"presentation\">\n\t\t<div class=\"dojoxGridContent\" dojoAttachPoint=\"contentNode\" hidefocus=\"hidefocus\" role=\"presentation\"></div>\n\t</div>\n</div>\n","dojo/dnd/Source":function(){define(["../_base/array","../_base/connect","../_base/declare","../_base/kernel","../_base/lang","../dom-class","../dom-geometry","../mouse","../ready","../topic","./common","./Selector","./Manager"],function(_2ce,_2cf,_2d0,_2d1,lang,_2d2,_2d3,_2d4,_2d5,_2d6,dnd,_2d7,_2d8){if(!_2d1.isAsync){_2d5(0,function(){var _2d9=["dojo/dnd/AutoSource","dojo/dnd/Target"];require(_2d9);});}var _2da=_2d0("dojo.dnd.Source",_2d7,{isSource:true,horizontal:false,copyOnly:false,selfCopy:false,selfAccept:true,skipForm:false,withHandles:false,autoSync:false,delay:0,accept:["text"],generateText:true,constructor:function(node,_2db){lang.mixin(this,lang.mixin({},_2db));var type=this.accept;if(type.length){this.accept={};for(var i=0;i<type.length;++i){this.accept[type[i]]=1;}}this.isDragging=false;this.mouseDown=false;this.targetAnchor=null;this.targetBox=null;this.before=true;this._lastX=0;this._lastY=0;this.sourceState="";if(this.isSource){_2d2.add(this.node,"dojoDndSource");}this.targetState="";if(this.accept){_2d2.add(this.node,"dojoDndTarget");}if(this.horizontal){_2d2.add(this.node,"dojoDndHorizontal");}this.topics=[_2d6.subscribe("/dnd/source/over",lang.hitch(this,"onDndSourceOver")),_2d6.subscribe("/dnd/start",lang.hitch(this,"onDndStart")),_2d6.subscribe("/dnd/drop",lang.hitch(this,"onDndDrop")),_2d6.subscribe("/dnd/cancel",lang.hitch(this,"onDndCancel"))];},checkAcceptance:function(_2dc,_2dd){if(this==_2dc){return !this.copyOnly||this.selfAccept;}for(var i=0;i<_2dd.length;++i){var type=_2dc.getItem(_2dd[i].id).type;var flag=false;for(var j=0;j<type.length;++j){if(type[j] in this.accept){flag=true;break;}}if(!flag){return false;}}return true;},copyState:function(_2de,self){if(_2de){return true;}if(arguments.length<2){self=this==_2d8.manager().target;}if(self){if(this.copyOnly){return this.selfCopy;}}else{return this.copyOnly;}return false;},destroy:function(){_2da.superclass.destroy.call(this);_2ce.forEach(this.topics,function(t){t.remove();});this.targetAnchor=null;},onMouseMove:function(e){if(this.isDragging&&this.targetState=="Disabled"){return;}_2da.superclass.onMouseMove.call(this,e);var m=_2d8.manager();if(!this.isDragging){if(this.mouseDown&&this.isSource&&(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay)){var _2df=this.getSelectedNodes();if(_2df.length){m.startDrag(this,_2df,this.copyState(dnd.getCopyKeyState(e),true));}}}if(this.isDragging){var _2e0=false;if(this.current){if(!this.targetBox||this.targetAnchor!=this.current){this.targetBox=_2d3.position(this.current,true);}if(this.horizontal){_2e0=(e.pageX-this.targetBox.x<this.targetBox.w/2)==_2d3.isBodyLtr(this.current.ownerDocument);}else{_2e0=(e.pageY-this.targetBox.y)<(this.targetBox.h/2);}}if(this.current!=this.targetAnchor||_2e0!=this.before){this._markTargetAnchor(_2e0);m.canDrop(!this.current||m.source!=this||!(this.current.id in this.selection));}}},onMouseDown:function(e){if(!this.mouseDown&&this._legalMouseDown(e)&&(!this.skipForm||!dnd.isFormElement(e))){this.mouseDown=true;this._lastX=e.pageX;this._lastY=e.pageY;_2da.superclass.onMouseDown.call(this,e);}},onMouseUp:function(e){if(this.mouseDown){this.mouseDown=false;_2da.superclass.onMouseUp.call(this,e);}},onDndSourceOver:function(_2e1){if(this!==_2e1){this.mouseDown=false;if(this.targetAnchor){this._unmarkTargetAnchor();}}else{if(this.isDragging){var m=_2d8.manager();m.canDrop(this.targetState!="Disabled"&&(!this.current||m.source!=this||!(this.current.id in this.selection)));}}},onDndStart:function(_2e2,_2e3,copy){if(this.autoSync){this.sync();}if(this.isSource){this._changeState("Source",this==_2e2?(copy?"Copied":"Moved"):"");}var _2e4=this.accept&&this.checkAcceptance(_2e2,_2e3);this._changeState("Target",_2e4?"":"Disabled");if(this==_2e2){_2d8.manager().overSource(this);}this.isDragging=true;},onDndDrop:function(_2e5,_2e6,copy,_2e7){if(this==_2e7){this.onDrop(_2e5,_2e6,copy);}this.onDndCancel();},onDndCancel:function(){if(this.targetAnchor){this._unmarkTargetAnchor();this.targetAnchor=null;}this.before=true;this.isDragging=false;this.mouseDown=false;this._changeState("Source","");this._changeState("Target","");},onDrop:function(_2e8,_2e9,copy){if(this!=_2e8){this.onDropExternal(_2e8,_2e9,copy);}else{this.onDropInternal(_2e9,copy);}},onDropExternal:function(_2ea,_2eb,copy){var _2ec=this._normalizedCreator;if(this.creator){this._normalizedCreator=function(node,hint){return _2ec.call(this,_2ea.getItem(node.id).data,hint);};}else{if(copy){this._normalizedCreator=function(node){var t=_2ea.getItem(node.id);var n=node.cloneNode(true);n.id=dnd.getUniqueId();return {node:n,data:t.data,type:t.type};};}else{this._normalizedCreator=function(node){var t=_2ea.getItem(node.id);_2ea.delItem(node.id);return {node:node,data:t.data,type:t.type};};}}this.selectNone();if(!copy&&!this.creator){_2ea.selectNone();}this.insertNodes(true,_2eb,this.before,this.current);if(!copy&&this.creator){_2ea.deleteSelectedNodes();}this._normalizedCreator=_2ec;},onDropInternal:function(_2ed,copy){var _2ee=this._normalizedCreator;if(this.current&&this.current.id in this.selection){return;}if(copy){if(this.creator){this._normalizedCreator=function(node,hint){return _2ee.call(this,this.getItem(node.id).data,hint);};}else{this._normalizedCreator=function(node){var t=this.getItem(node.id);var n=node.cloneNode(true);n.id=dnd.getUniqueId();return {node:n,data:t.data,type:t.type};};}}else{if(!this.current){return;}this._normalizedCreator=function(node){var t=this.getItem(node.id);return {node:node,data:t.data,type:t.type};};}this._removeSelection();this.insertNodes(true,_2ed,this.before,this.current);this._normalizedCreator=_2ee;},onDraggingOver:function(){},onDraggingOut:function(){},onOverEvent:function(){_2da.superclass.onOverEvent.call(this);_2d8.manager().overSource(this);if(this.isDragging&&this.targetState!="Disabled"){this.onDraggingOver();}},onOutEvent:function(){_2da.superclass.onOutEvent.call(this);_2d8.manager().outSource(this);if(this.isDragging&&this.targetState!="Disabled"){this.onDraggingOut();}},_markTargetAnchor:function(_2ef){if(this.current==this.targetAnchor&&this.before==_2ef){return;}if(this.targetAnchor){this._removeItemClass(this.targetAnchor,this.before?"Before":"After");}this.targetAnchor=this.current;this.targetBox=null;this.before=_2ef;if(this.targetAnchor){this._addItemClass(this.targetAnchor,this.before?"Before":"After");}},_unmarkTargetAnchor:function(){if(!this.targetAnchor){return;}this._removeItemClass(this.targetAnchor,this.before?"Before":"After");this.targetAnchor=null;this.targetBox=null;this.before=true;},_markDndStatus:function(copy){this._changeState("Source",copy?"Copied":"Moved");},_legalMouseDown:function(e){if(e.type!="touchstart"&&!_2d4.isLeft(e)){return false;}if(!this.withHandles){return true;}for(var node=e.target;node&&node!==this.node;node=node.parentNode){if(_2d2.contains(node,"dojoDndHandle")){return true;}if(_2d2.contains(node,"dojoDndItem")||_2d2.contains(node,"dojoDndIgnore")){break;}}return false;}});return _2da;});},"dojo/dnd/common":function(){define(["../_base/connect","../_base/kernel","../_base/lang","../dom"],function(_2f0,_2f1,lang,dom){var _2f2=lang.getObject("dojo.dnd",true);_2f2.getCopyKeyState=_2f0.isCopyKey;_2f2._uniqueId=0;_2f2.getUniqueId=function(){var id;do{id=_2f1._scopeName+"Unique"+(++_2f2._uniqueId);}while(dom.byId(id));return id;};_2f2._empty={};_2f2.isFormElement=function(e){var t=e.target;if(t.nodeType==3){t=t.parentNode;}return " button textarea input select option ".indexOf(" "+t.tagName.toLowerCase()+" ")>=0;};return _2f2;});},"dojo/dnd/Selector":function(){define(["../_base/array","../_base/declare","../_base/event","../_base/kernel","../_base/lang","../dom","../dom-construct","../mouse","../_base/NodeList","../on","../touch","./common","./Container"],function(_2f3,_2f4,_2f5,_2f6,lang,dom,_2f7,_2f8,_2f9,on,_2fa,dnd,_2fb){var _2fc=_2f4("dojo.dnd.Selector",_2fb,{constructor:function(node,_2fd){if(!_2fd){_2fd={};}this.singular=_2fd.singular;this.autoSync=_2fd.autoSync;this.selection={};this.anchor=null;this.simpleSelection=false;this.events.push(on(this.node,_2fa.press,lang.hitch(this,"onMouseDown")),on(this.node,_2fa.release,lang.hitch(this,"onMouseUp")));},singular:false,getSelectedNodes:function(){var t=new _2f9();var e=dnd._empty;for(var i in this.selection){if(i in e){continue;}t.push(dom.byId(i));}return t;},selectNone:function(){return this._removeSelection()._removeAnchor();},selectAll:function(){this.forInItems(function(data,id){this._addItemClass(dom.byId(id),"Selected");this.selection[id]=1;},this);return this._removeAnchor();},deleteSelectedNodes:function(){var e=dnd._empty;for(var i in this.selection){if(i in e){continue;}var n=dom.byId(i);this.delItem(i);_2f7.destroy(n);}this.anchor=null;this.selection={};return this;},forInSelectedItems:function(f,o){o=o||_2f6.global;var s=this.selection,e=dnd._empty;for(var i in s){if(i in e){continue;}f.call(o,this.getItem(i),i,this);}},sync:function(){_2fc.superclass.sync.call(this);if(this.anchor){if(!this.getItem(this.anchor.id)){this.anchor=null;}}var t=[],e=dnd._empty;for(var i in this.selection){if(i in e){continue;}if(!this.getItem(i)){t.push(i);}}_2f3.forEach(t,function(i){delete this.selection[i];},this);return this;},insertNodes:function(_2fe,data,_2ff,_300){var _301=this._normalizedCreator;this._normalizedCreator=function(item,hint){var t=_301.call(this,item,hint);if(_2fe){if(!this.anchor){this.anchor=t.node;this._removeItemClass(t.node,"Selected");this._addItemClass(this.anchor,"Anchor");}else{if(this.anchor!=t.node){this._removeItemClass(t.node,"Anchor");this._addItemClass(t.node,"Selected");}}this.selection[t.node.id]=1;}else{this._removeItemClass(t.node,"Selected");this._removeItemClass(t.node,"Anchor");}return t;};_2fc.superclass.insertNodes.call(this,data,_2ff,_300);this._normalizedCreator=_301;return this;},destroy:function(){_2fc.superclass.destroy.call(this);this.selection=this.anchor=null;},onMouseDown:function(e){if(this.autoSync){this.sync();}if(!this.current){return;}if(!this.singular&&!dnd.getCopyKeyState(e)&&!e.shiftKey&&(this.current.id in this.selection)){this.simpleSelection=true;if(_2f8.isLeft(e)){_2f5.stop(e);}return;}if(!this.singular&&e.shiftKey){if(!dnd.getCopyKeyState(e)){this._removeSelection();}var c=this.getAllNodes();if(c.length){if(!this.anchor){this.anchor=c[0];this._addItemClass(this.anchor,"Anchor");}this.selection[this.anchor.id]=1;if(this.anchor!=this.current){var i=0,node;for(;i<c.length;++i){node=c[i];if(node==this.anchor||node==this.current){break;}}for(++i;i<c.length;++i){node=c[i];if(node==this.anchor||node==this.current){break;}this._addItemClass(node,"Selected");this.selection[node.id]=1;}this._addItemClass(this.current,"Selected");this.selection[this.current.id]=1;}}}else{if(this.singular){if(this.anchor==this.current){if(dnd.getCopyKeyState(e)){this.selectNone();}}else{this.selectNone();this.anchor=this.current;this._addItemClass(this.anchor,"Anchor");this.selection[this.current.id]=1;}}else{if(dnd.getCopyKeyState(e)){if(this.anchor==this.current){delete this.selection[this.anchor.id];this._removeAnchor();}else{if(this.current.id in this.selection){this._removeItemClass(this.current,"Selected");delete this.selection[this.current.id];}else{if(this.anchor){this._removeItemClass(this.anchor,"Anchor");this._addItemClass(this.anchor,"Selected");}this.anchor=this.current;this._addItemClass(this.current,"Anchor");this.selection[this.current.id]=1;}}}else{if(!(this.current.id in this.selection)){this.selectNone();this.anchor=this.current;this._addItemClass(this.current,"Anchor");this.selection[this.current.id]=1;}}}}_2f5.stop(e);},onMouseUp:function(){if(!this.simpleSelection){return;}this.simpleSelection=false;this.selectNone();if(this.current){this.anchor=this.current;this._addItemClass(this.anchor,"Anchor");this.selection[this.current.id]=1;}},onMouseMove:function(){this.simpleSelection=false;},onOverEvent:function(){this.onmousemoveEvent=on(this.node,_2fa.move,lang.hitch(this,"onMouseMove"));},onOutEvent:function(){if(this.onmousemoveEvent){this.onmousemoveEvent.remove();delete this.onmousemoveEvent;}},_removeSelection:function(){var e=dnd._empty;for(var i in this.selection){if(i in e){continue;}var node=dom.byId(i);if(node){this._removeItemClass(node,"Selected");}}this.selection={};return this;},_removeAnchor:function(){if(this.anchor){this._removeItemClass(this.anchor,"Anchor");this.anchor=null;}return this;}});return _2fc;});},"dojo/touch":function(){define(["./_base/kernel","./aspect","./dom","./on","./has","./mouse","./domReady","./_base/window"],function(dojo,_302,dom,on,has,_303,_304,win){var _305=has("touch");var ios4=false;if(has("ios")){var ua=navigator.userAgent;var v=ua.match(/OS ([\d_]+)/)?RegExp.$1:"1";var os=parseFloat(v.replace(/_/,".").replace(/_/g,""));ios4=os<5;}var _306;function _307(_308,_309){if(_305){return function(node,_30a){var _30b=on(node,_309,_30a),_30c=on(node,_308,function(evt){if(!_306||(new Date()).getTime()>_306+1000){_30a.call(this,evt);}});return {remove:function(){_30b.remove();_30c.remove();}};};}else{return function(node,_30d){return on(node,_308,_30d);};}};var _30e,_30f;if(_305){_304(function(){_30f=win.body();win.doc.addEventListener("touchstart",function(evt){_306=(new Date()).getTime();var _310=_30f;_30f=evt.target;on.emit(_310,"dojotouchout",{target:_310,relatedTarget:_30f,bubbles:true});on.emit(_30f,"dojotouchover",{target:_30f,relatedTarget:_310,bubbles:true});},true);on(win.doc,"touchmove",function(evt){_306=(new Date()).getTime();var _311=win.doc.elementFromPoint(evt.pageX-(ios4?0:win.global.pageXOffset),evt.pageY-(ios4?0:win.global.pageYOffset));if(_311&&_30f!==_311){on.emit(_30f,"dojotouchout",{target:_30f,relatedTarget:_311,bubbles:true});on.emit(_311,"dojotouchover",{target:_311,relatedTarget:_30f,bubbles:true});_30f=_311;}});});_30e=function(node,_312){return on(win.doc,"touchmove",function(evt){if(node===win.doc||dom.isDescendant(_30f,node)){evt.target=_30f;_312.call(this,evt);}});};}var _313={press:_307("mousedown","touchstart"),move:_307("mousemove",_30e),release:_307("mouseup","touchend"),cancel:_307(_303.leave,"touchcancel"),over:_307("mouseover","dojotouchover"),out:_307("mouseout","dojotouchout"),enter:_303._eventHandler(_307("mouseover","dojotouchover")),leave:_303._eventHandler(_307("mouseout","dojotouchout"))};1&&(dojo.touch=_313);return _313;});},"dojo/dnd/Container":function(){define(["../_base/array","../_base/declare","../_base/event","../_base/kernel","../_base/lang","../_base/window","../dom","../dom-class","../dom-construct","../Evented","../has","../on","../query","../ready","../touch","./common"],function(_314,_315,_316,_317,lang,win,dom,_318,_319,_31a,has,on,_31b,_31c,_31d,dnd){var _31e=_315("dojo.dnd.Container",_31a,{skipForm:false,allowNested:false,constructor:function(node,_31f){this.node=dom.byId(node);if(!_31f){_31f={};}this.creator=_31f.creator||null;this.skipForm=_31f.skipForm;this.parent=_31f.dropParent&&dom.byId(_31f.dropParent);this.map={};this.current=null;this.containerState="";_318.add(this.node,"dojoDndContainer");if(!(_31f&&_31f._skipStartup)){this.startup();}this.events=[on(this.node,_31d.over,lang.hitch(this,"onMouseOver")),on(this.node,_31d.out,lang.hitch(this,"onMouseOut")),on(this.node,"dragstart",lang.hitch(this,"onSelectStart")),on(this.node,"selectstart",lang.hitch(this,"onSelectStart"))];},creator:function(){},getItem:function(key){return this.map[key];},setItem:function(key,data){this.map[key]=data;},delItem:function(key){delete this.map[key];},forInItems:function(f,o){o=o||_317.global;var m=this.map,e=dnd._empty;for(var i in m){if(i in e){continue;}f.call(o,m[i],i,this);}return o;},clearItems:function(){this.map={};},getAllNodes:function(){return _31b((this.allowNested?"":"> ")+".dojoDndItem",this.parent);},sync:function(){var map={};this.getAllNodes().forEach(function(node){if(node.id){var item=this.getItem(node.id);if(item){map[node.id]=item;return;}}else{node.id=dnd.getUniqueId();}var type=node.getAttribute("dndType"),data=node.getAttribute("dndData");map[node.id]={data:data||node.innerHTML,type:type?type.split(/\s*,\s*/):["text"]};},this);this.map=map;return this;},insertNodes:function(data,_320,_321){if(!this.parent.firstChild){_321=null;}else{if(_320){if(!_321){_321=this.parent.firstChild;}}else{if(_321){_321=_321.nextSibling;}}}var i,t;if(_321){for(i=0;i<data.length;++i){t=this._normalizedCreator(data[i]);this.setItem(t.node.id,{data:t.data,type:t.type});_321.parentNode.insertBefore(t.node,_321);}}else{for(i=0;i<data.length;++i){t=this._normalizedCreator(data[i]);this.setItem(t.node.id,{data:t.data,type:t.type});this.parent.appendChild(t.node);}}return this;},destroy:function(){_314.forEach(this.events,function(_322){_322.remove();});this.clearItems();this.node=this.parent=this.current=null;},markupFactory:function(_323,node,Ctor){_323._skipStartup=true;return new Ctor(node,_323);},startup:function(){if(!this.parent){this.parent=this.node;if(this.parent.tagName.toLowerCase()=="table"){var c=this.parent.getElementsByTagName("tbody");if(c&&c.length){this.parent=c[0];}}}this.defaultCreator=dnd._defaultCreator(this.parent);this.sync();},onMouseOver:function(e){var n=e.relatedTarget;while(n){if(n==this.node){break;}try{n=n.parentNode;}catch(x){n=null;}}if(!n){this._changeState("Container","Over");this.onOverEvent();}n=this._getChildByEvent(e);if(this.current==n){return;}if(this.current){this._removeItemClass(this.current,"Over");}if(n){this._addItemClass(n,"Over");}this.current=n;},onMouseOut:function(e){for(var n=e.relatedTarget;n;){if(n==this.node){return;}try{n=n.parentNode;}catch(x){n=null;}}if(this.current){this._removeItemClass(this.current,"Over");this.current=null;}this._changeState("Container","");this.onOutEvent();},onSelectStart:function(e){if(!this.skipForm||!dnd.isFormElement(e)){_316.stop(e);}},onOverEvent:function(){},onOutEvent:function(){},_changeState:function(type,_324){var _325="dojoDnd"+type;var _326=type.toLowerCase()+"State";_318.replace(this.node,_325+_324,_325+this[_326]);this[_326]=_324;},_addItemClass:function(node,type){_318.add(node,"dojoDndItem"+type);},_removeItemClass:function(node,type){_318.remove(node,"dojoDndItem"+type);},_getChildByEvent:function(e){var node=e.target;if(node){for(var _327=node.parentNode;_327;node=_327,_327=node.parentNode){if((_327==this.parent||this.allowNested)&&_318.contains(node,"dojoDndItem")){return node;}}}return null;},_normalizedCreator:function(item,hint){var t=(this.creator||this.defaultCreator).call(this,item,hint);if(!lang.isArray(t.type)){t.type=["text"];}if(!t.node.id){t.node.id=dnd.getUniqueId();}_318.add(t.node,"dojoDndItem");return t;}});dnd._createNode=function(tag){if(!tag){return dnd._createSpan;}return function(text){return _319.create(tag,{innerHTML:text});};};dnd._createTrTd=function(text){var tr=_319.create("tr");_319.create("td",{innerHTML:text},tr);return tr;};dnd._createSpan=function(text){return _319.create("span",{innerHTML:text});};dnd._defaultCreatorNodes={ul:"li",ol:"li",div:"div",p:"div"};dnd._defaultCreator=function(node){var tag=node.tagName.toLowerCase();var c=tag=="tbody"||tag=="thead"?dnd._createTrTd:dnd._createNode(dnd._defaultCreatorNodes[tag]);return function(item,hint){var _328=item&&lang.isObject(item),data,type,n;if(_328&&item.tagName&&item.nodeType&&item.getAttribute){data=item.getAttribute("dndData")||item.innerHTML;type=item.getAttribute("dndType");type=type?type.split(/\s*,\s*/):["text"];n=item;}else{data=(_328&&item.data)?item.data:item;type=(_328&&item.type)?item.type:["text"];n=(hint=="avatar"?dnd._createSpan:c)(String(data));}if(!n.id){n.id=dnd.getUniqueId();}return {node:n,data:data,type:type};};};return _31e;});},"dojo/dnd/Manager":function(){define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../_base/window","../dom-class","../Evented","../has","../keys","../on","../topic","../touch","./common","./autoscroll","./Avatar"],function(_329,_32a,_32b,lang,win,_32c,_32d,has,keys,on,_32e,_32f,dnd,_330,_331){var _332=_32a("dojo.dnd.Manager",[_32d],{constructor:function(){this.avatar=null;this.source=null;this.nodes=[];this.copy=true;this.target=null;this.canDropFlag=false;this.events=[];},OFFSET_X:has("touch")?4:16,OFFSET_Y:has("touch")?4:16,overSource:function(_333){if(this.avatar){this.target=(_333&&_333.targetState!="Disabled")?_333:null;this.canDropFlag=Boolean(this.target);this.avatar.update();}_32e.publish("/dnd/source/over",_333);},outSource:function(_334){if(this.avatar){if(this.target==_334){this.target=null;this.canDropFlag=false;this.avatar.update();_32e.publish("/dnd/source/over",null);}}else{_32e.publish("/dnd/source/over",null);}},startDrag:function(_335,_336,copy){_330.autoScrollStart(win.doc);this.source=_335;this.nodes=_336;this.copy=Boolean(copy);this.avatar=this.makeAvatar();win.body().appendChild(this.avatar.node);_32e.publish("/dnd/start",_335,_336,this.copy);this.events=[on(win.doc,_32f.move,lang.hitch(this,"onMouseMove")),on(win.doc,_32f.release,lang.hitch(this,"onMouseUp")),on(win.doc,"keydown",lang.hitch(this,"onKeyDown")),on(win.doc,"keyup",lang.hitch(this,"onKeyUp")),on(win.doc,"dragstart",_32b.stop),on(win.body(),"selectstart",_32b.stop)];var c="dojoDnd"+(copy?"Copy":"Move");_32c.add(win.body(),c);},canDrop:function(flag){var _337=Boolean(this.target&&flag);if(this.canDropFlag!=_337){this.canDropFlag=_337;this.avatar.update();}},stopDrag:function(){_32c.remove(win.body(),["dojoDndCopy","dojoDndMove"]);_329.forEach(this.events,function(_338){_338.remove();});this.events=[];this.avatar.destroy();this.avatar=null;this.source=this.target=null;this.nodes=[];},makeAvatar:function(){return new _331(this);},updateAvatar:function(){this.avatar.update();},onMouseMove:function(e){var a=this.avatar;if(a){_330.autoScrollNodes(e);var s=a.node.style;s.left=(e.pageX+this.OFFSET_X)+"px";s.top=(e.pageY+this.OFFSET_Y)+"px";var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));if(this.copy!=copy){this._setCopyStatus(copy);}}if(has("touch")){e.preventDefault();}},onMouseUp:function(e){if(this.avatar){if(this.target&&this.canDropFlag){var copy=Boolean(this.source.copyState(dnd.getCopyKeyState(e)));_32e.publish("/dnd/drop/before",this.source,this.nodes,copy,this.target,e);_32e.publish("/dnd/drop",this.source,this.nodes,copy,this.target,e);}else{_32e.publish("/dnd/cancel");}this.stopDrag();}},onKeyDown:function(e){if(this.avatar){switch(e.keyCode){case keys.CTRL:var copy=Boolean(this.source.copyState(true));if(this.copy!=copy){this._setCopyStatus(copy);}break;case keys.ESCAPE:_32e.publish("/dnd/cancel");this.stopDrag();break;}}},onKeyUp:function(e){if(this.avatar&&e.keyCode==keys.CTRL){var copy=Boolean(this.source.copyState(false));if(this.copy!=copy){this._setCopyStatus(copy);}}},_setCopyStatus:function(copy){this.copy=copy;this.source._markDndStatus(this.copy);this.updateAvatar();_32c.replace(win.body(),"dojoDnd"+(this.copy?"Copy":"Move"),"dojoDnd"+(this.copy?"Move":"Copy"));}});dnd._manager=null;_332.manager=dnd.manager=function(){if(!dnd._manager){dnd._manager=new _332();}return dnd._manager;};return _332;});},"dojo/dnd/autoscroll":function(){define(["../_base/lang","../sniff","../_base/window","../dom-geometry","../dom-style","../window"],function(lang,has,win,_339,_33a,_33b){var _33c={};lang.setObject("dojo.dnd.autoscroll",_33c);_33c.getViewport=_33b.getBox;_33c.V_TRIGGER_AUTOSCROLL=32;_33c.H_TRIGGER_AUTOSCROLL=32;_33c.V_AUTOSCROLL_VALUE=16;_33c.H_AUTOSCROLL_VALUE=16;var _33d,doc=win.doc,_33e=Infinity,_33f=Infinity;_33c.autoScrollStart=function(d){doc=d;_33d=_33b.getBox(doc);var html=win.body(doc).parentNode;_33e=Math.max(html.scrollHeight-_33d.h,0);_33f=Math.max(html.scrollWidth-_33d.w,0);};_33c.autoScroll=function(e){var v=_33d||_33b.getBox(doc),html=win.body(doc).parentNode,dx=0,dy=0;if(e.clientX<_33c.H_TRIGGER_AUTOSCROLL){dx=-_33c.H_AUTOSCROLL_VALUE;}else{if(e.clientX>v.w-_33c.H_TRIGGER_AUTOSCROLL){dx=Math.min(_33c.H_AUTOSCROLL_VALUE,_33f-html.scrollLeft);}}if(e.clientY<_33c.V_TRIGGER_AUTOSCROLL){dy=-_33c.V_AUTOSCROLL_VALUE;}else{if(e.clientY>v.h-_33c.V_TRIGGER_AUTOSCROLL){dy=Math.min(_33c.V_AUTOSCROLL_VALUE,_33e-html.scrollTop);}}window.scrollBy(dx,dy);};_33c._validNodes={"div":1,"p":1,"td":1};_33c._validOverflow={"auto":1,"scroll":1};_33c.autoScrollNodes=function(e){var b,t,w,h,rx,ry,dx=0,dy=0,_340,_341;for(var n=e.target;n;){if(n.nodeType==1&&(n.tagName.toLowerCase() in _33c._validNodes)){var s=_33a.getComputedStyle(n),_342=(s.overflowX.toLowerCase() in _33c._validOverflow),_343=(s.overflowY.toLowerCase() in _33c._validOverflow);if(_342||_343){b=_339.getContentBox(n,s);t=_339.position(n,true);}if(_342){w=Math.min(_33c.H_TRIGGER_AUTOSCROLL,b.w/2);rx=e.pageX-t.x;if(has("webkit")||has("opera")){rx+=win.body().scrollLeft;}dx=0;if(rx>0&&rx<b.w){if(rx<w){dx=-w;}else{if(rx>b.w-w){dx=w;}}_340=n.scrollLeft;n.scrollLeft=n.scrollLeft+dx;}}if(_343){h=Math.min(_33c.V_TRIGGER_AUTOSCROLL,b.h/2);ry=e.pageY-t.y;if(has("webkit")||has("opera")){ry+=win.body().scrollTop;}dy=0;if(ry>0&&ry<b.h){if(ry<h){dy=-h;}else{if(ry>b.h-h){dy=h;}}_341=n.scrollTop;n.scrollTop=n.scrollTop+dy;}}if(dx||dy){return;}}try{n=n.parentNode;}catch(x){n=null;}}_33c.autoScroll(e);};return _33c;});},"dojo/dnd/Avatar":function(){define(["../_base/declare","../_base/window","../dom","../dom-attr","../dom-class","../dom-construct","../hccss","../query"],function(_344,win,dom,_345,_346,_347,has,_348){return _344("dojo.dnd.Avatar",null,{constructor:function(_349){this.manager=_349;this.construct();},construct:function(){var a=_347.create("table",{"class":"dojoDndAvatar",style:{position:"absolute",zIndex:"1999",margin:"0px"}}),_34a=this.manager.source,node,b=_347.create("tbody",null,a),tr=_347.create("tr",null,b),td=_347.create("td",null,tr),k=Math.min(5,this.manager.nodes.length),i=0;if(has("highcontrast")){_347.create("span",{id:"a11yIcon",innerHTML:this.manager.copy?"+":"<"},td);}_347.create("span",{innerHTML:_34a.generateText?this._generateText():""},td);_345.set(tr,{"class":"dojoDndAvatarHeader",style:{opacity:0.9}});for(;i<k;++i){if(_34a.creator){node=_34a._normalizedCreator(_34a.getItem(this.manager.nodes[i].id).data,"avatar").node;}else{node=this.manager.nodes[i].cloneNode(true);if(node.tagName.toLowerCase()=="tr"){var _34b=_347.create("table"),_34c=_347.create("tbody",null,_34b);_34c.appendChild(node);node=_34b;}}node.id="";tr=_347.create("tr",null,b);td=_347.create("td",null,tr);td.appendChild(node);_345.set(tr,{"class":"dojoDndAvatarItem",style:{opacity:(9-i)/10}});}this.node=a;},destroy:function(){_347.destroy(this.node);this.node=false;},update:function(){_346.toggle(this.node,"dojoDndAvatarCanDrop",this.manager.canDropFlag);if(has("highcontrast")){var icon=dom.byId("a11yIcon");var text="+";if(this.manager.canDropFlag&&!this.manager.copy){text="< ";}else{if(!this.manager.canDropFlag&&!this.manager.copy){text="o";}else{if(!this.manager.canDropFlag){text="x";}}}icon.innerHTML=text;}_348(("tr.dojoDndAvatarHeader td span"+(has("highcontrast")?" span":"")),this.node).forEach(function(node){node.innerHTML=this.manager.source.generateText?this._generateText():"";},this);},_generateText:function(){return this.manager.nodes.length.toString();}});});},"dijit/_TemplatedMixin":function(){define("dijit/_TemplatedMixin",["dojo/_base/lang","dojo/touch","./_WidgetBase","dojo/string","dojo/cache","dojo/_base/array","dojo/_base/declare","dojo/dom-construct","dojo/sniff","dojo/_base/unload"],function(lang,_34d,_34e,_34f,_350,_351,_352,_353,has,_354){var _355=_352("dijit._TemplatedMixin",null,{templateString:null,templatePath:null,_skipNodeCache:false,_earlyTemplatedStartup:false,constructor:function(){this._attachPoints=[];this._attachEvents=[];},_stringRepl:function(tmpl){var _356=this.declaredClass,_357=this;return _34f.substitute(tmpl,this,function(_358,key){if(key.charAt(0)=="!"){_358=lang.getObject(key.substr(1),false,_357);}if(typeof _358=="undefined"){throw new Error(_356+" template:"+key);}if(_358==null){return "";}return key.charAt(0)=="!"?_358:_358.toString().replace(/"/g,"&quot;");},this);},buildRendering:function(){if(!this.templateString){this.templateString=_350(this.templatePath,{sanitize:true});}var _359=_355.getCachedTemplate(this.templateString,this._skipNodeCache,this.ownerDocument);var node;if(lang.isString(_359)){node=_353.toDom(this._stringRepl(_359),this.ownerDocument);if(node.nodeType!=1){throw new Error("Invalid template: "+_359);}}else{node=_359.cloneNode(true);}this.domNode=node;this.inherited(arguments);this._attachTemplateNodes(node,function(n,p){return n.getAttribute(p);});this._beforeFillContent();this._fillContent(this.srcNodeRef);},_beforeFillContent:function(){},_fillContent:function(_35a){var dest=this.containerNode;if(_35a&&dest){while(_35a.hasChildNodes()){dest.appendChild(_35a.firstChild);}}},_attachTemplateNodes:function(_35b,_35c){var _35d=lang.isArray(_35b)?_35b:(_35b.all||_35b.getElementsByTagName("*"));var x=lang.isArray(_35b)?0:-1;for(;x<0||_35d[x];x++){var _35e=(x==-1)?_35b:_35d[x];if(this.widgetsInTemplate&&(_35c(_35e,"dojoType")||_35c(_35e,"data-dojo-type"))){continue;}var _35f=_35c(_35e,"dojoAttachPoint")||_35c(_35e,"data-dojo-attach-point");if(_35f){var _360,_361=_35f.split(/\s*,\s*/);while((_360=_361.shift())){if(lang.isArray(this[_360])){this[_360].push(_35e);}else{this[_360]=_35e;}this._attachPoints.push(_360);}}var _362=_35c(_35e,"dojoAttachEvent")||_35c(_35e,"data-dojo-attach-event");if(_362){var _363,_364=_362.split(/\s*,\s*/);var trim=lang.trim;while((_363=_364.shift())){if(_363){var _365=null;if(_363.indexOf(":")!=-1){var _366=_363.split(":");_363=trim(_366[0]);_365=trim(_366[1]);}else{_363=trim(_363);}if(!_365){_365=_363;}this._attachEvents.push(this.connect(_35e,_34d[_363]||_363,_365));}}}}},destroyRendering:function(){_351.forEach(this._attachPoints,function(_367){delete this[_367];},this);this._attachPoints=[];_351.forEach(this._attachEvents,this.disconnect,this);this._attachEvents=[];this.inherited(arguments);}});_355._templateCache={};_355.getCachedTemplate=function(_368,_369,doc){var _36a=_355._templateCache;var key=_368;var _36b=_36a[key];if(_36b){try{if(!_36b.ownerDocument||_36b.ownerDocument==(doc||document)){return _36b;}}catch(e){}_353.destroy(_36b);}_368=_34f.trim(_368);if(_369||_368.match(/\$\{([^\}]+)\}/g)){return (_36a[key]=_368);}else{var node=_353.toDom(_368,doc);if(node.nodeType!=1){throw new Error("Invalid template: "+_368);}return (_36a[key]=node);}};if(has("ie")){_354.addOnWindowUnload(function(){var _36c=_355._templateCache;for(var key in _36c){var _36d=_36c[key];if(typeof _36d=="object"){_353.destroy(_36d);}delete _36c[key];}});}lang.extend(_34e,{dojoAttachEvent:"",dojoAttachPoint:""});return _355;});},"dojo/string":function(){define(["./_base/kernel","./_base/lang"],function(_36e,lang){var _36f={};lang.setObject("dojo.string",_36f);_36f.rep=function(str,num){if(num<=0||!str){return "";}var buf=[];for(;;){if(num&1){buf.push(str);}if(!(num>>=1)){break;}str+=str;}return buf.join("");};_36f.pad=function(text,size,ch,end){if(!ch){ch="0";}var out=String(text),pad=_36f.rep(ch,Math.ceil((size-out.length)/ch.length));return end?out+pad:pad+out;};_36f.substitute=function(_370,map,_371,_372){_372=_372||_36e.global;_371=_371?lang.hitch(_372,_371):function(v){return v;};return _370.replace(/\$\{([^\s\:\}]+)(?:\:([^\s\:\}]+))?\}/g,function(_373,key,_374){var _375=lang.getObject(key,false,map);if(_374){_375=lang.getObject(_374,false,_372).call(_372,_375,key);}return _371(_375,key).toString();});};_36f.trim=String.prototype.trim?lang.trim:function(str){str=str.replace(/^\s+/,"");for(var i=str.length-1;i>=0;i--){if(/\S/.test(str.charAt(i))){str=str.substring(0,i+1);break;}}return str;};return _36f;});},"dojo/cache":function(){define(["./_base/kernel","./text"],function(dojo){return dojo.cache;});},"dojox/html/metrics":function(){define(["dojo/_base/kernel","dojo/_base/lang","dojo/_base/sniff","dojo/ready","dojo/_base/unload","dojo/_base/window","dojo/dom-geometry"],function(_376,lang,has,_377,_378,_379,_37a){var dhm=lang.getObject("dojox.html.metrics",true);var _37b=lang.getObject("dojox");dhm.getFontMeasurements=function(){var _37c={"1em":0,"1ex":0,"100%":0,"12pt":0,"16px":0,"xx-small":0,"x-small":0,"small":0,"medium":0,"large":0,"x-large":0,"xx-large":0};var _37d;if(has("ie")){_37d=_379.doc.documentElement.style.fontSize||"";if(!_37d){_379.doc.documentElement.style.fontSize="100%";}}var div=_379.doc.createElement("div");var ds=div.style;ds.position="absolute";ds.left="-100px";ds.top="0";ds.width="30px";ds.height="1000em";ds.borderWidth="0";ds.margin="0";ds.padding="0";ds.outline="0";ds.lineHeight="1";ds.overflow="hidden";_379.body().appendChild(div);for(var p in _37c){ds.fontSize=p;_37c[p]=Math.round(div.offsetHeight*12/16)*16/12/1000;}if(has("ie")){_379.doc.documentElement.style.fontSize=_37d;}_379.body().removeChild(div);div=null;return _37c;};var _37e=null;dhm.getCachedFontMeasurements=function(_37f){if(_37f||!_37e){_37e=dhm.getFontMeasurements();}return _37e;};var _380=null,_381={};dhm.getTextBox=function(text,_382,_383){var m,s;if(!_380){m=_380=_379.doc.createElement("div");var c=_379.doc.createElement("div");c.appendChild(m);s=c.style;s.overflow="scroll";s.position="absolute";s.left="0px";s.top="-10000px";s.width="1px";s.height="1px";s.visibility="hidden";s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";_379.body().appendChild(c);}else{m=_380;}m.className="";s=m.style;s.borderWidth="0";s.margin="0";s.padding="0";s.outline="0";if(arguments.length>1&&_382){for(var i in _382){if(i in _381){continue;}s[i]=_382[i];}}if(arguments.length>2&&_383){m.className=_383;}m.innerHTML=text;var box=_37a.position(m);box.w=m.parentNode.scrollWidth;return box;};var _384={w:16,h:16};dhm.getScrollbar=function(){return {w:_384.w,h:_384.h};};dhm._fontResizeNode=null;dhm.initOnFontResize=function(_385){var f=dhm._fontResizeNode=_379.doc.createElement("iframe");var fs=f.style;fs.position="absolute";fs.width="5em";fs.height="10em";fs.top="-10000px";fs.display="none";if(has("ie")){f.onreadystatechange=function(){if(f.contentWindow.document.readyState=="complete"){f.onresize=f.contentWindow.parent[_37b._scopeName].html.metrics._fontresize;}};}else{f.onload=function(){f.contentWindow.onresize=f.contentWindow.parent[_37b._scopeName].html.metrics._fontresize;};}f.setAttribute("src","javascript:'<html><head><script>if(\"loadFirebugConsole\" in window){window.loadFirebugConsole();}</script></head><body></body></html>'");_379.body().appendChild(f);dhm.initOnFontResize=function(){};};dhm.onFontResize=function(){};dhm._fontresize=function(){dhm.onFontResize();};_378.addOnUnload(function(){var f=dhm._fontResizeNode;if(f){if(has("ie")&&f.onresize){f.onresize=null;}else{if(f.contentWindow&&f.contentWindow.onresize){f.contentWindow.onresize=null;}}dhm._fontResizeNode=null;}});_377(function(){try{var n=_379.doc.createElement("div");n.style.cssText="top:0;left:0;width:100px;height:100px;overflow:scroll;position:absolute;visibility:hidden;";_379.body().appendChild(n);_384.w=n.offsetWidth-n.clientWidth;_384.h=n.offsetHeight-n.clientHeight;_379.body().removeChild(n);delete n;}catch(e){}if("fontSizeWatch" in _376.config&&!!_376.config.fontSizeWatch){dhm.initOnFontResize();}});return dhm;});},"dojox/grid/_Builder":function(){define(["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/window","dojo/_base/event","dojo/_base/sniff","dojo/_base/connect","dojo/dnd/Moveable","dojox/html/metrics","./util","dojo/_base/html","dojo/dom-geometry"],function(_386,_387,lang,win,_388,has,_389,_38a,_38b,util,html,_38c){var dg=_386.grid;var _38d=function(td){return td.cellIndex>=0?td.cellIndex:_387.indexOf(td.parentNode.cells,td);};var _38e=function(tr){return tr.rowIndex>=0?tr.rowIndex:_387.indexOf(tr.parentNode.childNodes,tr);};var _38f=function(_390,_391){return _390&&((_390.rows||0)[_391]||_390.childNodes[_391]);};var _392=function(node){for(var n=node;n&&n.tagName!="TABLE";n=n.parentNode){}return n;};var _393=function(_394,_395){for(var n=_394;n&&_395(n);n=n.parentNode){}return n;};var _396=function(_397){var name=_397.toUpperCase();return function(node){return node.tagName!=name;};};var _398=util.rowIndexTag;var _399=util.gridViewTag;var _39a=dg._Builder=lang.extend(function(view){if(view){this.view=view;this.grid=view.grid;}},{view:null,_table:"<table class=\"dojoxGridRowTable\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\" role=\"presentation\"",getTableArray:function(){var html=[this._table];if(this.view.viewWidth){html.push([" style=\"width:",this.view.viewWidth,";\""].join(""));}html.push(">");return html;},generateCellMarkup:function(_39b,_39c,_39d,_39e){var _39f=[],html;if(_39e){var _3a0=_39b.index!=_39b.grid.getSortIndex()?"":_39b.grid.sortInfo>0?"aria-sort=\"ascending\"":"aria-sort=\"descending\"";if(!_39b.id){_39b.id=this.grid.id+"Hdr"+_39b.index;}html=["<th tabIndex=\"-1\" aria-readonly=\"true\" role=\"columnheader\"",_3a0,"id=\"",_39b.id,"\""];}else{var _3a1=this.grid.editable&&!_39b.editable?"aria-readonly=\"true\"":"";html=["<td tabIndex=\"-1\" role=\"gridcell\"",_3a1];}if(_39b.colSpan){html.push(" colspan=\"",_39b.colSpan,"\"");}if(_39b.rowSpan){html.push(" rowspan=\"",_39b.rowSpan,"\"");}html.push(" class=\"dojoxGridCell ");if(_39b.classes){html.push(_39b.classes," ");}if(_39d){html.push(_39d," ");}_39f.push(html.join(""));_39f.push("");html=["\" idx=\"",_39b.index,"\" style=\""];if(_39c&&_39c[_39c.length-1]!=";"){_39c+=";";}html.push(_39b.styles,_39c||"",_39b.hidden?"display:none;":"");if(_39b.unitWidth){html.push("width:",_39b.unitWidth,";");}_39f.push(html.join(""));_39f.push("");html=["\""];if(_39b.attrs){html.push(" ",_39b.attrs);}html.push(">");_39f.push(html.join(""));_39f.push("");_39f.push(_39e?"</th>":"</td>");return _39f;},isCellNode:function(_3a2){return Boolean(_3a2&&_3a2!=win.doc&&html.attr(_3a2,"idx"));},getCellNodeIndex:function(_3a3){return _3a3?Number(html.attr(_3a3,"idx")):-1;},getCellNode:function(_3a4,_3a5){for(var i=0,row;((row=_38f(_3a4.firstChild,i))&&row.cells);i++){for(var j=0,cell;(cell=row.cells[j]);j++){if(this.getCellNodeIndex(cell)==_3a5){return cell;}}}return null;},findCellTarget:function(_3a6,_3a7){var n=_3a6;while(n&&(!this.isCellNode(n)||(n.offsetParent&&_399 in n.offsetParent.parentNode&&n.offsetParent.parentNode[_399]!=this.view.id))&&(n!=_3a7)){n=n.parentNode;}return n!=_3a7?n:null;},baseDecorateEvent:function(e){e.dispatch="do"+e.type;e.grid=this.grid;e.sourceView=this.view;e.cellNode=this.findCellTarget(e.target,e.rowNode);e.cellIndex=this.getCellNodeIndex(e.cellNode);e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);},findTarget:function(_3a8,_3a9){var n=_3a8;while(n&&(n!=this.domNode)&&(!(_3a9 in n)||(_399 in n&&n[_399]!=this.view.id))){n=n.parentNode;}return (n!=this.domNode)?n:null;},findRowTarget:function(_3aa){return this.findTarget(_3aa,_398);},isIntraNodeEvent:function(e){try{return (e.cellNode&&e.relatedTarget&&html.isDescendant(e.relatedTarget,e.cellNode));}catch(x){return false;}},isIntraRowEvent:function(e){try{var row=e.relatedTarget&&this.findRowTarget(e.relatedTarget);return !row&&(e.rowIndex==-1)||row&&(e.rowIndex==row.gridRowIndex);}catch(x){return false;}},dispatchEvent:function(e){if(e.dispatch in this){return this[e.dispatch](e);}return false;},domouseover:function(e){if(e.cellNode&&(e.cellNode!=this.lastOverCellNode)){this.lastOverCellNode=e.cellNode;this.grid.onMouseOver(e);}this.grid.onMouseOverRow(e);},domouseout:function(e){if(e.cellNode&&(e.cellNode==this.lastOverCellNode)&&!this.isIntraNodeEvent(e,this.lastOverCellNode)){this.lastOverCellNode=null;this.grid.onMouseOut(e);if(!this.isIntraRowEvent(e)){this.grid.onMouseOutRow(e);}}},domousedown:function(e){if(e.cellNode){this.grid.onMouseDown(e);}this.grid.onMouseDownRow(e);}});var _3ab=dg._ContentBuilder=lang.extend(function(view){_39a.call(this,view);},_39a.prototype,{update:function(){this.prepareHtml();},prepareHtml:function(){var _3ac=this.grid.get,_3ad=this.view.structure.cells;for(var j=0,row;(row=_3ad[j]);j++){for(var i=0,cell;(cell=row[i]);i++){cell.get=cell.get||(cell.value==undefined)&&_3ac;cell.markup=this.generateCellMarkup(cell,cell.cellStyles,cell.cellClasses,false);if(!this.grid.editable&&cell.editable){this.grid.editable=true;}}}},generateHtml:function(_3ae,_3af){var html=this.getTableArray(),v=this.view,_3b0=v.structure.cells,item=this.grid.getItem(_3af);util.fire(this.view,"onBeforeRow",[_3af,_3b0]);for(var j=0,row;(row=_3b0[j]);j++){if(row.hidden||row.header){continue;}html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");for(var i=0,cell,m,cc,cs;(cell=row[i]);i++){m=cell.markup;cc=cell.customClasses=[];cs=cell.customStyles=[];m[5]=cell.format(_3af,item);m[1]=cc.join(" ");m[3]=cs.join(";");html.push.apply(html,m);}html.push("</tr>");}html.push("</table>");return html.join("");},decorateEvent:function(e){e.rowNode=this.findRowTarget(e.target);if(!e.rowNode){return false;}e.rowIndex=e.rowNode[_398];this.baseDecorateEvent(e);e.cell=this.grid.getCell(e.cellIndex);return true;}});var _3b1=dg._HeaderBuilder=lang.extend(function(view){this.moveable=null;_39a.call(this,view);},_39a.prototype,{_skipBogusClicks:false,overResizeWidth:4,minColWidth:1,update:function(){if(this.tableMap){this.tableMap.mapRows(this.view.structure.cells);}else{this.tableMap=new dg._TableMap(this.view.structure.cells);}},generateHtml:function(_3b2,_3b3){var html=this.getTableArray(),_3b4=this.view.structure.cells;util.fire(this.view,"onBeforeRow",[-1,_3b4]);for(var j=0,row;(row=_3b4[j]);j++){if(row.hidden){continue;}html.push(!row.invisible?"<tr>":"<tr class=\"dojoxGridInvisible\">");for(var i=0,cell,_3b5;(cell=row[i]);i++){cell.customClasses=[];cell.customStyles=[];if(this.view.simpleStructure){if(cell.draggable){if(cell.headerClasses){if(cell.headerClasses.indexOf("dojoDndItem")==-1){cell.headerClasses+=" dojoDndItem";}}else{cell.headerClasses="dojoDndItem";}}if(cell.attrs){if(cell.attrs.indexOf("dndType='gridColumn_")==-1){cell.attrs+=" dndType='gridColumn_"+this.grid.id+"'";}}else{cell.attrs="dndType='gridColumn_"+this.grid.id+"'";}}_3b5=this.generateCellMarkup(cell,cell.headerStyles,cell.headerClasses,true);_3b5[5]=(_3b3!=undefined?_3b3:_3b2(cell));_3b5[3]=cell.customStyles.join(";");_3b5[1]=cell.customClasses.join(" ");html.push(_3b5.join(""));}html.push("</tr>");}html.push("</table>");return html.join("");},getCellX:function(e){var n,x,pos;n=_393(e.target,_396("th"));if(n){pos=_38c.position(n);x=e.clientX-pos.x;}else{x=e.layerX;}return x;},decorateEvent:function(e){this.baseDecorateEvent(e);e.rowIndex=-1;e.cellX=this.getCellX(e);return true;},prepareResize:function(e,mod){do{var i=e.cellIndex;e.cellNode=(i?e.cellNode.parentNode.cells[i+mod]:null);e.cellIndex=(e.cellNode?this.getCellNodeIndex(e.cellNode):-1);}while(e.cellNode&&e.cellNode.style.display=="none");return Boolean(e.cellNode);},canResize:function(e){if(!e.cellNode||e.cellNode.colSpan>1){return false;}var cell=this.grid.getCell(e.cellIndex);return !cell.noresize&&cell.canResize();},overLeftResizeArea:function(e){if(html.hasClass(win.body(),"dojoDndMove")){return false;}if(has("ie")){var tN=e.target;if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){return false;}}if(this.grid.isLeftToRight()){return (e.cellIndex>0)&&(e.cellX>0&&e.cellX<this.overResizeWidth)&&this.prepareResize(e,-1);}var t=e.cellNode&&(e.cellX>0&&e.cellX<this.overResizeWidth);return t;},overRightResizeArea:function(e){if(html.hasClass(win.body(),"dojoDndMove")){return false;}if(has("ie")){var tN=e.target;if(html.hasClass(tN,"dojoxGridArrowButtonNode")||html.hasClass(tN,"dojoxGridArrowButtonChar")||html.hasClass(tN,"dojoxGridColCaption")){return false;}}if(this.grid.isLeftToRight()){return e.cellNode&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth);}return (e.cellIndex>0)&&(e.cellX>=e.cellNode.offsetWidth-this.overResizeWidth)&&this.prepareResize(e,-1);},domousemove:function(e){if(!this.moveable){var c=(this.overRightResizeArea(e)?"dojoxGridColResize":(this.overLeftResizeArea(e)?"dojoxGridColResize":""));if(c&&!this.canResize(e)){c="dojoxGridColNoResize";}html.toggleClass(e.sourceView.headerNode,"dojoxGridColNoResize",(c=="dojoxGridColNoResize"));html.toggleClass(e.sourceView.headerNode,"dojoxGridColResize",(c=="dojoxGridColResize"));if(c){_388.stop(e);}}},domousedown:function(e){if(!this.moveable){if((this.overRightResizeArea(e)||this.overLeftResizeArea(e))&&this.canResize(e)){this.beginColumnResize(e);}else{this.grid.onMouseDown(e);this.grid.onMouseOverRow(e);}}},doclick:function(e){if(this._skipBogusClicks){_388.stop(e);return true;}return false;},colResizeSetup:function(e,_3b6){var _3b7=html.contentBox(e.sourceView.headerNode);if(_3b6){this.lineDiv=document.createElement("div");var vw=html.position(e.sourceView.headerNode,true);var _3b8=html.contentBox(e.sourceView.domNode);var l=e.pageX;if(!this.grid.isLeftToRight()&&has("ie")<8){l-=_38b.getScrollbar().w;}html.style(this.lineDiv,{top:vw.y+"px",left:l+"px",height:(_3b8.h+_3b7.h)+"px"});html.addClass(this.lineDiv,"dojoxGridResizeColLine");this.lineDiv._origLeft=l;win.body().appendChild(this.lineDiv);}var _3b9=[],_3ba=this.tableMap.findOverlappingNodes(e.cellNode);for(var i=0,cell;(cell=_3ba[i]);i++){_3b9.push({node:cell,index:this.getCellNodeIndex(cell),width:cell.offsetWidth});}var view=e.sourceView;var adj=this.grid.isLeftToRight()?1:-1;var _3bb=e.grid.views.views;var _3bc=[];for(var j=view.idx+adj,_3bd;(_3bd=_3bb[j]);j=j+adj){_3bc.push({node:_3bd.headerNode,left:window.parseInt(_3bd.headerNode.style.left)});}var _3be=view.headerContentNode.firstChild;var drag={scrollLeft:e.sourceView.headerNode.scrollLeft,view:view,node:e.cellNode,index:e.cellIndex,w:html.contentBox(e.cellNode).w,vw:_3b7.w,table:_3be,tw:html.contentBox(_3be).w,spanners:_3b9,followers:_3bc};return drag;},beginColumnResize:function(e){this.moverDiv=document.createElement("div");html.style(this.moverDiv,{position:"absolute",left:0});win.body().appendChild(this.moverDiv);html.addClass(this.grid.domNode,"dojoxGridColumnResizing");var m=(this.moveable=new _38a(this.moverDiv));var drag=this.colResizeSetup(e,true);m.onMove=lang.hitch(this,"doResizeColumn",drag);_389.connect(m,"onMoveStop",lang.hitch(this,function(){this.endResizeColumn(drag);if(drag.node.releaseCapture){drag.node.releaseCapture();}this.moveable.destroy();delete this.moveable;this.moveable=null;html.removeClass(this.grid.domNode,"dojoxGridColumnResizing");}));if(e.cellNode.setCapture){e.cellNode.setCapture();}m.onMouseDown(e);},doResizeColumn:function(_3bf,_3c0,_3c1){var _3c2=_3c1.l;var data={deltaX:_3c2,w:_3bf.w+(this.grid.isLeftToRight()?_3c2:-_3c2),vw:_3bf.vw+_3c2,tw:_3bf.tw+_3c2};this.dragRecord={inDrag:_3bf,mover:_3c0,leftTop:_3c1};if(data.w>=this.minColWidth){if(!_3c0){this.doResizeNow(_3bf,data);}else{html.style(this.lineDiv,"left",(this.lineDiv._origLeft+data.deltaX)+"px");}}},endResizeColumn:function(_3c3){if(this.dragRecord){var _3c4=this.dragRecord.leftTop;var _3c5=this.grid.isLeftToRight()?_3c4.l:-_3c4.l;_3c5+=Math.max(_3c3.w+_3c5,this.minColWidth)-(_3c3.w+_3c5);if(has("webkit")&&_3c3.spanners.length){_3c5+=html._getPadBorderExtents(_3c3.spanners[0].node).w;}var data={deltaX:_3c5,w:_3c3.w+_3c5,vw:_3c3.vw+_3c5,tw:_3c3.tw+_3c5};this.doResizeNow(_3c3,data);delete this.dragRecord;}html.destroy(this.lineDiv);html.destroy(this.moverDiv);html.destroy(this.moverDiv);delete this.moverDiv;this._skipBogusClicks=true;_3c3.view.update();this._skipBogusClicks=false;this.grid.onResizeColumn(_3c3.index);},doResizeNow:function(_3c6,data){_3c6.view.convertColPctToFixed();if(_3c6.view.flexCells&&!_3c6.view.testFlexCells()){var t=_392(_3c6.node);if(t){(t.style.width="");}}var i,s,sw,f,fl;for(i=0;(s=_3c6.spanners[i]);i++){sw=s.width+data.deltaX;if(sw>0){s.node.style.width=sw+"px";_3c6.view.setColWidth(s.index,sw);}}if(this.grid.isLeftToRight()||!has("ie")){for(i=0;(f=_3c6.followers[i]);i++){fl=f.left+data.deltaX;f.node.style.left=fl+"px";}}_3c6.node.style.width=data.w+"px";_3c6.view.setColWidth(_3c6.index,data.w);_3c6.view.headerNode.style.width=data.vw+"px";_3c6.view.setColumnsWidth(data.tw);if(!this.grid.isLeftToRight()){_3c6.view.headerNode.scrollLeft=_3c6.scrollLeft+data.deltaX;}}});dg._TableMap=lang.extend(function(rows){this.mapRows(rows);},{map:null,mapRows:function(_3c7){var _3c8=_3c7.length;if(!_3c8){return;}this.map=[];var row;for(var k=0;(row=_3c7[k]);k++){this.map[k]=[];}for(var j=0;(row=_3c7[j]);j++){for(var i=0,x=0,cell,_3c9,_3ca;(cell=row[i]);i++){while(this.map[j][x]){x++;}this.map[j][x]={c:i,r:j};_3ca=cell.rowSpan||1;_3c9=cell.colSpan||1;for(var y=0;y<_3ca;y++){for(var s=0;s<_3c9;s++){this.map[j+y][x+s]=this.map[j][x];}}x+=_3c9;}}},dumpMap:function(){for(var j=0,row,h="";(row=this.map[j]);j++,h=""){for(var i=0,cell;(cell=row[i]);i++){h+=cell.r+","+cell.c+"   ";}}},getMapCoords:function(_3cb,_3cc){for(var j=0,row;(row=this.map[j]);j++){for(var i=0,cell;(cell=row[i]);i++){if(cell.c==_3cc&&cell.r==_3cb){return {j:j,i:i};}}}return {j:-1,i:-1};},getNode:function(_3cd,_3ce,_3cf){var row=_3cd&&_3cd.rows[_3ce];return row&&row.cells[_3cf];},_findOverlappingNodes:function(_3d0,_3d1,_3d2){var _3d3=[];var m=this.getMapCoords(_3d1,_3d2);for(var j=0,row;(row=this.map[j]);j++){if(j==m.j){continue;}var rw=row[m.i];var n=(rw?this.getNode(_3d0,rw.r,rw.c):null);if(n){_3d3.push(n);}}return _3d3;},findOverlappingNodes:function(_3d4){return this._findOverlappingNodes(_392(_3d4),_38e(_3d4.parentNode),_38d(_3d4));}});return {_Builder:_39a,_HeaderBuilder:_3b1,_ContentBuilder:_3ab};});},"dojo/dnd/Moveable":function(){define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../dom","../dom-class","../Evented","../on","../topic","../touch","./common","./Mover","../_base/window"],function(_3d5,_3d6,_3d7,lang,dom,_3d8,_3d9,on,_3da,_3db,dnd,_3dc,win){var _3dd=_3d6("dojo.dnd.Moveable",[_3d9],{handle:"",delay:0,skip:false,constructor:function(node,_3de){this.node=dom.byId(node);if(!_3de){_3de={};}this.handle=_3de.handle?dom.byId(_3de.handle):null;if(!this.handle){this.handle=this.node;}this.delay=_3de.delay>0?_3de.delay:0;this.skip=_3de.skip;this.mover=_3de.mover?_3de.mover:_3dc;this.events=[on(this.handle,_3db.press,lang.hitch(this,"onMouseDown")),on(this.handle,"dragstart",lang.hitch(this,"onSelectStart")),on(this.handle,"selectstart",lang.hitch(this,"onSelectStart"))];},markupFactory:function(_3df,node,Ctor){return new Ctor(node,_3df);},destroy:function(){_3d5.forEach(this.events,function(_3e0){_3e0.remove();});this.events=this.node=this.handle=null;},onMouseDown:function(e){if(this.skip&&dnd.isFormElement(e)){return;}if(this.delay){this.events.push(on(this.handle,_3db.move,lang.hitch(this,"onMouseMove")),on(this.handle,_3db.release,lang.hitch(this,"onMouseUp")));this._lastX=e.pageX;this._lastY=e.pageY;}else{this.onDragDetected(e);}_3d7.stop(e);},onMouseMove:function(e){if(Math.abs(e.pageX-this._lastX)>this.delay||Math.abs(e.pageY-this._lastY)>this.delay){this.onMouseUp(e);this.onDragDetected(e);}_3d7.stop(e);},onMouseUp:function(e){for(var i=0;i<2;++i){this.events.pop().remove();}_3d7.stop(e);},onSelectStart:function(e){if(!this.skip||!dnd.isFormElement(e)){_3d7.stop(e);}},onDragDetected:function(e){new this.mover(this.node,e,this);},onMoveStart:function(_3e1){_3da.publish("/dnd/move/start",_3e1);_3d8.add(win.body(),"dojoMove");_3d8.add(this.node,"dojoMoveItem");},onMoveStop:function(_3e2){_3da.publish("/dnd/move/stop",_3e2);_3d8.remove(win.body(),"dojoMove");_3d8.remove(this.node,"dojoMoveItem");},onFirstMove:function(){},onMove:function(_3e3,_3e4){this.onMoving(_3e3,_3e4);var s=_3e3.node.style;s.left=_3e4.l+"px";s.top=_3e4.t+"px";this.onMoved(_3e3,_3e4);},onMoving:function(){},onMoved:function(){}});return _3dd;});},"dojo/dnd/Mover":function(){define(["../_base/array","../_base/declare","../_base/event","../_base/lang","../sniff","../_base/window","../dom","../dom-geometry","../dom-style","../Evented","../on","../touch","./common","./autoscroll"],function(_3e5,_3e6,_3e7,lang,has,win,dom,_3e8,_3e9,_3ea,on,_3eb,dnd,_3ec){return _3e6("dojo.dnd.Mover",[_3ea],{constructor:function(node,e,host){this.node=dom.byId(node);this.marginBox={l:e.pageX,t:e.pageY};this.mouseButton=e.button;var h=(this.host=host),d=node.ownerDocument;this.events=[on(d,_3eb.move,lang.hitch(this,"onFirstMove")),on(d,_3eb.move,lang.hitch(this,"onMouseMove")),on(d,_3eb.release,lang.hitch(this,"onMouseUp")),on(d,"dragstart",_3e7.stop),on(d.body,"selectstart",_3e7.stop)];_3ec.autoScrollStart(d);if(h&&h.onMoveStart){h.onMoveStart(this);}},onMouseMove:function(e){_3ec.autoScroll(e);var m=this.marginBox;this.host.onMove(this,{l:m.l+e.pageX,t:m.t+e.pageY},e);_3e7.stop(e);},onMouseUp:function(e){if(has("webkit")&&has("mac")&&this.mouseButton==2?e.button==0:this.mouseButton==e.button){this.destroy();}_3e7.stop(e);},onFirstMove:function(e){var s=this.node.style,l,t,h=this.host;switch(s.position){case "relative":case "absolute":l=Math.round(parseFloat(s.left))||0;t=Math.round(parseFloat(s.top))||0;break;default:s.position="absolute";var m=_3e8.getMarginBox(this.node);var b=win.doc.body;var bs=_3e9.getComputedStyle(b);var bm=_3e8.getMarginBox(b,bs);var bc=_3e8.getContentBox(b,bs);l=m.l-(bc.l-bm.l);t=m.t-(bc.t-bm.t);break;}this.marginBox.l=l-this.marginBox.l;this.marginBox.t=t-this.marginBox.t;if(h&&h.onFirstMove){h.onFirstMove(this,e);}this.events.shift().remove();},destroy:function(){_3e5.forEach(this.events,function(_3ed){_3ed.remove();});var h=this.host;if(h&&h.onMoveStop){h.onMoveStop(this);}this.events=this.node=this.host=null;}});});},"dojox/grid/_ViewManager":function(){define(["dojo/_base/declare","dojo/_base/sniff","dojo/dom-class"],function(_3ee,has,_3ef){return _3ee("dojox.grid._ViewManager",null,{constructor:function(_3f0){this.grid=_3f0;},defaultWidth:200,views:[],resize:function(){this.onEach("resize");},render:function(){this.onEach("render");},addView:function(_3f1){_3f1.idx=this.views.length;this.views.push(_3f1);},destroyViews:function(){for(var i=0,v;v=this.views[i];i++){v.destroy();}this.views=[];},getContentNodes:function(){var _3f2=[];for(var i=0,v;v=this.views[i];i++){_3f2.push(v.contentNode);}return _3f2;},forEach:function(_3f3){for(var i=0,v;v=this.views[i];i++){_3f3(v,i);}},onEach:function(_3f4,_3f5){_3f5=_3f5||[];for(var i=0,v;v=this.views[i];i++){if(_3f4 in v){v[_3f4].apply(v,_3f5);}}},normalizeHeaderNodeHeight:function(){var _3f6=[];for(var i=0,v;(v=this.views[i]);i++){if(v.headerContentNode.firstChild){_3f6.push(v.headerContentNode);}}this.normalizeRowNodeHeights(_3f6);},normalizeRowNodeHeights:function(_3f7){var h=0;var _3f8=[];if(this.grid.rowHeight){h=this.grid.rowHeight;}else{if(_3f7.length<=1){return;}for(var i=0,n;(n=_3f7[i]);i++){if(!_3ef.contains(n,"dojoxGridNonNormalizedCell")){_3f8[i]=n.firstChild.offsetHeight;h=Math.max(h,_3f8[i]);}}h=(h>=0?h:0);if((has("mozilla")||has("ie")>8)&&h){h++;}}for(i=0;(n=_3f7[i]);i++){if(_3f8[i]!=h){n.firstChild.style.height=h+"px";}}},resetHeaderNodeHeight:function(){for(var i=0,v,n;(v=this.views[i]);i++){n=v.headerContentNode.firstChild;if(n){n.style.height="";}}},renormalizeRow:function(_3f9){var _3fa=[];for(var i=0,v,n;(v=this.views[i])&&(n=v.getRowNode(_3f9));i++){n.firstChild.style.height="";_3fa.push(n);}this.normalizeRowNodeHeights(_3fa);},getViewWidth:function(_3fb){return this.views[_3fb].getWidth()||this.defaultWidth;},measureHeader:function(){this.resetHeaderNodeHeight();this.forEach(function(_3fc){_3fc.headerContentNode.style.height="";});var h=0;this.forEach(function(_3fd){h=Math.max(_3fd.headerNode.offsetHeight,h);});return h;},measureContent:function(){var h=0;this.forEach(function(_3fe){h=Math.max(_3fe.domNode.offsetHeight,h);});return h;},findClient:function(_3ff){var c=this.grid.elasticView||-1;if(c<0){for(var i=1,v;(v=this.views[i]);i++){if(v.viewWidth){for(i=1;(v=this.views[i]);i++){if(!v.viewWidth){c=i;break;}}break;}}}if(c<0){c=Math.floor(this.views.length/2);}return c;},arrange:function(l,w){var i,v,vw,len=this.views.length,self=this;var c=(w<=0?len:this.findClient());var _400=function(v,l){var ds=v.domNode.style;var hs=v.headerNode.style;if(!self.grid.isLeftToRight()){ds.right=l+"px";if(has("ff")<4){hs.right=l+v.getScrollbarWidth()+"px";}else{hs.right=l+"px";}if(!has("webkit")){hs.width=parseInt(hs.width,10)-v.getScrollbarWidth()+"px";}}else{ds.left=l+"px";hs.left=l+"px";}ds.top=0+"px";hs.top=0;};for(i=0;(v=this.views[i])&&(i<c);i++){vw=this.getViewWidth(i);v.setSize(vw,0);_400(v,l);if(v.headerContentNode&&v.headerContentNode.firstChild){vw=v.getColumnsWidth()+v.getScrollbarWidth();}else{vw=v.domNode.offsetWidth;}l+=vw;}i++;var r=w;for(var j=len-1;(v=this.views[j])&&(i<=j);j--){vw=this.getViewWidth(j);v.setSize(vw,0);vw=v.domNode.offsetWidth;r-=vw;_400(v,r);}if(c<len){v=this.views[c];vw=Math.max(1,r-l);v.setSize(vw+"px",0);_400(v,l);}return l;},renderRow:function(_401,_402,_403){var _404=[];for(var i=0,v,n,_405;(v=this.views[i])&&(n=_402[i]);i++){_405=v.renderRow(_401);n.appendChild(_405);_404.push(_405);}if(!_403){this.normalizeRowNodeHeights(_404);}},rowRemoved:function(_406){this.onEach("rowRemoved",[_406]);},updateRow:function(_407,_408){for(var i=0,v;v=this.views[i];i++){v.updateRow(_407);}if(!_408){this.renormalizeRow(_407);}},updateRowStyles:function(_409){this.onEach("updateRowStyles",[_409]);},setScrollTop:function(_40a){var top=_40a;for(var i=0,v;v=this.views[i];i++){top=v.setScrollTop(_40a);if(has("ie")&&v.headerNode&&v.scrollboxNode){v.headerNode.scrollLeft=v.scrollboxNode.scrollLeft;}}return top;},getFirstScrollingView:function(){for(var i=0,v;(v=this.views[i]);i++){if(v.hasHScrollbar()||v.hasVScrollbar()){return v;}}return null;}});});},"dojox/grid/_RowManager":function(){define(["dojo/_base/declare","dojo/_base/lang","dojo/dom-class"],function(_40b,lang,_40c){var _40d=function(_40e,_40f){if(_40e.style.cssText==undefined){_40e.setAttribute("style",_40f);}else{_40e.style.cssText=_40f;}};return _40b("dojox.grid._RowManager",null,{constructor:function(_410){this.grid=_410;},linesToEms:2,overRow:-2,prepareStylingRow:function(_411,_412){return {index:_411,node:_412,odd:Boolean(_411&1),selected:!!this.grid.selection.isSelected(_411),over:this.isOver(_411),customStyles:"",customClasses:"dojoxGridRow"};},styleRowNode:function(_413,_414){var row=this.prepareStylingRow(_413,_414);this.grid.onStyleRow(row);this.applyStyles(row);},applyStyles:function(_415){var i=_415;i.node.className=i.customClasses;var h=i.node.style.height;_40d(i.node,i.customStyles+";"+(i.node._style||""));i.node.style.height=h;},updateStyles:function(_416){this.grid.updateRowStyles(_416);},setOverRow:function(_417){var last=this.overRow;this.overRow=_417;if((last!=this.overRow)&&(lang.isString(last)||last>=0)){this.updateStyles(last);}this.updateStyles(this.overRow);},isOver:function(_418){return (this.overRow==_418&&!_40c.contains(this.grid.domNode,"dojoxGridColumnResizing"));}});});},"dojox/grid/_FocusManager":function(){define(["dojo/_base/array","dojo/_base/lang","dojo/_base/declare","dojo/_base/connect","dojo/_base/event","dojo/_base/sniff","dojo/query","./util","dojo/_base/html"],function(_419,lang,_41a,_41b,_41c,has,_41d,util,html){return _41a("dojox.grid._FocusManager",null,{constructor:function(_41e){this.grid=_41e;this.cell=null;this.rowIndex=-1;this._connects=[];this._headerConnects=[];this.headerMenu=this.grid.headerMenu;this._connects.push(_41b.connect(this.grid.domNode,"onfocus",this,"doFocus"));this._connects.push(_41b.connect(this.grid.domNode,"onblur",this,"doBlur"));this._connects.push(_41b.connect(this.grid.domNode,"mousedown",this,"_mouseDown"));this._connects.push(_41b.connect(this.grid.domNode,"mouseup",this,"_mouseUp"));this._connects.push(_41b.connect(this.grid.domNode,"oncontextmenu",this,"doContextMenu"));this._connects.push(_41b.connect(this.grid.lastFocusNode,"onfocus",this,"doLastNodeFocus"));this._connects.push(_41b.connect(this.grid.lastFocusNode,"onblur",this,"doLastNodeBlur"));this._connects.push(_41b.connect(this.grid,"_onFetchComplete",this,"_delayedCellFocus"));this._connects.push(_41b.connect(this.grid,"postrender",this,"_delayedHeaderFocus"));},destroy:function(){_419.forEach(this._connects,_41b.disconnect);_419.forEach(this._headerConnects,_41b.disconnect);delete this.grid;delete this.cell;},_colHeadNode:null,_colHeadFocusIdx:null,_contextMenuBindNode:null,tabbingOut:false,focusClass:"dojoxGridCellFocus",focusView:null,initFocusView:function(){this.focusView=this.grid.views.getFirstScrollingView()||this.focusView||this.grid.views.views[0];this._initColumnHeaders();},isFocusCell:function(_41f,_420){return (this.cell==_41f)&&(this.rowIndex==_420);},isLastFocusCell:function(){if(this.cell){return (this.rowIndex==this.grid.rowCount-1)&&(this.cell.index==this.grid.layout.cellCount-1);}return false;},isFirstFocusCell:function(){if(this.cell){return (this.rowIndex===0)&&(this.cell.index===0);}return false;},isNoFocusCell:function(){return (this.rowIndex<0)||!this.cell;},isNavHeader:function(){return (!!this._colHeadNode);},getHeaderIndex:function(){if(this._colHeadNode){return _419.indexOf(this._findHeaderCells(),this._colHeadNode);}else{return -1;}},_focusifyCellNode:function(_421){var n=this.cell&&this.cell.getNode(this.rowIndex);if(n){html.toggleClass(n,this.focusClass,_421);if(_421){var sl=this.scrollIntoView();try{if(has("webkit")||!this.grid.edit.isEditing()){util.fire(n,"focus");if(sl){this.cell.view.scrollboxNode.scrollLeft=sl;}}}catch(e){}}}},_delayedCellFocus:function(){if(this.isNavHeader()||!this.grid.focused){return;}var n=this.cell&&this.cell.getNode(this.rowIndex);if(n){try{if(!this.grid.edit.isEditing()){html.toggleClass(n,this.focusClass,true);if(this._colHeadNode){this.blurHeader();}util.fire(n,"focus");}}catch(e){}}},_delayedHeaderFocus:function(){if(this.isNavHeader()){this.focusHeader();}},_initColumnHeaders:function(){_419.forEach(this._headerConnects,_41b.disconnect);this._headerConnects=[];var _422=this._findHeaderCells();for(var i=0;i<_422.length;i++){this._headerConnects.push(_41b.connect(_422[i],"onfocus",this,"doColHeaderFocus"));this._headerConnects.push(_41b.connect(_422[i],"onblur",this,"doColHeaderBlur"));}},_findHeaderCells:function(){var _423=_41d("th",this.grid.viewsHeaderNode);var _424=[];for(var i=0;i<_423.length;i++){var _425=_423[i];var _426=html.hasAttr(_425,"tabIndex");var _427=html.attr(_425,"tabIndex");if(_426&&_427<0){_424.push(_425);}}return _424;},_setActiveColHeader:function(_428,_429,_42a){this.grid.domNode.setAttribute("aria-activedescendant",_428.id);if(_42a!=null&&_42a>=0&&_42a!=_429){html.toggleClass(this._findHeaderCells()[_42a],this.focusClass,false);}html.toggleClass(_428,this.focusClass,true);this._colHeadNode=_428;this._colHeadFocusIdx=_429;this._scrollHeader(this._colHeadFocusIdx);},scrollIntoView:function(){var info=(this.cell?this._scrollInfo(this.cell):null);if(!info||!info.s){return null;}var rt=this.grid.scroller.findScrollTop(this.rowIndex);if(info.n&&info.sr){if(info.n.offsetLeft+info.n.offsetWidth>info.sr.l+info.sr.w){info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;}else{if(info.n.offsetLeft<info.sr.l){info.s.scrollLeft=info.n.offsetLeft;}}}if(info.r&&info.sr){if(rt+info.r.offsetHeight>info.sr.t+info.sr.h){this.grid.setScrollTop(rt+info.r.offsetHeight-info.sr.h);}else{if(rt<info.sr.t){this.grid.setScrollTop(rt);}}}return info.s.scrollLeft;},_scrollInfo:function(cell,_42b){if(cell){var cl=cell,sbn=cl.view.scrollboxNode,sbnr={w:sbn.clientWidth,l:sbn.scrollLeft,t:sbn.scrollTop,h:sbn.clientHeight},rn=cl.view.getRowNode(this.rowIndex);return {c:cl,s:sbn,sr:sbnr,n:(_42b?_42b:cell.getNode(this.rowIndex)),r:rn};}return null;},_scrollHeader:function(_42c){var info=null;if(this._colHeadNode){var cell=this.grid.getCell(_42c);if(!cell){return;}info=this._scrollInfo(cell,cell.getNode(0));}if(info&&info.s&&info.sr&&info.n){var _42d=info.sr.l+info.sr.w;if(info.n.offsetLeft+info.n.offsetWidth>_42d){info.s.scrollLeft=info.n.offsetLeft+info.n.offsetWidth-info.sr.w;}else{if(info.n.offsetLeft<info.sr.l){info.s.scrollLeft=info.n.offsetLeft;}else{if(has("ie")<=7&&cell&&cell.view.headerNode){cell.view.headerNode.scrollLeft=info.s.scrollLeft;}}}}},_isHeaderHidden:function(){var _42e=this.focusView;if(!_42e){for(var i=0,_42f;(_42f=this.grid.views.views[i]);i++){if(_42f.headerNode){_42e=_42f;break;}}}return (_42e&&html.getComputedStyle(_42e.headerNode).display=="none");},colSizeAdjust:function(e,_430,_431){var _432=this._findHeaderCells();var view=this.focusView;if(!view||!view.header.tableMap.map){for(var i=0,_433;(_433=this.grid.views.views[i]);i++){if(_433.header.tableMap.map){view=_433;break;}}}var _434=_432[_430];if(!view||(_430==_432.length-1&&_430===0)){return;}view.content.baseDecorateEvent(e);e.cellNode=_434;e.cellIndex=view.content.getCellNodeIndex(e.cellNode);e.cell=(e.cellIndex>=0?this.grid.getCell(e.cellIndex):null);if(view.header.canResize(e)){var _435={l:_431};var drag=view.header.colResizeSetup(e,false);view.header.doResizeColumn(drag,null,_435);view.update();}},styleRow:function(_436){return;},setFocusIndex:function(_437,_438){this.setFocusCell(this.grid.getCell(_438),_437);},setFocusCell:function(_439,_43a){if(_439&&!this.isFocusCell(_439,_43a)){this.tabbingOut=false;if(this._colHeadNode){this.blurHeader();}this._colHeadNode=this._colHeadFocusIdx=null;this.focusGridView();this._focusifyCellNode(false);this.cell=_439;this.rowIndex=_43a;this._focusifyCellNode(true);}if(has("opera")){setTimeout(lang.hitch(this.grid,"onCellFocus",this.cell,this.rowIndex),1);}else{this.grid.onCellFocus(this.cell,this.rowIndex);}},next:function(){if(this.cell){var row=this.rowIndex,col=this.cell.index+1,cc=this.grid.layout.cellCount-1,rc=this.grid.rowCount-1;if(col>cc){col=0;row++;}if(row>rc){col=cc;row=rc;}if(this.grid.edit.isEditing()){var _43b=this.grid.getCell(col);if(!this.isLastFocusCell()&&(!_43b.editable||this.grid.canEdit&&!this.grid.canEdit(_43b,row))){this.cell=_43b;this.rowIndex=row;this.next();return;}}this.setFocusIndex(row,col);}},previous:function(){if(this.cell){var row=(this.rowIndex||0),col=(this.cell.index||0)-1;if(col<0){col=this.grid.layout.cellCount-1;row--;}if(row<0){row=0;col=0;}if(this.grid.edit.isEditing()){var _43c=this.grid.getCell(col);if(!this.isFirstFocusCell()&&!_43c.editable){this.cell=_43c;this.rowIndex=row;this.previous();return;}}this.setFocusIndex(row,col);}},move:function(_43d,_43e){var _43f=_43e<0?-1:1;if(this.isNavHeader()){var _440=this._findHeaderCells();var _441=currentIdx=_419.indexOf(_440,this._colHeadNode);currentIdx+=_43e;while(currentIdx>=0&&currentIdx<_440.length&&_440[currentIdx].style.display=="none"){currentIdx+=_43f;}if((currentIdx>=0)&&(currentIdx<_440.length)){this._setActiveColHeader(_440[currentIdx],currentIdx,_441);}}else{if(this.cell){var sc=this.grid.scroller,r=this.rowIndex,rc=this.grid.rowCount-1,row=Math.min(rc,Math.max(0,r+_43d));if(_43d){if(_43d>0){if(row>sc.getLastPageRow(sc.page)){this.grid.setScrollTop(this.grid.scrollTop+sc.findScrollTop(row)-sc.findScrollTop(r));}}else{if(_43d<0){if(row<=sc.getPageRow(sc.page)){this.grid.setScrollTop(this.grid.scrollTop-sc.findScrollTop(r)-sc.findScrollTop(row));}}}}var cc=this.grid.layout.cellCount-1,i=this.cell.index,col=Math.min(cc,Math.max(0,i+_43e));var cell=this.grid.getCell(col);while(col>=0&&col<cc&&cell&&cell.hidden===true){col+=_43f;cell=this.grid.getCell(col);}if(!cell||cell.hidden===true){col=i;}var n=cell.getNode(row);if(!n&&_43d){if((row+_43d)>=0&&(row+_43d)<=rc){this.move(_43d>0?++_43d:--_43d,_43e);}return;}else{if((!n||html.style(n,"display")==="none")&&_43e){if((col+_43e)>=0&&(col+_43e)<=cc){this.move(_43d,_43e>0?++_43e:--_43e);}return;}}this.setFocusIndex(row,col);if(_43d){this.grid.updateRow(r);}}}},previousKey:function(e){if(this.grid.edit.isEditing()){_41c.stop(e);this.previous();}else{if(!this.isNavHeader()&&!this._isHeaderHidden()){this.grid.domNode.focus();_41c.stop(e);}else{this.tabOut(this.grid.domNode);if(this._colHeadFocusIdx!=null){html.toggleClass(this._findHeaderCells()[this._colHeadFocusIdx],this.focusClass,false);this._colHeadFocusIdx=null;}this._focusifyCellNode(false);}}},nextKey:function(e){var _442=(this.grid.rowCount===0);if(e.target===this.grid.domNode&&this._colHeadFocusIdx==null){this.focusHeader();_41c.stop(e);}else{if(this.isNavHeader()){this.blurHeader();if(!this.findAndFocusGridCell()){this.tabOut(this.grid.lastFocusNode);}this._colHeadNode=this._colHeadFocusIdx=null;}else{if(this.grid.edit.isEditing()){_41c.stop(e);this.next();}else{this.tabOut(this.grid.lastFocusNode);}}}},tabOut:function(_443){this.tabbingOut=true;_443.focus();},focusGridView:function(){util.fire(this.focusView,"focus");},focusGrid:function(_444){this.focusGridView();this._focusifyCellNode(true);},findAndFocusGridCell:function(){var _445=true;var _446=(this.grid.rowCount===0);if(this.isNoFocusCell()&&!_446){var _447=0;var cell=this.grid.getCell(_447);if(cell.hidden){_447=this.isNavHeader()?this._colHeadFocusIdx:0;}this.setFocusIndex(0,_447);}else{if(this.cell&&!_446){if(this.focusView&&!this.focusView.rowNodes[this.rowIndex]){this.grid.scrollToRow(this.rowIndex);}this.focusGrid();}else{_445=false;}}this._colHeadNode=this._colHeadFocusIdx=null;return _445;},focusHeader:function(){var _448=this._findHeaderCells();var _449=this._colHeadFocusIdx;if(this._isHeaderHidden()){this.findAndFocusGridCell();}else{if(!this._colHeadFocusIdx){if(this.isNoFocusCell()){this._colHeadFocusIdx=0;}else{this._colHeadFocusIdx=this.cell.index;}}}this._colHeadNode=_448[this._colHeadFocusIdx];while(this._colHeadNode&&this._colHeadFocusIdx>=0&&this._colHeadFocusIdx<_448.length&&this._colHeadNode.style.display=="none"){this._colHeadFocusIdx++;this._colHeadNode=_448[this._colHeadFocusIdx];}if(this._colHeadNode&&this._colHeadNode.style.display!="none"){if(this.headerMenu&&this._contextMenuBindNode!=this.grid.domNode){this.headerMenu.unBindDomNode(this.grid.viewsHeaderNode);this.headerMenu.bindDomNode(this.grid.domNode);this._contextMenuBindNode=this.grid.domNode;}this._setActiveColHeader(this._colHeadNode,this._colHeadFocusIdx,_449);this._scrollHeader(this._colHeadFocusIdx);this._focusifyCellNode(false);}else{this.findAndFocusGridCell();}},blurHeader:function(){html.removeClass(this._colHeadNode,this.focusClass);html.removeAttr(this.grid.domNode,"aria-activedescendant");if(this.headerMenu&&this._contextMenuBindNode==this.grid.domNode){var _44a=this.grid.viewsHeaderNode;this.headerMenu.unBindDomNode(this.grid.domNode);this.headerMenu.bindDomNode(_44a);this._contextMenuBindNode=_44a;}},doFocus:function(e){if(e&&e.target!=e.currentTarget){_41c.stop(e);return;}if(this._clickFocus){return;}if(!this.tabbingOut){this.focusHeader();}this.tabbingOut=false;_41c.stop(e);},doBlur:function(e){_41c.stop(e);},doContextMenu:function(e){if(!this.headerMenu){_41c.stop(e);}},doLastNodeFocus:function(e){if(this.tabbingOut){this._focusifyCellNode(false);}else{if(this.grid.rowCount>0){if(this.isNoFocusCell()){this.setFocusIndex(0,0);}this._focusifyCellNode(true);}else{this.focusHeader();}}this.tabbingOut=false;_41c.stop(e);},doLastNodeBlur:function(e){_41c.stop(e);},doColHeaderFocus:function(e){this._setActiveColHeader(e.target,html.attr(e.target,"idx"),this._colHeadFocusIdx);this._scrollHeader(this.getHeaderIndex());_41c.stop(e);},doColHeaderBlur:function(e){html.toggleClass(e.target,this.focusClass,false);},_mouseDown:function(e){this._clickFocus=dojo.some(this.grid.views.views,function(v){return v.scrollboxNode===e.target;});},_mouseUp:function(e){this._clickFocus=false;}});});},"dojox/grid/_EditManager":function(){define(["dojo/_base/lang","dojo/_base/array","dojo/_base/declare","dojo/_base/connect","dojo/_base/sniff","./util"],function(lang,_44b,_44c,_44d,has,util){return _44c("dojox.grid._EditManager",null,{constructor:function(_44e){this.grid=_44e;if(has("ie")){this.connections=[_44d.connect(document.body,"onfocus",lang.hitch(this,"_boomerangFocus"))];}else{this.connections=[_44d.connect(this.grid,"onBlur",this,"apply")];}},info:{},destroy:function(){_44b.forEach(this.connections,_44d.disconnect);},cellFocus:function(_44f,_450){if(this.grid.singleClickEdit||this.isEditRow(_450)){this.setEditCell(_44f,_450);}else{this.apply();}if(this.isEditing()||(_44f&&_44f.editable&&_44f.alwaysEditing)){this._focusEditor(_44f,_450);}},rowClick:function(e){if(this.isEditing()&&!this.isEditRow(e.rowIndex)){this.apply();}},styleRow:function(_451){if(_451.index==this.info.rowIndex){_451.customClasses+=" dojoxGridRowEditing";}},dispatchEvent:function(e){var c=e.cell,ed=(c&&c["editable"])?c:0;return ed&&ed.dispatchEvent(e.dispatch,e);},isEditing:function(){return this.info.rowIndex!==undefined;},isEditCell:function(_452,_453){return (this.info.rowIndex===_452)&&(this.info.cell.index==_453);},isEditRow:function(_454){return this.info.rowIndex===_454;},setEditCell:function(_455,_456){if(!this.isEditCell(_456,_455.index)&&this.grid.canEdit&&this.grid.canEdit(_455,_456)){this.start(_455,_456,this.isEditRow(_456)||_455.editable);}},_focusEditor:function(_457,_458){util.fire(_457,"focus",[_458]);},focusEditor:function(){if(this.isEditing()){this._focusEditor(this.info.cell,this.info.rowIndex);}},_boomerangWindow:500,_shouldCatchBoomerang:function(){return this._catchBoomerang>new Date().getTime();},_boomerangFocus:function(){if(this._shouldCatchBoomerang()){this.grid.focus.focusGrid();this.focusEditor();this._catchBoomerang=0;}},_doCatchBoomerang:function(){if(has("ie")){this._catchBoomerang=new Date().getTime()+this._boomerangWindow;}},start:function(_459,_45a,_45b){if(!this._isValidInput()){return;}this.grid.beginUpdate();this.editorApply();if(this.isEditing()&&!this.isEditRow(_45a)){this.applyRowEdit();this.grid.updateRow(_45a);}if(_45b){this.info={cell:_459,rowIndex:_45a};this.grid.doStartEdit(_459,_45a);this.grid.updateRow(_45a);}else{this.info={};}this.grid.endUpdate();this.grid.focus.focusGrid();this._focusEditor(_459,_45a);this._doCatchBoomerang();},_editorDo:function(_45c){var c=this.info.cell;if(c&&c.editable){c[_45c](this.info.rowIndex);}},editorApply:function(){this._editorDo("apply");},editorCancel:function(){this._editorDo("cancel");},applyCellEdit:function(_45d,_45e,_45f){if(this.grid.canEdit(_45e,_45f)){this.grid.doApplyCellEdit(_45d,_45f,_45e.field);}},applyRowEdit:function(){this.grid.doApplyEdit(this.info.rowIndex,this.info.cell.field);},apply:function(){if(this.isEditing()&&this._isValidInput()){this.grid.beginUpdate();this.editorApply();this.applyRowEdit();this.info={};this.grid.endUpdate();this.grid.focus.focusGrid();this._doCatchBoomerang();}},cancel:function(){if(this.isEditing()){this.grid.beginUpdate();this.editorCancel();this.info={};this.grid.endUpdate();this.grid.focus.focusGrid();this._doCatchBoomerang();}},save:function(_460,_461){var c=this.info.cell;if(this.isEditRow(_460)&&(!_461||c.view==_461)&&c.editable){c.save(c,this.info.rowIndex);}},restore:function(_462,_463){var c=this.info.cell;if(this.isEditRow(_463)&&c.view==_462&&c.editable){c.restore(this.info.rowIndex);}},_isValidInput:function(){var w=(this.info.cell||{}).widget;if(!w||!w.isValid){return true;}w.focused=true;return w.isValid(true);}});});},"dojox/grid/Selection":function(){define(["dojo/_base/declare","dojo/_base/array","dojo/_base/lang","dojo/dom-attr"],function(_464,_465,lang,_466){return _464("dojox.grid.Selection",null,{constructor:function(_467){this.grid=_467;this.selected=[];this.setMode(_467.selectionMode);},mode:"extended",selected:null,updating:0,selectedIndex:-1,rangeStartIndex:-1,setMode:function(mode){if(this.selected.length){this.deselectAll();}if(mode!="extended"&&mode!="multiple"&&mode!="single"&&mode!="none"){this.mode="extended";}else{this.mode=mode;}},onCanSelect:function(_468){return this.grid.onCanSelect(_468);},onCanDeselect:function(_469){return this.grid.onCanDeselect(_469);},onSelected:function(_46a){},onDeselected:function(_46b){},onChanging:function(){},onChanged:function(){},isSelected:function(_46c){if(this.mode=="none"){return false;}return this.selected[_46c];},getFirstSelected:function(){if(!this.selected.length||this.mode=="none"){return -1;}for(var i=0,l=this.selected.length;i<l;i++){if(this.selected[i]){return i;}}return -1;},getNextSelected:function(_46d){if(this.mode=="none"){return -1;}for(var i=_46d+1,l=this.selected.length;i<l;i++){if(this.selected[i]){return i;}}return -1;},getSelected:function(){var _46e=[];for(var i=0,l=this.selected.length;i<l;i++){if(this.selected[i]){_46e.push(i);}}return _46e;},getSelectedCount:function(){var c=0;for(var i=0;i<this.selected.length;i++){if(this.selected[i]){c++;}}return c;},_beginUpdate:function(){if(this.updating===0){this.onChanging();}this.updating++;},_endUpdate:function(){this.updating--;if(this.updating===0){this.onChanged();}},select:function(_46f){if(this.mode=="none"){return;}if(this.mode!="multiple"){this.deselectAll(_46f);this.addToSelection(_46f);}else{this.toggleSelect(_46f);}},addToSelection:function(_470){if(this.mode=="none"){return;}if(lang.isArray(_470)){_465.forEach(_470,this.addToSelection,this);return;}_470=Number(_470);if(this.selected[_470]){this.selectedIndex=_470;}else{if(this.onCanSelect(_470)!==false){this.selectedIndex=_470;var _471=this.grid.getRowNode(_470);if(_471){_466.set(_471,"aria-selected","true");}this._beginUpdate();this.selected[_470]=true;this.onSelected(_470);this._endUpdate();}}},deselect:function(_472){if(this.mode=="none"){return;}if(lang.isArray(_472)){_465.forEach(_472,this.deselect,this);return;}_472=Number(_472);if(this.selectedIndex==_472){this.selectedIndex=-1;}if(this.selected[_472]){if(this.onCanDeselect(_472)===false){return;}var _473=this.grid.getRowNode(_472);if(_473){_466.set(_473,"aria-selected","false");}this._beginUpdate();delete this.selected[_472];this.onDeselected(_472);this._endUpdate();}},setSelected:function(_474,_475){this[(_475?"addToSelection":"deselect")](_474);},toggleSelect:function(_476){if(lang.isArray(_476)){_465.forEach(_476,this.toggleSelect,this);return;}this.setSelected(_476,!this.selected[_476]);},_range:function(_477,inTo,func){var s=(_477>=0?_477:inTo),e=inTo;if(s>e){e=s;s=inTo;}for(var i=s;i<=e;i++){func(i);}},selectRange:function(_478,inTo){this._range(_478,inTo,lang.hitch(this,"addToSelection"));},deselectRange:function(_479,inTo){this._range(_479,inTo,lang.hitch(this,"deselect"));},insert:function(_47a){this.selected.splice(_47a,0,false);if(this.selectedIndex>=_47a){this.selectedIndex++;}},remove:function(_47b){this.selected.splice(_47b,1);if(this.selectedIndex>=_47b){this.selectedIndex--;}},deselectAll:function(_47c){for(var i in this.selected){if((i!=_47c)&&(this.selected[i]===true)){this.deselect(i);}}},clickSelect:function(_47d,_47e,_47f){if(this.mode=="none"){return;}this._beginUpdate();if(this.mode!="extended"){this.select(_47d);}else{if(!_47f||this.rangeStartIndex<0){this.rangeStartIndex=_47d;}if(!_47e){this.deselectAll(_47d);}if(_47f){this.selectRange(this.rangeStartIndex,_47d);}else{if(_47e){this.toggleSelect(_47d);}else{this.addToSelection(_47d);}}}this._endUpdate();},clickSelectEvent:function(e){this.clickSelect(e.rowIndex,dojo.isCopyKey(e),e.shiftKey);},clear:function(){this._beginUpdate();this.deselectAll();this._endUpdate();}});});},"dijit/CheckedMenuItem":function(){require({cache:{"url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitemcheckbox\" tabIndex=\"-1\" aria-checked=\"${checked}\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t<span class=\"dijitCheckedMenuItemIconChar\">&#10003;</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n"}});define("dijit/CheckedMenuItem",["dojo/_base/declare","dojo/dom-class","./MenuItem","dojo/text!./templates/CheckedMenuItem.html","./hccss"],function(_480,_481,_482,_483){return _480("dijit.CheckedMenuItem",_482,{templateString:_483,checked:false,_setCheckedAttr:function(_484){_481.toggle(this.domNode,"dijitCheckedMenuItemChecked",_484);this.domNode.setAttribute("aria-checked",_484?"true":"false");this._set("checked",_484);},iconClass:"",onChange:function(){},_onClick:function(evt){if(!this.disabled){this.set("checked",!this.checked);this.onChange(this.checked);}this.onClick(evt);}});});},"dijit/MenuItem":function(){require({cache:{"url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n"}});define("dijit/MenuItem",["dojo/_base/declare","dojo/dom","dojo/dom-attr","dojo/dom-class","dojo/_base/kernel","dojo/sniff","./_Widget","./_TemplatedMixin","./_Contained","./_CssStateMixin","dojo/text!./templates/MenuItem.html"],function(_485,dom,_486,_487,_488,has,_489,_48a,_48b,_48c,_48d){return _485("dijit.MenuItem",[_489,_48a,_48b,_48c],{templateString:_48d,baseClass:"dijitMenuItem",label:"",_setLabelAttr:function(val){this.containerNode.innerHTML=val;this._set("label",val);if(this.textDir==="auto"){this.applyTextDir(this.focusNode,this.label);}},iconClass:"dijitNoIcon",_setIconClassAttr:{node:"iconNode",type:"class"},accelKey:"",disabled:false,_fillContent:function(_48e){if(_48e&&!("label" in this.params)){this.set("label",_48e.innerHTML);}},buildRendering:function(){this.inherited(arguments);var _48f=this.id+"_text";_486.set(this.containerNode,"id",_48f);if(this.accelKeyNode){_486.set(this.accelKeyNode,"id",this.id+"_accel");_48f+=" "+this.id+"_accel";}this.domNode.setAttribute("aria-labelledby",_48f);dom.setSelectable(this.domNode,false);},onClick:function(){},focus:function(){try{if(has("ie")==8){this.containerNode.focus();}this.focusNode.focus();}catch(e){}},_onFocus:function(){this._setSelected(true);this.getParent()._onItemFocus(this);this.inherited(arguments);},_setSelected:function(_490){_487.toggle(this.domNode,"dijitMenuItemSelected",_490);},setLabel:function(_491){_488.deprecated("dijit.MenuItem.setLabel() is deprecated.  Use set('label', ...) instead.","","2.0");this.set("label",_491);},setDisabled:function(_492){_488.deprecated("dijit.Menu.setDisabled() is deprecated.  Use set('disabled', bool) instead.","","2.0");this.set("disabled",_492);},_setDisabledAttr:function(_493){this.focusNode.setAttribute("aria-disabled",_493?"true":"false");this._set("disabled",_493);},_setAccelKeyAttr:function(_494){this.accelKeyNode.style.display=_494?"":"none";this.accelKeyNode.innerHTML=_494;_486.set(this.containerNode,"colSpan",_494?"1":"2");this._set("accelKey",_494);},_setTextDirAttr:function(_495){if(!this._created||this.textDir!=_495){this._set("textDir",_495);this.applyTextDir(this.focusNode,this.label);}}});});},"dijit/_Contained":function(){define("dijit/_Contained",["dojo/_base/declare","./registry"],function(_496,_497){return _496("dijit._Contained",null,{_getSibling:function(_498){var node=this.domNode;do{node=node[_498+"Sibling"];}while(node&&node.nodeType!=1);return node&&_497.byNode(node);},getPreviousSibling:function(){return this._getSibling("previous");},getNextSibling:function(){return this._getSibling("next");},getIndexInParent:function(){var p=this.getParent();if(!p||!p.getIndexOfChild){return -1;}return p.getIndexOfChild(this);}});});},"dijit/_CssStateMixin":function(){define("dijit/_CssStateMixin",["dojo/_base/array","dojo/_base/declare","dojo/dom","dojo/dom-class","dojo/has","dojo/_base/lang","dojo/on","dojo/ready","dojo/_base/window","./registry"],function(_499,_49a,dom,_49b,has,lang,on,_49c,win,_49d){var _49e=_49a("dijit._CssStateMixin",[],{cssStateNodes:{},hovering:false,active:false,_applyAttributes:function(){this.inherited(arguments);_499.forEach(["disabled","readOnly","checked","selected","focused","state","hovering","active","_opened"],function(attr){this.watch(attr,lang.hitch(this,"_setStateClass"));},this);for(var ap in this.cssStateNodes){this._trackMouseState(this[ap],this.cssStateNodes[ap]);}this._trackMouseState(this.domNode,this.baseClass);this._setStateClass();},_cssMouseEvent:function(_49f){if(!this.disabled){switch(_49f.type){case "mouseover":this._set("hovering",true);this._set("active",this._mouseDown);break;case "mouseout":this._set("hovering",false);this._set("active",false);break;case "mousedown":case "touchstart":this._set("active",true);break;case "mouseup":case "touchend":this._set("active",false);break;}}},_setStateClass:function(){var _4a0=this.baseClass.split(" ");function _4a1(_4a2){_4a0=_4a0.concat(_499.map(_4a0,function(c){return c+_4a2;}),"dijit"+_4a2);};if(!this.isLeftToRight()){_4a1("Rtl");}var _4a3=this.checked=="mixed"?"Mixed":(this.checked?"Checked":"");if(this.checked){_4a1(_4a3);}if(this.state){_4a1(this.state);}if(this.selected){_4a1("Selected");}if(this._opened){_4a1("Opened");}if(this.disabled){_4a1("Disabled");}else{if(this.readOnly){_4a1("ReadOnly");}else{if(this.active){_4a1("Active");}else{if(this.hovering){_4a1("Hover");}}}}if(this.focused){_4a1("Focused");}var tn=this.stateNode||this.domNode,_4a4={};_499.forEach(tn.className.split(" "),function(c){_4a4[c]=true;});if("_stateClasses" in this){_499.forEach(this._stateClasses,function(c){delete _4a4[c];});}_499.forEach(_4a0,function(c){_4a4[c]=true;});var _4a5=[];for(var c in _4a4){_4a5.push(c);}tn.className=_4a5.join(" ");this._stateClasses=_4a0;},_subnodeCssMouseEvent:function(node,_4a6,evt){if(this.disabled||this.readOnly){return;}function _4a7(_4a8){_49b.toggle(node,_4a6+"Hover",_4a8);};function _4a9(_4aa){_49b.toggle(node,_4a6+"Active",_4aa);};function _4ab(_4ac){_49b.toggle(node,_4a6+"Focused",_4ac);};switch(evt.type){case "mouseover":_4a7(true);break;case "mouseout":_4a7(false);_4a9(false);break;case "mousedown":case "touchstart":_4a9(true);break;case "mouseup":case "touchend":_4a9(false);break;case "focus":case "focusin":_4ab(true);break;case "blur":case "focusout":_4ab(false);break;}},_trackMouseState:function(node,_4ad){node._cssState=_4ad;}});_49c(function(){function _4ae(evt){if(!dom.isDescendant(evt.relatedTarget,evt.target)){for(var node=evt.target;node&&node!=evt.relatedTarget;node=node.parentNode){if(node._cssState){var _4af=_49d.getEnclosingWidget(node);if(_4af){if(node==_4af.domNode){_4af._cssMouseEvent(evt);}else{_4af._subnodeCssMouseEvent(node,node._cssState,evt);}}}}}};function _4b0(evt){evt.target=evt.srcElement;_4ae(evt);};var body=win.body(),_4b1=(has("touch")?[]:["mouseover","mouseout"]).concat(["mousedown","touchstart","mouseup","touchend"]);_499.forEach(_4b1,function(type){if(body.addEventListener){body.addEventListener(type,_4ae,true);}else{body.attachEvent("on"+type,_4b0);}});on(body,"focusin, focusout",function(evt){var node=evt.target;if(node._cssState&&!node.getAttribute("widgetId")){var _4b2=_49d.getEnclosingWidget(node);_4b2._subnodeCssMouseEvent(node,node._cssState,evt);}});});return _49e;});},"url:dijit/templates/MenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitem\" tabIndex=\"-1\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitIcon dijitMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">\n\t\t<div data-dojo-attach-point=\"arrowWrapper\" style=\"visibility: hidden\">\n\t\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuExpand\"/>\n\t\t\t<span class=\"dijitMenuExpandA11y\">+</span>\n\t\t</div>\n\t</td>\n</tr>\n","url:dijit/templates/CheckedMenuItem.html":"<tr class=\"dijitReset dijitMenuItem\" data-dojo-attach-point=\"focusNode\" role=\"menuitemcheckbox\" tabIndex=\"-1\" aria-checked=\"${checked}\">\n\t<td class=\"dijitReset dijitMenuItemIconCell\" role=\"presentation\">\n\t\t<img src=\"${_blankGif}\" alt=\"\" class=\"dijitMenuItemIcon dijitCheckedMenuItemIcon\" data-dojo-attach-point=\"iconNode\"/>\n\t\t<span class=\"dijitCheckedMenuItemIconChar\">&#10003;</span>\n\t</td>\n\t<td class=\"dijitReset dijitMenuItemLabel\" colspan=\"2\" data-dojo-attach-point=\"containerNode,labelNode\"></td>\n\t<td class=\"dijitReset dijitMenuItemAccelKey\" style=\"display: none\" data-dojo-attach-point=\"accelKeyNode\"></td>\n\t<td class=\"dijitReset dijitMenuArrowCell\" role=\"presentation\">&#160;</td>\n</tr>\n","url:dojox/grid/resources/_Grid.html":"<div hidefocus=\"hidefocus\" role=\"grid\" dojoAttachEvent=\"onmouseout:_mouseOut\">\n\t<div class=\"dojoxGridMasterHeader\" dojoAttachPoint=\"viewsHeaderNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterView\" dojoAttachPoint=\"viewsNode\" role=\"presentation\"></div>\n\t<div class=\"dojoxGridMasterMessages\" style=\"display: none;\" dojoAttachPoint=\"messagesNode\"></div>\n\t<span dojoAttachPoint=\"lastFocusNode\" tabindex=\"0\"></span>\n</div>\n","dojox/grid/DataSelection":function(){define(["dojo/_base/declare","./_SelectionPreserver","./Selection"],function(_4b3,_4b4,_4b5){return _4b3("dojox.grid.DataSelection",_4b5,{constructor:function(grid){if(grid.keepSelection){this.preserver=new _4b4(this);}},destroy:function(){if(this.preserver){this.preserver.destroy();}},getFirstSelected:function(){var idx=_4b5.prototype.getFirstSelected.call(this);if(idx==-1){return null;}return this.grid.getItem(idx);},getNextSelected:function(_4b6){var _4b7=this.grid.getItemIndex(_4b6);var idx=_4b5.prototype.getNextSelected.call(this,_4b7);if(idx==-1){return null;}return this.grid.getItem(idx);},getSelected:function(){var _4b8=[];for(var i=0,l=this.selected.length;i<l;i++){if(this.selected[i]){_4b8.push(this.grid.getItem(i));}}return _4b8;},addToSelection:function(_4b9){if(this.mode=="none"){return;}var idx=null;if(typeof _4b9=="number"||typeof _4b9=="string"){idx=_4b9;}else{idx=this.grid.getItemIndex(_4b9);}_4b5.prototype.addToSelection.call(this,idx);},deselect:function(_4ba){if(this.mode=="none"){return;}var idx=null;if(typeof _4ba=="number"||typeof _4ba=="string"){idx=_4ba;}else{idx=this.grid.getItemIndex(_4ba);}_4b5.prototype.deselect.call(this,idx);},deselectAll:function(_4bb){var idx=null;if(_4bb||typeof _4bb=="number"){if(typeof _4bb=="number"||typeof _4bb=="string"){idx=_4bb;}else{idx=this.grid.getItemIndex(_4bb);}_4b5.prototype.deselectAll.call(this,idx);}else{this.inherited(arguments);}}});});},"dojox/grid/_SelectionPreserver":function(){define(["dojo/_base/declare","dojo/_base/connect","dojo/_base/lang","dojo/_base/array"],function(_4bc,_4bd,lang,_4be){return _4bc("dojox.grid._SelectionPreserver",null,{constructor:function(_4bf){this.selection=_4bf;var grid=this.grid=_4bf.grid;this.reset();this._connects=[_4bd.connect(grid,"_setStore",this,"reset"),_4bd.connect(grid,"_addItem",this,"_reSelectById"),_4bd.connect(_4bf,"onSelected",lang.hitch(this,"_selectById",true)),_4bd.connect(_4bf,"onDeselected",lang.hitch(this,"_selectById",false)),_4bd.connect(_4bf,"deselectAll",this,"reset")];},destroy:function(){this.reset();_4be.forEach(this._connects,_4bd.disconnect);delete this._connects;},reset:function(){this._selectedById={};},_reSelectById:function(item,_4c0){if(item&&this.grid._hasIdentity){this.selection.selected[_4c0]=this._selectedById[this.grid.store.getIdentity(item)];}},_selectById:function(_4c1,_4c2){if(this.selection.mode=="none"||!this.grid._hasIdentity){return;}var item=_4c2,g=this.grid;if(typeof _4c2=="number"||typeof _4c2=="string"){var _4c3=g._by_idx[_4c2];item=_4c3&&_4c3.item;}if(item){this._selectedById[g.store.getIdentity(item)]=!!_4c1;}return item;}});});},"*now":function(r){r(["dojo/i18n!*preload*dojox/grid/nls/DataGrid*[\"ar\",\"ca\",\"cs\",\"da\",\"de\",\"el\",\"en-gb\",\"en-us\",\"es-es\",\"fi-fi\",\"fr-fr\",\"he-il\",\"hu\",\"it-it\",\"ja-jp\",\"ko-kr\",\"nl-nl\",\"nb\",\"pl\",\"pt-br\",\"pt-pt\",\"ru\",\"sk\",\"sl\",\"sv\",\"th\",\"tr\",\"zh-tw\",\"zh-cn\",\"ROOT\"]"]);}}});define("dojox/grid/DataGrid",["../main","dojo/_base/array","dojo/_base/lang","dojo/_base/json","dojo/_base/sniff","dojo/_base/declare","./_Grid","./DataSelection","dojo/_base/html"],function(_4c4,_4c5,lang,json,has,_4c6,_4c7,_4c8,html){var _4c9=_4c6("dojox.grid.DataGrid",_4c7,{store:null,query:null,queryOptions:null,fetchText:"...",sortFields:null,updateDelay:1,items:null,_store_connects:null,_by_idty:null,_by_idx:null,_cache:null,_pages:null,_pending_requests:null,_bop:-1,_eop:-1,_requests:0,rowCount:0,_isLoaded:false,_isLoading:false,keepSelection:false,postCreate:function(){this._pages=[];this._store_connects=[];this._by_idty={};this._by_idx=[];this._cache=[];this._pending_requests={};this._setStore(this.store);this.inherited(arguments);},destroy:function(){this.selection.destroy();this.inherited(arguments);},createSelection:function(){this.selection=new _4c8(this);},get:function(_4ca,_4cb){if(_4cb&&this.field=="_item"&&!this.fields){return _4cb;}else{if(_4cb&&this.fields){var ret=[];var s=this.grid.store;_4c5.forEach(this.fields,function(f){ret=ret.concat(s.getValues(_4cb,f));});return ret;}else{if(!_4cb&&typeof _4ca==="string"){return this.inherited(arguments);}}}return (!_4cb?this.defaultValue:(!this.field?this.value:(this.field=="_item"?_4cb:this.grid.store.getValue(_4cb,this.field))));},_checkUpdateStatus:function(){if(this.updateDelay>0){var _4cc=false;if(this._endUpdateDelay){clearTimeout(this._endUpdateDelay);delete this._endUpdateDelay;_4cc=true;}if(!this.updating){this.beginUpdate();_4cc=true;}if(_4cc){var _4cd=this;this._endUpdateDelay=setTimeout(function(){delete _4cd._endUpdateDelay;_4cd.endUpdate();},this.updateDelay);}}},_onSet:function(item,_4ce,_4cf,_4d0){this._checkUpdateStatus();var idx=this.getItemIndex(item);if(idx>-1){this.updateRow(idx);}},_createItem:function(item,_4d1){var idty=this._hasIdentity?this.store.getIdentity(item):json.toJson(this.query)+":idx:"+_4d1+":sort:"+json.toJson(this.getSortProps());var o=this._by_idty[idty]={idty:idty,item:item};return o;},_addItem:function(item,_4d2,_4d3){this._by_idx[_4d2]=this._createItem(item,_4d2);if(!_4d3){this.updateRow(_4d2);}},_onNew:function(item,_4d4){this._checkUpdateStatus();var _4d5=this.get("rowCount");this._addingItem=true;this.updateRowCount(_4d5+1);this._addingItem=false;this._addItem(item,_4d5);this.showMessage();},_onDelete:function(item){this._checkUpdateStatus();var idx=this._getItemIndex(item,true);if(idx>=0){this._pages=[];this._bop=-1;this._eop=-1;var o=this._by_idx[idx];this._by_idx.splice(idx,1);delete this._by_idty[o.idty];this.updateRowCount(this.get("rowCount")-1);if(this.get("rowCount")===0){this.showMessage(this.noDataMessage);}}if(this.selection.isSelected(idx)){this.selection.deselect(idx);this.selection.selected.splice(idx,1);}},_onRevert:function(){this._refresh();},setStore:function(_4d6,_4d7,_4d8){if(this._requestsPending(0)){return;}this._setQuery(_4d7,_4d8);this._setStore(_4d6);this._refresh(true);},setQuery:function(_4d9,_4da){if(this._requestsPending(0)){return;}this._setQuery(_4d9,_4da);this._refresh(true);},setItems:function(_4db){this.items=_4db;this._setStore(this.store);this._refresh(true);},_setQuery:function(_4dc,_4dd){this.query=_4dc;this.queryOptions=_4dd||this.queryOptions;},_setStore:function(_4de){if(this.store&&this._store_connects){_4c5.forEach(this._store_connects,this.disconnect,this);}this.store=_4de;if(this.store){var f=this.store.getFeatures();var h=[];this._canEdit=!!f["dojo.data.api.Write"]&&!!f["dojo.data.api.Identity"];this._hasIdentity=!!f["dojo.data.api.Identity"];if(!!f["dojo.data.api.Notification"]&&!this.items){h.push(this.connect(this.store,"onSet","_onSet"));h.push(this.connect(this.store,"onNew","_onNew"));h.push(this.connect(this.store,"onDelete","_onDelete"));}if(this._canEdit){h.push(this.connect(this.store,"revert","_onRevert"));}this._store_connects=h;}},_onFetchBegin:function(size,req){if(!this.scroller){return;}if(this.rowCount!=size){if(req.isRender){this.scroller.init(size,this.keepRows,this.rowsPerPage);this.rowCount=size;this._setAutoHeightAttr(this.autoHeight,true);this._skipRowRenormalize=true;this.prerender();this._skipRowRenormalize=false;}else{this.updateRowCount(size);}}if(!size){this.views.render();this._resize();this.showMessage(this.noDataMessage);this.focus.initFocusView();}else{this.showMessage();}},_onFetchComplete:function(_4df,req){if(!this.scroller){return;}if(_4df&&_4df.length>0){_4c5.forEach(_4df,function(item,idx){this._addItem(item,req.start+idx,true);},this);this.updateRows(req.start,_4df.length);if(req.isRender){this.setScrollTop(0);this.postrender();}else{if(this._lastScrollTop){this.setScrollTop(this._lastScrollTop);}}if(has("ie")){html.setSelectable(this.domNode,this.selectable);}}delete this._lastScrollTop;if(!this._isLoaded){this._isLoading=false;this._isLoaded=true;}this._pending_requests[req.start]=false;},_onFetchError:function(err,req){delete this._lastScrollTop;if(!this._isLoaded){this._isLoading=false;this._isLoaded=true;this.showMessage(this.errorMessage);}this._pending_requests[req.start]=false;this.onFetchError(err,req);},onFetchError:function(err,req){},_fetch:function(_4e0,_4e1){_4e0=_4e0||0;if(this.store&&!this._pending_requests[_4e0]){if(!this._isLoaded&&!this._isLoading){this._isLoading=true;this.showMessage(this.loadingMessage);}this._pending_requests[_4e0]=true;try{if(this.items){var _4e2=this.items;var _4e3=this.store;this.rowsPerPage=_4e2.length;var req={start:_4e0,count:this.rowsPerPage,isRender:_4e1};this._onFetchBegin(_4e2.length,req);var _4e4=0;_4c5.forEach(_4e2,function(i){if(!_4e3.isItemLoaded(i)){_4e4++;}});if(_4e4===0){this._onFetchComplete(_4e2,req);}else{var _4e5=function(item){_4e4--;if(_4e4===0){this._onFetchComplete(_4e2,req);}};_4c5.forEach(_4e2,function(i){if(!_4e3.isItemLoaded(i)){_4e3.loadItem({item:i,onItem:_4e5,scope:this});}},this);}}else{this.store.fetch({start:_4e0,count:this.rowsPerPage,query:this.query,sort:this.getSortProps(),queryOptions:this.queryOptions,isRender:_4e1,onBegin:lang.hitch(this,"_onFetchBegin"),onComplete:lang.hitch(this,"_onFetchComplete"),onError:lang.hitch(this,"_onFetchError")});}}catch(e){this._onFetchError(e,{start:_4e0,count:this.rowsPerPage});}}},_clearData:function(){this.updateRowCount(0);this._by_idty={};this._by_idx=[];this._pages=[];this._bop=this._eop=-1;this._isLoaded=false;this._isLoading=false;},getItem:function(idx){var data=this._by_idx[idx];if(!data||(data&&!data.item)){this._preparePage(idx);return null;}return data.item;},getItemIndex:function(item){return this._getItemIndex(item,false);},_getItemIndex:function(item,_4e6){if(!_4e6&&!this.store.isItem(item)){return -1;}var idty=this._hasIdentity?this.store.getIdentity(item):null;for(var i=0,l=this._by_idx.length;i<l;i++){var d=this._by_idx[i];if(d&&((idty&&d.idty==idty)||(d.item===item))){return i;}}return -1;},filter:function(_4e7,_4e8){this.query=_4e7;if(_4e8){this._clearData();}this._fetch();},_getItemAttr:function(idx,attr){var item=this.getItem(idx);return (!item?this.fetchText:this.store.getValue(item,attr));},_render:function(){if(this.domNode.parentNode){this.scroller.init(this.get("rowCount"),this.keepRows,this.rowsPerPage);this.prerender();this._fetch(0,true);}},_requestsPending:function(_4e9){return this._pending_requests[_4e9];},_rowToPage:function(_4ea){return (this.rowsPerPage?Math.floor(_4ea/this.rowsPerPage):_4ea);},_pageToRow:function(_4eb){return (this.rowsPerPage?this.rowsPerPage*_4eb:_4eb);},_preparePage:function(_4ec){if((_4ec<this._bop||_4ec>=this._eop)&&!this._addingItem){var _4ed=this._rowToPage(_4ec);this._needPage(_4ed);this._bop=_4ed*this.rowsPerPage;this._eop=this._bop+(this.rowsPerPage||this.get("rowCount"));}},_needPage:function(_4ee){if(!this._pages[_4ee]){this._pages[_4ee]=true;this._requestPage(_4ee);}},_requestPage:function(_4ef){var row=this._pageToRow(_4ef);var _4f0=Math.min(this.rowsPerPage,this.get("rowCount")-row);if(_4f0>0){this._requests++;if(!this._requestsPending(row)){setTimeout(lang.hitch(this,"_fetch",row,false),1);}}},getCellName:function(_4f1){return _4f1.field;},_refresh:function(_4f2){this._clearData();this._fetch(0,_4f2);},sort:function(){this.edit.apply();this._lastScrollTop=this.scrollTop;this._refresh();},canSort:function(){return (!this._isLoading);},getSortProps:function(){var c=this.getCell(this.getSortIndex());if(!c){if(this.sortFields){return this.sortFields;}return null;}else{var desc=c["sortDesc"];var si=!(this.sortInfo>0);if(typeof desc=="undefined"){desc=si;}else{desc=si?!desc:desc;}return [{attribute:c.field,descending:desc}];}},styleRowState:function(_4f3){if(this.store&&this.store.getState){var _4f4=this.store.getState(_4f3.index),c="";for(var i=0,ss=["inflight","error","inserting"],s;s=ss[i];i++){if(_4f4[s]){c=" dojoxGridRow-"+s;break;}}_4f3.customClasses+=c;}},onStyleRow:function(_4f5){this.styleRowState(_4f5);this.inherited(arguments);},canEdit:function(_4f6,_4f7){return this._canEdit;},_copyAttr:function(idx,attr){var row={};var _4f8={};var src=this.getItem(idx);return this.store.getValue(src,attr);},doStartEdit:function(_4f9,_4fa){if(!this._cache[_4fa]){this._cache[_4fa]=this._copyAttr(_4fa,_4f9.field);}this.onStartEdit(_4f9,_4fa);},doApplyCellEdit:function(_4fb,_4fc,_4fd){this.store.fetchItemByIdentity({identity:this._by_idx[_4fc].idty,onItem:lang.hitch(this,function(item){var _4fe=this.store.getValue(item,_4fd);if(typeof _4fe=="number"){_4fb=isNaN(_4fb)?_4fb:parseFloat(_4fb);}else{if(typeof _4fe=="boolean"){_4fb=_4fb=="true"?true:_4fb=="false"?false:_4fb;}else{if(_4fe instanceof Date){var _4ff=new Date(_4fb);_4fb=isNaN(_4ff.getTime())?_4fb:_4ff;}}}this.store.setValue(item,_4fd,_4fb);this.onApplyCellEdit(_4fb,_4fc,_4fd);})});},doCancelEdit:function(_500){var _501=this._cache[_500];if(_501){this.updateRow(_500);delete this._cache[_500];}this.onCancelEdit.apply(this,arguments);},doApplyEdit:function(_502,_503){var _504=this._cache[_502];this.onApplyEdit(_502);},removeSelectedRows:function(){if(this._canEdit){this.edit.apply();var fx=lang.hitch(this,function(_505){if(_505.length){_4c5.forEach(_505,this.store.deleteItem,this.store);this.selection.clear();}});if(this.allItemsSelected){this.store.fetch({query:this.query,queryOptions:this.queryOptions,onComplete:fx});}else{fx(this.selection.getSelected());}}}});_4c9.cell_markupFactory=function(_506,node,_507){var _508=lang.trim(html.attr(node,"field")||"");if(_508){_507.field=_508;}_507.field=_507.field||_507.name;var _509=lang.trim(html.attr(node,"fields")||"");if(_509){_507.fields=_509.split(",");}if(_506){_506(node,_507);}};_4c9.markupFactory=function(_50a,node,ctor,_50b){return _4c7.markupFactory(_50a,node,ctor,lang.partial(_4c9.cell_markupFactory,_50b));};return _4c9;});