from pygments.lexer import RegexLexer, bygroups, words, include, inherit
from pygments.token import *

import re

__all__=['MznLexer']

class MznLexer(RegexLexer):
    name = 'Mzn'
    aliases = ['mzn']
    filenames = ['*.mzn', '*.fzn', '*.dzn']
    flags = re.MULTILINE | re.UNICODE

    tokens = {
        'root' : [
            (u'(/\\*)', bygroups(Comment), 'multi_line_comment__1'),
            (u'(%.*)', bygroups(Comment)),
            (u'(@.*@)', bygroups(Text)),
            (u'(\\b0o[0-7]+)', bygroups(Number)),
            (u'(\\b0x[0-9A-Fa-f]+)', bygroups(Number)),
            (u'(\\b0x[0-9A-Fa-f]+)', bygroups(Number)),
            (u'(\\b\\d+(?:(?:.\\d+)?[Ee][-+]?\\d+|.\\d+))', bygroups(Number)),
            (u'(\\b\\d+)', bygroups(Number)),
            (u'(\\\")', bygroups(String), 'string__1'),
            (u'(\\b(?:true|false)\\b)', bygroups(Literal)),
            (u'(\\bnot\\b|<->|->|<-|\\\\/|\\bxor\\b|/\\\\)', bygroups(Operator)),
            (u'(<|>|<=|>=|==|=|!=)', bygroups(Operator)),
            (u'(\\+|-|\\*|/|\\bdiv\\b|\\bmod\\b)', bygroups(Operator)),
            (u'(\\b(?:subset|superset|union|diff|symdiff|intersect|\\.\\.)\\b)', bygroups(Operator)),
            (u'(;)', bygroups(Punctuation)),
            (u'(:)', bygroups(Punctuation)),
            (u'(,)', bygroups(Punctuation)),
            (u'(\\{)', bygroups(Punctuation), 'main__1'),
            (u'(\\[)', bygroups(Punctuation), 'main__2'),
            (u'(\\()', bygroups(Punctuation), 'main__3'),
            (u'(\\}|\\]|\\))', bygroups(Generic.Error)),
            (u'(\\|)', bygroups(Generic.Error)),
            (u'(\\b(?:annotation|constraint|function|include|op|output|minimize|maximize|predicate|satisfy|solve|test|type)\\b)', bygroups(Keyword)),
            (u'(\\b(?:ann|array|bool|enum|float|int|list|of|par|set|string|tuple|var)\\b)', bygroups(Keyword.Type)),
            (u'(\\b(?:for|forall|if|then|elseif|else|endif|where|let|in)\\b)', bygroups(Keyword)),
            (u'(\\b(?:any|case|op|record)\\b)', bygroups(Generic.Error)),
            (u'(\\b(?:abort|abs|acosh|array_intersect|array_union|array1d|array2d|array3d|array4d|array5d|array6d|asin|assert|atan|bool2int|card|ceil|concat|cos|cosh|dom|dom_array|dom_size|fix|exp|floor|index_set|index_set_1of2|index_set_2of2|index_set_1of3|index_set_2of3|index_set_3of3|int2float|is_fixed|join|lb|lb_array|length|ln|log|log2|log10|min|max|pow|product|round|set2array|show|show_int|show_float|sin|sinh|sqrt|sum|tan|tanh|trace|ub|ub_array)\\b)', bygroups(Name.Builtin)),
            (u'(\\b(?:circuit|disjoint|maximum|maximum_arg|member|minimum|minimum_arg|network_flow|network_flow_cost|partition_set|range|roots|sliding_sum|subcircuit|sum_pred)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:alldifferent|all_different|all_disjoint|all_equal|alldifferent_except_0|nvalue|symmetric_all_different)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:lex2|lex_greater|lex_greatereq|lex_less|lex_lesseq|strict_lex2|value_precede|value_precede_chain)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:arg_sort|decreasing|increasing|sort)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:int_set_channel|inverse|inverse_set|link_set_to_booleans)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:among|at_least|at_most|at_most1|count|count_eq|count_geq|count_gt|count_leq|count_lt|count_neq|distribute|exactly|global_cardinality|global_cardinality_closed|global_cardinality_low_up|global_cardinality_low_up_closed)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:bin_packing|bin_packing_capa|bin_packing_load|diffn|diffn_k|diffn_nonstrict|diffn_nonstrict_k|geost|geost_bb|geost_smallest_bb|knapsack)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:alternative|cumulative|disjunctive|disjunctive_strict|span)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:regular|regular_nfa|table)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b[A-Za-z][A-Za-z0-9_]*|\'[^\'\\n\\r]*\')(\\()', bygroups(Name.Function, Punctuation), 'main__4'),
            (u'(\\b[A-Za-z][A-Za-z0-9_]*|\'[^\'\\n\\r]*\')', bygroups(Name.Variable)),
            ('(\n|\r|\r\n)', String),
            ('.', String),
        ],
        'main__1' : [
            (u'(\\})', bygroups(Punctuation), '#pop'),
            (u'(\\|)', bygroups(Punctuation)),
            (u'(/\\*)', bygroups(Comment), 'multi_line_comment__1'),
            (u'(%.*)', bygroups(Comment)),
            (u'(\\b0o[0-7]+)', bygroups(Number)),
            (u'(\\b0x[0-9A-Fa-f]+)', bygroups(Number)),
            (u'(\\b0x[0-9A-Fa-f]+)', bygroups(Number)),
            (u'(\\b\\d+(?:(?:.\\d+)?[Ee][-+]?\\d+|.\\d+))', bygroups(Number)),
            (u'(\\b\\d+)', bygroups(Number)),
            (u'(\\\")', bygroups(String), 'string__1'),
            (u'(\\b(?:true|false)\\b)', bygroups(Literal)),
            (u'(\\bnot\\b|<->|->|<-|\\\\/|\\bxor\\b|/\\\\)', bygroups(Operator)),
            (u'(<|>|<=|>=|==|=|!=)', bygroups(Operator)),
            (u'(\\+|-|\\*|/|\\bdiv\\b|\\bmod\\b)', bygroups(Operator)),
            (u'(\\b(?:subset|superset|union|diff|symdiff|intersect|\\.\\.)\\b)', bygroups(Operator)),
            (u'(;)', bygroups(Punctuation)),
            (u'(:)', bygroups(Punctuation)),
            (u'(,)', bygroups(Punctuation)),
            (u'(\\{)', bygroups(Punctuation), 'main__1'),
            (u'(\\[)', bygroups(Punctuation), 'main__2'),
            (u'(\\()', bygroups(Punctuation), 'main__3'),
            (u'(\\}|\\]|\\))', bygroups(Generic.Error)),
            (u'(\\|)', bygroups(Generic.Error)),
            (u'(\\b(?:annotation|constraint|function|include|op|output|minimize|maximize|predicate|satisfy|solve|test|type)\\b)', bygroups(Keyword)),
            (u'(\\b(?:ann|array|bool|enum|float|int|list|of|par|set|string|tuple|var)\\b)', bygroups(Keyword.Type)),
            (u'(\\b(?:for|forall|if|then|elseif|else|endif|where|let|in)\\b)', bygroups(Keyword)),
            (u'(\\b(?:any|case|op|record)\\b)', bygroups(Generic.Error)),
            (u'(\\b(?:abort|abs|acosh|array_intersect|array_union|array1d|array2d|array3d|array4d|array5d|array6d|asin|assert|atan|bool2int|card|ceil|concat|cos|cosh|dom|dom_array|dom_size|fix|exp|floor|index_set|index_set_1of2|index_set_2of2|index_set_1of3|index_set_2of3|index_set_3of3|int2float|is_fixed|join|lb|lb_array|length|ln|log|log2|log10|min|max|pow|product|round|set2array|show|show_int|show_float|sin|sinh|sqrt|sum|tan|tanh|trace|ub|ub_array)\\b)', bygroups(Name.Builtin)),
            (u'(\\b(?:circuit|disjoint|maximum|maximum_arg|member|minimum|minimum_arg|network_flow|network_flow_cost|partition_set|range|roots|sliding_sum|subcircuit|sum_pred)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:alldifferent|all_different|all_disjoint|all_equal|alldifferent_except_0|nvalue|symmetric_all_different)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:lex2|lex_greater|lex_greatereq|lex_less|lex_lesseq|strict_lex2|value_precede|value_precede_chain)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:arg_sort|decreasing|increasing|sort)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:int_set_channel|inverse|inverse_set|link_set_to_booleans)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:among|at_least|at_most|at_most1|count|count_eq|count_geq|count_gt|count_leq|count_lt|count_neq|distribute|exactly|global_cardinality|global_cardinality_closed|global_cardinality_low_up|global_cardinality_low_up_closed)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:bin_packing|bin_packing_capa|bin_packing_load|diffn|diffn_k|diffn_nonstrict|diffn_nonstrict_k|geost|geost_bb|geost_smallest_bb|knapsack)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:alternative|cumulative|disjunctive|disjunctive_strict|span)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:regular|regular_nfa|table)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b[A-Za-z][A-Za-z0-9_]*|\'[^\'\\n\\r]*\')(\\()', bygroups(Name.Function, Punctuation), 'main__4'),
            (u'(\\b[A-Za-z][A-Za-z0-9_]*|\'[^\'\\n\\r]*\')', bygroups(Name.Variable)),
            ('(\n|\r|\r\n)', String),
            ('.', String),
        ],
        'main__2' : [
            (u'(\\])', bygroups(Punctuation), '#pop'),
            (u'(\\|)', bygroups(Punctuation)),
            (u'(/\\*)', bygroups(Comment), 'multi_line_comment__1'),
            (u'(%.*)', bygroups(Comment)),
            (u'(\\b0o[0-7]+)', bygroups(Number)),
            (u'(\\b0x[0-9A-Fa-f]+)', bygroups(Number)),
            (u'(\\b0x[0-9A-Fa-f]+)', bygroups(Number)),
            (u'(\\b\\d+(?:(?:.\\d+)?[Ee][-+]?\\d+|.\\d+))', bygroups(Number)),
            (u'(\\b\\d+)', bygroups(Number)),
            (u'(\\\")', bygroups(String), 'string__1'),
            (u'(\\b(?:true|false)\\b)', bygroups(Literal)),
            (u'(\\bnot\\b|<->|->|<-|\\\\/|\\bxor\\b|/\\\\)', bygroups(Operator)),
            (u'(<|>|<=|>=|==|=|!=)', bygroups(Operator)),
            (u'(\\+|-|\\*|/|\\bdiv\\b|\\bmod\\b)', bygroups(Operator)),
            (u'(\\b(?:subset|superset|union|diff|symdiff|intersect|\\.\\.)\\b)', bygroups(Operator)),
            (u'(;)', bygroups(Punctuation)),
            (u'(:)', bygroups(Punctuation)),
            (u'(,)', bygroups(Punctuation)),
            (u'(\\{)', bygroups(Punctuation), 'main__1'),
            (u'(\\[)', bygroups(Punctuation), 'main__2'),
            (u'(\\()', bygroups(Punctuation), 'main__3'),
            (u'(\\}|\\]|\\))', bygroups(Generic.Error)),
            (u'(\\|)', bygroups(Generic.Error)),
            (u'(\\b(?:annotation|constraint|function|include|op|output|minimize|maximize|predicate|satisfy|solve|test|type)\\b)', bygroups(Keyword)),
            (u'(\\b(?:ann|array|bool|enum|float|int|list|of|par|set|string|tuple|var)\\b)', bygroups(Keyword.Type)),
            (u'(\\b(?:for|forall|if|then|elseif|else|endif|where|let|in)\\b)', bygroups(Keyword)),
            (u'(\\b(?:any|case|op|record)\\b)', bygroups(Generic.Error)),
            (u'(\\b(?:abort|abs|acosh|array_intersect|array_union|array1d|array2d|array3d|array4d|array5d|array6d|asin|assert|atan|bool2int|card|ceil|concat|cos|cosh|dom|dom_array|dom_size|fix|exp|floor|index_set|index_set_1of2|index_set_2of2|index_set_1of3|index_set_2of3|index_set_3of3|int2float|is_fixed|join|lb|lb_array|length|ln|log|log2|log10|min|max|pow|product|round|set2array|show|show_int|show_float|sin|sinh|sqrt|sum|tan|tanh|trace|ub|ub_array)\\b)', bygroups(Name.Builtin)),
            (u'(\\b(?:circuit|disjoint|maximum|maximum_arg|member|minimum|minimum_arg|network_flow|network_flow_cost|partition_set|range|roots|sliding_sum|subcircuit|sum_pred)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:alldifferent|all_different|all_disjoint|all_equal|alldifferent_except_0|nvalue|symmetric_all_different)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:lex2|lex_greater|lex_greatereq|lex_less|lex_lesseq|strict_lex2|value_precede|value_precede_chain)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:arg_sort|decreasing|increasing|sort)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:int_set_channel|inverse|inverse_set|link_set_to_booleans)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:among|at_least|at_most|at_most1|count|count_eq|count_geq|count_gt|count_leq|count_lt|count_neq|distribute|exactly|global_cardinality|global_cardinality_closed|global_cardinality_low_up|global_cardinality_low_up_closed)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:bin_packing|bin_packing_capa|bin_packing_load|diffn|diffn_k|diffn_nonstrict|diffn_nonstrict_k|geost|geost_bb|geost_smallest_bb|knapsack)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:alternative|cumulative|disjunctive|disjunctive_strict|span)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:regular|regular_nfa|table)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b[A-Za-z][A-Za-z0-9_]*|\'[^\'\\n\\r]*\')(\\()', bygroups(Name.Function, Punctuation), 'main__4'),
            (u'(\\b[A-Za-z][A-Za-z0-9_]*|\'[^\'\\n\\r]*\')', bygroups(Name.Variable)),
            ('(\n|\r|\r\n)', String),
            ('.', String),
        ],
        'main__3' : [
            (u'(\\))', bygroups(Punctuation), '#pop'),
            (u'(/\\*)', bygroups(Comment), 'multi_line_comment__1'),
            (u'(%.*)', bygroups(Comment)),
            (u'(\\b0o[0-7]+)', bygroups(Number)),
            (u'(\\b0x[0-9A-Fa-f]+)', bygroups(Number)),
            (u'(\\b0x[0-9A-Fa-f]+)', bygroups(Number)),
            (u'(\\b\\d+(?:(?:.\\d+)?[Ee][-+]?\\d+|.\\d+))', bygroups(Number)),
            (u'(\\b\\d+)', bygroups(Number)),
            (u'(\\\")', bygroups(String), 'string__1'),
            (u'(\\b(?:true|false)\\b)', bygroups(Literal)),
            (u'(\\bnot\\b|<->|->|<-|\\\\/|\\bxor\\b|/\\\\)', bygroups(Operator)),
            (u'(<|>|<=|>=|==|=|!=)', bygroups(Operator)),
            (u'(\\+|-|\\*|/|\\bdiv\\b|\\bmod\\b)', bygroups(Operator)),
            (u'(\\b(?:subset|superset|union|diff|symdiff|intersect|\\.\\.)\\b)', bygroups(Operator)),
            (u'(;)', bygroups(Punctuation)),
            (u'(:)', bygroups(Punctuation)),
            (u'(,)', bygroups(Punctuation)),
            (u'(\\{)', bygroups(Punctuation), 'main__1'),
            (u'(\\[)', bygroups(Punctuation), 'main__2'),
            (u'(\\()', bygroups(Punctuation), 'main__3'),
            (u'(\\}|\\]|\\))', bygroups(Generic.Error)),
            (u'(\\|)', bygroups(Generic.Error)),
            (u'(\\b(?:annotation|constraint|function|include|op|output|minimize|maximize|predicate|satisfy|solve|test|type)\\b)', bygroups(Keyword)),
            (u'(\\b(?:ann|array|bool|enum|float|int|list|of|par|set|string|tuple|var)\\b)', bygroups(Keyword.Type)),
            (u'(\\b(?:for|forall|if|then|elseif|else|endif|where|let|in)\\b)', bygroups(Keyword)),
            (u'(\\b(?:any|case|op|record)\\b)', bygroups(Generic.Error)),
            (u'(\\b(?:abort|abs|acosh|array_intersect|array_union|array1d|array2d|array3d|array4d|array5d|array6d|asin|assert|atan|bool2int|card|ceil|concat|cos|cosh|dom|dom_array|dom_size|fix|exp|floor|index_set|index_set_1of2|index_set_2of2|index_set_1of3|index_set_2of3|index_set_3of3|int2float|is_fixed|join|lb|lb_array|length|ln|log|log2|log10|min|max|pow|product|round|set2array|show|show_int|show_float|sin|sinh|sqrt|sum|tan|tanh|trace|ub|ub_array)\\b)', bygroups(Name.Builtin)),
            (u'(\\b(?:circuit|disjoint|maximum|maximum_arg|member|minimum|minimum_arg|network_flow|network_flow_cost|partition_set|range|roots|sliding_sum|subcircuit|sum_pred)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:alldifferent|all_different|all_disjoint|all_equal|alldifferent_except_0|nvalue|symmetric_all_different)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:lex2|lex_greater|lex_greatereq|lex_less|lex_lesseq|strict_lex2|value_precede|value_precede_chain)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:arg_sort|decreasing|increasing|sort)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:int_set_channel|inverse|inverse_set|link_set_to_booleans)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:among|at_least|at_most|at_most1|count|count_eq|count_geq|count_gt|count_leq|count_lt|count_neq|distribute|exactly|global_cardinality|global_cardinality_closed|global_cardinality_low_up|global_cardinality_low_up_closed)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:bin_packing|bin_packing_capa|bin_packing_load|diffn|diffn_k|diffn_nonstrict|diffn_nonstrict_k|geost|geost_bb|geost_smallest_bb|knapsack)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:alternative|cumulative|disjunctive|disjunctive_strict|span)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:regular|regular_nfa|table)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b[A-Za-z][A-Za-z0-9_]*|\'[^\'\\n\\r]*\')(\\()', bygroups(Name.Function, Punctuation), 'main__4'),
            (u'(\\b[A-Za-z][A-Za-z0-9_]*|\'[^\'\\n\\r]*\')', bygroups(Name.Variable)),
            ('(\n|\r|\r\n)', String),
            ('.', String),
        ],
        'main__4' : [
            (u'(\\))', bygroups(Punctuation), '#pop'),
            (u'(/\\*)', bygroups(Comment), 'multi_line_comment__1'),
            (u'(%.*)', bygroups(Comment)),
            (u'(\\b0o[0-7]+)', bygroups(Number)),
            (u'(\\b0x[0-9A-Fa-f]+)', bygroups(Number)),
            (u'(\\b0x[0-9A-Fa-f]+)', bygroups(Number)),
            (u'(\\b\\d+(?:(?:.\\d+)?[Ee][-+]?\\d+|.\\d+))', bygroups(Number)),
            (u'(\\b\\d+)', bygroups(Number)),
            (u'(\\\")', bygroups(String), 'string__1'),
            (u'(\\b(?:true|false)\\b)', bygroups(Literal)),
            (u'(\\bnot\\b|<->|->|<-|\\\\/|\\bxor\\b|/\\\\)', bygroups(Operator)),
            (u'(<|>|<=|>=|==|=|!=)', bygroups(Operator)),
            (u'(\\+|-|\\*|/|\\bdiv\\b|\\bmod\\b)', bygroups(Operator)),
            (u'(\\b(?:subset|superset|union|diff|symdiff|intersect|\\.\\.)\\b)', bygroups(Operator)),
            (u'(;)', bygroups(Punctuation)),
            (u'(:)', bygroups(Punctuation)),
            (u'(,)', bygroups(Punctuation)),
            (u'(\\{)', bygroups(Punctuation), 'main__1'),
            (u'(\\[)', bygroups(Punctuation), 'main__2'),
            (u'(\\()', bygroups(Punctuation), 'main__3'),
            (u'(\\}|\\]|\\))', bygroups(Generic.Error)),
            (u'(\\|)', bygroups(Generic.Error)),
            (u'(\\b(?:annotation|constraint|function|include|op|output|minimize|maximize|predicate|satisfy|solve|test|type)\\b)', bygroups(Keyword)),
            (u'(\\b(?:ann|array|bool|enum|float|int|list|of|par|set|string|tuple|var)\\b)', bygroups(Keyword.Type)),
            (u'(\\b(?:for|forall|if|then|elseif|else|endif|where|let|in)\\b)', bygroups(Keyword)),
            (u'(\\b(?:any|case|op|record)\\b)', bygroups(Generic.Error)),
            (u'(\\b(?:abort|abs|acosh|array_intersect|array_union|array1d|array2d|array3d|array4d|array5d|array6d|asin|assert|atan|bool2int|card|ceil|concat|cos|cosh|dom|dom_array|dom_size|fix|exp|floor|index_set|index_set_1of2|index_set_2of2|index_set_1of3|index_set_2of3|index_set_3of3|int2float|is_fixed|join|lb|lb_array|length|ln|log|log2|log10|min|max|pow|product|round|set2array|show|show_int|show_float|sin|sinh|sqrt|sum|tan|tanh|trace|ub|ub_array)\\b)', bygroups(Name.Builtin)),
            (u'(\\b(?:circuit|disjoint|maximum|maximum_arg|member|minimum|minimum_arg|network_flow|network_flow_cost|partition_set|range|roots|sliding_sum|subcircuit|sum_pred)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:alldifferent|all_different|all_disjoint|all_equal|alldifferent_except_0|nvalue|symmetric_all_different)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:lex2|lex_greater|lex_greatereq|lex_less|lex_lesseq|strict_lex2|value_precede|value_precede_chain)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:arg_sort|decreasing|increasing|sort)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:int_set_channel|inverse|inverse_set|link_set_to_booleans)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:among|at_least|at_most|at_most1|count|count_eq|count_geq|count_gt|count_leq|count_lt|count_neq|distribute|exactly|global_cardinality|global_cardinality_closed|global_cardinality_low_up|global_cardinality_low_up_closed)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:bin_packing|bin_packing_capa|bin_packing_load|diffn|diffn_k|diffn_nonstrict|diffn_nonstrict_k|geost|geost_bb|geost_smallest_bb|knapsack)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:alternative|cumulative|disjunctive|disjunctive_strict|span)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:regular|regular_nfa|table)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b[A-Za-z][A-Za-z0-9_]*|\'[^\'\\n\\r]*\')(\\()', bygroups(Name.Function, Punctuation), 'main__4'),
            (u'(\\b[A-Za-z][A-Za-z0-9_]*|\'[^\'\\n\\r]*\')', bygroups(Name.Variable)),
            ('(\n|\r|\r\n)', String),
            ('.', String),
        ],
        'multi_line_comment__1' : [
            (u'(\\*/)', bygroups(Comment), '#pop'),
            ('(\n|\r|\r\n)', String),
            ('.', Comment),
        ],
        'string__1' : [
            (u'(\\\")', bygroups(String), '#pop'),
            (u'(\\\\\\()', bygroups(Punctuation), 'string__2'),
            (u'(\\\\[\"\'\\\\nrvt])', bygroups(String.Escape)),
            (u'([^\\\"\\\\\\n\\r]+)', bygroups(String)),
            ('(\n|\r|\r\n)', String),
            ('.', String),
        ],
        'string__2' : [
            (u'(\\))', bygroups(Punctuation), '#pop'),
            (u'(/\\*)', bygroups(Comment), 'multi_line_comment__1'),
            (u'(%.*)', bygroups(Comment)),
            (u'(\\b0o[0-7]+)', bygroups(Number)),
            (u'(\\b0x[0-9A-Fa-f]+)', bygroups(Number)),
            (u'(\\b0x[0-9A-Fa-f]+)', bygroups(Number)),
            (u'(\\b\\d+(?:(?:.\\d+)?[Ee][-+]?\\d+|.\\d+))', bygroups(Number)),
            (u'(\\b\\d+)', bygroups(Number)),
            (u'(\\\")', bygroups(String), 'string__1'),
            (u'(\\b(?:true|false)\\b)', bygroups(Literal)),
            (u'(\\bnot\\b|<->|->|<-|\\\\/|\\bxor\\b|/\\\\)', bygroups(Operator)),
            (u'(<|>|<=|>=|==|=|!=)', bygroups(Operator)),
            (u'(\\+|-|\\*|/|\\bdiv\\b|\\bmod\\b)', bygroups(Operator)),
            (u'(\\b(?:subset|superset|union|diff|symdiff|intersect|\\.\\.)\\b)', bygroups(Operator)),
            (u'(;)', bygroups(Punctuation)),
            (u'(:)', bygroups(Punctuation)),
            (u'(,)', bygroups(Punctuation)),
            (u'(\\{)', bygroups(Punctuation), 'main__1'),
            (u'(\\[)', bygroups(Punctuation), 'main__2'),
            (u'(\\()', bygroups(Punctuation), 'main__3'),
            (u'(\\}|\\]|\\))', bygroups(Generic.Error)),
            (u'(\\|)', bygroups(Generic.Error)),
            (u'(\\b(?:annotation|constraint|function|include|op|output|minimize|maximize|predicate|satisfy|solve|test|type)\\b)', bygroups(Keyword)),
            (u'(\\b(?:ann|array|bool|enum|float|int|list|of|par|set|string|tuple|var)\\b)', bygroups(Keyword.Type)),
            (u'(\\b(?:for|forall|if|then|elseif|else|endif|where|let|in)\\b)', bygroups(Keyword)),
            (u'(\\b(?:any|case|op|record)\\b)', bygroups(Generic.Error)),
            (u'(\\b(?:abort|abs|acosh|array_intersect|array_union|array1d|array2d|array3d|array4d|array5d|array6d|asin|assert|atan|bool2int|card|ceil|concat|cos|cosh|dom|dom_array|dom_size|fix|exp|floor|index_set|index_set_1of2|index_set_2of2|index_set_1of3|index_set_2of3|index_set_3of3|int2float|is_fixed|join|lb|lb_array|length|ln|log|log2|log10|min|max|pow|product|round|set2array|show|show_int|show_float|sin|sinh|sqrt|sum|tan|tanh|trace|ub|ub_array)\\b)', bygroups(Name.Builtin)),
            (u'(\\b(?:circuit|disjoint|maximum|maximum_arg|member|minimum|minimum_arg|network_flow|network_flow_cost|partition_set|range|roots|sliding_sum|subcircuit|sum_pred)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:alldifferent|all_different|all_disjoint|all_equal|alldifferent_except_0|nvalue|symmetric_all_different)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:lex2|lex_greater|lex_greatereq|lex_less|lex_lesseq|strict_lex2|value_precede|value_precede_chain)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:arg_sort|decreasing|increasing|sort)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:int_set_channel|inverse|inverse_set|link_set_to_booleans)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:among|at_least|at_most|at_most1|count|count_eq|count_geq|count_gt|count_leq|count_lt|count_neq|distribute|exactly|global_cardinality|global_cardinality_closed|global_cardinality_low_up|global_cardinality_low_up_closed)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:bin_packing|bin_packing_capa|bin_packing_load|diffn|diffn_k|diffn_nonstrict|diffn_nonstrict_k|geost|geost_bb|geost_smallest_bb|knapsack)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:alternative|cumulative|disjunctive|disjunctive_strict|span)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b(?:regular|regular_nfa|table)\\b)', bygroups(Name.Builtin.Pseudo)),
            (u'(\\b[A-Za-z][A-Za-z0-9_]*|\'[^\'\\n\\r]*\')(\\()', bygroups(Name.Function, Punctuation), 'main__4'),
            (u'(\\b[A-Za-z][A-Za-z0-9_]*|\'[^\'\\n\\r]*\')', bygroups(Name.Variable)),
            ('(\n|\r|\r\n)', String),
            ('.', String),
        ]
    }

class MznDefLexer(MznLexer):
    name = 'MiniZincDef'
    aliases = ['minizincdef']

    tokens = {
        'root': [
            (r'<[0-9a-zA-Z- ]+>', Comment.Special),
            (r'"/\\"', String),
            (r'"""', String),
            (r'"\\\("', String),
            (r'"\\.\\.\\."', Comment.Special),
            (r'\[[^ ]', String.Regex, 'regex'),
            (r'::=', Comment.Special),
            (words(('|',), prefix=r'^\s*'), Comment.Special),
            inherit
        ],
        'main__1': [
            (r'<[0-9a-zA-Z- ]+>', Comment.Special),
            (r'"/\\"', String),
            (r'"""', String),
            (r'"\\\("', String),
            (r'"\\.\\.\\."', String),
            (r'\[[^ ]', String.Regex, 'regex'),
            (r'::=', Comment.Special),
            (words(('|',), prefix=r'^\s*'), Comment.Special),
            inherit  
        ],
        'main__2': [
            (r'<[0-9a-zA-Z- ]+>', Comment.Special),
            (r'"/\\"', String),
            (r'"""', String),
            (r'"\\\("', String),
            (r'"\\.\\.\\."', String),
            (r'\[[^ ]', String.Regex, 'regex'),
            (r'::=', Comment.Special),
            (words(('|',), prefix=r'^\s*'), Comment.Special),
            inherit  
        ],
        'main__3': [
            (r'<[0-9a-zA-Z- ]+>', Comment.Special),
            (r'"/\\"', String),
            (r'"""', String),
            (r'"\\\("', String),
            (r'"\\.\\.\\."', String),
            (r'\[[^ ]', String.Regex, 'regex'),
            (r'::=', Comment.Special),
            (words(('|',), prefix=r'^\s*'), Comment.Special),
            inherit  
        ],
        'main__4': [
            (r'<[0-9a-zA-Z- ]+>', Comment.Special),
            (r'"/\\"', String),
            (r'"""', String),
            (r'"\\\("', String),
            (r'"\\.\\.\\."', String),
            (r'\[[^ ]', String.Regex, 'regex'),
            (r'::=', Comment.Special),
            (words(('|',), prefix=r'^\s*'), Comment.Special),
            inherit  
        ],
        'regex': [
            (r'\]', String.Regex, '#pop'),
            (r'.', String.Regex)
        ]
    }
