import collections
import inspect
import unittest


def fun():
    return 1


def gen():
    yield 1


def make_closure():
    a = 1
    b = 2
    def closure(x):
        return a + b + x
    return closure


def make_gen_closure():
    a = 1
    b = 2
    def gen_closure(x):
        yield a + b + x
    return gen_closure


class Class:
    def meth(self):
        pass


entities = (
    fun,
    gen,
    gen(),
    Class,
    Class.meth,
    Class().meth,
    inspect,
)


class TestInspect(unittest.TestCase):
    def _test_is_helper(self, f, *entities_true):
        for entity in entities:
            result = f(entity)
            if entity in entities_true:
                self.assertTrue(result)
            else:
                self.assertFalse(result)

    def test_isfunction(self):
        self._test_is_helper(inspect.isfunction, entities[0], entities[4])

    def test_isgeneratorfunction(self):
        self._test_is_helper(inspect.isgeneratorfunction, entities[1])

    def test_isgenerator(self):
        self._test_is_helper(inspect.isgenerator, entities[2])

    def test_iscoroutinefunction(self):
        self._test_is_helper(inspect.iscoroutinefunction, entities[1])

    def test_iscoroutine(self):
        self._test_is_helper(inspect.iscoroutine, entities[2])

    def test_ismethod(self):
        self._test_is_helper(inspect.ismethod, entities[5])

    def test_isclass(self):
        self._test_is_helper(inspect.isclass, entities[3])

    def test_ismodule(self):
        self._test_is_helper(inspect.ismodule, entities[6])

    def test_signature(self):
        self.assertEqual(inspect.signature(globals).parameters, collections.OrderedDict())
        self.assertEqual(len(inspect.signature(abs).parameters), 1)
        self.assertEqual(len(inspect.signature(hasattr).parameters), 2)
        self.assertEqual(len(inspect.signature(setattr).parameters), 3)
        self.assertEqual(len(inspect.signature(lambda: 0).parameters), 0)
        self.assertEqual(len(inspect.signature(lambda x: 0).parameters), 1)
        self.assertEqual(len(inspect.signature(lambda *, x: 0).parameters), 1)
        self.assertEqual(len(inspect.signature(lambda x, y: 0).parameters), 2)
        self.assertEqual(len(inspect.signature(lambda x, y, z: 0).parameters), 3)
        self.assertEqual(len(inspect.signature(lambda x, y, *, z: 0).parameters), 3)
        self.assertEqual(len(inspect.signature(gen).parameters), 0)
        self.assertEqual(len(inspect.signature(make_closure()).parameters), 1)
        self.assertEqual(len(inspect.signature(make_gen_closure()).parameters), 1)
