#!/usr/bin/env ruby

###
#
# Windows Specific Constants
# --------------------------
#
# These are put into the global namespace for now
# so that they can be referenced globally.  
#
###

##
#
# Permissions
#
##
DELETE                   = 0x00010000
READ_CONTROL             = 0x00020000
WRITE_DAC                = 0x00040000
WRITE_OWNER              = 0x00080000
SYNCHRONIZE              = 0x00100000
STANDARD_RIGHTS_REQUIRED = 0x000f0000
STANDARD_RIGHTS_READ     = READ_CONTROL
STANDARD_RIGHTS_WRITE    = READ_CONTROL
STANDARD_RIGHTS_EXECUTE  = READ_CONTROL
STANDARD_RIGHTS_ALL      = 0x001f0000
SPECIFIC_RIGHTS_ALL      = 0x0000ffff
MAXIMUM_ALLOWED          = 0x02000000
GENERIC_READ             = 0x80000000
GENERIC_WRITE            = 0x40000000
GENERIC_EXECUTE          = 0x20000000
GENERIC_ALL              = 0x10000000

##
#
# Page Protections
#
##
PAGE_NOACCESS            = 0x00000001
PAGE_READONLY            = 0x00000002
PAGE_READWRITE           = 0x00000004
PAGE_WRITECOPY           = 0x00000008
PAGE_EXECUTE             = 0x00000010
PAGE_EXECUTE_READ        = 0x00000020
PAGE_EXECUTE_READWRITE   = 0x00000040
PAGE_EXECUTE_WRITECOPY   = 0x00000080
PAGE_GUARD               = 0x00000100
PAGE_NOCACHE             = 0x00000200
PAGE_WRITECOMBINE        = 0x00000400
MEM_COMMIT               = 0x00001000
MEM_RESERVE              = 0x00002000
MEM_DECOMMIT             = 0x00004000
MEM_RELEASE              = 0x00008000
MEM_FREE                 = 0x00010000
MEM_PRIVATE              = 0x00020000
MEM_MAPPED               = 0x00040000
MEM_RESET                = 0x00080000
MEM_TOP_DOWN             = 0x00100000
MEM_WRITE_WATCH          = 0x00200000
MEM_PHYSICAL             = 0x00400000
MEM_LARGE_PAGES          = 0x20000000
MEM_4MB_PAGES            = 0x80000000
SEC_FILE                 = 0x00800000
SEC_IMAGE                = 0x01000000
SEC_RESERVE              = 0x04000000
SEC_COMMIT               = 0x08000000
SEC_NOCACHE              = 0x10000000
MEM_IMAGE                = SEC_IMAGE

##
#
# Registry Permissions
#
##
KEY_QUERY_VALUE          = 0x00000001
KEY_SET_VALUE            = 0x00000002
KEY_CREATE_SUB_KEY       = 0x00000004
KEY_ENUMERATE_SUB_KEYS   = 0x00000008
KEY_NOTIFY               = 0x00000010
KEY_CREATE_LINK          = 0x00000020
KEY_READ                 = (STANDARD_RIGHTS_READ | KEY_QUERY_VALUE | 
                            KEY_ENUMERATE_SUB_KEYS | KEY_NOTIFY) & ~SYNCHRONIZE
KEY_WRITE                = (STANDARD_RIGHTS_WRITE | KEY_SET_VALUE | 
                            KEY_CREATE_SUB_KEY) & ~SYNCHRONIZE
KEY_EXECUTE              = KEY_READ
KEY_ALL_ACCESS           = (STANDARD_RIGHTS_ALL | KEY_QUERY_VALUE |
                            KEY_SET_VALUE | KEY_CREATE_SUB_KEY | 
                            KEY_ENUMERATE_SUB_KEYS | KEY_NOTIFY |
                            KEY_CREATE_LINK) & ~SYNCHRONIZE

##
#
# Registry
#
##
HKEY_CLASSES_ROOT        = 0x80000000
HKEY_CURRENT_USER        = 0x80000001
HKEY_LOCAL_MACHINE       = 0x80000002
HKEY_USERS               = 0x80000003
HKEY_PERFORMANCE_DATA    = 0x80000004
HKEY_CURRENT_CONFIG      = 0x80000005
HKEY_DYN_DATA            = 0x80000006

REG_NONE                 = 0
REG_SZ                   = 1
REG_EXPAND_SZ            = 2
REG_BINARY               = 3
REG_DWORD                = 4
REG_DWORD_LITTLE_ENDIAN  = 4
REG_DWORD_BIG_ENDIAN     = 5
REG_LINK                 = 6
REG_MULTI_SZ             = 7

##
#
# Process Permissions
#
##
PROCESS_TERMINATE        = 0x00000001
PROCESS_CREATE_THREAD    = 0x00000002
PROCESS_SET_SESSIONID    = 0x00000004
PROCESS_VM_OPERATION     = 0x00000008
PROCESS_VM_READ          = 0x00000010
PROCESS_VM_WRITE         = 0x00000020
PROCESS_DUP_HANDLE       = 0x00000040
PROCESS_CREATE_PROCESS   = 0x00000080
PROCESS_SET_QUOTA        = 0x00000100
PROCESS_SET_INFORMATION  = 0x00000200
PROCESS_QUERY_INFORMATION= 0x00000400
PROCESS_SUSPEND_RESUME   = 0x00000800
PROCESS_ALL_ACCESS       = STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0xFFF

##
#
# Thread Permissions
#
##
THREAD_TERMINATE            = 0x00000001
THREAD_SUSPEND_RESUME       = 0x00000002
THREAD_GET_CONTEXT          = 0x00000008
THREAD_SET_CONTEXT          = 0x00000010
THREAD_SET_INFORMATION      = 0x00000020
THREAD_QUERY_INFORMATION    = 0x00000040  
THREAD_SET_THREAD_TOKEN     = 0x00000080
THREAD_IMPERSONATE          = 0x00000100
THREAD_DIRECT_IMPERSONATION = 0x00000200
THREAD_ALL_ACCESS           = STANDARD_RIGHTS_REQUIRED | SYNCHRONIZE | 0x3FF

##
#
# Creation flags
#
##

CREATE_SUSPENDED            = 0x00000004

##
#
# Event Log
#
##
EVENTLOG_SEQUENTIAL_READ    = 0x00000001
EVENTLOG_SEEK_READ          = 0x00000002
EVENTLOG_FORWARDS_READ      = 0x00000004
EVENTLOG_BACKWARDS_READ     = 0x00000008

##
#
# Event Log
#
##
EWX_LOGOFF                  = 0
EWX_SHUTDOWN                = 0x00000001
EWX_REBOOT                  = 0x00000002
EWX_FORCE                   = 0x00000004
EWX_POWEROFF                = 0x00000008
EWX_FORCEIFHUNG             = 0x00000010
