require 'rex/proto/sunrpc'

module Msf

###
#
# This mixin provides utility methods for interacting with a SunRPC service on
# a remote machine.  These methods may generally be useful in the context of
# exploitation.  This mixin extends the Tcp exploit mixin. Only one SunRPC 
# service can be accessed at a time using this class.
#
###
module Exploit::Remote::SunRPC
	include Exploit::Remote::Tcp

	XDR = Rex::Proto::SunRPC::XDR

	def initialize(info = {})
		super

		register_evasion_options(
			[
				OptBool.new('ONCRPC::tcp_request_fragmentation', [false, 'Enable fragmentation of TCP ONC/RPC requests', 'false']),
			], Msf::Exploit::Remote::SunRPC
		)


		register_advanced_options(
			[
# XXX: Use portmapper to do call
			], Msf::Exploit::Remote::SunRPC)

		register_options(
			[
# XXX: XPORT
				Opt::RHOST,
				Opt::RPORT(111),
			], Msf::Exploit::Remote::SunRPC
		)
	end

	def sunrpc_create(protocol, program, version)
		self.rpcobj = Rex::Proto::SunRPC::Client.new(rhost, rport.to_i, protocol, program, version)
		if datastore['ONCRPC::tcp_request_fragmentation'] == true
			self.rpcobj.should_fragment = 1
		end

#		if datastore['XPORT']
#			rpcobj.pport = datastore['XPORT']
#		else
			rpcobj.create
#		end
	end

	def sunrpc_call(proc, buf)
		rpcobj.call(proc, buf)
	end

	def sunrpc_destroy
		rpcobj.destroy
		rpcobj = nil
	end

	def sunrpc_authnull(*args)
		rpcobj.authnull_create(*args)
	end

	def sunrpc_authunix(*args)
		rpcobj.authunix_create(*args)
	end

	# Used to track the last SunRPC context 
	attr_accessor	:rpcobj
end

end
