#!/usr/bin/env ruby

$:.unshift(File.join(File.dirname(__FILE__), '..', '..', '..'))

require 'test/unit'
require 'rex'
require 'msf/core'
require 'msf/core/exploit/seh'

module Msf

class Exploit::Seh::UnitTest < Test::Unit::TestCase

	class Stub < Msf::Exploit::Remote
		include Msf::Exploit::Seh
	end

	def test_seh
		e = Stub.new
		r = e.generate_seh_record(0x41414141)

		assert_equal("\xeb\x06", r[0, 2])
		assert_equal("\x41\x41\x41\x41", r[4, 4])
	end

end

end
