module Msf

###
#
# This module provides methods for receiving packets through the PcapX module
#
###

module Exploit::Pcap

	#
	# Initializes an instance of an exploit module that receives raw packets
	#
	
	def initialize(info = {})
		super

		register_options(
			[
				OptString.new('INTERFACE', [true, 'The name of the interface to sniff', 'eth0'])
			], Msf::Exploit::Pcap
		)

		begin
			require 'PcapX'
			@pcapx_loaded = true
		rescue ::Exception => e
			@pcapx_loaded = false
			@pcapx_error  = e
		end
	
	end

	#
	# Opens a network device for capture
	#
	def pcap_open_live(device = 'eth0', snaplen=65535, promisc=true)
	
		if (not @pcapx_loaded)
			print_status("The PcapX module is not available: #{@pcapx_error.to_s}")
			raise RuntimeError, "PcapX not available"
			return
		end

		self.capture =  ::PcapX::Capture.open_live(device, snaplen.to_i, promisc)
	end
	
	#
	# Sets the pcap filter
	# 
	def pcap_setfilter(filter='')
		return if not self.capture
		self.capture.setfilter(filter)
	end
	
	#
	# Opens a network device based on datastore
	#
	def pcap_open(filter='')
		pcap_open_live(datastore['INTERFACE'])
		pcap_setfilter(filter)
	end
	

	attr_accessor :capture
end

end
