module Msf

require 'msf/core/exploit/tcp'

###
#
# This module exposes methods that may be useful to exploits that deal with
# servers that speak the File Transfer Protocol (FTP).
#
###
module Exploit::Remote::Ftp

	include Exploit::Remote::Tcp
	
	#
	# Creates an instance of an FTP exploit module.
	#
	def initialize(info = {})
		super

		# Register the options that all FTP exploits may make use of.
		register_options(
			[
				Opt::RHOST,
				Opt::RPORT(21),
				OptString.new('FTPUSER', [ false, 'The username to authenticate as', 'anonymous']),
				OptString.new('FTPPASS', [ false, 'The password for the specified username', 'mozilla@example.com'])
			], Msf::Exploit::Remote::Ftp)
	end

	#
	# This method establishes an FTP connection to host and port specified by
	# the RHOST and RPORT options, respectively.  After connecting, the banner
	# message is read in and stored in the 'banner' attribute.
	#
	def connect(global = true, verbose = true)
		print_status("Connecting to FTP server #{rhost}:#{rport}...") if verbose

		fd = super(global)
	
		# Wait for a banner to arrive...
		self.banner = fd.get_once

		print_status("Connected to target FTP server.") if verbose
	
		# Return the file descriptor to the caller
		fd
	end

	#
	# Connect and login to the remote FTP server using the credentials 
	# that have been supplied in the exploit options.
	#
	def connect_login(global = true, verbose = true)
		ftpsock = connect(global, verbose)

		if (not (user and pass))
			print_status("No username and password were supplied, unable to login")
			return false
		end

		print_status("Authenticating as #{user} with password #{pass}...") if verbose
		res = send_user(user, ftpsock)
		
		if (res !~ /^(331|2)/)
			print_status("The server rejected our username")
			return false
		end

		if (pass)
			print_status("Sending password...") if verbose
			res = send_pass(pass, ftpsock)
			if (res !~ /^2/)
				print_status("The server rejected our password")
				return false
			end
		end
		
		return true
	end

	#
	# This method logs in as the supplied user by transmitting the FTP
	# 'USER <user>' command.
	#
	def send_user(user, nsock = self.sock)
		raw_send_recv("USER #{user}\r\n", nsock)
	end

	#
	# This method completes user authentication by sending the supplied
	# password using the FTP 'PASS <pass>' command.
	#
	def send_pass(pass, nsock = self.sock)
		raw_send_recv("PASS #{pass}\r\n", nsock)
	end
	
	#
	# This method sends one command with zero or more parameters
	#
	def send_cmd(args, recv = true, nsock = self.sock)
		cmd = args.join(" ") + "\r\n"
		if (recv)
			return raw_send_recv(cmd, nsock)
		else
			return raw_send(cmd, nsock)
		end
	end
	
	#
	# This method transmits a FTP command and waits for a response.  If one is
	# received, it is returned to the caller.
	#
	def raw_send_recv(cmd, nsock = self.sock)
		nsock.put(cmd)
		nsock.get_once
	end
	
	#
	# This method transmits a FTP command and does not wait for a response
	#
	def raw_send(cmd, nsock = self.sock)
		nsock.put(cmd)
	end
	
	##
	#
	# Wrappers for getters
	#
	##

	#
	# Returns the user string from the 'FTPUSER' option.
	#
	def user
		datastore['FTPUSER']
	end

	#
	# Returns the user string from the 'FTPPASS' option.
	#
	def pass
		datastore['FTPPASS']
	end

protected

	#
	# This attribute holds the banner that was read in after a successful call
	# to connect or connect_login.
	#
	attr_accessor :banner

end

end
