require 'rex/exploitation/egghunter'

module Msf

###
# 
# This mixin provides a interface to generating egghunters for various
# platforms using the Rex::Exploitation::Egghunter class.
#
###
module Exploit::Egghunter

	#
	# Creates an instance of an exploit that uses an Egghunter overwrite.
	#
	def initialize(info = {})
		super
	end


	# 
	# Generates an egghunter stub based on the current target's architecture
	# and operating system.
	#
	def generate_egghunter
		# Prefer the target's platform/architecture information, but use
		# the module's if no target specific information exists
		los   = target_platform
		larch = target_arch || ARCH_X86

		# If we found a platform list, then take the first platform
		los   = los.names[0] if (los.kind_of?(Msf::Module::PlatformList))

		if los.nil?
			raise RuntimeError, "No platform restrictions were specified -- cannot select egghunter"
		end
		
		egg   = Rex::Exploitation::Egghunter.new(los, larch)
		bunny = egg.generate(payload_badchars)
		
		if (bunny.nil?)
			print_error("The egghunter could not be generated")
			raise ArgumentError
		end
		
		return bunny
	end

end

end
