---
title: Users
...

# List of projects using Meson

If you have a project that uses Meson that you want to add to this list, let us know and we'll add it.

 - [AQEMU](https://github.com/tobimensch/aqemu), a Qt GUI for QEMU virtual machines, since version 0.9.3
 - [Arduino sample project](https://github.com/jpakkane/mesonarduino)
 - [Budgie Desktop](https://github.com/budgie-desktop/budgie-desktop), a desktop environment built on GNOME technologies
 - [casync](https://github.com/systemd/casync), 
 - [Emeus](https://github.com/ebassi/emeus), Constraint based layout manager for GTK+
 - [Frida](https://www.frida.re/), a dynamic binary instrumentation toolkit
 - [GLib](https://git.gnome.org/browse/glib/), cross-platform C library used by GTK+ and GStreamer (not the default yet)
 - [Gnome Builder](https://git.gnome.org/browse/gnome-builder/), an IDE for the Gnome platform
 - [Gnome MPV](https://github.com/gnome-mpv/gnome-mpv), Gnome frontend to the mpv video player
 - [Gnome Recipes](https://github.com/matthiasclasen/gr), application for cooking recipes
 - [Gnome Software](https://git.gnome.org//browse/gnome-software), an app store for Gnome
 - [Gnome Twitch](https://github.com/vinszent/gnome-twitch), an app for viewing Twitch streams on Gnome desktop
 - [Graphene](https://ebassi.github.io/graphene/), a thin type library for graphics
 - [Grilo](https://mail.gnome.org/archives/grilo-list/2017-February/msg00000.html) and [Grilo plugins](https://git.gnome.org/browse/grilo-plugins/commit/?id=ea047c4fb63e90268eb795ed91a09a2be5068a4c), the Grilo multimedia framework
 - [GStreamer](https://cgit.freedesktop.org/gstreamer/gstreamer/), multimedia framework (not the default yet)
 - [GTK+](https://git.gnome.org/browse/gtk+/), the multi-platform toolkit used by GNOME
 - [GtkDApp](https://gitlab.com/csoriano/GtkDApp), an application template for developing Flatpak apps with Gtk+ and D
 - [HexChat](https://github.com/hexchat/hexchat), a cross-platform IRC client in C
 - [Json-glib](https://git.gnome.org/browse/json-glib), GLib-based JSON manipulation library
 - [Libepoxy](https://github.com/anholt/libepoxy/), a library for handling OpenGL function pointer management
 - [Libgit2-glib](https://git.gnome.org/browse/libgit2-glib/), a GLib wrapper for libgit2
 - [Libhttpseverywhere](https://github.com/grindhold/libhttpseverywhere), a library to enable httpseverywhere on any desktop app
 - [Lightdm-Webkit2-Greeter](https://github.com/Antergos/lightdm-webkit2-greeter)
 - [Kiwix libraries](https://github.com/kiwix/kiwix-lib)
 - [Nautilus](https://git.gnome.org/browse/nautilus/commit/?id=ed5652c89ac0654df2e82b54b00b27d51c825465) the Gnome file manager
 - [Orc](http://cgit.freedesktop.org/gstreamer/orc/), the Optimized Inner Loop Runtime Compiler (not the default yet)
 - [Pango](https://git.gnome.org/browse/pango/), an Internationalized text layout and rendering library (not the default yet)
 - [Parzip](https://github.com/jpakkane/parzip), a multithreaded reimplementation of Zip
 - [Pitivi](http://pitivi.org/), a nonlinear video editor
 - [Polari](https://git.gnome.org/browse/polari), an IRC client
 - [Sysprof](https://wiki.gnome.org/Apps/Sysprof), a profiling tool
 - [systemd](https://github.com/systemd/systemd/pull/5704), the init system (not the default yet)
 - [Xorg](https://cgit.freedesktop.org/xorg/xserver/) the X.org display server (not the default yet)
 - [Valum](https://github.com/valum-framework/valum), a micro web framework written in Vala
 - [Wayland and Weston](https://lists.freedesktop.org/archives/wayland-devel/2016-November/031984.html), a next generation display server (not merged yet)
 - [ZStandard](https://github.com/facebook/zstd/commit/4dca56ed832c6a88108a2484a8f8ff63d8d76d91) a compression algorithm developed at Facebook (not used by default)

Note that a more up-to-date list of GNOME projects that use Meson can be found here: https://wiki.gnome.org/Initiatives/GnomeGoals/MesonPorting
