/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.assertions.Assertions;
import com.mongodb.async.SingleResultCallback;
import com.mongodb.connection.Authenticator;
import com.mongodb.connection.CommandHelper;
import com.mongodb.connection.ConnectionDescription;
import com.mongodb.connection.ConnectionId;
import com.mongodb.connection.DescriptionHelper;
import com.mongodb.connection.InternalConnection;
import com.mongodb.connection.InternalConnectionInitializer;
import com.mongodb.connection.ServerType;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.bson.BsonDocument;
import org.bson.BsonInt32;

class InternalStreamConnectionInitializer
implements InternalConnectionInitializer {
    private final List<Authenticator> authenticators;
    private final BsonDocument clientMetadataDocument;

    InternalStreamConnectionInitializer(List<Authenticator> authenticators, BsonDocument clientMetadataDocument) {
        this.authenticators = Assertions.notNull("authenticators", authenticators);
        this.clientMetadataDocument = clientMetadataDocument;
    }

    @Override
    public ConnectionDescription initialize(InternalConnection internalConnection) {
        Assertions.notNull("internalConnection", internalConnection);
        ConnectionDescription connectionDescription = this.initializeConnectionDescription(internalConnection);
        this.authenticateAll(internalConnection, connectionDescription);
        return this.completeConnectionDescriptionInitialization(internalConnection, connectionDescription);
    }

    @Override
    public void initializeAsync(InternalConnection internalConnection, SingleResultCallback<ConnectionDescription> callback) {
        this.initializeConnectionDescriptionAsync(internalConnection, this.createConnectionDescriptionCallback(internalConnection, callback));
    }

    private SingleResultCallback<ConnectionDescription> createConnectionDescriptionCallback(final InternalConnection internalConnection, final SingleResultCallback<ConnectionDescription> callback) {
        return new SingleResultCallback<ConnectionDescription>(){

            @Override
            public void onResult(final ConnectionDescription connectionDescription, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    new CompoundAuthenticator(internalConnection, connectionDescription, new SingleResultCallback<Void>(){

                        @Override
                        public void onResult(Void result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                InternalStreamConnectionInitializer.this.completeConnectionDescriptionInitializationAsync(internalConnection, connectionDescription, callback);
                            }
                        }
                    }).start();
                }
            }
        };
    }

    private ConnectionDescription initializeConnectionDescription(InternalConnection internalConnection) {
        BsonDocument isMasterResult = CommandHelper.executeCommand("admin", this.createIsMasterCommand(), internalConnection);
        BsonDocument buildInfoResult = CommandHelper.executeCommand("admin", new BsonDocument("buildinfo", new BsonInt32(1)), internalConnection);
        return DescriptionHelper.createConnectionDescription(internalConnection.getDescription().getConnectionId(), isMasterResult, buildInfoResult);
    }

    private BsonDocument createIsMasterCommand() {
        BsonDocument isMasterCommandDocument = new BsonDocument("ismaster", new BsonInt32(1));
        if (this.clientMetadataDocument != null) {
            isMasterCommandDocument.append("client", this.clientMetadataDocument);
        }
        return isMasterCommandDocument;
    }

    private ConnectionDescription completeConnectionDescriptionInitialization(InternalConnection internalConnection, ConnectionDescription connectionDescription) {
        return this.applyGetLastErrorResult(CommandHelper.executeCommandWithoutCheckingForFailure("admin", new BsonDocument("getlasterror", new BsonInt32(1)), internalConnection), connectionDescription);
    }

    private void authenticateAll(InternalConnection internalConnection, ConnectionDescription connectionDescription) {
        if (connectionDescription.getServerType() != ServerType.REPLICA_SET_ARBITER) {
            for (Authenticator cur : this.authenticators) {
                cur.authenticate(internalConnection, connectionDescription);
            }
        }
    }

    private void initializeConnectionDescriptionAsync(final InternalConnection internalConnection, final SingleResultCallback<ConnectionDescription> callback) {
        CommandHelper.executeCommandAsync("admin", this.createIsMasterCommand(), internalConnection, new SingleResultCallback<BsonDocument>(){

            @Override
            public void onResult(final BsonDocument isMasterResult, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    CommandHelper.executeCommandAsync("admin", new BsonDocument("buildinfo", new BsonInt32(1)), internalConnection, new SingleResultCallback<BsonDocument>(){

                        @Override
                        public void onResult(BsonDocument buildInfoResult, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, t);
                            } else {
                                ConnectionId connectionId = internalConnection.getDescription().getConnectionId();
                                callback.onResult(DescriptionHelper.createConnectionDescription(connectionId, isMasterResult, buildInfoResult), null);
                            }
                        }
                    });
                }
            }
        });
    }

    private void completeConnectionDescriptionInitializationAsync(InternalConnection internalConnection, final ConnectionDescription connectionDescription, final SingleResultCallback<ConnectionDescription> callback) {
        CommandHelper.executeCommandAsync("admin", new BsonDocument("getlasterror", new BsonInt32(1)), internalConnection, new SingleResultCallback<BsonDocument>(){

            @Override
            public void onResult(BsonDocument result, Throwable t) {
                if (result == null) {
                    callback.onResult(connectionDescription, null);
                } else {
                    callback.onResult(InternalStreamConnectionInitializer.this.applyGetLastErrorResult(result, connectionDescription), null);
                }
            }
        });
    }

    private ConnectionDescription applyGetLastErrorResult(BsonDocument getLastErrorResult, ConnectionDescription connectionDescription) {
        ConnectionId connectionId = getLastErrorResult.containsKey("connectionId") ? connectionDescription.getConnectionId().withServerValue(getLastErrorResult.getNumber("connectionId").intValue()) : connectionDescription.getConnectionId();
        return connectionDescription.withConnectionId(connectionId);
    }

    private class CompoundAuthenticator
    implements SingleResultCallback<Void> {
        private final InternalConnection internalConnection;
        private final ConnectionDescription connectionDescription;
        private final SingleResultCallback<Void> callback;
        private final AtomicInteger currentAuthenticatorIndex = new AtomicInteger(-1);

        public CompoundAuthenticator(InternalConnection internalConnection, ConnectionDescription connectionDescription, SingleResultCallback<Void> callback) {
            this.internalConnection = internalConnection;
            this.connectionDescription = connectionDescription;
            this.callback = callback;
        }

        @Override
        public void onResult(Void result, Throwable t) {
            if (t != null) {
                this.callback.onResult(null, t);
            } else if (this.completedAuthentication()) {
                this.callback.onResult(null, null);
            } else {
                this.authenticateNext();
            }
        }

        public void start() {
            if (this.connectionDescription.getServerType() == ServerType.REPLICA_SET_ARBITER || InternalStreamConnectionInitializer.this.authenticators.isEmpty()) {
                this.callback.onResult(null, null);
            } else {
                this.authenticateNext();
            }
        }

        private boolean completedAuthentication() {
            return this.currentAuthenticatorIndex.get() == InternalStreamConnectionInitializer.this.authenticators.size() - 1;
        }

        private void authenticateNext() {
            ((Authenticator)InternalStreamConnectionInitializer.this.authenticators.get(this.currentAuthenticatorIndex.incrementAndGet())).authenticateAsync(this.internalConnection, this.connectionDescription, this);
        }
    }
}

