/*****************************************************************************

Copyright (c) 2013, 2015, Oracle and/or its affiliates. All Rights Reserved.
Copyright (c) 2017, MariaDB Corporation.

This program is free software; you can redistribute it and/or modify it under
the terms of the GNU General Public License as published by the Free Software
Foundation; version 2 of the License.

This program is distributed in the hope that it will be useful, but WITHOUT
ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc.,
51 Franklin Street, Fifth Floor, Boston, MA 02110-1335 USA

*****************************************************************************/

/******************************************************************//**
@file include/sync0policy.ic
Policy for mutexes.

Created 2012-08-21 Sunny Bains.
***********************************************************************/

#include "sync0debug.h"

template <typename Mutex>
std::string GenericPolicy<Mutex>::to_string() const
{
	return(sync_mutex_to_string(get_id(), sync_file_created_get(this)));
}

template <typename Mutex>
std::string BlockMutexPolicy<Mutex>::to_string() const
{
	/* I don't think it makes sense to keep track of the file name
	and line number for each block mutex. Too much of overhead. Use the
	latch id to figure out the location from the source. */
	return(sync_mutex_to_string(get_id(), "buf0buf.cc:0"));
}

#ifdef UNIV_DEBUG

template <typename Mutex>
void MutexDebug<Mutex>::init(latch_id_t id)
	UNIV_NOTHROW
{
	m_context.m_id = id;

	m_context.release();

	m_magic_n = MUTEX_MAGIC_N;
}

template <typename Mutex>
void MutexDebug<Mutex>::enter(
	const Mutex*	mutex,
	const char*	name,
	unsigned	line)
	UNIV_NOTHROW
{
	ut_ad(!is_owned());

	Context	context(m_context.get_id());

	context.locked(mutex, name, line);

	/* Check for latch order violation. */

	sync_check_lock_validate(&context);
}

template <typename Mutex>
void MutexDebug<Mutex>::locked(
	const Mutex*	mutex,
	const char*	name,
	unsigned	line)
	UNIV_NOTHROW
{
	ut_ad(!is_owned());
	ut_ad(m_context.m_thread_id == os_thread_id_t(ULINT_UNDEFINED));

	m_context.locked(mutex, name, line);

	sync_check_lock_granted(&m_context);
}

template <typename Mutex>
void MutexDebug<Mutex>::release(const Mutex* mutex)
	UNIV_NOTHROW
{
	ut_ad(is_owned());

	m_context.release();

	sync_check_unlock(&m_context);
}

#endif /* UNIV_DEBUG */
