/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BSONBinaryWriter;
import com.mongodb.BaseWriteCommandMessage;
import com.mongodb.DBEncoder;
import com.mongodb.MessageSettings;
import com.mongodb.MongoNamespace;
import com.mongodb.RemoveRequest;
import com.mongodb.WriteConcern;
import java.util.List;
import org.bson.io.OutputBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DeleteCommandMessage
extends BaseWriteCommandMessage {
    private final List<RemoveRequest> deletes;
    private final DBEncoder queryEncoder;

    public DeleteCommandMessage(MongoNamespace namespace, WriteConcern writeConcern, List<RemoveRequest> deletes, DBEncoder commandEncoder, DBEncoder queryEncoder, MessageSettings settings) {
        super(namespace, writeConcern, commandEncoder, settings);
        this.deletes = deletes;
        this.queryEncoder = queryEncoder;
    }

    @Override
    protected String getCommandName() {
        return "delete";
    }

    @Override
    protected BaseWriteCommandMessage writeTheWrites(OutputBuffer buffer, int commandStartPosition, BSONBinaryWriter writer) {
        DeleteCommandMessage nextMessage = null;
        writer.writeStartArray("deletes");
        for (int i = 0; i < this.deletes.size(); ++i) {
            writer.mark();
            RemoveRequest remove = this.deletes.get(i);
            writer.writeStartDocument();
            writer.pushMaxDocumentSize(this.getSettings().getMaxDocumentSize());
            writer.writeName("q");
            writer.encodeDocument(this.getCommandEncoder(), remove.getQuery());
            writer.writeInt32("limit", remove.isMulti() ? 0 : 1);
            writer.popMaxDocumentSize();
            writer.writeEndDocument();
            if (!this.exceedsLimits(buffer.getPosition() - commandStartPosition, i + 1)) continue;
            writer.reset();
            nextMessage = new DeleteCommandMessage(this.getWriteNamespace(), this.getWriteConcern(), this.deletes.subList(i, this.deletes.size()), this.getCommandEncoder(), this.queryEncoder, this.getSettings());
            break;
        }
        writer.writeEndArray();
        return nextMessage;
    }

    @Override
    public int getItemCount() {
        return this.deletes.size();
    }
}

