/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileValueIterator;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.MatrixWritable;

public final class MatrixDumper
extends AbstractJob {
    private MatrixDumper() {
    }

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new MatrixDumper(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOption("output", "o", "Output path", null);
        Map parsedArgs = this.parseArguments(args);
        if (parsedArgs == null) {
            return -1;
        }
        String outputFile = this.hasOption("output") ? this.getOption("output") : null;
        MatrixDumper.exportCSV(this.getInputPath(), outputFile, false);
        return 0;
    }

    private static void exportCSV(Path inputPath, String outputFile, boolean doLabels) throws IOException {
        SequenceFileValueIterator it = new SequenceFileValueIterator(inputPath, true, new Configuration());
        Matrix m = ((MatrixWritable)it.next()).get();
        it.close();
        PrintStream ps = MatrixDumper.getPrintStream(outputFile);
        String[] columnLabels = MatrixDumper.getLabels(m.numCols(), m.getColumnLabelBindings(), "col");
        String[] rowLabels = MatrixDumper.getLabels(m.numRows(), m.getRowLabelBindings(), "row");
        if (doLabels) {
            ps.print("rowid,");
            ps.print(columnLabels[0]);
            for (int c = 1; c < m.numCols(); ++c) {
                ps.print(',' + columnLabels[c]);
            }
            ps.println();
        }
        for (int r = 0; r < m.numRows(); ++r) {
            if (doLabels) {
                ps.print(rowLabels[0] + ',');
            }
            ps.print(Double.toString(m.getQuick(r, 0)));
            for (int c = 1; c < m.numCols(); ++c) {
                ps.print(",");
                ps.print(Double.toString(m.getQuick(r, c)));
            }
            ps.println();
        }
        if (ps != System.out) {
            ps.close();
        }
    }

    private static PrintStream getPrintStream(String outputPath) throws IOException {
        if (outputPath == null) {
            return System.out;
        }
        File outputFile = new File(outputPath);
        if (outputFile.exists()) {
            outputFile.delete();
        }
        outputFile.createNewFile();
        FileOutputStream os = new FileOutputStream(outputFile);
        return new PrintStream((OutputStream)os, false, Charsets.UTF_8.displayName());
    }

    private static String[] getLabels(int length, Map<String, Integer> labels, String start) {
        if (labels != null) {
            return MatrixDumper.sortLabels(labels);
        }
        String[] sorted = new String[length];
        for (int i = 1; i <= length; ++i) {
            sorted[i] = start + i;
        }
        return sorted;
    }

    private static String[] sortLabels(Map<String, Integer> labels) {
        String[] sorted = new String[labels.size()];
        for (Map.Entry<String, Integer> entry : labels.entrySet()) {
            sorted[entry.getValue().intValue()] = entry.getKey();
        }
        return sorted;
    }
}

