/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.similarity.precompute.example;

import java.io.File;
import org.apache.mahout.cf.taste.impl.recommender.GenericItemBasedRecommender;
import org.apache.mahout.cf.taste.impl.similarity.LogLikelihoodSimilarity;
import org.apache.mahout.cf.taste.impl.similarity.precompute.FileSimilarItemsWriter;
import org.apache.mahout.cf.taste.impl.similarity.precompute.MultithreadedBatchItemSimilarities;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.ItemBasedRecommender;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;
import org.apache.mahout.cf.taste.similarity.precompute.SimilarItemsWriter;
import org.apache.mahout.cf.taste.similarity.precompute.example.GroupLensDataModel;

public final class BatchItemSimilaritiesGroupLens {
    private BatchItemSimilaritiesGroupLens() {
    }

    public static void main(String[] args) throws Exception {
        File resultFile;
        if (args.length != 1) {
            System.err.println("Need path to ratings.dat of the movielens1M dataset as argument!");
            System.exit(-1);
        }
        if ((resultFile = new File(System.getProperty("java.io.tmpdir"), "similarities.csv")).exists()) {
            resultFile.delete();
        }
        GroupLensDataModel dataModel = new GroupLensDataModel(new File(args[0]));
        GenericItemBasedRecommender recommender = new GenericItemBasedRecommender((DataModel)dataModel, (ItemSimilarity)new LogLikelihoodSimilarity((DataModel)dataModel));
        MultithreadedBatchItemSimilarities batch = new MultithreadedBatchItemSimilarities((ItemBasedRecommender)recommender, 5);
        int numSimilarities = batch.computeItemSimilarities(Runtime.getRuntime().availableProcessors(), 1, (SimilarItemsWriter)new FileSimilarItemsWriter(resultFile));
        System.out.println("Computed " + numSimilarities + " similarities for " + dataModel.getNumItems() + " items " + "and saved them to " + resultFile.getAbsolutePath());
    }
}

