/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track2;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.example.kddcup.track2.HybridSimilarity;
import org.apache.mahout.cf.taste.impl.recommender.GenericBooleanPrefItemBasedRecommender;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.recommender.IDRescorer;
import org.apache.mahout.cf.taste.recommender.RecommendedItem;
import org.apache.mahout.cf.taste.recommender.Recommender;
import org.apache.mahout.cf.taste.similarity.ItemSimilarity;

public final class Track2Recommender
implements Recommender {
    private final Recommender recommender;

    public Track2Recommender(DataModel dataModel, File dataFileDirectory) throws TasteException {
        HybridSimilarity similarity;
        try {
            similarity = new HybridSimilarity(dataModel, dataFileDirectory);
        }
        catch (IOException ioe) {
            throw new TasteException((Throwable)ioe);
        }
        this.recommender = new GenericBooleanPrefItemBasedRecommender(dataModel, (ItemSimilarity)similarity);
    }

    public List<RecommendedItem> recommend(long userID, int howMany) throws TasteException {
        return this.recommender.recommend(userID, howMany);
    }

    public List<RecommendedItem> recommend(long userID, int howMany, IDRescorer rescorer) throws TasteException {
        return this.recommender.recommend(userID, howMany, rescorer);
    }

    public float estimatePreference(long userID, long itemID) throws TasteException {
        return this.recommender.estimatePreference(userID, itemID);
    }

    public void setPreference(long userID, long itemID, float value) throws TasteException {
        this.recommender.setPreference(userID, itemID, value);
    }

    public void removePreference(long userID, long itemID) throws TasteException {
        this.recommender.removePreference(userID, itemID);
    }

    public DataModel getDataModel() {
        return this.recommender.getDataModel();
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
        this.recommender.refresh(alreadyRefreshed);
    }

    public String toString() {
        return "Track1Recommender[recommender:" + this.recommender + ']';
    }
}

