/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup.track1.svd;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import java.io.File;
import org.apache.mahout.cf.taste.example.kddcup.DataFileIterable;
import org.apache.mahout.cf.taste.example.kddcup.track1.svd.FactorizablePreferences;
import org.apache.mahout.cf.taste.impl.common.AbstractLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.Pair;

public class KDDCupFactorizablePreferences
implements FactorizablePreferences {
    private final File dataFile;

    public KDDCupFactorizablePreferences(File dataFile) {
        this.dataFile = dataFile;
    }

    @Override
    public LongPrimitiveIterator getUserIDs() {
        return new FixedSizeLongIterator(this.numUsers());
    }

    @Override
    public LongPrimitiveIterator getItemIDs() {
        return new FixedSizeLongIterator(this.numItems());
    }

    @Override
    public Iterable<Preference> getPreferences() {
        Iterable prefIterators = Iterables.transform((Iterable)new DataFileIterable(this.dataFile), (Function)new Function<Pair<PreferenceArray, long[]>, Iterable<Preference>>(){

            public Iterable<Preference> apply(Pair<PreferenceArray, long[]> from) {
                return (Iterable)from.getFirst();
            }
        });
        return Iterables.concat((Iterable)prefIterators);
    }

    @Override
    public float getMinPreference() {
        return 0.0f;
    }

    @Override
    public float getMaxPreference() {
        return 100.0f;
    }

    @Override
    public int numUsers() {
        return 1000990;
    }

    @Override
    public int numItems() {
        return 624961;
    }

    @Override
    public int numPreferences() {
        return 252800275;
    }

    static class FixedSizeLongIterator
    extends AbstractLongPrimitiveIterator {
        private long currentValue;
        private final long maximum;

        FixedSizeLongIterator(long maximum) {
            this.maximum = maximum;
            this.currentValue = 0L;
        }

        public long nextLong() {
            return this.currentValue++;
        }

        public long peek() {
            return this.currentValue;
        }

        public void skip(int n) {
            this.currentValue += (long)n;
        }

        public boolean hasNext() {
            return this.currentValue < this.maximum;
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

