/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.example.kddcup;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import org.apache.mahout.cf.taste.common.Refreshable;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.example.kddcup.DataFileIterator;
import org.apache.mahout.cf.taste.impl.common.FastByIDMap;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.model.GenericDataModel;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.SamplingIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KDDCupDataModel
implements DataModel {
    private static final Logger log = LoggerFactory.getLogger(KDDCupDataModel.class);
    private final File dataFileDirectory;
    private final DataModel delegate;

    public KDDCupDataModel(File dataFile) throws IOException {
        this(dataFile, false, 1.0);
    }

    public KDDCupDataModel(File dataFile, boolean storeDates, double samplingRate) throws IOException {
        Preconditions.checkArgument((!Double.isNaN(samplingRate) && samplingRate > 0.0 && samplingRate <= 1.0 ? 1 : 0) != 0, (Object)"Must be: 0.0 < samplingRate <= 1.0");
        this.dataFileDirectory = dataFile.getParentFile();
        DataFileIterator dataIterator = new DataFileIterator(dataFile);
        if (samplingRate < 1.0) {
            dataIterator = new SamplingIterator((Iterator)((Object)dataIterator), samplingRate);
        }
        FastByIDMap userData = new FastByIDMap();
        FastByIDMap timestamps = new FastByIDMap();
        while (dataIterator.hasNext()) {
            Pair pair = (Pair)dataIterator.next();
            PreferenceArray userPrefs = (PreferenceArray)pair.getFirst();
            long[] timestampsForPrefs = (long[])pair.getSecond();
            userData.put(userPrefs.getUserID(0), (Object)userPrefs);
            if (!storeDates) continue;
            FastByIDMap itemTimestamps = new FastByIDMap();
            for (int i = 0; i < timestampsForPrefs.length; ++i) {
                long timestamp = timestampsForPrefs[i];
                if (timestamp <= 0L) continue;
                itemTimestamps.put(userPrefs.getItemID(i), (Object)timestamp);
            }
        }
        this.delegate = storeDates ? new GenericDataModel(userData, timestamps) : new GenericDataModel(userData);
        Runtime runtime = Runtime.getRuntime();
        log.info("Loaded data model in about {}MB heap", (Object)((runtime.totalMemory() - runtime.freeMemory()) / 1000000L));
    }

    public File getDataFileDirectory() {
        return this.dataFileDirectory;
    }

    public static File getTrainingFile(File dataFileDirectory) {
        return KDDCupDataModel.getFile(dataFileDirectory, "trainIdx");
    }

    public static File getValidationFile(File dataFileDirectory) {
        return KDDCupDataModel.getFile(dataFileDirectory, "validationIdx");
    }

    public static File getTestFile(File dataFileDirectory) {
        return KDDCupDataModel.getFile(dataFileDirectory, "testIdx");
    }

    public static File getTrackFile(File dataFileDirectory) {
        return KDDCupDataModel.getFile(dataFileDirectory, "trackData");
    }

    private static File getFile(File dataFileDirectory, String prefix) {
        for (int set : new int[]{1, 2}) {
            for (String firstLinesOrNot : new String[]{"", ".firstLines"}) {
                for (String gzippedOrNot : new String[]{".gz", ""}) {
                    File dataFile = new File(dataFileDirectory, prefix + set + firstLinesOrNot + ".txt" + gzippedOrNot);
                    if (!dataFile.exists()) continue;
                    return dataFile;
                }
            }
        }
        throw new IllegalArgumentException("Can't find " + prefix + " file in " + dataFileDirectory);
    }

    public LongPrimitiveIterator getUserIDs() throws TasteException {
        return this.delegate.getUserIDs();
    }

    public PreferenceArray getPreferencesFromUser(long userID) throws TasteException {
        return this.delegate.getPreferencesFromUser(userID);
    }

    public FastIDSet getItemIDsFromUser(long userID) throws TasteException {
        return this.delegate.getItemIDsFromUser(userID);
    }

    public LongPrimitiveIterator getItemIDs() throws TasteException {
        return this.delegate.getItemIDs();
    }

    public PreferenceArray getPreferencesForItem(long itemID) throws TasteException {
        return this.delegate.getPreferencesForItem(itemID);
    }

    public Float getPreferenceValue(long userID, long itemID) throws TasteException {
        return this.delegate.getPreferenceValue(userID, itemID);
    }

    public Long getPreferenceTime(long userID, long itemID) throws TasteException {
        return this.delegate.getPreferenceTime(userID, itemID);
    }

    public int getNumItems() throws TasteException {
        return this.delegate.getNumItems();
    }

    public int getNumUsers() throws TasteException {
        return this.delegate.getNumUsers();
    }

    public int getNumUsersWithPreferenceFor(long itemID) throws TasteException {
        return this.delegate.getNumUsersWithPreferenceFor(itemID);
    }

    public int getNumUsersWithPreferenceFor(long itemID1, long itemID2) throws TasteException {
        return this.delegate.getNumUsersWithPreferenceFor(itemID1, itemID2);
    }

    public void setPreference(long userID, long itemID, float value) throws TasteException {
        this.delegate.setPreference(userID, itemID, value);
    }

    public void removePreference(long userID, long itemID) throws TasteException {
        this.delegate.removePreference(userID, itemID);
    }

    public boolean hasPreferenceValues() {
        return this.delegate.hasPreferenceValues();
    }

    public float getMaxPreference() {
        return 100.0f;
    }

    public float getMinPreference() {
        return 0.0f;
    }

    public void refresh(Collection<Refreshable> alreadyRefreshed) {
    }
}

