/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.net;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.net.NetworkTopology;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;

@InterfaceAudience.LimitedPrivate(value={"HDFS", "MapReduce"})
@InterfaceStability.Unstable
public class NetworkTopologyWithNodeGroup
extends NetworkTopology {
    public static final String DEFAULT_NODEGROUP = "/default-nodegroup";

    public NetworkTopologyWithNodeGroup() {
        this.clusterMap = new InnerNodeWithNodeGroup("");
    }

    @Override
    protected Node getNodeForNetworkLocation(Node node) {
        Node nodeGroup;
        if ("/default-rack".equals(node.getNetworkLocation())) {
            node.setNetworkLocation(node.getNetworkLocation() + DEFAULT_NODEGROUP);
        }
        if ((nodeGroup = this.getNode(node.getNetworkLocation())) == null) {
            nodeGroup = new InnerNodeWithNodeGroup(node.getNetworkLocation());
        }
        return this.getNode(nodeGroup.getNetworkLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getRack(String loc) {
        this.netlock.readLock().lock();
        try {
            loc = NetworkTopology.InnerNode.normalize(loc);
            Node locNode = this.getNode(loc);
            if (locNode instanceof InnerNodeWithNodeGroup) {
                InnerNodeWithNodeGroup node = (InnerNodeWithNodeGroup)locNode;
                if (node.isRack()) {
                    String string = loc;
                    return string;
                }
                if (node.isNodeGroup()) {
                    String string = node.getNetworkLocation();
                    return string;
                }
                String string = null;
                return string;
            }
            String string = loc;
            return string;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getNodeGroup(String loc) {
        this.netlock.readLock().lock();
        try {
            loc = NetworkTopology.InnerNode.normalize(loc);
            Node locNode = this.getNode(loc);
            if (locNode instanceof InnerNodeWithNodeGroup) {
                InnerNodeWithNodeGroup node = (InnerNodeWithNodeGroup)locNode;
                if (node.isNodeGroup()) {
                    String string = loc;
                    return string;
                }
                if (node.isRack()) {
                    String string = null;
                    return string;
                }
                String string = this.getNodeGroup(node.getNetworkLocation());
                return string;
            }
            String string = loc;
            return string;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOnSameRack(Node node1, Node node2) {
        if (node1 == null || node2 == null || node1.getParent() == null || node2.getParent() == null) {
            return false;
        }
        this.netlock.readLock().lock();
        try {
            boolean bl = this.isSameParents(node1.getParent(), node2.getParent());
            return bl;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isOnSameNodeGroup(Node node1, Node node2) {
        if (node1 == null || node2 == null) {
            return false;
        }
        this.netlock.readLock().lock();
        try {
            boolean bl = this.isSameParents(node1, node2);
            return bl;
        }
        finally {
            this.netlock.readLock().unlock();
        }
    }

    @Override
    public boolean isNodeGroupAware() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof NetworkTopology.InnerNode) {
            throw new IllegalArgumentException("Not allow to add an inner node: " + NodeBase.getPath(node));
        }
        this.netlock.writeLock().lock();
        try {
            Node nodeGroup;
            Node rack = null;
            if ("/default-rack".equals(node.getNetworkLocation())) {
                node.setNetworkLocation(node.getNetworkLocation() + DEFAULT_NODEGROUP);
            }
            if ((nodeGroup = this.getNode(node.getNetworkLocation())) == null) {
                nodeGroup = new InnerNodeWithNodeGroup(node.getNetworkLocation());
            }
            if (!((rack = this.getNode(nodeGroup.getNetworkLocation())) == null || rack instanceof NetworkTopology.InnerNode && rack.getParent() != null)) {
                throw new IllegalArgumentException("Unexpected data node " + node.toString() + " at an illegal network location");
            }
            if (this.clusterMap.add(node)) {
                LOG.info((Object)("Adding a new node: " + NodeBase.getPath(node)));
                if (rack == null) {
                    ++this.numOfRacks;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("NetworkTopology became:\n" + this.toString()));
            }
        }
        finally {
            this.netlock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Node node) {
        if (node == null) {
            return;
        }
        if (node instanceof NetworkTopology.InnerNode) {
            throw new IllegalArgumentException("Not allow to remove an inner node: " + NodeBase.getPath(node));
        }
        LOG.info((Object)("Removing a node: " + NodeBase.getPath(node)));
        this.netlock.writeLock().lock();
        try {
            if (this.clusterMap.remove(node)) {
                NetworkTopology.InnerNode rack;
                Node nodeGroup = this.getNode(node.getNetworkLocation());
                if (nodeGroup == null) {
                    nodeGroup = new NetworkTopology.InnerNode(node.getNetworkLocation());
                }
                if ((rack = (NetworkTopology.InnerNode)this.getNode(nodeGroup.getNetworkLocation())) == null) {
                    --this.numOfRacks;
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("NetworkTopology became:\n" + this.toString()));
            }
        }
        finally {
            this.netlock.writeLock().unlock();
        }
    }

    @Override
    public void pseudoSortByDistance(Node reader, Node[] nodes) {
        if (reader != null && !this.contains(reader)) {
            Node nodeGroup = this.getNode(reader.getNetworkLocation());
            if (nodeGroup != null && nodeGroup instanceof NetworkTopology.InnerNode) {
                NetworkTopology.InnerNode parentNode = (NetworkTopology.InnerNode)nodeGroup;
                reader = parentNode.getLeaf(0, null);
            } else {
                return;
            }
        }
        int tempIndex = 0;
        int localRackNode = -1;
        int localNodeGroupNode = -1;
        if (reader != null) {
            for (int i = 0; i < nodes.length; ++i) {
                if (tempIndex == 0 && reader == nodes[i]) {
                    if (i != 0) {
                        NetworkTopologyWithNodeGroup.swap(nodes, tempIndex, i);
                    }
                    tempIndex = 1;
                    if (localRackNode == -1 || localNodeGroupNode == -1) continue;
                    if (localRackNode == 0) {
                        localRackNode = i;
                    }
                    if (localNodeGroupNode != 0) break;
                    localNodeGroupNode = i;
                    break;
                }
                if (localNodeGroupNode == -1 && this.isOnSameNodeGroup(reader, nodes[i])) {
                    localNodeGroupNode = i;
                    if (tempIndex == 0 || localRackNode == -1) continue;
                    break;
                }
                if (localRackNode != -1 || !this.isOnSameRack(reader, nodes[i])) continue;
                localRackNode = i;
                if (tempIndex != 0 && localNodeGroupNode != -1) break;
            }
            if (localNodeGroupNode != -1 && localNodeGroupNode != tempIndex) {
                NetworkTopologyWithNodeGroup.swap(nodes, tempIndex, localNodeGroupNode);
                if (localRackNode == tempIndex) {
                    localRackNode = localNodeGroupNode;
                }
                ++tempIndex;
            }
            if (localRackNode != -1 && localRackNode != tempIndex) {
                NetworkTopologyWithNodeGroup.swap(nodes, tempIndex, localRackNode);
                ++tempIndex;
            }
        }
        if (tempIndex == 0 && localNodeGroupNode == -1 && localRackNode == -1 && nodes.length != 0) {
            NetworkTopologyWithNodeGroup.swap(nodes, 0, r.nextInt(nodes.length));
        }
    }

    static class InnerNodeWithNodeGroup
    extends NetworkTopology.InnerNode {
        public InnerNodeWithNodeGroup(String name, String location, NetworkTopology.InnerNode parent, int level) {
            super(name, location, parent, level);
        }

        public InnerNodeWithNodeGroup(String name, String location) {
            super(name, location);
        }

        public InnerNodeWithNodeGroup(String path) {
            super(path);
        }

        @Override
        boolean isRack() {
            if (this.getChildren().isEmpty()) {
                return false;
            }
            Node firstChild = (Node)this.children.get(0);
            if (firstChild instanceof NetworkTopology.InnerNode) {
                Node firstGrandChild = ((NetworkTopology.InnerNode)firstChild).children.get(0);
                return !(firstGrandChild instanceof NetworkTopology.InnerNode);
            }
            return false;
        }

        @Override
        protected boolean isLeafParent() {
            return this.isNodeGroup();
        }

        boolean isNodeGroup() {
            if (this.children.isEmpty()) {
                return true;
            }
            Node firstChild = (Node)this.children.get(0);
            return !(firstChild instanceof NetworkTopology.InnerNode);
        }

        @Override
        protected NetworkTopology.InnerNode createParentNode(String parentName) {
            return new InnerNodeWithNodeGroup(parentName, InnerNodeWithNodeGroup.getPath(this), this, this.getLevel() + 1);
        }

        @Override
        protected boolean areChildrenLeaves() {
            return this.isNodeGroup();
        }
    }
}

