/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.vectorizer.collocations.llr;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.mapreduce.lib.output.SequenceFileOutputFormat;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.mahout.common.AbstractJob;
import org.apache.mahout.common.HadoopUtil;
import org.apache.mahout.common.commandline.DefaultOptionCreator;
import org.apache.mahout.common.lucene.AnalyzerUtils;
import org.apache.mahout.vectorizer.DocumentProcessor;
import org.apache.mahout.vectorizer.collocations.llr.CollocCombiner;
import org.apache.mahout.vectorizer.collocations.llr.CollocMapper;
import org.apache.mahout.vectorizer.collocations.llr.CollocReducer;
import org.apache.mahout.vectorizer.collocations.llr.Gram;
import org.apache.mahout.vectorizer.collocations.llr.GramKey;
import org.apache.mahout.vectorizer.collocations.llr.GramKeyGroupComparator;
import org.apache.mahout.vectorizer.collocations.llr.GramKeyPartitioner;
import org.apache.mahout.vectorizer.collocations.llr.LLRReducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CollocDriver
extends AbstractJob {
    public static final String SUBGRAM_OUTPUT_DIRECTORY = "subgrams";
    public static final String NGRAM_OUTPUT_DIRECTORY = "ngrams";
    public static final String EMIT_UNIGRAMS = "emit-unigrams";
    public static final boolean DEFAULT_EMIT_UNIGRAMS = false;
    private static final int DEFAULT_MAX_NGRAM_SIZE = 2;
    private static final int DEFAULT_PASS1_NUM_REDUCE_TASKS = 1;
    private static final Logger log = LoggerFactory.getLogger(CollocDriver.class);

    public static void main(String[] args) throws Exception {
        ToolRunner.run((Tool)new CollocDriver(), (String[])args);
    }

    public int run(String[] args) throws Exception {
        this.addInputOption();
        this.addOutputOption();
        this.addOption(DefaultOptionCreator.numReducersOption().create());
        this.addOption("maxNGramSize", "ng", "(Optional) The max size of ngrams to create (2 = bigrams, 3 = trigrams, etc) default: 2", String.valueOf(2));
        this.addOption("minSupport", "s", "(Optional) Minimum Support. Default Value: 2", String.valueOf(2));
        this.addOption("minLLR", "ml", "(Optional)The minimum Log Likelihood Ratio(Float)  Default is 1.0", String.valueOf(1.0f));
        this.addOption(DefaultOptionCreator.overwriteOption().create());
        this.addOption("analyzerName", "a", "The class name of the analyzer to use for preprocessing", null);
        this.addFlag("preprocess", "p", "If set, input is SequenceFile<Text,Text> where the value is the document,  which will be tokenized using the specified analyzer.");
        this.addFlag("unigram", "u", "If set, unigrams will be emitted in the final output alongside collocations");
        Map<String, List<String>> argMap = this.parseArguments(args);
        if (argMap == null) {
            return -1;
        }
        Path input = this.getInputPath();
        Path output = this.getOutputPath();
        int maxNGramSize = 2;
        if (this.hasOption("maxNGramSize")) {
            try {
                maxNGramSize = Integer.parseInt(this.getOption("maxNGramSize"));
            }
            catch (NumberFormatException ex) {
                log.warn("Could not parse ngram size option");
            }
        }
        log.info("Maximum n-gram size is: {}", (Object)maxNGramSize);
        if (this.hasOption("overwrite")) {
            HadoopUtil.delete(this.getConf(), output);
        }
        int minSupport = 2;
        if (this.getOption("minSupport") != null) {
            minSupport = Integer.parseInt(this.getOption("minSupport"));
        }
        log.info("Minimum Support value: {}", (Object)minSupport);
        float minLLRValue = 1.0f;
        if (this.getOption("minLLR") != null) {
            minLLRValue = Float.parseFloat(this.getOption("minLLR"));
        }
        log.info("Minimum LLR value: {}", (Object)Float.valueOf(minLLRValue));
        int reduceTasks = 1;
        if (this.getOption("maxRed") != null) {
            reduceTasks = Integer.parseInt(this.getOption("maxRed"));
        }
        log.info("Number of pass1 reduce tasks: {}", (Object)reduceTasks);
        boolean emitUnigrams = argMap.containsKey("emitUnigrams");
        if (argMap.containsKey("preprocess")) {
            log.info("Input will be preprocessed");
            Class analyzerClass = StandardAnalyzer.class;
            if (this.getOption("analyzerName") != null) {
                String className = this.getOption("analyzerName");
                analyzerClass = Class.forName(className).asSubclass(Analyzer.class);
                AnalyzerUtils.createAnalyzer(analyzerClass);
            }
            Path tokenizedPath = new Path(output, "tokenized-documents");
            DocumentProcessor.tokenizeDocuments(input, analyzerClass, tokenizedPath, this.getConf());
            input = tokenizedPath;
        } else {
            log.info("Input will NOT be preprocessed");
        }
        long ngramCount = CollocDriver.generateCollocations(input, output, this.getConf(), emitUnigrams, maxNGramSize, reduceTasks, minSupport);
        CollocDriver.computeNGramsPruneByLLR(output, this.getConf(), ngramCount, emitUnigrams, minLLRValue, reduceTasks);
        return 0;
    }

    public static void generateAllGrams(Path input, Path output, Configuration baseConf, int maxNGramSize, int minSupport, float minLLRValue, int reduceTasks) throws IOException, InterruptedException, ClassNotFoundException {
        long ngramCount = CollocDriver.generateCollocations(input, output, baseConf, true, maxNGramSize, reduceTasks, minSupport);
        CollocDriver.computeNGramsPruneByLLR(output, baseConf, ngramCount, true, minLLRValue, reduceTasks);
    }

    private static long generateCollocations(Path input, Path output, Configuration baseConf, boolean emitUnigrams, int maxNGramSize, int reduceTasks, int minSupport) throws IOException, ClassNotFoundException, InterruptedException {
        Configuration con = new Configuration(baseConf);
        con.setBoolean(EMIT_UNIGRAMS, emitUnigrams);
        con.setInt("maxShingleSize", maxNGramSize);
        con.setInt("minSupport", minSupport);
        Job job = new Job(con);
        job.setJobName(CollocDriver.class.getSimpleName() + ".generateCollocations:" + input);
        job.setJarByClass(CollocDriver.class);
        job.setMapOutputKeyClass(GramKey.class);
        job.setMapOutputValueClass(Gram.class);
        job.setPartitionerClass(GramKeyPartitioner.class);
        job.setGroupingComparatorClass(GramKeyGroupComparator.class);
        job.setOutputKeyClass(Gram.class);
        job.setOutputValueClass(Gram.class);
        job.setCombinerClass(CollocCombiner.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{input});
        Path outputPath = new Path(output, SUBGRAM_OUTPUT_DIRECTORY);
        FileOutputFormat.setOutputPath((Job)job, (Path)outputPath);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setMapperClass(CollocMapper.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setReducerClass(CollocReducer.class);
        job.setNumReduceTasks(reduceTasks);
        boolean succeeded = job.waitForCompletion(true);
        if (!succeeded) {
            throw new IllegalStateException("Job failed!");
        }
        return job.getCounters().findCounter((Enum)CollocMapper.Count.NGRAM_TOTAL).getValue();
    }

    private static void computeNGramsPruneByLLR(Path output, Configuration baseConf, long nGramTotal, boolean emitUnigrams, float minLLRValue, int reduceTasks) throws IOException, InterruptedException, ClassNotFoundException {
        Configuration conf = new Configuration(baseConf);
        conf.setLong("ngramTotal", nGramTotal);
        conf.setBoolean(EMIT_UNIGRAMS, emitUnigrams);
        conf.setFloat("minLLR", minLLRValue);
        Job job = new Job(conf);
        job.setJobName(CollocDriver.class.getSimpleName() + ".computeNGrams: " + output);
        job.setJarByClass(CollocDriver.class);
        job.setMapOutputKeyClass(Gram.class);
        job.setMapOutputValueClass(Gram.class);
        job.setOutputKeyClass(Text.class);
        job.setOutputValueClass(DoubleWritable.class);
        FileInputFormat.setInputPaths((Job)job, (Path[])new Path[]{new Path(output, SUBGRAM_OUTPUT_DIRECTORY)});
        Path outPath = new Path(output, NGRAM_OUTPUT_DIRECTORY);
        FileOutputFormat.setOutputPath((Job)job, (Path)outPath);
        job.setMapperClass(Mapper.class);
        job.setInputFormatClass(SequenceFileInputFormat.class);
        job.setOutputFormatClass(SequenceFileOutputFormat.class);
        job.setReducerClass(LLRReducer.class);
        job.setNumReduceTasks(reduceTasks);
        boolean succeeded = job.waitForCompletion(true);
        if (!succeeded) {
            throw new IllegalStateException("Job failed!");
        }
    }
}

