/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.hadoop.stochasticsvd.qr;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.Validate;
import org.apache.mahout.common.iterator.CopyConstructorIterator;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.UpperTriangular;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.DenseBlockWritable;
import org.apache.mahout.math.hadoop.stochasticsvd.qr.GivensThinSolver;

public class QRLastStep
implements Closeable,
Iterator<Vector> {
    private final Iterator<DenseBlockWritable> qHatInput;
    private final List<UpperTriangular> mRs = Lists.newArrayList();
    private final int blockNum;
    private double[][] mQt;
    private int cnt;
    private int r;
    private int kp;
    private Vector qRow;

    public QRLastStep(Iterator<DenseBlockWritable> qHatInput, Iterator<VectorWritable> rHatInput, int blockNum) {
        this.blockNum = blockNum;
        this.qHatInput = qHatInput;
        int block = 0;
        while (rHatInput.hasNext()) {
            Vector value = rHatInput.next().get();
            if (block < blockNum && block > 0) {
                GivensThinSolver.mergeR(this.mRs.get(0), new UpperTriangular(value));
            } else {
                this.mRs.add(new UpperTriangular(value));
            }
            ++block;
        }
    }

    private boolean loadNextQt() {
        boolean more = this.qHatInput.hasNext();
        if (!more) {
            return false;
        }
        DenseBlockWritable v = this.qHatInput.next();
        this.mQt = GivensThinSolver.computeQtHat(v.getBlock(), this.blockNum == 0 ? 0 : 1, new CopyConstructorIterator<UpperTriangular>(this.mRs.iterator()));
        this.r = this.mQt[0].length;
        this.kp = this.mQt.length;
        if (this.qRow == null) {
            this.qRow = new DenseVector(this.kp);
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.mQt != null && this.cnt == this.r) {
            this.mQt = null;
        }
        boolean result = true;
        if (this.mQt == null) {
            result = this.loadNextQt();
            this.cnt = 0;
        }
        return result;
    }

    @Override
    public Vector next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Validate.isTrue(this.hasNext(), "Q input overrun", new Object[0]);
        int qRowIndex = this.r - this.cnt - 1;
        for (int j = 0; j < this.kp; ++j) {
            this.qRow.setQuick(j, this.mQt[j][qRowIndex]);
        }
        ++this.cnt;
        return this.qRow;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        this.mQt = null;
        this.mRs.clear();
    }
}

