/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math.als;

import com.google.common.base.Preconditions;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.DenseVector;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.QRDecomposition;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;
import org.apache.mahout.math.list.IntArrayList;
import org.apache.mahout.math.map.OpenIntObjectHashMap;

public class ImplicitFeedbackAlternatingLeastSquaresSolver {
    private final int numFeatures;
    private final double alpha;
    private final double lambda;
    private final OpenIntObjectHashMap<Vector> Y;
    private final Matrix YtransposeY;

    public ImplicitFeedbackAlternatingLeastSquaresSolver(int numFeatures, double lambda, double alpha, OpenIntObjectHashMap<Vector> Y) {
        this.numFeatures = numFeatures;
        this.lambda = lambda;
        this.alpha = alpha;
        this.Y = Y;
        this.YtransposeY = this.getYtransposeY(Y);
    }

    public Vector solve(Vector ratings) {
        return ImplicitFeedbackAlternatingLeastSquaresSolver.solve(this.YtransposeY.plus(this.getYtransponseCuMinusIYPlusLambdaI(ratings)), this.getYtransponseCuPu(ratings));
    }

    private static Vector solve(Matrix A, Matrix y) {
        return new QRDecomposition(A).solve(y).viewColumn(0);
    }

    double confidence(double rating) {
        return 1.0 + this.alpha * rating;
    }

    private Matrix getYtransposeY(OpenIntObjectHashMap<Vector> Y) {
        IntArrayList indexes = Y.keys();
        indexes.quickSort();
        int numIndexes = indexes.size();
        double[][] YtY = new double[this.numFeatures][this.numFeatures];
        for (int i = 0; i < this.numFeatures; ++i) {
            for (int j = i; j < this.numFeatures; ++j) {
                double dot = 0.0;
                for (int k = 0; k < numIndexes; ++k) {
                    Vector row = Y.get(indexes.getQuick(k));
                    dot += row.getQuick(i) * row.getQuick(j);
                }
                YtY[i][j] = dot;
                if (i == j) continue;
                YtY[j][i] = dot;
            }
        }
        return new DenseMatrix(YtY, true);
    }

    private Matrix getYtransponseCuMinusIYPlusLambdaI(Vector userRatings) {
        Preconditions.checkArgument(userRatings.isSequentialAccess(), "need sequential access to ratings!");
        OpenIntObjectHashMap<Vector> CuMinusIY = new OpenIntObjectHashMap<Vector>(userRatings.getNumNondefaultElements());
        for (Vector.Element e : userRatings.nonZeroes()) {
            CuMinusIY.put(e.index(), this.Y.get(e.index()).times(this.confidence(e.get()) - 1.0));
        }
        DenseMatrix YtransponseCuMinusIY = new DenseMatrix(this.numFeatures, this.numFeatures);
        for (Vector.Element e : userRatings.nonZeroes()) {
            for (Vector.Element feature : this.Y.get(e.index()).all()) {
                Vector partial = ((Vector)CuMinusIY.get(e.index())).times(feature.get());
                YtransponseCuMinusIY.viewRow(feature.index()).assign(partial, Functions.PLUS);
            }
        }
        for (int feature = 0; feature < this.numFeatures; ++feature) {
            YtransponseCuMinusIY.setQuick(feature, feature, YtransponseCuMinusIY.getQuick(feature, feature) + this.lambda);
        }
        return YtransponseCuMinusIY;
    }

    private Matrix getYtransponseCuPu(Vector userRatings) {
        Preconditions.checkArgument(userRatings.isSequentialAccess(), "need sequential access to ratings!");
        DenseVector YtransponseCuPu = new DenseVector(this.numFeatures);
        for (Vector.Element e : userRatings.nonZeroes()) {
            YtransponseCuPu.assign(this.Y.get(e.index()).times(this.confidence(e.get())), Functions.PLUS);
        }
        return this.columnVectorAsMatrix(YtransponseCuPu);
    }

    private Matrix columnVectorAsMatrix(Vector v) {
        double[][] matrix = new double[this.numFeatures][1];
        for (Vector.Element e : v.all()) {
            matrix[e.index()][0] = e.get();
        }
        return new DenseMatrix(matrix, true);
    }
}

