/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.math;

import com.google.common.base.Preconditions;
import org.apache.mahout.math.DenseMatrix;
import org.apache.mahout.math.Matrix;
import org.apache.mahout.math.PivotedMatrix;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.function.Functions;

public class CholeskyDecomposition {
    private final PivotedMatrix L;
    private boolean isPositiveDefinite;

    public CholeskyDecomposition(Matrix a) {
        this(a, true);
    }

    public CholeskyDecomposition(Matrix a, boolean pivot) {
        int rows = a.rowSize();
        this.L = new PivotedMatrix(new DenseMatrix(rows, rows));
        Preconditions.checkArgument(rows == a.columnSize(), "Must be a Square Matrix");
        if (pivot) {
            this.decomposeWithPivoting(a);
        } else {
            this.decompose(a);
        }
    }

    private void decomposeWithPivoting(Matrix a) {
        int n = a.rowSize();
        this.L.assign(a);
        double uberMax = this.L.viewDiagonal().aggregate(Functions.MAX, Functions.ABS);
        for (int k = 0; k < n; ++k) {
            double max = 0.0;
            int pivot = k;
            for (int j = k; j < n; ++j) {
                if (!(this.L.get(j, j) > max)) continue;
                max = this.L.get(j, j);
                pivot = j;
                if (!(uberMax < Math.abs(max))) continue;
                uberMax = Math.abs(max);
            }
            this.L.swap(k, pivot);
            double akk = this.L.get(k, k);
            double epsilon = 1.0E-10 * Math.max(uberMax, this.L.viewColumn(k).aggregate(Functions.MAX, Functions.ABS));
            if (akk < -epsilon) {
                throw new IllegalArgumentException("Matrix is not positive semi-definite");
            }
            if (akk <= epsilon) {
                this.L.viewColumn(k).assign(0.0);
                this.isPositiveDefinite = false;
                continue;
            }
            akk = Math.sqrt(Math.max(0.0, akk));
            this.L.viewColumn(k).viewPart(k, n - k).assign(Functions.div(akk));
            this.L.viewColumn(k).viewPart(0, k).assign(0.0);
            for (int j = k + 1; j < n; ++j) {
                Vector columnJ = this.L.viewColumn(j).viewPart(k, n - k);
                Vector columnK = this.L.viewColumn(k).viewPart(k, n - k);
                columnJ.assign(columnK, Functions.minusMult(columnK.get(j - k)));
            }
        }
    }

    private void decompose(Matrix a) {
        int n = a.rowSize();
        this.L.assign(a);
        for (int k = 0; k < n; ++k) {
            double akk = this.L.get(k, k);
            this.L.viewColumn(k).viewPart(0, k).assign(0.0);
            double epsilon = 1.0E-10 * this.L.viewColumn(k).aggregate(Functions.MAX, Functions.ABS);
            if (akk <= epsilon) {
                this.L.viewColumn(k).viewPart(k, n - k).assign(0.0);
                this.isPositiveDefinite = false;
                continue;
            }
            akk = Math.sqrt(Math.max(0.0, akk));
            this.L.set(k, k, akk);
            this.L.viewColumn(k).viewPart(k + 1, n - k - 1).assign(Functions.div(akk));
            for (int j = k + 1; j < n; ++j) {
                Vector columnJ = this.L.viewColumn(j).viewPart(j, n - j);
                Vector columnK = this.L.viewColumn(k).viewPart(j, n - j);
                columnJ.assign(columnK, Functions.minusMult(this.L.get(j, k)));
            }
        }
    }

    public boolean isPositiveDefinite() {
        return this.isPositiveDefinite;
    }

    public Matrix getL() {
        return this.L.getBase();
    }

    public PivotedMatrix getPermutedL() {
        return this.L;
    }

    public int[] getPivot() {
        return this.L.getRowPivot();
    }

    public int[] getInversePivot() {
        return this.L.getInverseRowPivot();
    }

    public Matrix solveLeft(Matrix z) {
        int n = this.L.columnSize();
        int nx = z.columnSize();
        DenseMatrix X = new DenseMatrix(n, z.columnSize());
        X.assign(z);
        for (int internalK = 0; internalK < n; ++internalK) {
            int k = this.L.rowUnpivot(internalK);
            for (int j = 0; j < nx; ++j) {
                for (int internalI = 0; internalI < internalK; ++internalI) {
                    int i = this.L.rowUnpivot(internalI);
                    X.set(k, j, X.get(k, j) - X.get(i, j) * this.L.get(k, i));
                }
                if (this.L.get(k, k) != 0.0) {
                    X.set(k, j, X.get(k, j) / this.L.get(k, k));
                    continue;
                }
                X.set(k, j, 0.0);
            }
        }
        return X;
    }

    public Matrix solveRight(Matrix z) {
        int n = z.columnSize();
        int nx = z.rowSize();
        DenseMatrix x = new DenseMatrix(z.rowSize(), z.columnSize());
        x.assign(z);
        for (int internalK = 0; internalK < n; ++internalK) {
            int k = this.L.rowUnpivot(internalK);
            for (int j = 0; j < nx; ++j) {
                for (int internalI = 0; internalI < k; ++internalI) {
                    int i = this.L.rowUnpivot(internalI);
                    x.set(j, k, x.get(j, k) - x.get(j, i) * this.L.get(k, i));
                    if (!Double.isInfinite(x.get(j, k)) && !Double.isNaN(x.get(j, k))) continue;
                    throw new IllegalStateException(String.format("Invalid value found at %d,%d (should not be possible)", j, k));
                }
                if (this.L.get(k, k) != 0.0) {
                    x.set(j, k, x.get(j, k) / this.L.get(k, k));
                } else {
                    x.set(j, k, 0.0);
                }
                if (!Double.isInfinite(x.get(j, k)) && !Double.isNaN(x.get(j, k))) continue;
                throw new IllegalStateException(String.format("Invalid value found at %d,%d (should not be possible)", j, k));
            }
        }
        return x;
    }
}

