/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.common.iterator;

import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import java.util.Iterator;
import org.apache.commons.math3.distribution.PascalDistribution;
import org.apache.mahout.cf.taste.impl.common.SkippingIterator;
import org.apache.mahout.common.RandomUtils;
import org.apache.mahout.common.RandomWrapper;

public final class SamplingIterator<T>
extends AbstractIterator<T> {
    private final PascalDistribution geometricDistribution;
    private final Iterator<? extends T> delegate;

    public SamplingIterator(Iterator<? extends T> delegate, double samplingRate) {
        this(RandomUtils.getRandom(), delegate, samplingRate);
    }

    public SamplingIterator(RandomWrapper random, Iterator<? extends T> delegate, double samplingRate) {
        Preconditions.checkNotNull(delegate);
        Preconditions.checkArgument(samplingRate > 0.0 && samplingRate <= 1.0, "Must be: 0.0 < samplingRate <= 1.0. But samplingRate = " + samplingRate);
        this.geometricDistribution = new PascalDistribution(random.getRandomGenerator(), 1, samplingRate);
        this.delegate = delegate;
    }

    @Override
    protected T computeNext() {
        int toSkip = this.geometricDistribution.sample();
        if (this.delegate instanceof SkippingIterator) {
            SkippingIterator skippingDelegate = (SkippingIterator)this.delegate;
            skippingDelegate.skip(toSkip);
            if (skippingDelegate.hasNext()) {
                return (T)skippingDelegate.next();
            }
        } else {
            for (int i = 0; i < toSkip && this.delegate.hasNext(); ++i) {
                this.delegate.next();
            }
            if (this.delegate.hasNext()) {
                return this.delegate.next();
            }
        }
        return this.endOfData();
    }
}

