/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.classifier.sgd;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.commons.math3.special.Gamma;
import org.apache.mahout.classifier.sgd.PriorFunction;

public class TPrior
implements PriorFunction {
    private double df;

    public TPrior(double df) {
        this.df = df;
    }

    @Override
    public double age(double oldValue, double generations, double learningRate) {
        int i = 0;
        while ((double)i < generations) {
            oldValue -= learningRate * oldValue * (this.df + 1.0) / (this.df + oldValue * oldValue);
            ++i;
        }
        return oldValue;
    }

    @Override
    public double logP(double betaIJ) {
        return Gamma.logGamma((this.df + 1.0) / 2.0) - Math.log(this.df * Math.PI) - Gamma.logGamma(this.df / 2.0) - (this.df + 1.0) / 2.0 * Math.log1p(betaIJ * betaIJ);
    }

    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.df);
    }

    public void readFields(DataInput in) throws IOException {
        this.df = in.readDouble();
    }
}

