/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.cf.taste.impl.recommender;

import com.google.common.base.Preconditions;
import org.apache.mahout.cf.taste.common.TasteException;
import org.apache.mahout.cf.taste.impl.common.FastIDSet;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveArrayIterator;
import org.apache.mahout.cf.taste.impl.common.LongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.common.SamplingLongPrimitiveIterator;
import org.apache.mahout.cf.taste.impl.recommender.AbstractCandidateItemsStrategy;
import org.apache.mahout.cf.taste.model.DataModel;
import org.apache.mahout.cf.taste.model.Preference;
import org.apache.mahout.cf.taste.model.PreferenceArray;
import org.apache.mahout.common.iterator.FixedSizeSamplingIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SamplingCandidateItemsStrategy
extends AbstractCandidateItemsStrategy {
    private static final Logger log = LoggerFactory.getLogger(SamplingCandidateItemsStrategy.class);
    public static final int DEFAULT_FACTOR = 30;
    public static final int NO_LIMIT_FACTOR = Integer.MAX_VALUE;
    private static final int MAX_LIMIT = Integer.MAX_VALUE;
    private static final double LOG2 = Math.log(2.0);
    private final int maxItems;
    private final int maxUsersPerItem;
    private final int maxItemsPerUser;

    public SamplingCandidateItemsStrategy(int numUsers, int numItems) {
        this(30, 30, 30, numUsers, numItems);
    }

    public SamplingCandidateItemsStrategy(int itemsFactor, int usersPerItemFactor, int candidatesPerUserFactor, int numUsers, int numItems) {
        Preconditions.checkArgument(itemsFactor > 0, "itemsFactor must be greater then 0!");
        Preconditions.checkArgument(usersPerItemFactor > 0, "usersPerItemFactor must be greater then 0!");
        Preconditions.checkArgument(candidatesPerUserFactor > 0, "candidatesPerUserFactor must be greater then 0!");
        Preconditions.checkArgument(numUsers > 0, "numUsers must be greater then 0!");
        Preconditions.checkArgument(numItems > 0, "numItems must be greater then 0!");
        this.maxItems = SamplingCandidateItemsStrategy.computeMaxFrom(itemsFactor, numItems);
        this.maxUsersPerItem = SamplingCandidateItemsStrategy.computeMaxFrom(usersPerItemFactor, numUsers);
        this.maxItemsPerUser = SamplingCandidateItemsStrategy.computeMaxFrom(candidatesPerUserFactor, numItems);
        log.debug("maxItems {}, maxUsersPerItem {}, maxItemsPerUser {}", this.maxItems, this.maxUsersPerItem, this.maxItemsPerUser);
    }

    private static int computeMaxFrom(int factor, int numThings) {
        if (factor == Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        long max = (long)((double)factor * (1.0 + Math.log(numThings) / LOG2));
        return max > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)max;
    }

    @Override
    protected FastIDSet doGetCandidateItems(long[] preferredItemIDs, DataModel dataModel) throws TasteException {
        LongPrimitiveIterator preferredItemIDsIterator = new LongPrimitiveArrayIterator(preferredItemIDs);
        if (preferredItemIDs.length > this.maxItems) {
            double samplingRate = (double)this.maxItems / (double)preferredItemIDs.length;
            preferredItemIDsIterator = new SamplingLongPrimitiveIterator(preferredItemIDsIterator, samplingRate);
        }
        FastIDSet possibleItemsIDs = new FastIDSet();
        while (preferredItemIDsIterator.hasNext()) {
            long itemID = preferredItemIDsIterator.nextLong();
            PreferenceArray prefs = dataModel.getPreferencesForItem(itemID);
            int prefsLength = prefs.length();
            if (prefsLength > this.maxUsersPerItem) {
                FixedSizeSamplingIterator sampledPrefs = new FixedSizeSamplingIterator(this.maxUsersPerItem, prefs.iterator());
                while (sampledPrefs.hasNext()) {
                    this.addSomeOf(possibleItemsIDs, dataModel.getItemIDsFromUser(((Preference)sampledPrefs.next()).getUserID()));
                }
                continue;
            }
            for (int i = 0; i < prefsLength; ++i) {
                this.addSomeOf(possibleItemsIDs, dataModel.getItemIDsFromUser(prefs.getUserID(i)));
            }
        }
        possibleItemsIDs.removeAll(preferredItemIDs);
        return possibleItemsIDs;
    }

    private void addSomeOf(FastIDSet possibleItemIDs, FastIDSet itemIDs) {
        if (itemIDs.size() > this.maxItemsPerUser) {
            SamplingLongPrimitiveIterator it = new SamplingLongPrimitiveIterator(itemIDs.iterator(), (double)this.maxItemsPerUser / (double)itemIDs.size());
            while (it.hasNext()) {
                possibleItemIDs.add(it.nextLong());
            }
        } else {
            possibleItemIDs.addAll(itemIDs);
        }
    }
}

