/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils.vectors;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;
import org.apache.lucene.util.PriorityQueue;
import org.apache.mahout.common.Pair;
import org.apache.mahout.common.iterator.FileLineIterator;
import org.apache.mahout.common.iterator.sequencefile.PathType;
import org.apache.mahout.common.iterator.sequencefile.SequenceFileDirIterable;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.map.OpenObjectIntHashMap;

public final class VectorHelper {
    private static final Pattern TAB_PATTERN = Pattern.compile("\t");

    private VectorHelper() {
    }

    public static String vectorToCSVString(Vector vector, boolean namesAsComments) throws IOException {
        StringBuilder bldr = new StringBuilder(2048);
        VectorHelper.vectorToCSVString(vector, namesAsComments, bldr);
        return ((Object)bldr).toString();
    }

    public static String buildJson(Iterable<Pair<String, Double>> iterable) {
        return VectorHelper.buildJson(iterable, new StringBuilder(2048));
    }

    public static String buildJson(Iterable<Pair<String, Double>> iterable, StringBuilder bldr) {
        bldr.append('{');
        for (Pair<String, Double> p : iterable) {
            bldr.append(p.getFirst());
            bldr.append(':');
            bldr.append(p.getSecond());
            bldr.append(',');
        }
        if (bldr.length() > 1) {
            bldr.setCharAt(bldr.length() - 1, '}');
        }
        return bldr.toString();
    }

    public static List<Pair<Integer, Double>> topEntries(Vector vector, int maxEntries) {
        Pair pair;
        int sizeOfNonZeroElementsInVector = Iterables.size(vector.nonZeroes());
        if (sizeOfNonZeroElementsInVector < maxEntries) {
            maxEntries = sizeOfNonZeroElementsInVector;
        }
        TDoublePQ<Pair<Integer, Double>> queue = new TDoublePQ<Pair<Integer, Double>>(-1, maxEntries);
        for (Vector.Element e : vector.nonZeroes()) {
            queue.insertWithOverflow(Pair.of(e.index(), e.get()));
        }
        ArrayList<Pair<Integer, Double>> entries = Lists.newArrayList();
        while ((pair = (Pair)queue.pop()) != null) {
            if ((Integer)pair.getFirst() <= -1) continue;
            entries.add(pair);
        }
        Collections.sort(entries, new Comparator<Pair<Integer, Double>>(){

            @Override
            public int compare(Pair<Integer, Double> a, Pair<Integer, Double> b) {
                return b.getSecond().compareTo(a.getSecond());
            }
        });
        return entries;
    }

    public static List<Pair<Integer, Double>> firstEntries(Vector vector, int maxEntries) {
        ArrayList<Pair<Integer, Double>> entries = Lists.newArrayList();
        Iterator<Vector.Element> it = vector.nonZeroes().iterator();
        int i = 0;
        while (it.hasNext() && i++ < maxEntries) {
            Vector.Element e = it.next();
            entries.add(Pair.of(e.index(), e.get()));
        }
        return entries;
    }

    public static List<Pair<String, Double>> toWeightedTerms(Collection<Pair<Integer, Double>> entries, final String[] dictionary) {
        if (dictionary != null) {
            return Lists.newArrayList(Collections2.transform(entries, new Function<Pair<Integer, Double>, Pair<String, Double>>(){

                @Override
                public Pair<String, Double> apply(Pair<Integer, Double> p) {
                    return Pair.of(dictionary[p.getFirst()], p.getSecond());
                }
            }));
        }
        return Lists.newArrayList(Collections2.transform(entries, new Function<Pair<Integer, Double>, Pair<String, Double>>(){

            @Override
            public Pair<String, Double> apply(Pair<Integer, Double> p) {
                return Pair.of(Integer.toString(p.getFirst()), p.getSecond());
            }
        }));
    }

    public static String vectorToJson(Vector vector, String[] dictionary, int maxEntries, boolean sort) {
        return VectorHelper.buildJson(VectorHelper.toWeightedTerms(sort ? VectorHelper.topEntries(vector, maxEntries) : VectorHelper.firstEntries(vector, maxEntries), dictionary));
    }

    public static void vectorToCSVString(Vector vector, boolean namesAsComments, Appendable bldr) throws IOException {
        if (namesAsComments && vector instanceof NamedVector) {
            bldr.append('#').append(((NamedVector)vector).getName()).append('\n');
        }
        Iterator<Vector.Element> iter = vector.all().iterator();
        boolean first = true;
        while (iter.hasNext()) {
            if (first) {
                first = false;
            } else {
                bldr.append(',');
            }
            Vector.Element elt = iter.next();
            bldr.append(String.valueOf(elt.get()));
        }
        bldr.append('\n');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] loadTermDictionary(File dictFile) throws IOException {
        FileInputStream in = new FileInputStream(dictFile);
        try {
            String[] stringArray = VectorHelper.loadTermDictionary(in);
            return stringArray;
        }
        finally {
            ((InputStream)in).close();
        }
    }

    public static String[] loadTermDictionary(Configuration conf, String filePattern) {
        OpenObjectIntHashMap<String> dict = new OpenObjectIntHashMap<String>();
        int maxIndexValue = 0;
        for (Pair record : new SequenceFileDirIterable(new Path(filePattern), PathType.GLOB, null, null, true, conf)) {
            dict.put(((Text)record.getFirst()).toString(), ((IntWritable)record.getSecond()).get());
            if (((IntWritable)record.getSecond()).get() <= maxIndexValue) continue;
            maxIndexValue = ((IntWritable)record.getSecond()).get();
        }
        int maxDictionarySize = maxIndexValue + 1 > dict.size() ? maxIndexValue + 1 : dict.size();
        String[] dictionary = new String[maxDictionarySize];
        Iterator i$ = dict.keys().iterator();
        while (i$.hasNext()) {
            String feature;
            dictionary[dict.get(feature)] = feature = (String)i$.next();
        }
        return dictionary;
    }

    private static String[] loadTermDictionary(InputStream is) throws IOException {
        FileLineIterator it = new FileLineIterator(is);
        int numEntries = Integer.parseInt((String)it.next());
        String[] result = new String[numEntries];
        while (it.hasNext()) {
            String[] tokens;
            String line = (String)it.next();
            if (line.startsWith("#") || (tokens = TAB_PATTERN.split(line)).length < 3) continue;
            int index = Integer.parseInt(tokens[2]);
            result[index] = tokens[0];
        }
        return result;
    }

    private static final class TDoublePQ<T>
    extends PriorityQueue<Pair<T, Double>> {
        private final T sentinel;

        private TDoublePQ(T sentinel, int size) {
            super(size);
            this.sentinel = sentinel;
        }

        @Override
        protected boolean lessThan(Pair<T, Double> a, Pair<T, Double> b) {
            return a.getSecond().compareTo(b.getSecond()) < 0;
        }

        @Override
        protected Pair<T, Double> getSentinelObject() {
            return Pair.of(this.sentinel, Double.NEGATIVE_INFINITY);
        }
    }
}

