/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mahout.utils;

import com.google.common.base.Preconditions;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.mahout.math.NamedVector;
import org.apache.mahout.math.SequentialAccessSparseVector;
import org.apache.mahout.math.Vector;
import org.apache.mahout.math.VectorWritable;

public class ConcatenateVectorsReducer
extends Reducer<IntWritable, VectorWritable, IntWritable, VectorWritable> {
    int dimsA = 0;
    int dimsB = 0;

    public void setup(Reducer.Context context) throws IOException, InterruptedException {
        Configuration configuration = context.getConfiguration();
        this.dimsA = Integer.valueOf(configuration.getStrings("mahout.concatenatevectors.matrixA_dims")[0]);
        this.dimsB = Integer.valueOf(configuration.getStrings("mahout.concatenatevectors.matrixB_dims")[0]);
    }

    public void reduce(IntWritable row, Iterable<VectorWritable> vectorWritableIterable, Reducer.Context ctx) throws IOException, InterruptedException {
        Vector vA = null;
        Vector vB = null;
        Vector vOut = null;
        boolean isNamed = false;
        String name = null;
        for (VectorWritable vw : vectorWritableIterable) {
            Vector v = vw.get();
            if (v instanceof NamedVector) {
                name = ((NamedVector)v).getName();
                isNamed = true;
            }
            if (v.size() == this.dimsA) {
                vA = v;
                continue;
            }
            if (v.size() == this.dimsB) {
                vB = v;
                continue;
            }
            if (v.size() != this.dimsA + this.dimsB) continue;
            vOut = v;
            break;
        }
        Preconditions.checkArgument(vA != null || vB != null || vOut != null);
        if (vOut == null) {
            vOut = new SequentialAccessSparseVector(this.dimsA + this.dimsB);
            if (isNamed) {
                vOut = new NamedVector(vOut, name);
            }
        }
        if (vA != null) {
            this.appendVector(vOut, vA, 0);
        }
        if (vB != null) {
            this.appendVector(vOut, vB, this.dimsA);
        }
        ctx.write((Object)row, (Object)new VectorWritable(vOut));
    }

    private void appendVector(Vector vOut, Vector vIn, int offset) {
        for (Vector.Element element : vIn.nonZeroes()) {
            vOut.set(element.index() + offset, element.get());
        }
    }
}

